/*
 * Decompiled with CFR 0.152.
 */
package ij.gui;

import ij.IJ;
import ij.ImageJ;
import ij.ImagePlus;
import ij.Menus;
import ij.Prefs;
import ij.WindowManager;
import ij.gui.ImageCanvas;
import ij.gui.ImageWindow;
import ij.gui.PhotometerParams;
import ij.plugin.MacroInstaller;
import ij.plugin.frame.Recorder;
import ij.process.Photometer;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Menu;
import java.awt.MenuItem;
import java.awt.Toolkit;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.net.URL;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public class EuHouToolbar
extends Canvas
implements MouseListener,
MouseMotionListener {
    public static final int NEWIMG = 0;
    public static final int OPEN = 1;
    public static final int SAVE = 2;
    public static final int SAVEAS = 3;
    public static final int PRINT = 4;
    public static final int CLEAR = 6;
    public static final int UNDO = 7;
    public static final int MAG_PLUS = 99;
    public static final int MAG_MINUS = 98;
    public static final int BRIGHTNESS_CONTRAST = 8;
    public static final int PHOTOMETER = 9;
    public static final int PHOTOSETTINGS = 10;
    public static final int CLEARPHOTO = 11;
    public static final int INFO = 12;
    public static final int NONE = 100;
    private static final int NUM_TOOLS = 13;
    private static final int SIZE = 28;
    private static final int SIZECORR = 3;
    private static final int OFFSET = 3;
    private Dimension ps = new Dimension(366, 30);
    private boolean[] down;
    private static int current;
    private int x;
    private int y;
    private int xOffset;
    private int yOffset;
    private long mouseDownTime;
    private Graphics g;
    private static EuHouToolbar instance;
    private String[] names = new String[13];
    private Image[] icons = new Image[13];
    private String[] command = new String[]{"New", "Open", "Save", "FITS...", "Print", null, EuHouToolbar.addPluginItem("selection02"), "Undo", EuHouToolbar.addPluginItem("adjust01"), null, "PhotometrySettings", "ClearPhotometer", "OnlineDocs", null, null, null, null, null, null, null};
    private int pc;
    private String icon;
    private MacroInstaller macroInstaller;
    private static Color foregroundColor;
    private static Color backgroundColor;
    private Color gray = ImageJ.backgroundColor;
    private Color brighter = this.gray.brighter();
    private Color darker = this.gray.darker();
    private Color evenDarker = this.darker.darker();
    private ResourceBundle table;
    private boolean drag = false;
    private static Photometer photometer;

    private static String addPluginItem(String s) {
        int openBracket;
        int index;
        String st = Prefs.getString(s);
        String command = st.substring(1, (index = st.lastIndexOf(44)) - 1);
        if (command.endsWith("]") && (openBracket = command.lastIndexOf(91)) > 0) {
            command = command.substring(0, openBracket);
        }
        return command;
    }

    public EuHouToolbar() {
        this.down = new boolean[13];
        ClassLoader cl = this.getClass().getClassLoader();
        for (int i = 0; i < 13; ++i) {
            URL path = cl.getResource("images/" + i + ".png");
            if (path != null) {
                this.icons[i] = Toolkit.getDefaultToolkit().getImage(path);
                continue;
            }
            path = cl.getResource("images/none.png");
            this.icons[i] = Toolkit.getDefaultToolkit().getImage(path);
        }
        this.resetButtons();
        this.setForeground(foregroundColor);
        this.setBackground(this.gray);
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        instance = this;
        this.table = ResourceBundle.getBundle("ij/i18n/ToolBundle", IJ.getLocale());
    }

    public static EuHouToolbar getInstance() {
        return instance;
    }

    public static boolean photometerSelected() {
        return EuHouToolbar.getInstance().down[9];
    }

    public static Photometer getPhotometer() {
        return photometer;
    }

    private void drawButtons(Graphics g) {
        for (int i = 0; i < 13; ++i) {
            this.drawButton(g, i);
        }
    }

    private void fill3DRect(Graphics g, int x, int y, int width, int height, boolean raised) {
        if (raised) {
            g.setColor(this.gray);
        } else {
            g.setColor(this.darker);
        }
        g.fillRect(x + 1, y + 1, width - 1, height - 1);
        g.setColor(raised ? this.brighter : this.evenDarker);
        g.drawLine(x, y, x, y + height - 1);
        g.drawLine(x + 1, y, x + width - 2, y);
        g.setColor(raised ? this.evenDarker : this.brighter);
        g.drawLine(x + 1, y + height - 1, x + width - 1, y + height - 1);
        g.drawLine(x + width - 1, y, x + width - 1, y + height - 2);
    }

    private void drawButton(Graphics g, int tool) {
        this.fill3DRect(g, tool * 28 + 1, 1, 28, 28, !this.down[tool]);
        g.setColor(Color.black);
        int x = tool * 28 + 3;
        int y = 3;
        if (this.down[tool]) {
            ++x;
            ++y;
        }
        this.g = g;
        if (this.icons[tool] != null) {
            g.drawImage(this.icons[tool], x, y, this);
        }
    }

    private void showMessage(int tool) {
        switch (tool) {
            case 0: {
                IJ.showStatus(this.table.getString("NewHint"));
                return;
            }
            case 1: {
                IJ.showStatus(this.table.getString("OpenHint"));
                return;
            }
            case 2: {
                IJ.showStatus(this.table.getString("SaveHint"));
                return;
            }
            case 3: {
                IJ.showStatus(this.table.getString("SaveAsHint"));
                return;
            }
            case 4: {
                IJ.showStatus(this.table.getString("PrintHint"));
                return;
            }
            case 6: {
                IJ.showStatus(this.table.getString("ClearHint"));
                return;
            }
            case 7: {
                IJ.showStatus(this.table.getString("UndoHint"));
                return;
            }
            case 99: {
                IJ.showStatus(this.table.getString("Mag+Hint"));
                return;
            }
            case 98: {
                IJ.showStatus(this.table.getString("Mag-Hint"));
                return;
            }
            case 8: {
                IJ.showStatus(this.table.getString("BrightnessContrastHint"));
                return;
            }
            case 9: {
                IJ.showStatus(this.table.getString("PhotometryHint"));
                return;
            }
            case 10: {
                IJ.showStatus(this.table.getString("PhotometryAdjustHint"));
                return;
            }
            case 11: {
                IJ.showStatus(this.table.getString("ClearPhotometryHint"));
                return;
            }
            case 12: {
                IJ.showStatus(this.table.getString("InfoHint"));
                return;
            }
        }
        IJ.showStatus("");
    }

    private void resetButtons() {
        for (int i = 0; i < 13; ++i) {
            this.down[i] = false;
        }
    }

    public void paint(Graphics g) {
        this.drawButtons(g);
    }

    public void update(Graphics g) {
        for (int i = 0; i < 13; ++i) {
            if (!g.hitClip(i * 28, 0, 28, 28)) continue;
            this.drawButton(g, i);
        }
    }

    public void setTool(int tool) {
        if (tool < 0 || tool >= 13) {
            return;
        }
        this.setTool2(tool);
    }

    private void setTool2(int tool) {
        if (tool < 0 || tool >= 13) {
            return;
        }
        current = tool;
        this.showMessage(current);
        Hashtable table = Menus.getCommands();
        if (this.command[tool] != null) {
            String Cmd;
            try {
                Cmd = IJ.getBundle().getString(this.command[tool]);
            }
            catch (MissingResourceException e) {
                Cmd = this.command[tool];
            }
            if (Cmd == "options01") {
                IJ.doCommand(Prefs.getCommand(Cmd));
            } else {
                IJ.doCommand(Cmd);
            }
            if (Recorder.record && tool != 1) {
                Recorder.record(Cmd);
            }
        }
        if (IJ.isMacOSX()) {
            this.repaint();
        }
    }

    public void mouseReleased(MouseEvent e) {
        if (this.drag) {
            return;
        }
        int x = e.getX();
        int newTool = x / 28;
        if (newTool >= 13 || newTool == 9 || newTool == 10) {
            return;
        }
        boolean doubleClick = newTool == current && System.currentTimeMillis() - this.mouseDownTime <= 500L;
        this.mouseDownTime = System.currentTimeMillis();
        if (!doubleClick) {
            this.setTool2(newTool);
        }
        this.down[newTool] = false;
        Graphics g = this.getGraphics();
        this.drawButton(g, newTool);
        g.dispose();
    }

    public void photometerButtonAction() {
        this.down[9] = !this.down[9];
        Graphics gr = this.getGraphics();
        this.drawButton(gr, 9);
        Enumeration en = WindowManager.getImageWindows().elements();
        if (this.down[9]) {
            if (photometer == null) {
                photometer = new Photometer();
            } else {
                photometer.activate();
            }
            while (en.hasMoreElements()) {
                ImageCanvas c = ((ImageWindow)en.nextElement()).getCanvas();
                c.addMouseListener(photometer);
            }
        } else {
            while (en.hasMoreElements()) {
                ImageWindow win = (ImageWindow)en.nextElement();
                ImagePlus imp = win.getImagePlus();
                if (photometer.affectedImage(imp.getTitle())) {
                    imp.killRoi();
                }
                win.getCanvas().removeMouseListener(photometer);
            }
            photometer.close();
        }
        ResourceBundle bun = IJ.getBundle();
        int i = 0;
        try {
            MenuItem it;
            Menu m;
            while (!(m = Menus.getMenuBar().getMenu(i++)).getLabel().equals(bun.getString("Analyze"))) {
            }
            i = -1;
            String s = bun.getString(this.down[9] ? "Photometer" : "DisablePhotometer");
            while (!(it = m.getItem(++i)).getLabel().equals(s)) {
            }
            m.remove(i);
            s = this.down[9] ? "DisablePhotometer" : "Photometer";
            m.insert(bun.getString(s), i);
            m.getItem(i).addActionListener(IJ.getInstance());
        }
        catch (Exception ex) {
            // empty catch block
        }
    }

    public void settingsAction() {
        this.down[10] = !this.down[10];
        Graphics gr = this.getGraphics();
        this.drawButton(gr, 10);
        PhotometerParams s = PhotometerParams.getInstance();
        if (s == null) {
            s = new PhotometerParams();
        } else {
            s.dispose();
        }
    }

    public static void clearPhotometer() {
        Photometer.clear();
    }

    public void mousePressed(MouseEvent e) {
        this.drag = false;
        int x = e.getX();
        if ((x /= 28) >= 13) {
            return;
        }
        if (x == 9) {
            this.photometerButtonAction();
        } else if (x == 10) {
            this.settingsAction();
        } else {
            this.down[x] = !this.down[x];
            Graphics g = this.getGraphics();
            this.drawButton(g, x);
            if (x == 99 || x == 98) {
                ImageCanvas ic = WindowManager.getCurrentWindow().getCanvas();
                Dimension d = ic.getPreferredSize();
                int xx = d.width / 2;
                int y = d.height / 2;
                if (x == 99) {
                    ic.zoomIn(xx, y);
                } else {
                    ic.zoomOut(xx, y);
                }
            }
        }
    }

    public void mouseExited(MouseEvent e) {
        this.showMessage(100);
    }

    public void mouseClicked(MouseEvent e) {
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseDragged(MouseEvent e) {
        this.drag = true;
        int x = e.getX();
        if ((x /= 28) >= 13) {
            return;
        }
        this.down[x] = false;
        Graphics g = this.getGraphics();
        this.drawButton(g, x);
        g.dispose();
    }

    public void mouseMoved(MouseEvent e) {
        int x = e.getX();
        this.showMessage(x /= 28);
    }

    public Dimension getSize() {
        return this.ps;
    }

    public Dimension getPreferredSize() {
        return this.ps;
    }

    public Dimension getMinimumSize() {
        return this.ps;
    }

    static {
        foregroundColor = Prefs.getColor("fcolor", Color.black);
        backgroundColor = Prefs.getColor("bcolor", Color.white);
    }
}

