/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin;

import ij.IJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.WindowManager;
import ij.gui.GenericDialog;
import ij.gui.ImageCanvas;
import ij.gui.ImageWindow;
import ij.gui.Line;
import ij.gui.PolygonRoi;
import ij.gui.Roi;
import ij.measure.Calibration;
import ij.plugin.PlugIn;
import ij.plugin.RGBStackMerge;
import ij.plugin.filter.RGBStackSplitter;
import ij.process.ImageProcessor;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Rectangle;

public class Slicer
implements PlugIn {
    private static final String[] starts = new String[]{"Top", "Left", "Bottom", "Right"};
    private static String startAt = starts[0];
    private static boolean rotate;
    private static boolean flip;
    private double outputZSpacing = 1.0;
    private int outputSlices = 1;
    private ImageWindow win;
    private boolean noRoi;

    public void run(String arg) {
        ImagePlus imp = WindowManager.getCurrentImage();
        if (imp == null) {
            IJ.noImage();
            return;
        }
        int stackSize = imp.getStackSize();
        if (stackSize < 2) {
            IJ.showMessage("Reslicer", "Stack required");
            return;
        }
        if (!this.showDialog(imp)) {
            return;
        }
        IJ.showStatus("Reslice... (press esc to abort)");
        this.win = imp.getWindow();
        if (this.win != null) {
            this.win.running = true;
        }
        long startTime = System.currentTimeMillis();
        ImagePlus imp2 = null;
        imp2 = imp.getType() == 4 ? this.resliceRGB(imp) : this.reslice(imp);
        if (imp2 == null) {
            return;
        }
        imp2.setCalibration(imp.getCalibration());
        Calibration cal = imp2.getCalibration();
        cal.pixelDepth = this.outputZSpacing * cal.pixelWidth;
        imp2.show();
        if (this.noRoi) {
            imp.killRoi();
        } else {
            imp.draw();
        }
        if (this.win != null) {
            this.win.running = false;
        }
        IJ.showStatus(IJ.d2s((double)(System.currentTimeMillis() - startTime) / 1000.0, 2) + " seconds");
    }

    public ImagePlus resliceRGB(ImagePlus imp) {
        Roi roi = imp.getRoi();
        RGBStackSplitter splitter = new RGBStackSplitter();
        splitter.split(imp.getStack(), true);
        IJ.showStatus("Slicer: RGB split");
        ImagePlus red = new ImagePlus("Red", splitter.red);
        ImagePlus green = new ImagePlus("Green", splitter.green);
        ImagePlus blue = new ImagePlus("Blue", splitter.blue);
        red.setRoi(roi);
        green.setRoi(roi);
        blue.setRoi(roi);
        Calibration cal = imp.getCalibration();
        red.setCalibration(cal);
        green.setCalibration(cal);
        blue.setCalibration(cal);
        IJ.showStatus("Slicer: reslicing red");
        red = this.reslice(red);
        IJ.showStatus("Slicer: reslicing green");
        green = this.reslice(green);
        IJ.showStatus("Slicer: reslicing blue");
        blue = this.reslice(blue);
        int w = red.getWidth();
        int h = red.getHeight();
        int d = red.getStackSize();
        RGBStackMerge merge = new RGBStackMerge();
        IJ.showStatus("Slicer: RGB merge");
        ImageStack stack = merge.mergeStacks(w, h, d, red.getStack(), green.getStack(), blue.getStack(), true);
        return new ImagePlus("Reslice of  " + imp.getShortTitle(), stack);
    }

    public ImagePlus reslice(ImagePlus imp) {
        int roiType;
        Roi roi = imp.getRoi();
        int n = roiType = roi != null ? roi.getType() : 0;
        if (roi == null || roiType == 0 || roiType == 5) {
            return this.resliceRectOrLine(imp);
        }
        if (roiType == 6 || roiType == 7) {
            ImageProcessor ip2 = this.getSlice(imp, 0.0, 0.0, 0.0, 0.0);
            return new ImagePlus("Reslice of  " + imp.getShortTitle(), ip2);
        }
        IJ.showMessage("Reslice...", "Line or rectangular selection required");
        return null;
    }

    boolean showDialog(ImagePlus imp) {
        Calibration cal = imp.getCalibration();
        String units = cal.getUnits();
        if (cal.pixelWidth == 0.0) {
            cal.pixelWidth = 1.0;
        }
        double outputSpacing = cal.pixelDepth;
        Roi roi = imp.getRoi();
        boolean line = roi != null && roi.getType() == 5;
        GenericDialog gd = new GenericDialog("Reslice");
        gd.addNumericField("Input Z Spacing (" + units + "):", cal.pixelDepth, 3);
        gd.addNumericField("Output Z Spacing (" + units + "):", outputSpacing, 3);
        if (line) {
            gd.addNumericField("Slice Count:", this.outputSlices, 0);
        } else {
            gd.addChoice("Start At:", starts, startAt);
        }
        gd.addCheckbox("Flip Vertically", flip);
        gd.addCheckbox("Rotate 90 Degrees", rotate);
        gd.showDialog();
        if (gd.wasCanceled()) {
            return false;
        }
        cal.pixelDepth = gd.getNextNumber();
        if (cal.pixelDepth == 0.0) {
            cal.pixelDepth = 1.0;
        }
        this.outputZSpacing = gd.getNextNumber() / cal.pixelWidth;
        if (line) {
            this.outputSlices = (int)gd.getNextNumber();
        } else {
            startAt = gd.getNextChoice();
        }
        flip = gd.getNextBoolean();
        rotate = gd.getNextBoolean();
        return true;
    }

    ImagePlus resliceRectOrLine(ImagePlus imp) {
        double x1 = 0.0;
        double y1 = 0.0;
        double x2 = 0.0;
        double y2 = 0.0;
        double xInc = 0.0;
        double yInc = 0.0;
        this.noRoi = false;
        Roi roi = imp.getRoi();
        if (roi == null) {
            this.noRoi = true;
            imp.setRoi(0, 0, imp.getWidth(), imp.getHeight());
            roi = imp.getRoi();
        }
        if (roi.getType() == 0) {
            Rectangle r = roi.getBoundingRect();
            if (startAt.equals(starts[0])) {
                x1 = r.x;
                y1 = r.y;
                x2 = r.x + r.width;
                y2 = r.y;
                xInc = 0.0;
                yInc = this.outputZSpacing;
                this.outputSlices = (int)((double)r.height / this.outputZSpacing);
            } else if (startAt.equals(starts[1])) {
                x1 = r.x;
                y1 = r.y;
                x2 = r.x;
                y2 = r.y + r.height;
                xInc = this.outputZSpacing;
                yInc = 0.0;
                this.outputSlices = (int)((double)r.width / this.outputZSpacing);
            } else if (startAt.equals(starts[2])) {
                x1 = r.x;
                y1 = r.y + r.height;
                x2 = r.x + r.width;
                y2 = r.y + r.height;
                xInc = 0.0;
                yInc = -this.outputZSpacing;
                this.outputSlices = (int)((double)r.height / this.outputZSpacing);
            } else if (startAt.equals(starts[3])) {
                x1 = r.x + r.width;
                y1 = r.y;
                x2 = r.x + r.width;
                y2 = r.y + r.height;
                xInc = -this.outputZSpacing;
                yInc = 0.0;
                this.outputSlices = (int)((double)r.width / this.outputZSpacing);
            }
        } else if (roi.getType() == 5) {
            Line line = (Line)roi;
            x1 = line.x1;
            y1 = line.y1;
            x2 = line.x2;
            y2 = line.y2;
            double dx = x2 - x1;
            double dy = y2 - y1;
            double nrm = Math.sqrt(dx * dx + dy * dy) / this.outputZSpacing;
            xInc = -(dy / nrm);
            yInc = dx / nrm;
        } else {
            return null;
        }
        if (this.outputSlices == 0) {
            IJ.showMessage("Reslicer", "Output Z spacing (" + IJ.d2s(this.outputZSpacing, 0) + " pixels) is too large.");
            return null;
        }
        ImageStack stack = null;
        for (int i = 0; i < this.outputSlices; ++i) {
            ImageProcessor ip = this.getSlice(imp, x1, y1, x2, y2);
            this.drawLine(x1, y1, x2, y2, imp);
            if (stack == null) {
                stack = new ImageStack(ip.getWidth(), ip.getHeight());
            }
            stack.addSlice(null, ip);
            x1 += xInc;
            x2 += xInc;
            y1 += yInc;
            y2 += yInc;
            if (this.win == null || this.win.running) continue;
            IJ.beep();
            imp.draw();
            return null;
        }
        return new ImagePlus("Reslice of  " + imp.getShortTitle(), stack);
    }

    ImageProcessor getSlice(ImagePlus imp, double x1, double y1, double x2, double y2) {
        Roi roi = imp.getRoi();
        int roiType = roi != null ? roi.getType() : 0;
        ImageStack stack = imp.getStack();
        int stackSize = stack.getSize();
        ImageProcessor ip2 = null;
        double[] line = null;
        for (int i = 0; i < stackSize; ++i) {
            ImageProcessor ip = stack.getProcessor(flip ? stackSize - i : i + 1);
            line = roiType == 6 || roiType == 7 ? this.getIrregularProfile(roi, ip) : this.getLine(ip, x1, y1, x2, y2, line);
            if (rotate) {
                if (i == 0) {
                    ip2 = ip.createProcessor(stackSize, line.length);
                }
                this.putColumn(ip2, i, 0, line, line.length);
                continue;
            }
            if (i == 0) {
                ip2 = ip.createProcessor(line.length, stackSize);
            }
            this.putRow(ip2, 0, i, line, line.length);
        }
        Calibration cal = imp.getCalibration();
        double zSpacing = cal.pixelDepth / cal.pixelWidth;
        if (zSpacing != 1.0) {
            ip2.setInterpolate(true);
            ip2 = rotate ? ip2.resize((int)((double)stackSize * zSpacing), line.length) : ip2.resize(line.length, (int)((double)stackSize * zSpacing));
        }
        return ip2;
    }

    public void putRow(ImageProcessor ip, int x, int y, double[] data, int length) {
        for (int i = 0; i < length; ++i) {
            ip.putPixelValue(x++, y, data[i]);
        }
    }

    public void putColumn(ImageProcessor ip, int x, int y, double[] data, int length) {
        for (int i = 0; i < length; ++i) {
            ip.putPixelValue(x, y++, data[i]);
        }
    }

    double[] getIrregularProfile(Roi roi, ImageProcessor ip) {
        int n = ((PolygonRoi)roi).getNCoordinates();
        int[] x = ((PolygonRoi)roi).getXCoordinates();
        int[] y = ((PolygonRoi)roi).getYCoordinates();
        Rectangle r = roi.getBoundingRect();
        int xbase = r.x;
        int ybase = r.y;
        double length = 0.0;
        double[] segmentLengths = new double[n];
        int[] dx = new int[n];
        int[] dy = new int[n];
        for (int i = 0; i < n - 1; ++i) {
            int xdelta = x[i + 1] - x[i];
            int ydelta = y[i + 1] - y[i];
            double segmentLength = Math.sqrt(xdelta * xdelta + ydelta * ydelta);
            length += segmentLength;
            segmentLengths[i] = segmentLength;
            dx[i] = xdelta;
            dy[i] = ydelta;
        }
        double[] values = new double[(int)length];
        double leftOver = 1.0;
        double distance = 0.0;
        double oldx = xbase;
        double oldy = ybase;
        for (int i = 0; i < n; ++i) {
            double len = segmentLengths[i];
            if (len == 0.0) continue;
            double xinc = (double)dx[i] / len;
            double yinc = (double)dy[i] / len;
            double start = 1.0 - leftOver;
            double rx = (double)(xbase + x[i]) + start * xinc;
            double ry = (double)(ybase + y[i]) + start * yinc;
            double len2 = len - start;
            int n2 = (int)len2;
            for (int j = 0; j <= n2; ++j) {
                int index = (int)distance + j;
                if (index < values.length) {
                    values[index] = ip.getInterpolatedValue(rx, ry);
                }
                rx += xinc;
                ry += yinc;
            }
            distance += len;
            leftOver = len2 - (double)n2;
        }
        return values;
    }

    private double[] getLine(ImageProcessor ip, double x1, double y1, double x2, double y2, double[] data) {
        double dx = x2 - x1;
        double dy = y2 - y1;
        int n = (int)Math.round(Math.sqrt(dx * dx + dy * dy));
        if (data == null) {
            data = new double[n];
        }
        double xinc = dx / (double)n;
        double yinc = dy / (double)n;
        double rx = x1;
        double ry = y1;
        for (int i = 0; i < n; ++i) {
            data[i] = ip.getInterpolatedValue(rx, ry);
            rx += xinc;
            ry += yinc;
        }
        return data;
    }

    void drawLine(double x1, double y1, double x2, double y2, ImagePlus imp) {
        ImageWindow win = imp.getWindow();
        if (win == null) {
            return;
        }
        ImageCanvas ic = win.getCanvas();
        Graphics g = ic.getGraphics();
        g.setColor(Roi.getColor());
        g.setXORMode(Color.black);
        g.drawLine(ic.screenX((int)(x1 + 0.5)), ic.screenY((int)(y1 + 0.5)), ic.screenX((int)(x2 + 0.5)), ic.screenY((int)(y2 + 0.5)));
    }
}

