/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin.filter;

import ij.IJ;
import ij.ImagePlus;
import ij.gui.GenericDialog;
import ij.gui.ImageWindow;
import ij.gui.Roi;
import ij.plugin.filter.PlugInFilter;
import ij.process.ByteProcessor;
import ij.process.ColorProcessor;
import ij.process.FloatProcessor;
import ij.process.ImageProcessor;
import ij.process.ShortProcessor;
import java.awt.Rectangle;
import java.util.StringTokenizer;

public class Convolver
implements PlugInFilter {
    static final int BYTE = 0;
    static final int SHORT = 1;
    static final int FLOAT = 2;
    static final int RGB = 3;
    ImagePlus imp;
    int kw;
    int kh;
    int slice = 1;
    boolean canceled;
    float[] kernel;
    ImageWindow win;
    boolean isLineRoi;
    static String kernelText = "-1 -1 -1 -1 -1\n-1 -1 -1 -1 -1\n-1 -1 24 -1 -1\n-1 -1 -1 -1 -1\n-1 -1 -1 -1 -1\n";
    static boolean normalize = true;

    public int setup(String arg, ImagePlus imp) {
        IJ.register(Convolver.class);
        this.imp = imp;
        this.canceled = false;
        if (imp == null) {
            IJ.noImage();
            return 4096;
        }
        Roi roi = imp.getRoi();
        this.isLineRoi = roi != null && roi.getType() >= 5;
        this.kernel = this.getKernel();
        if (this.kernel == null) {
            return 4096;
        }
        if ((this.kw & 1) == 0) {
            IJ.showMessage("Convolver", "The kernel must be square and have an\nodd width. This kernel is " + this.kw + "x" + this.kh + ".");
            return 4096;
        }
        int flags = IJ.setupDialog(imp, 31);
        if ((flags & 0x1000) != 0) {
            return 4096;
        }
        this.win = imp.getWindow();
        this.win.running = true;
        IJ.showStatus("Convolve: " + this.kw + "x" + this.kh + " kernel");
        imp.startTiming();
        return flags;
    }

    public void run(ImageProcessor ip) {
        if (this.canceled) {
            return;
        }
        if (!this.win.running) {
            this.canceled = true;
            return;
        }
        if (this.isLineRoi) {
            ip.resetRoi();
        }
        this.convolve(ip, this.kernel, this.kw, this.kh);
        if (this.slice > 1) {
            IJ.showStatus("Convolve: " + this.slice + "/" + this.imp.getStackSize());
        }
        if (this.slice == this.imp.getStackSize()) {
            ip.resetMinAndMax();
        }
        ++this.slice;
    }

    float[] getKernel() {
        GenericDialog gd = new GenericDialog("Convolver...", IJ.getInstance());
        gd.addTextAreas(kernelText, null, 10, 30);
        gd.addCheckbox("Normalize Kernel", normalize);
        gd.showDialog();
        if (gd.wasCanceled()) {
            this.canceled = true;
            return null;
        }
        kernelText = gd.getNextText();
        normalize = gd.getNextBoolean();
        StringTokenizer st = new StringTokenizer(kernelText);
        int n = st.countTokens();
        this.kh = this.kw = (int)Math.sqrt(n);
        n = this.kw * this.kh;
        float[] k = new float[n];
        for (int i = 0; i < n; ++i) {
            k[i] = (float)this.getNum(st);
        }
        return k;
    }

    double getNum(StringTokenizer st) {
        Double d;
        String token = st.nextToken();
        try {
            d = new Double(token);
        }
        catch (NumberFormatException e) {
            d = null;
        }
        if (d != null) {
            return d;
        }
        return 0.0;
    }

    public void convolve(ImageProcessor ip, float[] kernel, int kw, int kh) {
        if ((kw & 1) != 1 || (kh & 1) != 1) {
            throw new IllegalArgumentException("Kernel width or height not odd");
        }
        int type = ip instanceof ByteProcessor ? 0 : (ip instanceof ShortProcessor ? 1 : (ip instanceof FloatProcessor ? 2 : 3));
        if (type == 3) {
            this.convolveRGB(ip, kernel, kw, kh);
            return;
        }
        ip.setCalibrationTable(null);
        ImageProcessor ip2 = ip.convertToFloat();
        ip2.setRoi(ip.getRoi());
        ip2.setMask(ip.getMask());
        this.convolveFloat(ip2, kernel, kw, kh);
        switch (type) {
            case 0: {
                ip2 = ip2.convertToByte(false);
                byte[] pixels = (byte[])ip.getPixels();
                byte[] pixels2 = (byte[])ip2.getPixels();
                System.arraycopy(pixels2, 0, pixels, 0, pixels.length);
                break;
            }
            case 1: {
                ip2 = ip2.convertToShort(false);
                short[] pixels16 = (short[])ip.getPixels();
                short[] pixels16b = (short[])ip2.getPixels();
                System.arraycopy(pixels16b, 0, pixels16, 0, pixels16.length);
                break;
            }
        }
    }

    public void convolveRGB(ImageProcessor ip, float[] kernel, int kw, int kh) {
        int width = ip.getWidth();
        int height = ip.getHeight();
        Rectangle roi = ip.getRoi();
        int[] mask = ip.getMask();
        int size = width * height;
        if (this.slice == 1) {
            IJ.showStatus("Convolve (red)");
        }
        byte[] r = new byte[size];
        byte[] g = new byte[size];
        byte[] b = new byte[size];
        ((ColorProcessor)ip).getRGB(r, g, b);
        ByteProcessor rip = new ByteProcessor(width, height, r, null);
        ByteProcessor gip = new ByteProcessor(width, height, g, null);
        ByteProcessor bip = new ByteProcessor(width, height, b, null);
        Rectangle rect = ip.getRoi();
        ImageProcessor ip2 = rip.convertToFloat();
        ip2.setRoi(roi);
        ip2.setMask(mask);
        this.convolveFloat(ip2, kernel, kw, kh);
        ImageProcessor r2 = ip2.convertToByte(false);
        if (this.slice == 1) {
            IJ.showStatus("Convolve (green)");
        }
        ip2 = gip.convertToFloat();
        ip2.setRoi(roi);
        ip2.setMask(mask);
        this.convolveFloat(ip2, kernel, kw, kh);
        ImageProcessor g2 = ip2.convertToByte(false);
        ip2 = bip.convertToFloat();
        ip2.setRoi(roi);
        ip2.setMask(mask);
        if (this.slice == 1) {
            IJ.showStatus("Convolve (blue)");
        }
        this.convolveFloat(ip2, kernel, kw, kh);
        ImageProcessor b2 = ip2.convertToByte(false);
        ((ColorProcessor)ip).setRGB((byte[])r2.getPixels(), (byte[])g2.getPixels(), (byte[])b2.getPixels());
    }

    public void convolveFloat(ImageProcessor ip, float[] kernel, int kw, int kh) {
        boolean nonRectRoi;
        int width = ip.getWidth();
        int height = ip.getHeight();
        Rectangle r = ip.getRoi();
        boolean isRoi = r.width != width || r.height != height;
        boolean bl = nonRectRoi = isRoi && ip.getMask() != null;
        if (nonRectRoi) {
            ip.snapshot();
        }
        int x1 = r.x;
        int y1 = r.y;
        int x2 = x1 + r.width;
        int y2 = y1 + r.height;
        int uc = kw / 2;
        int vc = kh / 2;
        float[] pixels = (float[])ip.getPixels();
        float[] pixels2 = (float[])ip.getPixelsCopy();
        double scale = 1.0;
        if (normalize) {
            double sum = 0.0;
            for (int i = 0; i < kernel.length; ++i) {
                sum += (double)kernel[i];
            }
            if (sum != 0.0) {
                scale = (float)(1.0 / sum);
            }
        }
        int progress = Math.max((y2 - y1) / 25, 1);
        int xedge = width - uc;
        int yedge = height - vc;
        for (int y = y1; y < y2; ++y) {
            if (y % progress == 0) {
                IJ.showProgress((double)y / (double)height);
            }
            for (int x = x1; x < x2; ++x) {
                double sum = 0.0;
                int i = 0;
                boolean edgePixel = y < vc || y >= yedge || x < uc || x >= xedge;
                for (int v = -vc; v <= vc; ++v) {
                    int offset = x + (y + v) * width;
                    for (int u = -uc; u <= uc; ++u) {
                        if (edgePixel) {
                            sum += (double)(this.getPixel(x + u, y + v, pixels2, width, height) * kernel[i++]);
                            continue;
                        }
                        sum += (double)(pixels2[offset + u] * kernel[i++]);
                    }
                }
                pixels[x + y * width] = (float)(sum * scale);
            }
        }
        if (nonRectRoi) {
            ip.reset(ip.getMask());
        }
        IJ.showProgress(1.0);
    }

    private float getPixel(int x, int y, float[] pixels, int width, int height) {
        if (x <= 0) {
            x = 0;
        }
        if (x >= width) {
            x = width - 1;
        }
        if (y <= 0) {
            y = 0;
        }
        if (y >= height) {
            y = height - 1;
        }
        return pixels[x + y * width];
    }
}

