/*
 * Decompiled with CFR 0.152.
 */
package ij.process;

import ij.measure.Calibration;
import ij.process.ImageProcessor;
import ij.process.ImageStatistics;

public class FloatStatistics
extends ImageStatistics {
    public FloatStatistics(ImageProcessor ip) {
        this(ip, 27, null);
    }

    /*
     * Unable to fully structure code
     */
    public FloatStatistics(ImageProcessor ip, int mOptions, Calibration cal) {
        super();
        this.width = ip.getWidth();
        this.height = ip.getHeight();
        this.setup(ip, cal);
        minT = ip.getMinThreshold();
        if ((mOptions & 256) == 0) ** GOTO lbl-1000
        if (minT == -808080.0) lbl-1000:
        // 2 sources

        {
            minThreshold = -3.4028234663852886E38;
            maxThreshold = 3.4028234663852886E38;
        } else {
            minThreshold = minT;
            maxThreshold = ip.getMaxThreshold();
        }
        this.getStatistics(ip, minThreshold, maxThreshold);
        if ((mOptions & 8) != 0) {
            this.getMode();
        }
        if ((mOptions & 2048) != 0) {
            this.fitEllipse(ip);
        } else if ((mOptions & 32) != 0) {
            this.getCentroid(ip, minThreshold, maxThreshold);
        }
        if ((mOptions & 64) != 0) {
            this.getCenterOfMass(ip, minThreshold, maxThreshold);
        }
    }

    void getStatistics(ImageProcessor ip, double minThreshold, double maxThreshold) {
        double v;
        float[] pixels = (float[])ip.getPixels();
        this.nBins = ip.getHistogramSize();
        this.histogram = new int[this.nBins];
        double sum = 0.0;
        double sum2 = 0.0;
        int[] mask = ip.getMask();
        double roiMin = Double.MAX_VALUE;
        double roiMax = -1.7976931348623157E308;
        double roiMin2 = Double.MAX_VALUE;
        double roiMax2 = -1.7976931348623157E308;
        int y = this.ry;
        int my = 0;
        while (y < this.ry + this.rh) {
            int i = y * this.width + this.rx;
            int mi = my * this.rw;
            for (int x = this.rx; x < this.rx + this.rw; ++x) {
                block16: {
                    block15: {
                        if (mask == null) break block15;
                        int n = mi++;
                        if (mask[n] != -16777216) break block16;
                    }
                    if ((v = (double)pixels[i]) >= minThreshold && v <= maxThreshold) {
                        if (v < roiMin) {
                            roiMin = v;
                        }
                        if (v > roiMax) {
                            roiMax = v;
                        }
                    }
                }
                ++i;
            }
            ++y;
            ++my;
        }
        this.min = roiMin;
        this.max = roiMax;
        this.histMin = this.min;
        this.histMax = this.max;
        this.binSize = (this.histMax - this.histMin) / (double)this.nBins;
        double scale = (double)this.nBins / (this.histMax - this.histMin);
        this.pixelCount = 0;
        int y2 = this.ry;
        int my2 = 0;
        while (y2 < this.ry + this.rh) {
            int i = y2 * this.width + this.rx;
            int mi = my2 * this.rw;
            for (int x = this.rx; x < this.rx + this.rw; ++x) {
                block18: {
                    block17: {
                        if (mask == null) break block17;
                        int n = mi++;
                        if (mask[n] != -16777216) break block18;
                    }
                    if ((v = (double)pixels[i]) >= minThreshold && v <= maxThreshold) {
                        ++this.pixelCount;
                        sum += v;
                        sum2 += v * v;
                        int index = (int)(scale * (v - this.histMin));
                        if (index >= this.nBins) {
                            index = this.nBins - 1;
                        }
                        int n = index;
                        this.histogram[n] = this.histogram[n] + 1;
                    }
                }
                ++i;
            }
            ++y2;
            ++my2;
        }
        this.area = (double)this.pixelCount * this.pw * this.ph;
        this.mean = sum / (double)this.pixelCount;
        this.calculateStdDev(this.pixelCount, sum, sum2);
    }

    void getMode() {
        this.maxCount = 0;
        for (int i = 0; i < this.nBins; ++i) {
            int count = this.histogram[i];
            if (count <= this.maxCount) continue;
            this.maxCount = count;
            this.mode = i;
        }
        this.dmode = this.histMin + (double)this.mode * this.binSize;
    }

    void getCenterOfMass(ImageProcessor ip, double minThreshold, double maxThreshold) {
        float[] pixels = (float[])ip.getPixels();
        int[] mask = ip.getMask();
        double count = 0.0;
        double xsum = 0.0;
        double ysum = 0.0;
        int y = this.ry;
        int my = 0;
        while (y < this.ry + this.rh) {
            int i = y * this.width + this.rx;
            int mi = my * this.rw;
            for (int x = this.rx; x < this.rx + this.rw; ++x) {
                block7: {
                    double v;
                    block6: {
                        if (mask == null) break block6;
                        int n = mi++;
                        if (mask[n] != -16777216) break block7;
                    }
                    if ((v = (double)pixels[i] + Double.MIN_VALUE) >= minThreshold && v <= maxThreshold) {
                        count += v;
                        xsum += (double)x * v;
                        ysum += (double)y * v;
                    }
                }
                ++i;
            }
            ++y;
            ++my;
        }
        this.xCenterOfMass = (xsum / count + 0.5) * this.pw;
        this.yCenterOfMass = (ysum / count + 0.5) * this.ph;
    }

    void getCentroid(ImageProcessor ip, double minThreshold, double maxThreshold) {
        float[] pixels = (float[])ip.getPixels();
        int[] mask = ip.getMask();
        double count = 0.0;
        double xsum = 0.0;
        double ysum = 0.0;
        int y = this.ry;
        int my = 0;
        while (y < this.ry + this.rh) {
            int i = y * this.width + this.rx;
            int mi = my * this.rw;
            for (int x = this.rx; x < this.rx + this.rw; ++x) {
                block7: {
                    double v;
                    block6: {
                        if (mask == null) break block6;
                        int n = mi++;
                        if (mask[n] != -16777216) break block7;
                    }
                    if ((v = (double)pixels[i]) >= minThreshold && v <= maxThreshold) {
                        count += 1.0;
                        xsum += (double)x;
                        ysum += (double)y;
                    }
                }
                ++i;
            }
            ++y;
            ++my;
        }
        this.xCentroid = (xsum / count + 0.5) * this.pw;
        this.yCentroid = (ysum / count + 0.5) * this.ph;
    }
}

