/*
 * Decompiled with CFR 0.152.
 */
package java.beans.beancontext;

import java.beans.beancontext.BeanContext;
import java.beans.beancontext.BeanContextChild;
import java.beans.beancontext.BeanContextServiceAvailableEvent;
import java.beans.beancontext.BeanContextServiceProvider;
import java.beans.beancontext.BeanContextServiceRevokedEvent;
import java.beans.beancontext.BeanContextServiceRevokedListener;
import java.beans.beancontext.BeanContextServices;
import java.beans.beancontext.BeanContextServicesListener;
import java.beans.beancontext.BeanContextSupport;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.TooManyListenersException;

public class BeanContextServicesSupport
extends BeanContextSupport
implements BeanContextServices {
    protected transient HashMap services;
    protected transient int serializable = 0;
    protected transient BCSSProxyServiceProvider proxy;
    protected transient ArrayList bcsListeners;

    public BeanContextServicesSupport(BeanContextServices beanContextServices, Locale locale, boolean bl2, boolean bl3) {
        super(beanContextServices, locale, bl2, bl3);
    }

    public BeanContextServicesSupport(BeanContextServices beanContextServices, Locale locale, boolean bl2) {
        this(beanContextServices, locale, bl2, true);
    }

    public BeanContextServicesSupport(BeanContextServices beanContextServices, Locale locale) {
        this(beanContextServices, locale, false, true);
    }

    public BeanContextServicesSupport(BeanContextServices beanContextServices) {
        this(beanContextServices, null, false, true);
    }

    public BeanContextServicesSupport() {
        this(null, null, false, true);
    }

    public void initialize() {
        super.initialize();
        this.services = new HashMap(this.serializable + 1);
        this.bcsListeners = new ArrayList(1);
    }

    public BeanContextServices getBeanContextServicesPeer() {
        return (BeanContextServices)this.getBeanContextChildPeer();
    }

    protected BeanContextSupport.BCSChild createBCSChild(Object object, Object object2) {
        return new BCSSChild(object, object2);
    }

    protected BCSSServiceProvider createBCSSServiceProvider(Class clazz, BeanContextServiceProvider beanContextServiceProvider) {
        return new BCSSServiceProvider(clazz, beanContextServiceProvider);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addBeanContextServicesListener(BeanContextServicesListener beanContextServicesListener) {
        if (beanContextServicesListener == null) {
            throw new NullPointerException("bcsl");
        }
        ArrayList arrayList = this.bcsListeners;
        synchronized (arrayList) {
            if (this.bcsListeners.contains(beanContextServicesListener)) {
                return;
            }
            this.bcsListeners.add(beanContextServicesListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeBeanContextServicesListener(BeanContextServicesListener beanContextServicesListener) {
        if (beanContextServicesListener == null) {
            throw new NullPointerException("bcsl");
        }
        ArrayList arrayList = this.bcsListeners;
        synchronized (arrayList) {
            if (!this.bcsListeners.contains(beanContextServicesListener)) {
                return;
            }
            this.bcsListeners.remove(beanContextServicesListener);
        }
    }

    public boolean addService(Class clazz, BeanContextServiceProvider beanContextServiceProvider) {
        return this.addService(clazz, beanContextServiceProvider, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean addService(Class clazz, BeanContextServiceProvider beanContextServiceProvider, boolean bl2) {
        if (clazz == null) {
            throw new NullPointerException("serviceClass");
        }
        if (beanContextServiceProvider == null) {
            throw new NullPointerException("bcsp");
        }
        Object object = BeanContext.globalHierarchyLock;
        synchronized (object) {
            if (this.services.containsKey(clazz)) {
                return false;
            }
            this.services.put(clazz, this.createBCSSServiceProvider(clazz, beanContextServiceProvider));
            if (beanContextServiceProvider instanceof Serializable) {
                ++this.serializable;
            }
            if (!bl2) {
                return true;
            }
            BeanContextServiceAvailableEvent beanContextServiceAvailableEvent = new BeanContextServiceAvailableEvent(this.getBeanContextServicesPeer(), clazz);
            this.fireServiceAdded(beanContextServiceAvailableEvent);
            HashMap hashMap = this.children;
            synchronized (hashMap) {
                for (Object k2 : this.children.keySet()) {
                    if (!(k2 instanceof BeanContextServices)) continue;
                    ((BeanContextServicesListener)k2).serviceAvailable(beanContextServiceAvailableEvent);
                }
            }
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void revokeService(Class clazz, BeanContextServiceProvider beanContextServiceProvider, boolean bl2) {
        if (clazz == null) {
            throw new NullPointerException("serviceClass");
        }
        if (beanContextServiceProvider == null) {
            throw new NullPointerException("bcsp");
        }
        Object object = BeanContext.globalHierarchyLock;
        synchronized (object) {
            if (!this.services.containsKey(clazz)) {
                return;
            }
            BCSSServiceProvider bCSSServiceProvider = (BCSSServiceProvider)this.services.get(clazz);
            if (!bCSSServiceProvider.getServiceProvider().equals(beanContextServiceProvider)) {
                throw new IllegalArgumentException("service provider mismatch");
            }
            this.services.remove(clazz);
            if (beanContextServiceProvider instanceof Serializable) {
                --this.serializable;
            }
            Iterator iterator = this.bcsChildren();
            while (iterator.hasNext()) {
                ((BCSSChild)iterator.next()).revokeService(clazz, false, bl2);
            }
            this.fireServiceRevoked(clazz, bl2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized boolean hasService(Class clazz) {
        if (clazz == null) {
            throw new NullPointerException("serviceClass");
        }
        Object object = BeanContext.globalHierarchyLock;
        synchronized (object) {
            if (this.services.containsKey(clazz)) {
                return true;
            }
            BeanContextServices beanContextServices = null;
            try {
                beanContextServices = (BeanContextServices)this.getBeanContext();
            }
            catch (ClassCastException classCastException) {
                return false;
            }
            return beanContextServices == null ? false : beanContextServices.hasService(clazz);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getService(BeanContextChild beanContextChild, Object object, Class clazz, Object object2, BeanContextServiceRevokedListener beanContextServiceRevokedListener) throws TooManyListenersException {
        if (beanContextChild == null) {
            throw new NullPointerException("child");
        }
        if (clazz == null) {
            throw new NullPointerException("serviceClass");
        }
        if (object == null) {
            throw new NullPointerException("requestor");
        }
        if (beanContextServiceRevokedListener == null) {
            throw new NullPointerException("bcsrl");
        }
        Object object3 = null;
        BeanContextServices beanContextServices = this.getBeanContextServicesPeer();
        Object object4 = BeanContext.globalHierarchyLock;
        synchronized (object4) {
            BeanContextServiceProvider beanContextServiceProvider;
            BCSSChild bCSSChild;
            Serializable serializable = this.children;
            synchronized (serializable) {
                bCSSChild = (BCSSChild)this.children.get(beanContextChild);
            }
            if (bCSSChild == null) {
                throw new IllegalArgumentException("not a child of this context");
            }
            serializable = (BCSSServiceProvider)this.services.get(clazz);
            if (serializable != null && (object3 = (beanContextServiceProvider = ((BCSSServiceProvider)serializable).getServiceProvider()).getService(beanContextServices, object, clazz, object2)) != null) {
                try {
                    bCSSChild.usingService(object, object3, clazz, beanContextServiceProvider, false, beanContextServiceRevokedListener);
                }
                catch (TooManyListenersException tooManyListenersException) {
                    beanContextServiceProvider.releaseService(beanContextServices, object, object3);
                    throw tooManyListenersException;
                }
                catch (UnsupportedOperationException unsupportedOperationException) {
                    beanContextServiceProvider.releaseService(beanContextServices, object, object3);
                    throw unsupportedOperationException;
                }
                return object3;
            }
            if (this.proxy != null && (object3 = this.proxy.getService(beanContextServices, object, clazz, object2)) != null) {
                try {
                    bCSSChild.usingService(object, object3, clazz, this.proxy, true, beanContextServiceRevokedListener);
                }
                catch (TooManyListenersException tooManyListenersException) {
                    this.proxy.releaseService(beanContextServices, object, object3);
                    throw tooManyListenersException;
                }
                catch (UnsupportedOperationException unsupportedOperationException) {
                    this.proxy.releaseService(beanContextServices, object, object3);
                    throw unsupportedOperationException;
                }
                return object3;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releaseService(BeanContextChild beanContextChild, Object object, Object object2) {
        if (beanContextChild == null) {
            throw new NullPointerException("child");
        }
        if (object == null) {
            throw new NullPointerException("requestor");
        }
        if (object2 == null) {
            throw new NullPointerException("service");
        }
        Object object3 = BeanContext.globalHierarchyLock;
        synchronized (object3) {
            BCSSChild bCSSChild;
            HashMap hashMap = this.children;
            synchronized (hashMap) {
                bCSSChild = (BCSSChild)this.children.get(beanContextChild);
            }
            if (bCSSChild == null) {
                throw new IllegalArgumentException("child actual is not a child of this BeanContext");
            }
            bCSSChild.releaseService(object, object2);
        }
    }

    public Iterator getCurrentServiceClasses() {
        return new BeanContextSupport.BCSIterator(this.services.keySet().iterator());
    }

    public Iterator getCurrentServiceSelectors(Class clazz) {
        BCSSServiceProvider bCSSServiceProvider = (BCSSServiceProvider)this.services.get(clazz);
        return bCSSServiceProvider != null ? new BeanContextSupport.BCSIterator(bCSSServiceProvider.getServiceProvider().getCurrentServiceSelectors(this.getBeanContextServicesPeer(), clazz)) : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void serviceAvailable(BeanContextServiceAvailableEvent beanContextServiceAvailableEvent) {
        Object object = BeanContext.globalHierarchyLock;
        synchronized (object) {
            Iterator iterator;
            if (this.services.containsKey(beanContextServiceAvailableEvent.getServiceClass())) {
                return;
            }
            this.fireServiceAdded(beanContextServiceAvailableEvent);
            HashMap hashMap = this.children;
            synchronized (hashMap) {
                iterator = this.children.keySet().iterator();
            }
            while (iterator.hasNext()) {
                hashMap = iterator.next();
                if (!(hashMap instanceof BeanContextServices)) continue;
                ((BeanContextServicesListener)((Object)hashMap)).serviceAvailable(beanContextServiceAvailableEvent);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void serviceRevoked(BeanContextServiceRevokedEvent beanContextServiceRevokedEvent) {
        Object object = BeanContext.globalHierarchyLock;
        synchronized (object) {
            Iterator iterator;
            if (this.services.containsKey(beanContextServiceRevokedEvent.getServiceClass())) {
                return;
            }
            this.fireServiceRevoked(beanContextServiceRevokedEvent);
            HashMap hashMap = this.children;
            synchronized (hashMap) {
                iterator = this.children.keySet().iterator();
            }
            while (iterator.hasNext()) {
                hashMap = iterator.next();
                if (!(hashMap instanceof BeanContextServices)) continue;
                ((BeanContextServicesListener)((Object)hashMap)).serviceRevoked(beanContextServiceRevokedEvent);
            }
        }
    }

    protected static final BeanContextServicesListener getChildBeanContextServicesListener(Object object) {
        try {
            return (BeanContextServicesListener)object;
        }
        catch (ClassCastException classCastException) {
            return null;
        }
    }

    protected void childJustRemovedHook(Object object, BeanContextSupport.BCSChild bCSChild) {
        BCSSChild bCSSChild = (BCSSChild)bCSChild;
        bCSSChild.cleanupReferences();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized void releaseBeanContextResources() {
        Object[] objectArray;
        super.releaseBeanContextResources();
        HashMap hashMap = this.children;
        synchronized (hashMap) {
            if (this.children.isEmpty()) {
                return;
            }
            objectArray = this.children.values().toArray();
        }
        for (int i2 = 0; i2 < objectArray.length; ++i2) {
            ((BCSSChild)objectArray[i2]).revokeAllDelegatedServicesNow();
        }
        this.proxy = null;
    }

    protected synchronized void initializeBeanContextResources() {
        super.initializeBeanContextResources();
        BeanContext beanContext = this.getBeanContext();
        if (beanContext == null) {
            return;
        }
        try {
            BeanContextServices beanContextServices = (BeanContextServices)beanContext;
            this.proxy = new BCSSProxyServiceProvider(beanContextServices);
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
    }

    protected final void fireServiceAdded(Class clazz) {
        BeanContextServiceAvailableEvent beanContextServiceAvailableEvent = new BeanContextServiceAvailableEvent(this.getBeanContextServicesPeer(), clazz);
        this.fireServiceAdded(beanContextServiceAvailableEvent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void fireServiceAdded(BeanContextServiceAvailableEvent beanContextServiceAvailableEvent) {
        Object[] objectArray;
        ArrayList arrayList = this.bcsListeners;
        synchronized (arrayList) {
            objectArray = this.bcsListeners.toArray();
        }
        for (int i2 = 0; i2 < objectArray.length; ++i2) {
            ((BeanContextServicesListener)objectArray[i2]).serviceAvailable(beanContextServiceAvailableEvent);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void fireServiceRevoked(BeanContextServiceRevokedEvent beanContextServiceRevokedEvent) {
        Object[] objectArray;
        ArrayList arrayList = this.bcsListeners;
        synchronized (arrayList) {
            objectArray = this.bcsListeners.toArray();
        }
        for (int i2 = 0; i2 < objectArray.length; ++i2) {
            ((BeanContextServiceRevokedListener)objectArray[i2]).serviceRevoked(beanContextServiceRevokedEvent);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void fireServiceRevoked(Class clazz, boolean bl2) {
        Object[] objectArray;
        BeanContextServiceRevokedEvent beanContextServiceRevokedEvent = new BeanContextServiceRevokedEvent(this.getBeanContextServicesPeer(), clazz, bl2);
        ArrayList arrayList = this.bcsListeners;
        synchronized (arrayList) {
            objectArray = this.bcsListeners.toArray();
        }
        for (int i2 = 0; i2 < objectArray.length; ++i2) {
            ((BeanContextServicesListener)objectArray[i2]).serviceRevoked(beanContextServiceRevokedEvent);
        }
    }

    protected synchronized void bcsPreSerializationHook(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.writeInt(this.serializable);
        if (this.serializable <= 0) {
            return;
        }
        int n2 = 0;
        Iterator iterator = this.services.entrySet().iterator();
        while (iterator.hasNext() && n2 < this.serializable) {
            Map.Entry entry = iterator.next();
            BCSSServiceProvider bCSSServiceProvider = null;
            try {
                bCSSServiceProvider = (BCSSServiceProvider)entry.getValue();
            }
            catch (ClassCastException classCastException) {
                continue;
            }
            if (!(bCSSServiceProvider.getServiceProvider() instanceof Serializable)) continue;
            objectOutputStream.writeObject(entry.getKey());
            objectOutputStream.writeObject(bCSSServiceProvider);
            ++n2;
        }
        if (n2 != this.serializable) {
            throw new IOException("wrote different number of service providers than expected");
        }
    }

    protected synchronized void bcsPreDeserializationHook(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        for (int i2 = this.serializable = objectInputStream.readInt(); i2 > 0; --i2) {
            this.services.put(objectInputStream.readObject(), objectInputStream.readObject());
        }
    }

    private synchronized void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        this.serialize(objectOutputStream, this.bcsListeners);
    }

    private synchronized void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.deserialize(objectInputStream, this.bcsListeners);
    }

    protected class BCSSChild
    extends BeanContextSupport.BCSChild {
        private static final long serialVersionUID = -3263851306889194873L;
        private transient HashMap serviceClasses;
        private transient HashMap serviceRequestors;

        BCSSChild(Object object, Object object2) {
            super(BeanContextServicesSupport.this, object, object2);
        }

        synchronized void usingService(Object object, Object object2, Class clazz, BeanContextServiceProvider beanContextServiceProvider, boolean bl2, BeanContextServiceRevokedListener beanContextServiceRevokedListener) throws TooManyListenersException, UnsupportedOperationException {
            BCSSCServiceClassRef bCSSCServiceClassRef = null;
            if (this.serviceClasses == null) {
                this.serviceClasses = new HashMap(1);
            } else {
                bCSSCServiceClassRef = (BCSSCServiceClassRef)this.serviceClasses.get(clazz);
            }
            if (bCSSCServiceClassRef == null) {
                bCSSCServiceClassRef = new BCSSCServiceClassRef(clazz, beanContextServiceProvider, bl2);
                this.serviceClasses.put(clazz, bCSSCServiceClassRef);
            } else {
                bCSSCServiceClassRef.verifyAndMaybeSetProvider(beanContextServiceProvider, bl2);
                bCSSCServiceClassRef.verifyRequestor(object, beanContextServiceRevokedListener);
            }
            bCSSCServiceClassRef.addRequestor(object, beanContextServiceRevokedListener);
            bCSSCServiceClassRef.addRef(bl2);
            BCSSCServiceRef bCSSCServiceRef = null;
            HashMap<Object, BCSSCServiceRef> hashMap = null;
            if (this.serviceRequestors == null) {
                this.serviceRequestors = new HashMap(1);
            } else {
                hashMap = (HashMap<Object, BCSSCServiceRef>)this.serviceRequestors.get(object);
            }
            if (hashMap == null) {
                hashMap = new HashMap<Object, BCSSCServiceRef>(1);
                this.serviceRequestors.put(object, hashMap);
            } else {
                bCSSCServiceRef = (BCSSCServiceRef)hashMap.get(object2);
            }
            if (bCSSCServiceRef == null) {
                bCSSCServiceRef = new BCSSCServiceRef(bCSSCServiceClassRef, bl2);
                hashMap.put(object2, bCSSCServiceRef);
            } else {
                bCSSCServiceRef.addRef();
            }
        }

        synchronized void releaseService(Object object, Object object2) {
            if (this.serviceRequestors == null) {
                return;
            }
            Map map = (Map)this.serviceRequestors.get(object);
            if (map == null) {
                return;
            }
            BCSSCServiceRef bCSSCServiceRef = (BCSSCServiceRef)map.get(object2);
            if (bCSSCServiceRef == null) {
                return;
            }
            BCSSCServiceClassRef bCSSCServiceClassRef = bCSSCServiceRef.getServiceClassRef();
            boolean bl2 = bCSSCServiceRef.isDelegated();
            BeanContextServiceProvider beanContextServiceProvider = bl2 ? bCSSCServiceClassRef.getDelegateProvider() : bCSSCServiceClassRef.getServiceProvider();
            beanContextServiceProvider.releaseService(BeanContextServicesSupport.this.getBeanContextServicesPeer(), object, object2);
            bCSSCServiceClassRef.releaseRef(bl2);
            bCSSCServiceClassRef.removeRequestor(object);
            if (bCSSCServiceRef.release() == 0) {
                map.remove(object2);
                if (map.isEmpty()) {
                    this.serviceRequestors.remove(object);
                    bCSSCServiceClassRef.removeRequestor(object);
                }
                if (this.serviceRequestors.isEmpty()) {
                    this.serviceRequestors = null;
                }
                if (bCSSCServiceClassRef.isEmpty()) {
                    this.serviceClasses.remove(bCSSCServiceClassRef.getServiceClass());
                }
                if (this.serviceClasses.isEmpty()) {
                    this.serviceClasses = null;
                }
            }
        }

        synchronized void revokeService(Class clazz, boolean bl2, boolean bl3) {
            if (this.serviceClasses == null) {
                return;
            }
            BCSSCServiceClassRef bCSSCServiceClassRef = (BCSSCServiceClassRef)this.serviceClasses.get(clazz);
            if (bCSSCServiceClassRef == null) {
                return;
            }
            Iterator iterator = bCSSCServiceClassRef.cloneOfEntries();
            BeanContextServiceRevokedEvent beanContextServiceRevokedEvent = new BeanContextServiceRevokedEvent(BeanContextServicesSupport.this.getBeanContextServicesPeer(), clazz, bl3);
            boolean bl4 = false;
            while (iterator.hasNext() && this.serviceRequestors != null) {
                Map.Entry entry = (Map.Entry)iterator.next();
                BeanContextServiceRevokedListener beanContextServiceRevokedListener = (BeanContextServiceRevokedListener)entry.getValue();
                if (bl3) {
                    Object k2 = entry.getKey();
                    Map map = (Map)this.serviceRequestors.get(k2);
                    if (map != null) {
                        Iterator iterator2 = map.entrySet().iterator();
                        while (iterator2.hasNext()) {
                            Map.Entry entry2 = iterator2.next();
                            BCSSCServiceRef bCSSCServiceRef = (BCSSCServiceRef)entry2.getValue();
                            if (!bCSSCServiceRef.getServiceClassRef().equals(bCSSCServiceClassRef) || bl2 != bCSSCServiceRef.isDelegated()) continue;
                            iterator2.remove();
                        }
                        bl4 = map.isEmpty();
                        if (bl4) {
                            this.serviceRequestors.remove(k2);
                        }
                    }
                    if (bl4) {
                        bCSSCServiceClassRef.removeRequestor(k2);
                    }
                }
                beanContextServiceRevokedListener.serviceRevoked(beanContextServiceRevokedEvent);
            }
            if (bl3 && this.serviceClasses != null) {
                if (bCSSCServiceClassRef.isEmpty()) {
                    this.serviceClasses.remove(clazz);
                }
                if (this.serviceClasses.isEmpty()) {
                    this.serviceClasses = null;
                }
            }
            if (this.serviceRequestors != null && this.serviceRequestors.isEmpty()) {
                this.serviceRequestors = null;
            }
        }

        void cleanupReferences() {
            if (this.serviceRequestors == null) {
                return;
            }
            Iterator iterator = this.serviceRequestors.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                Object k2 = entry.getKey();
                Iterator iterator2 = ((Map)entry.getValue()).entrySet().iterator();
                iterator.remove();
                while (iterator2.hasNext()) {
                    Map.Entry entry2 = iterator2.next();
                    Object k3 = entry2.getKey();
                    BCSSCServiceRef bCSSCServiceRef = (BCSSCServiceRef)entry2.getValue();
                    BCSSCServiceClassRef bCSSCServiceClassRef = bCSSCServiceRef.getServiceClassRef();
                    BeanContextServiceProvider beanContextServiceProvider = bCSSCServiceRef.isDelegated() ? bCSSCServiceClassRef.getDelegateProvider() : bCSSCServiceClassRef.getServiceProvider();
                    bCSSCServiceClassRef.removeRequestor(k2);
                    iterator2.remove();
                    while (bCSSCServiceRef.release() >= 0) {
                        beanContextServiceProvider.releaseService(BeanContextServicesSupport.this.getBeanContextServicesPeer(), k2, k3);
                    }
                }
            }
            this.serviceRequestors = null;
            this.serviceClasses = null;
        }

        void revokeAllDelegatedServicesNow() {
            if (this.serviceClasses == null) {
                return;
            }
            for (BCSSCServiceClassRef bCSSCServiceClassRef : new HashSet(this.serviceClasses.values())) {
                if (!bCSSCServiceClassRef.isDelegated()) continue;
                Iterator iterator = bCSSCServiceClassRef.cloneOfEntries();
                BeanContextServiceRevokedEvent beanContextServiceRevokedEvent = new BeanContextServiceRevokedEvent(BeanContextServicesSupport.this.getBeanContextServicesPeer(), bCSSCServiceClassRef.getServiceClass(), true);
                boolean bl2 = false;
                while (iterator.hasNext()) {
                    Map.Entry entry = (Map.Entry)iterator.next();
                    BeanContextServiceRevokedListener beanContextServiceRevokedListener = (BeanContextServiceRevokedListener)entry.getValue();
                    Object k2 = entry.getKey();
                    Map map = (Map)this.serviceRequestors.get(k2);
                    if (map != null) {
                        Iterator iterator2 = map.entrySet().iterator();
                        while (iterator2.hasNext()) {
                            Map.Entry entry2 = iterator2.next();
                            BCSSCServiceRef bCSSCServiceRef = (BCSSCServiceRef)entry2.getValue();
                            if (!bCSSCServiceRef.getServiceClassRef().equals(bCSSCServiceClassRef) || !bCSSCServiceRef.isDelegated()) continue;
                            iterator2.remove();
                        }
                        bl2 = map.isEmpty();
                        if (bl2) {
                            this.serviceRequestors.remove(k2);
                        }
                    }
                    if (bl2) {
                        bCSSCServiceClassRef.removeRequestor(k2);
                    }
                    beanContextServiceRevokedListener.serviceRevoked(beanContextServiceRevokedEvent);
                    if (!bCSSCServiceClassRef.isEmpty()) continue;
                    this.serviceClasses.remove(bCSSCServiceClassRef.getServiceClass());
                }
            }
            if (this.serviceClasses.isEmpty()) {
                this.serviceClasses = null;
            }
            if (this.serviceRequestors != null && this.serviceRequestors.isEmpty()) {
                this.serviceRequestors = null;
            }
        }

        class BCSSCServiceClassRef {
            Class serviceClass;
            BeanContextServiceProvider serviceProvider;
            int serviceRefs;
            BeanContextServiceProvider delegateProvider;
            int delegateRefs;
            HashMap requestors = new HashMap(1);

            BCSSCServiceClassRef(Class clazz, BeanContextServiceProvider beanContextServiceProvider, boolean bl2) {
                this.serviceClass = clazz;
                if (bl2) {
                    this.delegateProvider = beanContextServiceProvider;
                } else {
                    this.serviceProvider = beanContextServiceProvider;
                }
            }

            void addRequestor(Object object, BeanContextServiceRevokedListener beanContextServiceRevokedListener) throws TooManyListenersException {
                BeanContextServiceRevokedListener beanContextServiceRevokedListener2 = (BeanContextServiceRevokedListener)this.requestors.get(object);
                if (beanContextServiceRevokedListener2 != null && !beanContextServiceRevokedListener2.equals(beanContextServiceRevokedListener)) {
                    throw new TooManyListenersException();
                }
                this.requestors.put(object, beanContextServiceRevokedListener);
            }

            void removeRequestor(Object object) {
                this.requestors.remove(object);
            }

            void verifyRequestor(Object object, BeanContextServiceRevokedListener beanContextServiceRevokedListener) throws TooManyListenersException {
                BeanContextServiceRevokedListener beanContextServiceRevokedListener2 = (BeanContextServiceRevokedListener)this.requestors.get(object);
                if (beanContextServiceRevokedListener2 != null && !beanContextServiceRevokedListener2.equals(beanContextServiceRevokedListener)) {
                    throw new TooManyListenersException();
                }
            }

            void verifyAndMaybeSetProvider(BeanContextServiceProvider beanContextServiceProvider, boolean bl2) {
                BeanContextServiceProvider beanContextServiceProvider2;
                if (bl2) {
                    beanContextServiceProvider2 = this.delegateProvider;
                    if (beanContextServiceProvider2 == null || beanContextServiceProvider == null) {
                        this.delegateProvider = beanContextServiceProvider;
                        return;
                    }
                } else {
                    beanContextServiceProvider2 = this.serviceProvider;
                    if (beanContextServiceProvider2 == null || beanContextServiceProvider == null) {
                        this.serviceProvider = beanContextServiceProvider;
                        return;
                    }
                }
                if (!beanContextServiceProvider2.equals(beanContextServiceProvider)) {
                    throw new UnsupportedOperationException("existing service reference obtained from different BeanContextServiceProvider not supported");
                }
            }

            Iterator cloneOfEntries() {
                return ((HashMap)this.requestors.clone()).entrySet().iterator();
            }

            Iterator entries() {
                return this.requestors.entrySet().iterator();
            }

            boolean isEmpty() {
                return this.requestors.isEmpty();
            }

            Class getServiceClass() {
                return this.serviceClass;
            }

            BeanContextServiceProvider getServiceProvider() {
                return this.serviceProvider;
            }

            BeanContextServiceProvider getDelegateProvider() {
                return this.delegateProvider;
            }

            boolean isDelegated() {
                return this.delegateProvider != null;
            }

            void addRef(boolean bl2) {
                if (bl2) {
                    ++this.delegateRefs;
                } else {
                    ++this.serviceRefs;
                }
            }

            void releaseRef(boolean bl2) {
                if (bl2) {
                    if (--this.delegateRefs == 0) {
                        this.delegateProvider = null;
                    }
                } else if (--this.serviceRefs <= 0) {
                    this.serviceProvider = null;
                }
            }

            int getRefs() {
                return this.serviceRefs + this.delegateRefs;
            }

            int getDelegateRefs() {
                return this.delegateRefs;
            }

            int getServiceRefs() {
                return this.serviceRefs;
            }
        }

        class BCSSCServiceRef {
            BCSSCServiceClassRef serviceClassRef;
            int refCnt = 1;
            boolean delegated = false;

            BCSSCServiceRef(BCSSCServiceClassRef bCSSCServiceClassRef, boolean bl2) {
                this.serviceClassRef = bCSSCServiceClassRef;
                this.delegated = bl2;
            }

            void addRef() {
                ++this.refCnt;
            }

            int release() {
                return --this.refCnt;
            }

            BCSSCServiceClassRef getServiceClassRef() {
                return this.serviceClassRef;
            }

            boolean isDelegated() {
                return this.delegated;
            }
        }
    }

    protected class BCSSProxyServiceProvider
    implements BeanContextServiceProvider,
    BeanContextServiceRevokedListener {
        private BeanContextServices nestingCtxt;

        BCSSProxyServiceProvider(BeanContextServices beanContextServices) {
            this.nestingCtxt = beanContextServices;
        }

        public Object getService(BeanContextServices beanContextServices, Object object, Class clazz, Object object2) {
            Object object3 = null;
            try {
                object3 = this.nestingCtxt.getService(beanContextServices, object, clazz, object2, this);
            }
            catch (TooManyListenersException tooManyListenersException) {
                return null;
            }
            return object3;
        }

        public void releaseService(BeanContextServices beanContextServices, Object object, Object object2) {
            this.nestingCtxt.releaseService(beanContextServices, object, object2);
        }

        public Iterator getCurrentServiceSelectors(BeanContextServices beanContextServices, Class clazz) {
            return this.nestingCtxt.getCurrentServiceSelectors(clazz);
        }

        public void serviceRevoked(BeanContextServiceRevokedEvent beanContextServiceRevokedEvent) {
            Iterator iterator = BeanContextServicesSupport.this.bcsChildren();
            while (iterator.hasNext()) {
                ((BCSSChild)iterator.next()).revokeService(beanContextServiceRevokedEvent.getServiceClass(), true, beanContextServiceRevokedEvent.isCurrentServiceInvalidNow());
            }
        }
    }

    protected static class BCSSServiceProvider
    implements Serializable {
        protected BeanContextServiceProvider serviceProvider;

        BCSSServiceProvider(Class clazz, BeanContextServiceProvider beanContextServiceProvider) {
            this.serviceProvider = beanContextServiceProvider;
        }

        protected BeanContextServiceProvider getServiceProvider() {
            return this.serviceProvider;
        }
    }
}

