/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.io.Serializable;
import java.lang.ref.SoftReference;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.text.DateFormatSymbols;
import java.util.Date;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Map;
import sun.security.action.GetPropertyAction;
import sun.util.calendar.ZoneInfo;
import sun.util.calendar.ZoneInfoFile;

public abstract class TimeZone
implements Serializable,
Cloneable {
    public static final int SHORT = 0;
    public static final int LONG = 1;
    private static final int ONE_MINUTE = 60000;
    private static final int ONE_HOUR = 3600000;
    private static final int ONE_DAY = 86400000;
    private static Hashtable cachedLocaleData = new Hashtable(3);
    static final long serialVersionUID = 3581463369166924961L;
    private static Map<String, SoftReference> displayNames;
    static final TimeZone NO_TIMEZONE;
    private String ID;
    private static final InheritableThreadLocal defaultZoneTL;
    static final String GMT_ID = "GMT";
    private static final int GMT_ID_LENGTH = 3;

    public abstract int getOffset(int var1, int var2, int var3, int var4, int var5, int var6);

    public int getOffset(long l2) {
        if (this.inDaylightTime(new Date(l2))) {
            return this.getRawOffset() + this.getDSTSavings();
        }
        return this.getRawOffset();
    }

    int getOffsets(long l2, int[] nArray) {
        int n2 = this.getRawOffset();
        int n3 = 0;
        if (this.inDaylightTime(new Date(l2))) {
            n3 = this.getDSTSavings();
        }
        if (nArray != null) {
            nArray[0] = n2;
            nArray[1] = n3;
        }
        return n2 + n3;
    }

    public abstract void setRawOffset(int var1);

    public abstract int getRawOffset();

    public String getID() {
        return this.ID;
    }

    public void setID(String string) {
        if (string == null) {
            throw new NullPointerException();
        }
        this.ID = string;
    }

    public final String getDisplayName() {
        return this.getDisplayName(false, 1, Locale.getDefault());
    }

    public final String getDisplayName(Locale locale) {
        return this.getDisplayName(false, 1, locale);
    }

    public final String getDisplayName(boolean bl2, int n2) {
        return this.getDisplayName(bl2, n2, Locale.getDefault());
    }

    public String getDisplayName(boolean bl2, int n2, Locale locale) {
        int n3;
        if (n2 != 0 && n2 != 1) {
            throw new IllegalArgumentException("Illegal style: " + n2);
        }
        String string = this.getID();
        String[] stringArray = TimeZone.getDisplayNames(string, locale);
        if (stringArray == null) {
            int n4;
            if (string.startsWith(GMT_ID) && ((n4 = (int)string.charAt(3)) == 43 || n4 == 45)) {
                return string;
            }
            n4 = this.getRawOffset();
            if (bl2) {
                n4 += this.getDSTSavings();
            }
            return ZoneInfoFile.toCustomID(n4);
        }
        int n5 = n3 = bl2 && this.useDaylightTime() ? 3 : 1;
        if (n2 == 0) {
            ++n3;
        }
        return stringArray[n3];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final String[] getDisplayNames(String string, Locale locale) {
        Object object = TimeZone.class;
        synchronized (TimeZone.class) {
            if (displayNames == null) {
                displayNames = new HashMap<String, SoftReference>();
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            object = displayNames;
            synchronized (object) {
                HashMap<Locale, String[]> hashMap;
                SoftReference softReference = displayNames.get(string);
                if (softReference != null && (hashMap = (HashMap<Locale, String[]>)softReference.get()) != null) {
                    String[] stringArray = (String[])hashMap.get(locale);
                    if (stringArray != null) {
                        return stringArray;
                    }
                    stringArray = TimeZone.retrieveDisplayNames(string, locale);
                    if (stringArray != null) {
                        hashMap.put(locale, stringArray);
                    }
                    return stringArray;
                }
                String[] stringArray = TimeZone.retrieveDisplayNames(string, locale);
                if (stringArray != null) {
                    hashMap = new HashMap<Locale, String[]>();
                    hashMap.put(locale, stringArray);
                    softReference = new SoftReference(hashMap);
                    displayNames.put(string, softReference);
                }
                return stringArray;
            }
        }
    }

    private static final String[] retrieveDisplayNames(String string, Locale locale) {
        String[][] stringArray = new DateFormatSymbols(locale).getZoneStrings();
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            String[] stringArray2 = stringArray[i2];
            if (!string.equals(stringArray2[0])) continue;
            return stringArray2;
        }
        return null;
    }

    public int getDSTSavings() {
        if (this.useDaylightTime()) {
            return 3600000;
        }
        return 0;
    }

    public abstract boolean useDaylightTime();

    public abstract boolean inDaylightTime(Date var1);

    public static synchronized TimeZone getTimeZone(String string) {
        return TimeZone.getTimeZone(string, true);
    }

    private static TimeZone getTimeZone(String string, boolean bl2) {
        TimeZone timeZone = ZoneInfo.getTimeZone(string);
        if (timeZone == null && (timeZone = TimeZone.parseCustomTimeZone(string)) == null && bl2) {
            timeZone = new ZoneInfo(GMT_ID, 0);
        }
        return timeZone;
    }

    public static synchronized String[] getAvailableIDs(int n2) {
        return ZoneInfo.getAvailableIDs(n2);
    }

    public static synchronized String[] getAvailableIDs() {
        return ZoneInfo.getAvailableIDs();
    }

    private static native String getSystemTimeZoneID(String var0, String var1);

    private static native String getSystemGMTOffsetID();

    public static synchronized TimeZone getDefault() {
        TimeZone timeZone = (TimeZone)defaultZoneTL.get();
        if (timeZone == null) {
            TimeZone.setDefaultZone();
            timeZone = (TimeZone)defaultZoneTL.get();
        }
        return (TimeZone)timeZone.clone();
    }

    static synchronized TimeZone getDefaultRef() {
        TimeZone timeZone = (TimeZone)defaultZoneTL.get();
        if (timeZone == null) {
            TimeZone.setDefaultZone();
            timeZone = (TimeZone)defaultZoneTL.get();
        }
        return timeZone;
    }

    private static void setDefaultZone() {
        String string;
        TimeZone timeZone = null;
        String string2 = (String)AccessController.doPrivileged(new GetPropertyAction("user.timezone"));
        if (string2 == null || string2.equals("")) {
            string = (String)AccessController.doPrivileged(new GetPropertyAction("user.country"));
            String string3 = (String)AccessController.doPrivileged(new GetPropertyAction("java.home"));
            try {
                string2 = TimeZone.getSystemTimeZoneID(string3, string);
                if (string2 == null) {
                    string2 = GMT_ID;
                }
            }
            catch (NullPointerException nullPointerException) {
                string2 = GMT_ID;
            }
        }
        if ((timeZone = TimeZone.getTimeZone(string2, false)) == null) {
            string = TimeZone.getSystemGMTOffsetID();
            if (string != null) {
                string2 = string;
            }
            timeZone = TimeZone.getTimeZone(string2, true);
        }
        assert (timeZone != null);
        string = string2;
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                System.setProperty("user.timezone", string);
                return null;
            }
        });
        defaultZoneTL.set(timeZone);
    }

    public static synchronized void setDefault(TimeZone timeZone) {
        defaultZoneTL.set(timeZone);
    }

    public boolean hasSameRules(TimeZone timeZone) {
        return timeZone != null && this.getRawOffset() == timeZone.getRawOffset() && this.useDaylightTime() == timeZone.useDaylightTime();
    }

    public Object clone() {
        try {
            TimeZone timeZone = (TimeZone)super.clone();
            timeZone.ID = this.ID;
            return timeZone;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
    }

    private static final TimeZone parseCustomTimeZone(String string) {
        char c2;
        int n2 = string.length();
        if (n2 < 5 || string.indexOf(GMT_ID) != 0) {
            return null;
        }
        ZoneInfo zoneInfo = ZoneInfoFile.getZoneInfo(string);
        if (zoneInfo != null) {
            return zoneInfo;
        }
        int n3 = 3;
        boolean bl2 = false;
        if ((c2 = string.charAt(n3++)) == '-') {
            bl2 = true;
        } else if (c2 != '+') {
            return null;
        }
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        while (n3 < n2) {
            if ((c2 = string.charAt(n3++)) == ':') {
                if (n6 > 0) {
                    return null;
                }
                if (n7 > 2) {
                    return null;
                }
                n4 = n5;
                ++n6;
                n5 = 0;
                n7 = 0;
                continue;
            }
            if (c2 < '0' || c2 > '9') {
                return null;
            }
            n5 = n5 * 10 + (c2 - 48);
            ++n7;
        }
        if (n3 != n2) {
            return null;
        }
        if (n6 == 0) {
            if (n7 <= 2) {
                n4 = n5;
                n5 = 0;
            } else {
                n4 = n5 / 100;
                n5 %= 100;
            }
        } else if (n7 != 2) {
            return null;
        }
        if (n4 > 23 || n5 > 59) {
            return null;
        }
        int n8 = (n4 * 60 + n5) * 60 * 1000;
        if (n8 == 0) {
            zoneInfo = ZoneInfoFile.getZoneInfo(GMT_ID);
            if (bl2) {
                zoneInfo.setID("GMT-00:00");
            } else {
                zoneInfo.setID("GMT+00:00");
            }
        } else {
            zoneInfo = ZoneInfoFile.getCustomTimeZone(string, bl2 ? -n8 : n8);
        }
        return zoneInfo;
    }

    static {
        NO_TIMEZONE = null;
        defaultZoneTL = new InheritableThreadLocal();
    }
}

