/*
 * Decompiled with CFR 0.152.
 */
package java.util.concurrent;

import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletionService;
import java.util.concurrent.Executor;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExecutorCompletionService<V>
implements CompletionService<V> {
    private final Executor executor;
    private final BlockingQueue<Future<V>> completionQueue;

    public ExecutorCompletionService(Executor executor) {
        if (executor == null) {
            throw new NullPointerException();
        }
        this.executor = executor;
        this.completionQueue = new LinkedBlockingQueue<Future<V>>();
    }

    public ExecutorCompletionService(Executor executor, BlockingQueue<Future<V>> blockingQueue) {
        if (executor == null || blockingQueue == null) {
            throw new NullPointerException();
        }
        this.executor = executor;
        this.completionQueue = blockingQueue;
    }

    @Override
    public Future<V> submit(Callable<V> callable) {
        if (callable == null) {
            throw new NullPointerException();
        }
        QueueingFuture queueingFuture = new QueueingFuture(callable);
        this.executor.execute(queueingFuture);
        return queueingFuture;
    }

    @Override
    public Future<V> submit(Runnable runnable, V v2) {
        if (runnable == null) {
            throw new NullPointerException();
        }
        QueueingFuture queueingFuture = new QueueingFuture(runnable, v2);
        this.executor.execute(queueingFuture);
        return queueingFuture;
    }

    @Override
    public Future<V> take() throws InterruptedException {
        return this.completionQueue.take();
    }

    @Override
    public Future<V> poll() {
        return (Future)this.completionQueue.poll();
    }

    @Override
    public Future<V> poll(long l2, TimeUnit timeUnit) throws InterruptedException {
        return this.completionQueue.poll(l2, timeUnit);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class QueueingFuture
    extends FutureTask<V> {
        QueueingFuture(Callable<V> callable) {
            super(callable);
        }

        QueueingFuture(Runnable runnable, V v2) {
            super(runnable, v2);
        }

        @Override
        protected void done() {
            ExecutorCompletionService.this.completionQueue.add(this);
        }
    }
}

