/*
 * Decompiled with CFR 0.152.
 */
package javax.management;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.security.Permission;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;

public class MBeanPermission
extends Permission {
    private static final long serialVersionUID = -2416928705275160661L;
    private static final int AddNotificationListener = 1;
    private static final int GetAttribute = 2;
    private static final int GetClassLoader = 4;
    private static final int GetClassLoaderFor = 8;
    private static final int GetClassLoaderRepository = 16;
    private static final int GetDomains = 32;
    private static final int GetMBeanInfo = 64;
    private static final int GetObjectInstance = 128;
    private static final int Instantiate = 256;
    private static final int Invoke = 512;
    private static final int IsInstanceOf = 1024;
    private static final int QueryMBeans = 2048;
    private static final int QueryNames = 4096;
    private static final int RegisterMBean = 8192;
    private static final int RemoveNotificationListener = 16384;
    private static final int SetAttribute = 32768;
    private static final int UnregisterMBean = 65536;
    private static final int NONE = 0;
    private static final int ALL = 131071;
    private static final ObjectName allObjectNames;
    private String actions;
    private transient int mask;
    private transient String classNamePrefix;
    private transient boolean classNameExactMatch;
    private transient String member;
    private transient ObjectName objectName;

    private void parseActions() {
        if (this.actions == null) {
            throw new IllegalArgumentException("MBeanPermission: actions can't be null");
        }
        if (this.actions.equals("")) {
            throw new IllegalArgumentException("MBeanPermission: actions can't be empty");
        }
        int n2 = MBeanPermission.getMask(this.actions);
        if ((n2 & 0x1FFFF) != n2) {
            throw new IllegalArgumentException("Invalid actions mask");
        }
        if (n2 == 0) {
            throw new IllegalArgumentException("Invalid actions mask");
        }
        this.mask = n2;
    }

    private void parseName() {
        String string = this.getName();
        if (string.equals("")) {
            throw new IllegalArgumentException("MBeanPermission name cannot be empty");
        }
        int n2 = string.indexOf("[");
        if (n2 == -1) {
            this.objectName = allObjectNames;
        } else {
            if (!string.endsWith("]")) {
                throw new IllegalArgumentException("MBeanPermission: The ObjectName in the target name must be included in square brackets");
            }
            try {
                String string2 = string.substring(n2 + 1, string.length() - 1);
                this.objectName = string2.equals("") ? allObjectNames : (string2.equals("-") ? null : new ObjectName(string2));
            }
            catch (MalformedObjectNameException malformedObjectNameException) {
                throw new IllegalArgumentException("MBeanPermission: The target name does not specify a valid ObjectName");
            }
            string = string.substring(0, n2);
        }
        int n3 = string.indexOf("#");
        if (n3 == -1) {
            this.setMember("*");
        } else {
            String string3 = string.substring(n3 + 1);
            this.setMember(string3);
            string = string.substring(0, n3);
        }
        this.setClassName(string);
    }

    private void initName(String string, String string2, ObjectName objectName) {
        this.setClassName(string);
        this.setMember(string2);
        this.objectName = objectName;
    }

    private void setClassName(String string) {
        if (string == null || string.equals("-")) {
            this.classNamePrefix = null;
            this.classNameExactMatch = false;
        } else if (string.equals("") || string.equals("*")) {
            this.classNamePrefix = "";
            this.classNameExactMatch = false;
        } else if (string.endsWith(".*")) {
            this.classNamePrefix = string.substring(0, string.length() - 1);
            this.classNameExactMatch = false;
        } else {
            this.classNamePrefix = string;
            this.classNameExactMatch = true;
        }
    }

    private void setMember(String string) {
        this.member = string == null || string.equals("-") ? null : (string.equals("") ? "*" : string);
    }

    public MBeanPermission(String string, String string2) {
        super(string);
        this.parseName();
        this.actions = string2;
        this.parseActions();
    }

    public MBeanPermission(String string, String string2, ObjectName objectName, String string3) {
        super(MBeanPermission.makeName(string, string2, objectName));
        this.initName(string, string2, objectName);
        this.actions = string3;
        this.parseActions();
    }

    private static String makeName(String string, String string2, ObjectName objectName) {
        StringBuffer stringBuffer = new StringBuffer();
        if (string == null) {
            string = "-";
        }
        stringBuffer.append(string);
        if (string2 == null) {
            string2 = "-";
        }
        stringBuffer.append("#" + string2);
        if (objectName == null) {
            stringBuffer.append("[-]");
        } else {
            stringBuffer.append("[").append(objectName.getCanonicalName()).append("]");
        }
        if (stringBuffer.length() == 0) {
            return "*";
        }
        return stringBuffer.toString();
    }

    public String getActions() {
        if (this.actions == null) {
            this.actions = MBeanPermission.getActions(this.mask);
        }
        return this.actions;
    }

    private static String getActions(int n2) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl2 = false;
        if ((n2 & 1) == 1) {
            bl2 = true;
            stringBuffer.append("addNotificationListener");
        }
        if ((n2 & 2) == 2) {
            if (bl2) {
                stringBuffer.append(',');
            } else {
                bl2 = true;
            }
            stringBuffer.append("getAttribute");
        }
        if ((n2 & 4) == 4) {
            if (bl2) {
                stringBuffer.append(',');
            } else {
                bl2 = true;
            }
            stringBuffer.append("getClassLoader");
        }
        if ((n2 & 8) == 8) {
            if (bl2) {
                stringBuffer.append(',');
            } else {
                bl2 = true;
            }
            stringBuffer.append("getClassLoaderFor");
        }
        if ((n2 & 0x10) == 16) {
            if (bl2) {
                stringBuffer.append(',');
            } else {
                bl2 = true;
            }
            stringBuffer.append("getClassLoaderRepository");
        }
        if ((n2 & 0x20) == 32) {
            if (bl2) {
                stringBuffer.append(',');
            } else {
                bl2 = true;
            }
            stringBuffer.append("getDomains");
        }
        if ((n2 & 0x40) == 64) {
            if (bl2) {
                stringBuffer.append(',');
            } else {
                bl2 = true;
            }
            stringBuffer.append("getMBeanInfo");
        }
        if ((n2 & 0x80) == 128) {
            if (bl2) {
                stringBuffer.append(',');
            } else {
                bl2 = true;
            }
            stringBuffer.append("getObjectInstance");
        }
        if ((n2 & 0x100) == 256) {
            if (bl2) {
                stringBuffer.append(',');
            } else {
                bl2 = true;
            }
            stringBuffer.append("instantiate");
        }
        if ((n2 & 0x200) == 512) {
            if (bl2) {
                stringBuffer.append(',');
            } else {
                bl2 = true;
            }
            stringBuffer.append("invoke");
        }
        if ((n2 & 0x400) == 1024) {
            if (bl2) {
                stringBuffer.append(',');
            } else {
                bl2 = true;
            }
            stringBuffer.append("isInstanceOf");
        }
        if ((n2 & 0x800) == 2048) {
            if (bl2) {
                stringBuffer.append(',');
            } else {
                bl2 = true;
            }
            stringBuffer.append("queryMBeans");
        }
        if ((n2 & 0x1000) == 4096) {
            if (bl2) {
                stringBuffer.append(',');
            } else {
                bl2 = true;
            }
            stringBuffer.append("queryNames");
        }
        if ((n2 & 0x2000) == 8192) {
            if (bl2) {
                stringBuffer.append(',');
            } else {
                bl2 = true;
            }
            stringBuffer.append("registerMBean");
        }
        if ((n2 & 0x4000) == 16384) {
            if (bl2) {
                stringBuffer.append(',');
            } else {
                bl2 = true;
            }
            stringBuffer.append("removeNotificationListener");
        }
        if ((n2 & 0x8000) == 32768) {
            if (bl2) {
                stringBuffer.append(',');
            } else {
                bl2 = true;
            }
            stringBuffer.append("setAttribute");
        }
        if ((n2 & 0x10000) == 65536) {
            if (bl2) {
                stringBuffer.append(',');
            } else {
                bl2 = true;
            }
            stringBuffer.append("unregisterMBean");
        }
        return stringBuffer.toString();
    }

    public int hashCode() {
        return this.getName().hashCode() + this.getActions().hashCode();
    }

    private static int getMask(String string) {
        int n2 = 0;
        if (string == null) {
            return n2;
        }
        if (string.equals("*")) {
            return 131071;
        }
        char[] cArray = string.toCharArray();
        int n3 = cArray.length - 1;
        if (n3 < 0) {
            return n2;
        }
        while (n3 != -1) {
            int n4;
            char c2;
            while (n3 != -1 && ((c2 = cArray[n3]) == ' ' || c2 == '\r' || c2 == '\n' || c2 == '\f' || c2 == '\t')) {
                --n3;
            }
            if (n3 >= 25 && cArray[n3 - 25] == 'r' && cArray[n3 - 24] == 'e' && cArray[n3 - 23] == 'm' && cArray[n3 - 22] == 'o' && cArray[n3 - 21] == 'v' && cArray[n3 - 20] == 'e' && cArray[n3 - 19] == 'N' && cArray[n3 - 18] == 'o' && cArray[n3 - 17] == 't' && cArray[n3 - 16] == 'i' && cArray[n3 - 15] == 'f' && cArray[n3 - 14] == 'i' && cArray[n3 - 13] == 'c' && cArray[n3 - 12] == 'a' && cArray[n3 - 11] == 't' && cArray[n3 - 10] == 'i' && cArray[n3 - 9] == 'o' && cArray[n3 - 8] == 'n' && cArray[n3 - 7] == 'L' && cArray[n3 - 6] == 'i' && cArray[n3 - 5] == 's' && cArray[n3 - 4] == 't' && cArray[n3 - 3] == 'e' && cArray[n3 - 2] == 'n' && cArray[n3 - 1] == 'e' && cArray[n3] == 'r') {
                n4 = 26;
                n2 |= 0x4000;
            } else if (n3 >= 23 && cArray[n3 - 23] == 'g' && cArray[n3 - 22] == 'e' && cArray[n3 - 21] == 't' && cArray[n3 - 20] == 'C' && cArray[n3 - 19] == 'l' && cArray[n3 - 18] == 'a' && cArray[n3 - 17] == 's' && cArray[n3 - 16] == 's' && cArray[n3 - 15] == 'L' && cArray[n3 - 14] == 'o' && cArray[n3 - 13] == 'a' && cArray[n3 - 12] == 'd' && cArray[n3 - 11] == 'e' && cArray[n3 - 10] == 'r' && cArray[n3 - 9] == 'R' && cArray[n3 - 8] == 'e' && cArray[n3 - 7] == 'p' && cArray[n3 - 6] == 'o' && cArray[n3 - 5] == 's' && cArray[n3 - 4] == 'i' && cArray[n3 - 3] == 't' && cArray[n3 - 2] == 'o' && cArray[n3 - 1] == 'r' && cArray[n3] == 'y') {
                n4 = 24;
                n2 |= 0x10;
            } else if (n3 >= 22 && cArray[n3 - 22] == 'a' && cArray[n3 - 21] == 'd' && cArray[n3 - 20] == 'd' && cArray[n3 - 19] == 'N' && cArray[n3 - 18] == 'o' && cArray[n3 - 17] == 't' && cArray[n3 - 16] == 'i' && cArray[n3 - 15] == 'f' && cArray[n3 - 14] == 'i' && cArray[n3 - 13] == 'c' && cArray[n3 - 12] == 'a' && cArray[n3 - 11] == 't' && cArray[n3 - 10] == 'i' && cArray[n3 - 9] == 'o' && cArray[n3 - 8] == 'n' && cArray[n3 - 7] == 'L' && cArray[n3 - 6] == 'i' && cArray[n3 - 5] == 's' && cArray[n3 - 4] == 't' && cArray[n3 - 3] == 'e' && cArray[n3 - 2] == 'n' && cArray[n3 - 1] == 'e' && cArray[n3] == 'r') {
                n4 = 23;
                n2 |= 1;
            } else if (n3 >= 16 && cArray[n3 - 16] == 'g' && cArray[n3 - 15] == 'e' && cArray[n3 - 14] == 't' && cArray[n3 - 13] == 'C' && cArray[n3 - 12] == 'l' && cArray[n3 - 11] == 'a' && cArray[n3 - 10] == 's' && cArray[n3 - 9] == 's' && cArray[n3 - 8] == 'L' && cArray[n3 - 7] == 'o' && cArray[n3 - 6] == 'a' && cArray[n3 - 5] == 'd' && cArray[n3 - 4] == 'e' && cArray[n3 - 3] == 'r' && cArray[n3 - 2] == 'F' && cArray[n3 - 1] == 'o' && cArray[n3] == 'r') {
                n4 = 17;
                n2 |= 8;
            } else if (n3 >= 16 && cArray[n3 - 16] == 'g' && cArray[n3 - 15] == 'e' && cArray[n3 - 14] == 't' && cArray[n3 - 13] == 'O' && cArray[n3 - 12] == 'b' && cArray[n3 - 11] == 'j' && cArray[n3 - 10] == 'e' && cArray[n3 - 9] == 'c' && cArray[n3 - 8] == 't' && cArray[n3 - 7] == 'I' && cArray[n3 - 6] == 'n' && cArray[n3 - 5] == 's' && cArray[n3 - 4] == 't' && cArray[n3 - 3] == 'a' && cArray[n3 - 2] == 'n' && cArray[n3 - 1] == 'c' && cArray[n3] == 'e') {
                n4 = 17;
                n2 |= 0x80;
            } else if (n3 >= 14 && cArray[n3 - 14] == 'u' && cArray[n3 - 13] == 'n' && cArray[n3 - 12] == 'r' && cArray[n3 - 11] == 'e' && cArray[n3 - 10] == 'g' && cArray[n3 - 9] == 'i' && cArray[n3 - 8] == 's' && cArray[n3 - 7] == 't' && cArray[n3 - 6] == 'e' && cArray[n3 - 5] == 'r' && cArray[n3 - 4] == 'M' && cArray[n3 - 3] == 'B' && cArray[n3 - 2] == 'e' && cArray[n3 - 1] == 'a' && cArray[n3] == 'n') {
                n4 = 15;
                n2 |= 0x10000;
            } else if (n3 >= 13 && cArray[n3 - 13] == 'g' && cArray[n3 - 12] == 'e' && cArray[n3 - 11] == 't' && cArray[n3 - 10] == 'C' && cArray[n3 - 9] == 'l' && cArray[n3 - 8] == 'a' && cArray[n3 - 7] == 's' && cArray[n3 - 6] == 's' && cArray[n3 - 5] == 'L' && cArray[n3 - 4] == 'o' && cArray[n3 - 3] == 'a' && cArray[n3 - 2] == 'd' && cArray[n3 - 1] == 'e' && cArray[n3] == 'r') {
                n4 = 14;
                n2 |= 4;
            } else if (n3 >= 12 && cArray[n3 - 12] == 'r' && cArray[n3 - 11] == 'e' && cArray[n3 - 10] == 'g' && cArray[n3 - 9] == 'i' && cArray[n3 - 8] == 's' && cArray[n3 - 7] == 't' && cArray[n3 - 6] == 'e' && cArray[n3 - 5] == 'r' && cArray[n3 - 4] == 'M' && cArray[n3 - 3] == 'B' && cArray[n3 - 2] == 'e' && cArray[n3 - 1] == 'a' && cArray[n3] == 'n') {
                n4 = 13;
                n2 |= 0x2000;
            } else if (n3 >= 11 && cArray[n3 - 11] == 'g' && cArray[n3 - 10] == 'e' && cArray[n3 - 9] == 't' && cArray[n3 - 8] == 'A' && cArray[n3 - 7] == 't' && cArray[n3 - 6] == 't' && cArray[n3 - 5] == 'r' && cArray[n3 - 4] == 'i' && cArray[n3 - 3] == 'b' && cArray[n3 - 2] == 'u' && cArray[n3 - 1] == 't' && cArray[n3] == 'e') {
                n4 = 12;
                n2 |= 2;
            } else if (n3 >= 11 && cArray[n3 - 11] == 'g' && cArray[n3 - 10] == 'e' && cArray[n3 - 9] == 't' && cArray[n3 - 8] == 'M' && cArray[n3 - 7] == 'B' && cArray[n3 - 6] == 'e' && cArray[n3 - 5] == 'a' && cArray[n3 - 4] == 'n' && cArray[n3 - 3] == 'I' && cArray[n3 - 2] == 'n' && cArray[n3 - 1] == 'f' && cArray[n3] == 'o') {
                n4 = 12;
                n2 |= 0x40;
            } else if (n3 >= 11 && cArray[n3 - 11] == 'i' && cArray[n3 - 10] == 's' && cArray[n3 - 9] == 'I' && cArray[n3 - 8] == 'n' && cArray[n3 - 7] == 's' && cArray[n3 - 6] == 't' && cArray[n3 - 5] == 'a' && cArray[n3 - 4] == 'n' && cArray[n3 - 3] == 'c' && cArray[n3 - 2] == 'e' && cArray[n3 - 1] == 'O' && cArray[n3] == 'f') {
                n4 = 12;
                n2 |= 0x400;
            } else if (n3 >= 11 && cArray[n3 - 11] == 's' && cArray[n3 - 10] == 'e' && cArray[n3 - 9] == 't' && cArray[n3 - 8] == 'A' && cArray[n3 - 7] == 't' && cArray[n3 - 6] == 't' && cArray[n3 - 5] == 'r' && cArray[n3 - 4] == 'i' && cArray[n3 - 3] == 'b' && cArray[n3 - 2] == 'u' && cArray[n3 - 1] == 't' && cArray[n3] == 'e') {
                n4 = 12;
                n2 |= 0x8000;
            } else if (n3 >= 10 && cArray[n3 - 10] == 'i' && cArray[n3 - 9] == 'n' && cArray[n3 - 8] == 's' && cArray[n3 - 7] == 't' && cArray[n3 - 6] == 'a' && cArray[n3 - 5] == 'n' && cArray[n3 - 4] == 't' && cArray[n3 - 3] == 'i' && cArray[n3 - 2] == 'a' && cArray[n3 - 1] == 't' && cArray[n3] == 'e') {
                n4 = 11;
                n2 |= 0x100;
            } else if (n3 >= 10 && cArray[n3 - 10] == 'q' && cArray[n3 - 9] == 'u' && cArray[n3 - 8] == 'e' && cArray[n3 - 7] == 'r' && cArray[n3 - 6] == 'y' && cArray[n3 - 5] == 'M' && cArray[n3 - 4] == 'B' && cArray[n3 - 3] == 'e' && cArray[n3 - 2] == 'a' && cArray[n3 - 1] == 'n' && cArray[n3] == 's') {
                n4 = 11;
                n2 |= 0x800;
            } else if (n3 >= 9 && cArray[n3 - 9] == 'g' && cArray[n3 - 8] == 'e' && cArray[n3 - 7] == 't' && cArray[n3 - 6] == 'D' && cArray[n3 - 5] == 'o' && cArray[n3 - 4] == 'm' && cArray[n3 - 3] == 'a' && cArray[n3 - 2] == 'i' && cArray[n3 - 1] == 'n' && cArray[n3] == 's') {
                n4 = 10;
                n2 |= 0x20;
            } else if (n3 >= 9 && cArray[n3 - 9] == 'q' && cArray[n3 - 8] == 'u' && cArray[n3 - 7] == 'e' && cArray[n3 - 6] == 'r' && cArray[n3 - 5] == 'y' && cArray[n3 - 4] == 'N' && cArray[n3 - 3] == 'a' && cArray[n3 - 2] == 'm' && cArray[n3 - 1] == 'e' && cArray[n3] == 's') {
                n4 = 10;
                n2 |= 0x1000;
            } else if (n3 >= 5 && cArray[n3 - 5] == 'i' && cArray[n3 - 4] == 'n' && cArray[n3 - 3] == 'v' && cArray[n3 - 2] == 'o' && cArray[n3 - 1] == 'k' && cArray[n3] == 'e') {
                n4 = 6;
                n2 |= 0x200;
            } else {
                throw new IllegalArgumentException("Invalid permission: " + string);
            }
            boolean bl2 = false;
            while (n3 >= n4 && !bl2) {
                switch (cArray[n3 - n4]) {
                    case ',': {
                        bl2 = true;
                    }
                    case '\t': 
                    case '\n': 
                    case '\f': 
                    case '\r': 
                    case ' ': {
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("Invalid permission: " + string);
                    }
                }
                --n3;
            }
            n3 -= n4;
        }
        return n2;
    }

    public boolean implies(Permission permission) {
        if (!(permission instanceof MBeanPermission)) {
            return false;
        }
        MBeanPermission mBeanPermission = (MBeanPermission)permission;
        if ((this.mask & 0x800) == 2048 ? ((this.mask | 0x1000) & mBeanPermission.mask) != mBeanPermission.mask : (this.mask & mBeanPermission.mask) != mBeanPermission.mask) {
            return false;
        }
        if (mBeanPermission.classNamePrefix != null) {
            if (this.classNamePrefix == null) {
                return false;
            }
            if (this.classNameExactMatch) {
                if (!mBeanPermission.classNameExactMatch) {
                    return false;
                }
                if (!mBeanPermission.classNamePrefix.equals(this.classNamePrefix)) {
                    return false;
                }
            } else if (!mBeanPermission.classNamePrefix.startsWith(this.classNamePrefix)) {
                return false;
            }
        }
        if (mBeanPermission.member != null) {
            if (this.member == null) {
                return false;
            }
            if (!this.member.equals("*") && !this.member.equals(mBeanPermission.member)) {
                return false;
            }
        }
        if (mBeanPermission.objectName != null) {
            if (this.objectName == null) {
                return false;
            }
            if (!this.objectName.apply(mBeanPermission.objectName) && !this.objectName.equals(mBeanPermission.objectName)) {
                return false;
            }
        }
        return true;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof MBeanPermission)) {
            return false;
        }
        MBeanPermission mBeanPermission = (MBeanPermission)object;
        return this.mask == mBeanPermission.mask && this.getName().equals(mBeanPermission.getName());
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.parseName();
        this.parseActions();
    }

    static {
        try {
            allObjectNames = new ObjectName("*:*");
        }
        catch (MalformedObjectNameException malformedObjectNameException) {
            throw new IllegalArgumentException("can't happen");
        }
    }
}

