/*
 * Decompiled with CFR 0.152.
 */
package javax.print.attribute;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.HashMap;
import javax.print.attribute.Attribute;
import javax.print.attribute.AttributeSet;
import javax.print.attribute.AttributeSetUtilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HashAttributeSet
implements AttributeSet,
Serializable {
    private static final long serialVersionUID = 5311560590283707917L;
    private Class myInterface;
    private transient HashMap attrMap = new HashMap();

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        Attribute[] attributeArray = this.toArray();
        objectOutputStream.writeInt(attributeArray.length);
        for (int i2 = 0; i2 < attributeArray.length; ++i2) {
            objectOutputStream.writeObject(attributeArray[i2]);
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws ClassNotFoundException, IOException {
        objectInputStream.defaultReadObject();
        this.attrMap = new HashMap();
        int n2 = objectInputStream.readInt();
        for (int i2 = 0; i2 < n2; ++i2) {
            Attribute attribute = (Attribute)objectInputStream.readObject();
            this.add(attribute);
        }
    }

    public HashAttributeSet() {
        this(Attribute.class);
    }

    public HashAttributeSet(Attribute attribute) {
        this(attribute, Attribute.class);
    }

    public HashAttributeSet(Attribute[] attributeArray) {
        this(attributeArray, Attribute.class);
    }

    public HashAttributeSet(AttributeSet attributeSet) {
        this(attributeSet, Attribute.class);
    }

    protected HashAttributeSet(Class<?> clazz) {
        if (clazz == null) {
            throw new NullPointerException("null interface");
        }
        this.myInterface = clazz;
    }

    protected HashAttributeSet(Attribute attribute, Class<?> clazz) {
        if (clazz == null) {
            throw new NullPointerException("null interface");
        }
        this.myInterface = clazz;
        this.add(attribute);
    }

    protected HashAttributeSet(Attribute[] attributeArray, Class<?> clazz) {
        if (clazz == null) {
            throw new NullPointerException("null interface");
        }
        this.myInterface = clazz;
        int n2 = attributeArray == null ? 0 : attributeArray.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            this.add(attributeArray[i2]);
        }
    }

    protected HashAttributeSet(AttributeSet attributeSet, Class<?> clazz) {
        this.myInterface = clazz;
        if (attributeSet != null) {
            Attribute[] attributeArray = attributeSet.toArray();
            int n2 = attributeArray == null ? 0 : attributeArray.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                this.add(attributeArray[i2]);
            }
        }
    }

    @Override
    public Attribute get(Class<?> clazz) {
        return (Attribute)this.attrMap.get(AttributeSetUtilities.verifyAttributeCategory(clazz, Attribute.class));
    }

    @Override
    public boolean add(Attribute attribute) {
        Attribute attribute2 = this.attrMap.put(attribute.getCategory(), AttributeSetUtilities.verifyAttributeValue(attribute, this.myInterface));
        return !attribute.equals(attribute2);
    }

    @Override
    public boolean remove(Class<?> clazz) {
        return clazz != null && AttributeSetUtilities.verifyAttributeCategory(clazz, Attribute.class) != null && this.attrMap.remove(clazz) != null;
    }

    @Override
    public boolean remove(Attribute attribute) {
        return attribute != null && this.attrMap.remove(attribute.getCategory()) != null;
    }

    @Override
    public boolean containsKey(Class<?> clazz) {
        return clazz != null && AttributeSetUtilities.verifyAttributeCategory(clazz, Attribute.class) != null && this.attrMap.get(clazz) != null;
    }

    @Override
    public boolean containsValue(Attribute attribute) {
        return attribute != null && attribute instanceof Attribute && attribute.equals(this.attrMap.get(attribute.getCategory()));
    }

    @Override
    public boolean addAll(AttributeSet attributeSet) {
        Attribute[] attributeArray = attributeSet.toArray();
        boolean bl2 = false;
        for (int i2 = 0; i2 < attributeArray.length; ++i2) {
            Attribute attribute;
            Attribute attribute2 = AttributeSetUtilities.verifyAttributeValue(attributeArray[i2], this.myInterface);
            bl2 = !attribute2.equals(attribute = this.attrMap.put(attribute2.getCategory(), attribute2)) || bl2;
        }
        return bl2;
    }

    @Override
    public int size() {
        return this.attrMap.size();
    }

    @Override
    public Attribute[] toArray() {
        Attribute[] attributeArray = new Attribute[this.size()];
        this.attrMap.values().toArray(attributeArray);
        return attributeArray;
    }

    @Override
    public void clear() {
        this.attrMap.clear();
    }

    @Override
    public boolean isEmpty() {
        return this.attrMap.isEmpty();
    }

    @Override
    public boolean equals(Object object) {
        if (object == null || !(object instanceof AttributeSet)) {
            return false;
        }
        AttributeSet attributeSet = (AttributeSet)object;
        if (attributeSet.size() != this.size()) {
            return false;
        }
        Attribute[] attributeArray = this.toArray();
        for (int i2 = 0; i2 < attributeArray.length; ++i2) {
            if (attributeSet.containsValue(attributeArray[i2])) continue;
            return false;
        }
        return true;
    }

    @Override
    public int hashCode() {
        int n2 = 0;
        Attribute[] attributeArray = this.toArray();
        for (int i2 = 0; i2 < attributeArray.length; ++i2) {
            n2 += attributeArray[i2].hashCode();
        }
        return n2;
    }
}

