/*
 * Decompiled with CFR 0.152.
 */
package javax.swing;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.IllegalComponentStateException;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Locale;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleComponent;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.accessibility.AccessibleStateSet;
import javax.accessibility.AccessibleText;
import javax.accessibility.AccessibleValue;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JProgressBar;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.text.AttributeSet;

public class ProgressMonitor
implements Accessible {
    private ProgressMonitor root;
    private JDialog dialog;
    private JOptionPane pane;
    private JProgressBar myBar;
    private JLabel noteLabel;
    private Component parentComponent;
    private String note;
    private Object[] cancelOption = null;
    private Object message;
    private long T0;
    private int millisToDecideToPopup = 500;
    private int millisToPopup = 2000;
    private int min;
    private int max;
    private int v;
    private int lastDisp;
    private int reportDelta;
    protected AccessibleContext accessibleContext = null;
    private AccessibleContext accessibleJOptionPane = null;

    public ProgressMonitor(Component component, Object object, String string, int n2, int n3) {
        this(component, object, string, n2, n3, null);
    }

    private ProgressMonitor(Component component, Object object, String string, int n2, int n3, ProgressMonitor progressMonitor) {
        this.min = n2;
        this.max = n3;
        this.parentComponent = component;
        this.cancelOption = new Object[1];
        this.cancelOption[0] = UIManager.getString("OptionPane.cancelButtonText");
        this.reportDelta = (n3 - n2) / 100;
        if (this.reportDelta < 1) {
            this.reportDelta = 1;
        }
        this.v = n2;
        this.message = object;
        this.note = string;
        if (progressMonitor != null) {
            this.root = progressMonitor.root != null ? progressMonitor.root : progressMonitor;
            this.T0 = this.root.T0;
            this.dialog = this.root.dialog;
        } else {
            this.T0 = System.currentTimeMillis();
        }
    }

    public void setProgress(int n2) {
        this.v = n2;
        if (n2 >= this.max) {
            this.close();
        } else if (n2 >= this.lastDisp + this.reportDelta) {
            this.lastDisp = n2;
            if (this.myBar != null) {
                this.myBar.setValue(n2);
            } else {
                int n3;
                long l2 = System.currentTimeMillis();
                long l3 = (int)(l2 - this.T0);
                if (l3 >= (long)this.millisToDecideToPopup && (n3 = n2 > this.min ? (int)(l3 * (long)(this.max - this.min) / (long)(n2 - this.min)) : this.millisToPopup) >= this.millisToPopup) {
                    this.myBar = new JProgressBar();
                    this.myBar.setMinimum(this.min);
                    this.myBar.setMaximum(this.max);
                    this.myBar.setValue(n2);
                    if (this.note != null) {
                        this.noteLabel = new JLabel(this.note);
                    }
                    this.pane = new ProgressOptionPane(new Object[]{this.message, this.noteLabel, this.myBar});
                    this.dialog = this.pane.createDialog(this.parentComponent, UIManager.getString("ProgressMonitor.progressText"));
                    this.dialog.show();
                }
            }
        }
    }

    public void close() {
        if (this.dialog != null) {
            this.dialog.setVisible(false);
            this.dialog.dispose();
            this.dialog = null;
            this.pane = null;
            this.myBar = null;
        }
    }

    public int getMinimum() {
        return this.min;
    }

    public void setMinimum(int n2) {
        this.min = n2;
    }

    public int getMaximum() {
        return this.max;
    }

    public void setMaximum(int n2) {
        this.max = n2;
    }

    public boolean isCanceled() {
        if (this.pane == null) {
            return false;
        }
        Object object = this.pane.getValue();
        return object != null && this.cancelOption.length == 1 && object.equals(this.cancelOption[0]);
    }

    public void setMillisToDecideToPopup(int n2) {
        this.millisToDecideToPopup = n2;
    }

    public int getMillisToDecideToPopup() {
        return this.millisToDecideToPopup;
    }

    public void setMillisToPopup(int n2) {
        this.millisToPopup = n2;
    }

    public int getMillisToPopup() {
        return this.millisToPopup;
    }

    public void setNote(String string) {
        this.note = string;
        if (this.noteLabel != null) {
            this.noteLabel.setText(string);
        }
    }

    public String getNote() {
        return this.note;
    }

    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessibleProgressMonitor();
        }
        if (this.pane != null && this.accessibleJOptionPane == null && this.accessibleContext instanceof AccessibleProgressMonitor) {
            ((AccessibleProgressMonitor)this.accessibleContext).optionPaneCreated();
        }
        return this.accessibleContext;
    }

    protected class AccessibleProgressMonitor
    extends AccessibleContext
    implements AccessibleText,
    ChangeListener,
    PropertyChangeListener {
        private Object oldModelValue;

        protected AccessibleProgressMonitor() {
        }

        private void optionPaneCreated() {
            ProgressMonitor.this.accessibleJOptionPane = ((ProgressOptionPane)ProgressMonitor.this.pane).getAccessibleJOptionPane();
            if (ProgressMonitor.this.myBar != null) {
                ProgressMonitor.this.myBar.addChangeListener(this);
            }
            if (ProgressMonitor.this.noteLabel != null) {
                ProgressMonitor.this.noteLabel.addPropertyChangeListener(this);
            }
        }

        public void stateChanged(ChangeEvent changeEvent) {
            if (changeEvent == null) {
                return;
            }
            if (ProgressMonitor.this.myBar != null) {
                Integer n2 = ProgressMonitor.this.myBar.getValue();
                this.firePropertyChange("AccessibleValue", this.oldModelValue, n2);
                this.oldModelValue = n2;
            }
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if (propertyChangeEvent.getSource() == ProgressMonitor.this.noteLabel && propertyChangeEvent.getPropertyName() == "text") {
                this.firePropertyChange("AccessibleText", null, 0);
            }
        }

        public String getAccessibleName() {
            if (this.accessibleName != null) {
                return this.accessibleName;
            }
            if (ProgressMonitor.this.accessibleJOptionPane != null) {
                return ProgressMonitor.this.accessibleJOptionPane.getAccessibleName();
            }
            return null;
        }

        public String getAccessibleDescription() {
            if (this.accessibleDescription != null) {
                return this.accessibleDescription;
            }
            if (ProgressMonitor.this.accessibleJOptionPane != null) {
                return ProgressMonitor.this.accessibleJOptionPane.getAccessibleDescription();
            }
            return null;
        }

        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.PROGRESS_MONITOR;
        }

        public AccessibleStateSet getAccessibleStateSet() {
            if (ProgressMonitor.this.accessibleJOptionPane != null) {
                return ProgressMonitor.this.accessibleJOptionPane.getAccessibleStateSet();
            }
            return null;
        }

        public Accessible getAccessibleParent() {
            if (ProgressMonitor.this.dialog != null) {
                return ProgressMonitor.this.dialog;
            }
            return null;
        }

        private AccessibleContext getParentAccessibleContext() {
            if (ProgressMonitor.this.dialog != null) {
                return ProgressMonitor.this.dialog.getAccessibleContext();
            }
            return null;
        }

        public int getAccessibleIndexInParent() {
            if (ProgressMonitor.this.accessibleJOptionPane != null) {
                return ProgressMonitor.this.accessibleJOptionPane.getAccessibleIndexInParent();
            }
            return -1;
        }

        public int getAccessibleChildrenCount() {
            AccessibleContext accessibleContext = this.getPanelAccessibleContext();
            if (accessibleContext != null) {
                return accessibleContext.getAccessibleChildrenCount();
            }
            return 0;
        }

        public Accessible getAccessibleChild(int n2) {
            AccessibleContext accessibleContext = this.getPanelAccessibleContext();
            if (accessibleContext != null) {
                return accessibleContext.getAccessibleChild(n2);
            }
            return null;
        }

        private AccessibleContext getPanelAccessibleContext() {
            Container container;
            if (ProgressMonitor.this.myBar != null && (container = ProgressMonitor.this.myBar.getParent()) instanceof Accessible) {
                return ((Accessible)((Object)container)).getAccessibleContext();
            }
            return null;
        }

        public Locale getLocale() throws IllegalComponentStateException {
            if (ProgressMonitor.this.accessibleJOptionPane != null) {
                return ProgressMonitor.this.accessibleJOptionPane.getLocale();
            }
            return null;
        }

        public AccessibleComponent getAccessibleComponent() {
            if (ProgressMonitor.this.accessibleJOptionPane != null) {
                return ProgressMonitor.this.accessibleJOptionPane.getAccessibleComponent();
            }
            return null;
        }

        public AccessibleValue getAccessibleValue() {
            if (ProgressMonitor.this.myBar != null) {
                return ProgressMonitor.this.myBar.getAccessibleContext().getAccessibleValue();
            }
            return null;
        }

        public AccessibleText getAccessibleText() {
            if (this.getNoteLabelAccessibleText() != null) {
                return this;
            }
            return null;
        }

        private AccessibleText getNoteLabelAccessibleText() {
            if (ProgressMonitor.this.noteLabel != null) {
                return ProgressMonitor.this.noteLabel.getAccessibleContext().getAccessibleText();
            }
            return null;
        }

        public int getIndexAtPoint(Point point) {
            Point point2;
            AccessibleText accessibleText = this.getNoteLabelAccessibleText();
            if (accessibleText != null && this.sameWindowAncestor(ProgressMonitor.this.pane, ProgressMonitor.this.noteLabel) && (point2 = SwingUtilities.convertPoint(ProgressMonitor.this.pane, point, ProgressMonitor.this.noteLabel)) != null) {
                return accessibleText.getIndexAtPoint(point2);
            }
            return -1;
        }

        public Rectangle getCharacterBounds(int n2) {
            Rectangle rectangle;
            AccessibleText accessibleText = this.getNoteLabelAccessibleText();
            if (accessibleText != null && this.sameWindowAncestor(ProgressMonitor.this.pane, ProgressMonitor.this.noteLabel) && (rectangle = accessibleText.getCharacterBounds(n2)) != null) {
                return SwingUtilities.convertRectangle(ProgressMonitor.this.noteLabel, rectangle, ProgressMonitor.this.pane);
            }
            return null;
        }

        private boolean sameWindowAncestor(Component component, Component component2) {
            if (component == null || component2 == null) {
                return false;
            }
            return SwingUtilities.getWindowAncestor(component) == SwingUtilities.getWindowAncestor(component2);
        }

        public int getCharCount() {
            AccessibleText accessibleText = this.getNoteLabelAccessibleText();
            if (accessibleText != null) {
                return accessibleText.getCharCount();
            }
            return -1;
        }

        public int getCaretPosition() {
            AccessibleText accessibleText = this.getNoteLabelAccessibleText();
            if (accessibleText != null) {
                return accessibleText.getCaretPosition();
            }
            return -1;
        }

        public String getAtIndex(int n2, int n3) {
            AccessibleText accessibleText = this.getNoteLabelAccessibleText();
            if (accessibleText != null) {
                return accessibleText.getAtIndex(n2, n3);
            }
            return null;
        }

        public String getAfterIndex(int n2, int n3) {
            AccessibleText accessibleText = this.getNoteLabelAccessibleText();
            if (accessibleText != null) {
                return accessibleText.getAfterIndex(n2, n3);
            }
            return null;
        }

        public String getBeforeIndex(int n2, int n3) {
            AccessibleText accessibleText = this.getNoteLabelAccessibleText();
            if (accessibleText != null) {
                return accessibleText.getBeforeIndex(n2, n3);
            }
            return null;
        }

        public AttributeSet getCharacterAttribute(int n2) {
            AccessibleText accessibleText = this.getNoteLabelAccessibleText();
            if (accessibleText != null) {
                return accessibleText.getCharacterAttribute(n2);
            }
            return null;
        }

        public int getSelectionStart() {
            AccessibleText accessibleText = this.getNoteLabelAccessibleText();
            if (accessibleText != null) {
                return accessibleText.getSelectionStart();
            }
            return -1;
        }

        public int getSelectionEnd() {
            AccessibleText accessibleText = this.getNoteLabelAccessibleText();
            if (accessibleText != null) {
                return accessibleText.getSelectionEnd();
            }
            return -1;
        }

        public String getSelectedText() {
            AccessibleText accessibleText = this.getNoteLabelAccessibleText();
            if (accessibleText != null) {
                return accessibleText.getSelectedText();
            }
            return null;
        }
    }

    private class ProgressOptionPane
    extends JOptionPane {
        ProgressOptionPane(Object object) {
            super(object, 1, -1, null, ProgressMonitor.this.cancelOption, null);
        }

        public int getMaxCharactersPerLineCount() {
            return 60;
        }

        public JDialog createDialog(Component component, String string) {
            Object object;
            Window window = JOptionPane.getWindowForComponent(component);
            final JDialog jDialog = window instanceof Frame ? new JDialog((Frame)window, string, false) : new JDialog((Dialog)window, string, false);
            if (window instanceof SwingUtilities.SharedOwnerFrame) {
                object = SwingUtilities.getSharedOwnerFrameShutdownListener();
                jDialog.addWindowListener((WindowListener)object);
            }
            object = jDialog.getContentPane();
            ((Container)object).setLayout(new BorderLayout());
            ((Container)object).add((Component)this, "Center");
            jDialog.pack();
            jDialog.setLocationRelativeTo(component);
            jDialog.addWindowListener(new WindowAdapter(){
                boolean gotFocus = false;

                public void windowClosing(WindowEvent windowEvent) {
                    ProgressOptionPane.this.setValue(ProgressMonitor.this.cancelOption[0]);
                }

                public void windowActivated(WindowEvent windowEvent) {
                    if (!this.gotFocus) {
                        ProgressOptionPane.this.selectInitialValue();
                        this.gotFocus = true;
                    }
                }
            });
            this.addPropertyChangeListener(new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    if (jDialog.isVisible() && propertyChangeEvent.getSource() == ProgressOptionPane.this && (propertyChangeEvent.getPropertyName().equals("value") || propertyChangeEvent.getPropertyName().equals("inputValue"))) {
                        jDialog.setVisible(false);
                        jDialog.dispose();
                    }
                }
            });
            return jDialog;
        }

        public AccessibleContext getAccessibleContext() {
            return ProgressMonitor.this.getAccessibleContext();
        }

        private AccessibleContext getAccessibleJOptionPane() {
            return super.getAccessibleContext();
        }
    }
}

