/*
 * Decompiled with CFR 0.152.
 */
package sun.security.rsa;

import java.math.BigInteger;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.InvalidParameterException;
import java.security.KeyPair;
import java.security.KeyPairGeneratorSpi;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.RSAKeyGenParameterSpec;
import sun.security.jca.JCAUtil;
import sun.security.rsa.RSAPrivateCrtKeyImpl;
import sun.security.rsa.RSAPublicKeyImpl;

public final class RSAKeyPairGenerator
extends KeyPairGeneratorSpi {
    private BigInteger publicExponent;
    private int keySize;
    private SecureRandom random;

    public RSAKeyPairGenerator() {
        this.initialize(1024, null);
    }

    public void initialize(int n2, SecureRandom secureRandom) {
        if (n2 < 512) {
            throw new InvalidParameterException("Key size must be at least 512 bits");
        }
        if (n2 > 65536) {
            throw new InvalidParameterException("Key size must be 65536 bits or less");
        }
        this.keySize = n2;
        this.random = secureRandom;
        this.publicExponent = RSAKeyGenParameterSpec.F4;
    }

    public void initialize(AlgorithmParameterSpec algorithmParameterSpec, SecureRandom secureRandom) throws InvalidAlgorithmParameterException {
        if (!(algorithmParameterSpec instanceof RSAKeyGenParameterSpec)) {
            throw new InvalidAlgorithmParameterException("Params must be instance of RSAKeyGenParameterSpec");
        }
        RSAKeyGenParameterSpec rSAKeyGenParameterSpec = (RSAKeyGenParameterSpec)algorithmParameterSpec;
        this.keySize = rSAKeyGenParameterSpec.getKeysize();
        this.publicExponent = rSAKeyGenParameterSpec.getPublicExponent();
        this.random = secureRandom;
        if (this.keySize < 512) {
            throw new InvalidAlgorithmParameterException("Key size must be at least 512 bits");
        }
        if (this.keySize > 65536) {
            throw new InvalidParameterException("Key size must be 65536 bits or less");
        }
        if (this.publicExponent == null) {
            this.publicExponent = RSAKeyGenParameterSpec.F4;
        } else {
            if (this.publicExponent.compareTo(RSAKeyGenParameterSpec.F0) < 0) {
                throw new InvalidAlgorithmParameterException("Public exponent must be 3 or larger");
            }
            if (this.publicExponent.bitLength() > this.keySize) {
                throw new InvalidAlgorithmParameterException("Public exponent must be smaller than key size");
            }
        }
    }

    public KeyPair generateKeyPair() {
        BigInteger bigInteger;
        BigInteger bigInteger2;
        BigInteger bigInteger3;
        BigInteger bigInteger4;
        BigInteger bigInteger5;
        int n2 = this.keySize + 1 >> 1;
        int n3 = this.keySize - n2;
        if (this.random == null) {
            this.random = JCAUtil.getSecureRandom();
        }
        BigInteger bigInteger6 = this.publicExponent;
        do {
            if ((bigInteger3 = BigInteger.probablePrime(n2, this.random)).compareTo(bigInteger = BigInteger.probablePrime(n3, this.random)) >= 0) continue;
            bigInteger4 = bigInteger3;
            bigInteger3 = bigInteger;
            bigInteger = bigInteger4;
        } while (!bigInteger6.gcd(bigInteger5 = (bigInteger4 = bigInteger3.subtract(BigInteger.ONE)).multiply(bigInteger2 = bigInteger.subtract(BigInteger.ONE))).equals(BigInteger.ONE));
        BigInteger bigInteger7 = bigInteger6.modInverse(bigInteger5);
        BigInteger bigInteger8 = bigInteger3.multiply(bigInteger);
        BigInteger bigInteger9 = bigInteger7.mod(bigInteger4);
        BigInteger bigInteger10 = bigInteger7.mod(bigInteger2);
        BigInteger bigInteger11 = bigInteger.modInverse(bigInteger3);
        try {
            RSAPublicKeyImpl rSAPublicKeyImpl = new RSAPublicKeyImpl(bigInteger8, bigInteger6);
            RSAPrivateCrtKeyImpl rSAPrivateCrtKeyImpl = new RSAPrivateCrtKeyImpl(bigInteger8, bigInteger6, bigInteger7, bigInteger3, bigInteger, bigInteger9, bigInteger10, bigInteger11);
            return new KeyPair(rSAPublicKeyImpl, rSAPrivateCrtKeyImpl);
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new RuntimeException(invalidKeyException);
        }
    }
}

