/*
 * Decompiled with CFR 0.152.
 */
import ij.IJ;
import ij.Macro;
import ij.Prefs;
import ij.WindowManager;
import ij.gui.ImageWindow;
import ij.gui.Toolbar;
import ij.macro.MacroRunner;
import ij.plugin.MacroInstaller;
import ij.plugin.PlugIn;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.MouseInfo;
import java.awt.Toolkit;
import java.awt.dnd.DropTarget;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.net.URL;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JToolBar;

public class Action_Bar
implements PlugIn,
ActionListener {
    String macrodir = IJ.getDirectory("macros");
    String name;
    String title;
    String path;
    String startupAction = "";
    String codeLibrary = "";
    String separator = System.getProperty("file.separator");
    JFrame frame = new JFrame();
    Frame frontframe;
    int xfw = 0;
    int yfw = 0;
    int wfw = 0;
    int hfw = 0;
    JToolBar toolBar = null;
    boolean tbOpenned = false;
    boolean grid = true;
    boolean visible = true;
    boolean shouldExit = false;
    JButton button = null;
    private boolean isPopup = false;
    private boolean isSticky = false;
    int nButtons = 0;

    @Override
    public void run(String s) {
        String arg = Macro.getOptions();
        if (arg == null && s.equals("")) {
            try {
                File macro = new File(Action_Bar.class.getResource("createAB.txt").getFile());
                new MacroRunner(macro);
                return;
            }
            catch (Exception e) {
                IJ.error("createAB.txt file not found");
            }
        } else if (arg == null) {
            this.path = String.valueOf(IJ.getDirectory("startup")) + s;
            try {
                this.name = this.path.substring(this.path.lastIndexOf("/") + 1);
            }
            catch (Exception e) {}
        } else {
            this.path = String.valueOf(IJ.getDirectory("startup")) + arg;
            try {
                this.path = this.path.substring(0, this.path.indexOf(".txt") + 4);
                this.name = this.path.substring(this.path.lastIndexOf("/") + 1);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        this.title = this.name.substring(0, this.name.indexOf(".")).replaceAll("_", " ").trim();
        this.frame.setTitle(this.title);
        if (WindowManager.getFrame(this.title) != null) {
            WindowManager.getFrame(this.title).toFront();
            return;
        }
        this.frame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                Action_Bar.this.rememberXYlocation();
                e.getWindow().dispose();
                WindowManager.removeWindow(Action_Bar.this.frame);
            }
        });
        this.frontframe = WindowManager.getFrontWindow();
        if (this.frontframe != null) {
            this.xfw = this.frontframe.getLocation().x;
            this.yfw = this.frontframe.getLocation().y;
            this.wfw = this.frontframe.getWidth();
            this.hfw = this.frontframe.getHeight();
        }
        this.frame.getContentPane().setLayout(new GridLayout(0, 1));
        this.frame.setIconImage(IJ.getInstance().getIconImage());
        this.designPanel();
        this.frame.setFocusable(true);
        this.frame.addKeyListener(IJ.getInstance());
        this.frame.setResizable(false);
        if (!this.isPopup) {
            this.frame.setLocation((int)Prefs.get("actionbar" + this.title + ".xloc", 10.0), (int)Prefs.get("actionbar" + this.title + ".yloc", 10.0));
            WindowManager.addWindow(this.frame);
        } else {
            this.frame.setLocation(MouseInfo.getPointerInfo().getLocation());
            this.frame.setUndecorated(true);
            this.frame.addKeyListener(new KeyListener(){

                @Override
                public void keyReleased(KeyEvent e) {
                }

                @Override
                public void keyTyped(KeyEvent e) {
                }

                @Override
                public void keyPressed(KeyEvent e) {
                    int code = e.getKeyCode();
                    if (code == 27) {
                        Action_Bar.this.frame.dispose();
                        WindowManager.removeWindow(Action_Bar.this.frame);
                    }
                }
            });
        }
        if (this.isSticky) {
            this.frame.setUndecorated(true);
        }
        this.frame.pack();
        this.frame.setVisible(true);
        if (this.startupAction != "") {
            try {
                new MacroRunner(String.valueOf(this.startupAction) + "\n" + this.codeLibrary);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        WindowManager.setWindow(this.frontframe);
        if (this.isSticky) {
            this.stickToActiveWindow();
            while (!this.shouldExit && this.frame.getTitle() != "xxxx") {
                try {
                    ImageWindow fw = WindowManager.getCurrentWindow();
                    if (fw == null) {
                        this.frame.setVisible(false);
                    }
                    if (fw != null && fw.getLocation().x != this.xfw || fw.getLocation().y != this.yfw || fw.getWidth() != this.wfw || fw.getHeight() != this.hfw) {
                        this.xfw = fw.getLocation().x;
                        this.yfw = fw.getLocation().y;
                        this.wfw = fw.getWidth();
                        this.hfw = fw.getHeight();
                        this.stickToActiveWindow();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                IJ.wait(20);
            }
            if (this.frame.getTitle() == "xxxx") {
                this.closeActionBar();
            }
            if (this.shouldExit) {
                return;
            }
        }
    }

    private void stickToActiveWindow() {
        ImageWindow fw = WindowManager.getCurrentWindow();
        try {
            if (fw != null) {
                if (!this.frame.isVisible()) {
                    this.frame.setVisible(true);
                }
                this.frame.toFront();
                this.frame.setLocation(fw.getLocation().x + fw.getWidth(), fw.getLocation().y);
                fw.toFront();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void closeActionBar() {
        this.frame.dispose();
        WindowManager.removeWindow(this.frame);
        WindowManager.setWindow(this.frontframe);
        this.shouldExit = true;
    }

    private void designPanel() {
        try {
            File file = new File(this.path);
            if (!file.exists()) {
                IJ.error("Config File not found");
            }
            BufferedReader r = new BufferedReader(new FileReader(file));
            block2: while (true) {
                String sc;
                String code;
                String sc2;
                String code2;
                String s;
                if ((s = r.readLine()).equals(null)) break;
                if (s.startsWith("<main>")) {
                    this.setABasMain();
                    this.hideIJ();
                    continue;
                }
                if (s.startsWith("<popup>")) {
                    this.isPopup = true;
                    continue;
                }
                if (s.startsWith("<sticky>")) {
                    this.isSticky = true;
                    continue;
                }
                if (s.startsWith("<DnD>")) {
                    this.setABDnD();
                    continue;
                }
                if (s.startsWith("<onTop>")) {
                    this.setABonTop();
                    continue;
                }
                if (s.startsWith("<startupAction>")) {
                    code2 = "";
                    while (true) {
                        if ((sc2 = r.readLine()).equals(null)) continue block2;
                        if (sc2.startsWith("</startupAction>")) break;
                        code2 = String.valueOf(code2) + sc2;
                    }
                    this.startupAction = code2;
                    continue;
                }
                if (s.startsWith("<codeLibrary>")) {
                    code2 = "";
                    while (true) {
                        if ((sc2 = r.readLine()).equals(null)) continue block2;
                        if (sc2.startsWith("</codeLibrary>")) break;
                        code2 = String.valueOf(code2) + sc2;
                    }
                    this.codeLibrary = code2;
                    continue;
                }
                if (s.startsWith("<icon>")) {
                    String frameiconName = r.readLine().substring(5);
                    this.setABIcon(frameiconName);
                    continue;
                }
                if (s.startsWith("<noGrid>") && !this.tbOpenned) {
                    this.grid = false;
                    continue;
                }
                if (s.startsWith("<text>") && !this.tbOpenned) {
                    this.frame.getContentPane().add(new JLabel(s.substring(6)));
                    continue;
                }
                if (s.startsWith("<line>") && !this.tbOpenned) {
                    this.toolBar = new JToolBar();
                    this.nButtons = 0;
                    this.tbOpenned = true;
                    continue;
                }
                if (s.startsWith("</line>") && this.tbOpenned) {
                    this.closeToolBar();
                    this.tbOpenned = false;
                    continue;
                }
                if (s.startsWith("<separator>") && this.tbOpenned) {
                    this.toolBar.addSeparator();
                    continue;
                }
                if (!s.startsWith("<button>") || !this.tbOpenned) continue;
                String label = r.readLine().substring(6);
                String icon = r.readLine().substring(5);
                String arg = r.readLine().substring(4);
                if (arg.startsWith("<macro>")) {
                    code = "";
                    while (!(sc = r.readLine()).equals(null)) {
                        if (!sc.startsWith("</macro>")) {
                            code = String.valueOf(code) + sc;
                            continue;
                        }
                        arg = code;
                        break;
                    }
                } else if (arg.startsWith("<tool>")) {
                    code = "<tool>\n";
                    while (!(sc = r.readLine()).equals(null)) {
                        if (!sc.startsWith("</tool>")) {
                            code = String.valueOf(code) + sc;
                            continue;
                        }
                        arg = code;
                        break;
                    }
                } else if (arg.startsWith("<hide>")) {
                    arg = "<hide>";
                } else if (arg.startsWith("<close>")) {
                    arg = "<close>";
                }
                this.button = this.makeNavigationButton(icon, arg, label, label);
                this.toolBar.add(this.button);
                ++this.nButtons;
            }
            r.close();
            this.closeToolBar();
            r.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void closeToolBar() {
        this.toolBar.setFloatable(false);
        if (this.grid) {
            this.toolBar.setLayout(new GridLayout(1, this.nButtons));
        }
        this.frame.getContentPane().add(this.toolBar);
        this.tbOpenned = false;
    }

    protected JButton makeNavigationButton(String imageName, String actionCommand, String toolTipText, String altText) {
        String imgLocation = "icons/" + imageName;
        URL imageURL = Action_Bar.class.getResource(imgLocation);
        JButton button = new JButton();
        button.setActionCommand(actionCommand);
        button.setMargin(new Insets(2, 2, 2, 2));
        button.addActionListener(this);
        button.setFocusable(true);
        button.addKeyListener(IJ.getInstance());
        if (imageURL != null) {
            button.setIcon(new ImageIcon(imageURL, altText));
            button.setToolTipText(toolTipText);
        } else {
            button.setText(altText);
            button.setToolTipText(toolTipText);
        }
        return button;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String cmd = e.getActionCommand();
        if ((e.getModifiers() & 8) * (e.getModifiers() & 2) != 0) {
            IJ.run("Edit...", "open=[" + this.path + "]");
            return;
        }
        if ((e.getModifiers() & 8) != 0) {
            this.closeActionBar();
            return;
        }
        if (cmd.startsWith("<hide>")) {
            this.toggleIJ();
        } else {
            if (cmd.startsWith("<close>")) {
                this.closeActionBar();
                return;
            }
            if (cmd.startsWith("<tool>")) {
                String tool = cmd.substring(6, cmd.length());
                String toolname = ((JButton)e.getSource()).getToolTipText();
                tool = "macro '" + toolname + " Tool - C000'{\n" + tool + "\n}\n" + this.codeLibrary;
                new MacroInstaller().install(tool);
                Toolbar.getInstance().setTool(10);
                IJ.showStatus(String.valueOf(toolname) + " Tool installed");
            } else {
                try {
                    new MacroRunner(String.valueOf(cmd) + "\n" + this.codeLibrary);
                }
                catch (Exception fe) {
                    IJ.error("Error in macro command");
                }
            }
        }
        this.frame.repaint();
        if (this.isPopup) {
            this.frame.dispose();
            WindowManager.removeWindow(this.frame);
            WindowManager.setWindow(this.frontframe);
        }
    }

    private void toggleIJ() {
        IJ.getInstance().setVisible(!IJ.getInstance().isVisible());
        this.visible = IJ.getInstance().isVisible();
    }

    private void hideIJ() {
        IJ.getInstance().setVisible(false);
        this.visible = false;
    }

    protected void rememberXYlocation() {
        Prefs.set("actionbar" + this.title + ".xloc", this.frame.getLocation().x);
        Prefs.set("actionbar" + this.title + ".yloc", this.frame.getLocation().y);
    }

    private void setABasMain() {
        this.frame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                Action_Bar.this.rememberXYlocation();
                e.getWindow().dispose();
                IJ.run("Quit");
            }
        });
    }

    private void setABDnD() {
        DropTarget dt = new DropTarget(this.frame, IJ.getInstance().getDropTarget());
    }

    private void setABIcon(String s) {
        String imgLocation = "icons/" + s;
        try {
            URL imageURL = Action_Bar.class.getResource(imgLocation);
            this.frame.setIconImage(Toolkit.getDefaultToolkit().getImage(imageURL));
        }
        catch (Exception fe) {
            IJ.error("Error creating the bar's icon");
        }
    }

    private void setABonTop() {
        this.frame.setAlwaysOnTop(true);
    }
}

