/*
 * Decompiled with CFR 0.152.
 */
package ij;

import ij.process.ByteProcessor;
import ij.process.ColorProcessor;
import ij.process.ImageProcessor;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.image.ColorModel;
import java.awt.image.IndexColorModel;
import java.awt.image.PixelGrabber;

public class LookUpTable {
    private int width;
    private int height;
    private byte[] pixels;
    private int mapSize = 0;
    private ColorModel cm;
    private byte[] rLUT;
    private byte[] gLUT;
    private byte[] bLUT;

    public LookUpTable(Image img) {
        PixelGrabber pg = new PixelGrabber(img, 0, 0, 1, 1, false);
        try {
            pg.grabPixels();
            this.cm = pg.getColorModel();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.getColors(this.cm);
    }

    public LookUpTable(ColorModel cm) {
        this.cm = cm;
        this.getColors(cm);
    }

    void getColors(ColorModel cm) {
        if (cm instanceof IndexColorModel) {
            IndexColorModel m = (IndexColorModel)cm;
            this.mapSize = m.getMapSize();
            this.rLUT = new byte[this.mapSize];
            this.gLUT = new byte[this.mapSize];
            this.bLUT = new byte[this.mapSize];
            m.getReds(this.rLUT);
            m.getGreens(this.gLUT);
            m.getBlues(this.bLUT);
        }
    }

    public int getMapSize() {
        return this.mapSize;
    }

    public byte[] getReds() {
        return this.rLUT;
    }

    public byte[] getGreens() {
        return this.gLUT;
    }

    public byte[] getBlues() {
        return this.bLUT;
    }

    public ColorModel getColorModel() {
        return this.cm;
    }

    public boolean isGrayscale() {
        boolean isGray = true;
        if (this.mapSize < 256) {
            return false;
        }
        for (int i = 0; i < this.mapSize; ++i) {
            if (this.rLUT[i] == this.gLUT[i] && this.gLUT[i] == this.bLUT[i]) continue;
            isGray = false;
        }
        return isGray;
    }

    public void drawColorBar(Graphics g, int x, int y, int width, int height) {
        if (this.mapSize == 0) {
            return;
        }
        ColorProcessor cp = new ColorProcessor(width, height);
        double scale = 256.0 / (double)this.mapSize;
        for (int i = 0; i < 256; ++i) {
            int index = (int)((double)i / scale);
            cp.setColor(new Color(this.rLUT[index] & 0xFF, this.gLUT[index] & 0xFF, this.bLUT[index] & 0xFF));
            cp.moveTo(i, 0);
            cp.lineTo(i, height);
        }
        g.drawImage(cp.createImage(), x, y, null);
        g.setColor(Color.black);
        g.drawRect(x, y, width, height);
    }

    public void drawVertColorBar(Graphics g, int x, int y, int width, int height, double imin, double imax) {
        if (this.mapSize == 0) {
            return;
        }
        ColorProcessor cp = new ColorProcessor(3 * width / 5, height);
        double scale = 256.0 / (double)this.mapSize;
        double st = (double)height / 256.0;
        cp.setLineWidth((int)(st + 0.5));
        int w2 = 3 * width / 5;
        g.setColor(Color.black);
        for (int i = 0; i < 256; ++i) {
            int y2 = height - (int)((double)i * st);
            int index = (int)((double)i / scale);
            cp.setColor(new Color(this.rLUT[index] & 0xFF, this.gLUT[index] & 0xFF, this.bLUT[index] & 0xFF));
            cp.moveTo(0, y2);
            cp.lineTo(w2, y2);
            if (i % 32 != 0) continue;
            g.drawLine(x + w2, y + y2, x + width, y + y2);
            g.drawString("" + (long)(imin + (double)i * (imax - imin) / 256.0), x + w2 + 5, y + y2);
        }
        g.drawImage(cp.createImage(), x, y, null);
        g.drawRect(x, y, width, height);
        g.drawString("" + (long)imax, x + w2 + 5, y);
    }

    public void drawUnscaledColorBar(ImageProcessor ip, int x, int y, int width, int height) {
        ImageProcessor bar = null;
        bar = ip instanceof ColorProcessor ? new ColorProcessor(width, height) : new ByteProcessor(width, height);
        if (this.mapSize == 0) {
            for (int i = 0; i < 256; ++i) {
                bar.setColor(new Color(i, i, i));
                bar.moveTo(i, 0);
                bar.lineTo(i, height);
            }
        } else {
            for (int i = 0; i < this.mapSize; ++i) {
                bar.setColor(new Color(this.rLUT[i] & 0xFF, this.gLUT[i] & 0xFF, this.bLUT[i] & 0xFF));
                bar.moveTo(i, 0);
                bar.lineTo(i, height);
            }
        }
        ip.insert(bar, x, y);
        ip.setColor(Color.black);
        ip.drawRect(x - 1, y, width + 2, height);
    }

    public static ColorModel createGrayscaleColorModel(boolean invert) {
        byte[] rLUT = new byte[256];
        byte[] gLUT = new byte[256];
        byte[] bLUT = new byte[256];
        if (invert) {
            for (int i = 0; i < 256; ++i) {
                rLUT[255 - i] = (byte)i;
                gLUT[255 - i] = (byte)i;
                bLUT[255 - i] = (byte)i;
            }
        } else {
            for (int i = 0; i < 256; ++i) {
                rLUT[i] = (byte)i;
                gLUT[i] = (byte)i;
                bLUT[i] = (byte)i;
            }
        }
        return new IndexColorModel(8, 256, rLUT, gLUT, bLUT);
    }
}

