/*
 * Decompiled with CFR 0.152.
 */
package ij.gui;

import ij.IJ;
import ij.ImagePlus;
import ij.Prefs;
import ij.gui.GenericDialog;
import ij.gui.ImageWindow;
import ij.gui.Line;
import ij.gui.NewImage;
import ij.gui.Plot;
import ij.gui.ProfilePlot;
import ij.gui.Roi;
import ij.io.FileInfo;
import ij.plugin.RadioSpectrum_Reader;
import ij.plugin.filter.Analyzer;
import ij.process.ByteProcessor;
import ij.process.ColorProcessor;
import ij.process.ImageProcessor;
import ij.text.TextWindow;
import ij.util.Tools;
import java.awt.Button;
import java.awt.Color;
import java.awt.FileDialog;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Label;
import java.awt.Panel;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedOutputStream;
import java.io.CharArrayWriter;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Properties;
import java.util.Vector;

public class PlotWindow
extends ImageWindow
implements ActionListener,
ClipboardOwner {
    public static final int CIRCLE = 0;
    public static final int X = 1;
    public static final int BOX = 3;
    public static final int TRIANGLE = 4;
    public static final int CROSS = 5;
    public static final int LINE = 2;
    private static final int WIDTH = 450;
    private static final int HEIGHT = 200;
    private static final String MIN = "pp.min";
    private static final String MAX = "pp.max";
    private static final String PLOT_WIDTH = "pp.width";
    private static final String PLOT_HEIGHT = "pp.height";
    private static final String OPTIONS = "pp.options";
    private static final int SAVE_X_VALUES = 1;
    private static final int AUTO_CLOSE = 2;
    private static final int LIST_VALUES = 4;
    private static final int INTERPOLATE = 8;
    private static final int NO_GRID_LINES = 16;
    private Button list;
    private Button save;
    private Button copy;
    private Label coordinates;
    private static String defaultDirectory = null;
    private Font font = new Font("Helvetica", 0, 12);
    private static int options;
    private int defaultDigits = -1;
    private boolean realNumbers;
    private int xdigits;
    private int ydigits;
    private int markSize = 5;
    private static Plot staticPlot;
    private Plot plot;
    private static final int LEFT_MARGIN = 50;
    private static final int RIGHT_MARGIN = 20;
    private static final int TOP_MARGIN = 20;
    private static final int BOTTOM_MARGIN = 30;
    private boolean fixedYScale;
    private int nPoints;
    private float[] xValues;
    private float[] yValues;
    private float[] xInitValues;
    private float[] yInitValues;
    private float[] yValuesBaseLine;
    private float[] yValuesMergeGaussFit;
    private double[] gaussFitResult;
    private int nbgauss;
    private double xMin;
    private double xMax;
    private double xInitMin;
    private double xInitMax;
    private double yMin;
    private double yMax;
    private Button setting;
    private Button setScale;
    private Button option;
    private Button setScaleRadio;
    private Button baseline;
    private Button subtract;
    private Button gauss;
    private Label Xcoord;
    private Label Ycoord;
    private boolean modifListener = false;
    private int oldX = -1;
    private int oldY = -1;
    private int oldindex = -1;
    private int[] Xpoints;
    private int[] Ypoints;
    private String xLabel;
    private String yLabel;
    public static boolean saveXValues;
    public static boolean autoClose;
    public static int plotWidth;
    public static int plotHeight;
    public static boolean listValues;
    public static boolean interpolate;
    public static boolean noGridLines;
    private ImagePlus origin;
    private Roi region;
    private ImageProcessor ip;
    private static boolean horizontal;
    public static boolean RadioSpectra;
    public static boolean Base_Line;
    public static boolean Base_Line_subtracted;
    public static boolean ZERO_LINE;
    private Vector labels = new Vector();
    private Vector xlabs = new Vector();
    private Vector ylabs = new Vector();

    public PlotWindow(String title, String xLabel, String yLabel, float[] xValues, float[] yValues, float[] xInitValues, float[] yInitValues) {
        super(NewImage.createByteImage(title, plotWidth + 50 + 20, plotHeight + 20 + 30, 1, 4), false);
        System.out.println("Plot Window 1");
        IJ.showProgress(0.1);
        this.xLabel = xLabel;
        this.yLabel = yLabel;
        this.xValues = xValues;
        this.yValues = yValues;
        this.xInitValues = xInitValues;
        this.yInitValues = yInitValues;
        double[] a = Tools.getMinMax(xValues);
        this.xMin = a[0];
        this.xMax = a[1];
        a = Tools.getMinMax(xInitValues);
        this.xInitMin = a[0];
        this.xInitMax = a[1];
        a = Tools.getMinMax(yValues);
        this.yMin = a[0];
        this.yMax = a[1];
        this.fixedYScale = false;
        this.nPoints = xValues.length;
        this.nbgauss = -1;
        this.gaussFitResult = new double[18];
        Panel buttons = new Panel();
        buttons.setLayout(new GridLayout(3, 3));
        this.list = new Button(IJ.getBundle().getString("List"));
        this.list.addActionListener(this);
        buttons.add(this.list);
        this.save = new Button(IJ.getBundle().getString("Save"));
        this.save.addActionListener(this);
        buttons.add(this.save);
        this.copy = new Button(IJ.getBundle().getString("Copy"));
        this.copy.addActionListener(this);
        buttons.add(this.copy);
        this.setting = new Button(IJ.getBundle().getString("Prop"));
        this.setting.addActionListener(this);
        buttons.add(this.setting);
        if (RadioSpectra) {
            System.out.println("Radio Spectrum");
            String s = Base_Line_subtracted || Base_Line ? IJ.getPluginBundle().getString("Reset") : IJ.getBundle().getString("Set_Scale");
            this.setScaleRadio = new Button(s);
            this.setScaleRadio.addActionListener(this);
            buttons.add(this.setScaleRadio);
            if (Base_Line) {
                this.subtract = new Button(IJ.getPluginBundle().getString("subtractRS"));
                this.subtract.addActionListener(this);
                buttons.add(this.subtract);
            } else if (Base_Line_subtracted) {
                this.gauss = new Button(IJ.getPluginBundle().getString("GaussianFit"));
                this.gauss.addActionListener(this);
                buttons.add(this.gauss);
            } else {
                this.baseline = new Button(IJ.getPluginBundle().getString("baseline"));
                this.baseline.addActionListener(this);
                buttons.add(this.baseline);
            }
        } else {
            System.out.println("Not Radio Spectrum");
            this.setScale = new Button(IJ.getBundle().getString("Set_Scale"));
            this.setScale.addActionListener(this);
            buttons.add(this.setScale);
            this.option = new Button(IJ.getPluginBundle().getString("ProOptTitle"));
            this.option.addActionListener(this);
            buttons.add(this.option);
        }
        buttons.add(new Label("     "));
        this.Xcoord = new Label("           ");
        this.Xcoord.setFont(new Font("Monospaced", 0, 12));
        buttons.add(this.Xcoord);
        this.Ycoord = new Label("             ");
        this.Ycoord.setFont(new Font("Monospaced", 0, 12));
        buttons.add(this.Ycoord);
        this.add(buttons);
        this.pack();
        IJ.showResults();
        IJ.getTextPanel().setFont(new Font("Monospaced", 0, 12));
    }

    public PlotWindow(String title, String xLabel, String yLabel, float[] xValues, float[] yValues, float[] xInitValues, float[] yInitValues, ImagePlus origin) {
        this(title, xLabel, yLabel, xValues, yValues, xInitValues, yInitValues);
        this.origin = origin;
        horizontal = false;
        System.out.println("Plot Window 2");
    }

    public PlotWindow(String title, String xLabel, String yLabel, float[] xValues, float[] yValues, ImagePlus origin) {
        this(title, xLabel, yLabel, xValues, yValues, xValues, yValues);
        this.origin = origin;
        horizontal = false;
        System.out.println("Plot Window 3");
    }

    public PlotWindow(String title, String xLabel, String yLabel, float[] xValues, float[] yValues, float[] yValuesBaseLine, ImagePlus origin) {
        this(title, xLabel, yLabel, xValues, yValues, origin);
        if (Base_Line_subtracted) {
            this.yValuesMergeGaussFit = yValuesBaseLine;
        } else {
            this.yValuesBaseLine = yValuesBaseLine;
        }
        System.out.println("Plot Window 4");
    }

    public PlotWindow(String title, String xLabel, String yLabel, float[] xValues, float[] yValues, double[] gaussFitResult, int nbgauss, ImagePlus origin) {
        this(title, xLabel, yLabel, xValues, yValues, origin);
        this.gaussFitResult = gaussFitResult;
        this.nbgauss = nbgauss;
        System.out.println("Plot Window 5");
    }

    public PlotWindow(String title, String xLabel, String yLabel, double[] xValues, double[] yValues, ImagePlus origin) {
        this(title, xLabel, yLabel, Tools.toFloat(xValues), Tools.toFloat(yValues));
        horizontal = false;
        System.out.println("Plot Window 6");
    }

    public PlotWindow(String title, String xLabel, String yLabel, float[] xValues, float[] yValues, boolean horiz, ImagePlus origin, Roi region) {
        this(title, xLabel, yLabel, xValues, yValues, origin);
        this.modifListener = true;
        this.region = (Roi)region.clone();
        horizontal = horiz;
        RadioSpectra = false;
        if (horizontal) {
            int xOrigine = ((Line)region).getX();
            int i = 0;
            while (i < xValues.length) {
                int n = i++;
                this.xValues[n] = this.xValues[n] + (float)xOrigine;
            }
            double[] a = Tools.getMinMax(xValues);
            this.xMin = a[0];
            this.xMax = a[1];
            a = Tools.getMinMax(this.xInitValues);
            this.xInitMin = a[0];
            this.xInitMax = a[1];
        }
        System.out.println("Plot Window 7");
    }

    public PlotWindow(String title, String xLabel, String yLabel, float[] xValues, float[] yValues, float[] xInitValues, float[] yInitValues, boolean horiz, ImagePlus origin, Roi region) {
        this(title, xLabel, yLabel, xValues, yValues, false, origin, region);
        horizontal = horiz;
        this.xInitValues = xInitValues;
        this.yInitValues = yInitValues;
        double[] a = Tools.getMinMax(xInitValues);
        this.xInitMin = a[0];
        this.xInitMax = a[1];
        System.out.println("Plot Window 8");
    }

    public PlotWindow(String title, String xLabel, String yLabel, double[] xValues, double[] yValues, boolean horiz, ImagePlus origin, Roi region) {
        this(title, xLabel, yLabel, Tools.toFloat(xValues), Tools.toFloat(yValues), horiz, origin, region);
        System.out.println("Plot Window 9");
    }

    public PlotWindow(String title, String xLabel, String yLabel, float[] xValues, float[] yValues) {
        super(PlotWindow.createImage(title, xLabel, yLabel, xValues, yValues));
        this.plot = staticPlot;
        System.out.println("Plot Window 10");
    }

    public PlotWindow(String title, String xLabel, String yLabel, double[] xValues, double[] yValues) {
        this(title, xLabel, yLabel, Tools.toFloat(xValues), Tools.toFloat(yValues));
        System.out.println("Plot Window 11");
    }

    PlotWindow(Plot plot, ImagePlus imp) {
        super(imp);
        this.plot = plot;
        this.draw();
        System.out.println("Plot Window 12");
    }

    PlotWindow(Plot plot, ImagePlus imp, boolean radio) {
        super(imp);
        this.plot = plot;
        this.draw();
        RadioSpectra = radio;
        System.out.println("Plot Window 13");
    }

    @Override
    public boolean close() {
        boolean b = super.close();
        this.plot.killOverlayOrigin();
        return b;
    }

    static ImagePlus createImage(String title, String xLabel, String yLabel, float[] xValues, float[] yValues) {
        staticPlot = new Plot(title, xLabel, yLabel, xValues, yValues, null, null);
        return new ImagePlus(title, staticPlot.getBlankProcessor());
    }

    public void setLimits(double xMin, double xMax, double yMin, double yMax) {
        this.plot.setLimits(xMin, xMax, yMin, yMax);
    }

    public void addPoints(float[] x, float[] y, int shape) {
        this.plot.addPoints(x, y, shape);
    }

    public void addPoints(double[] x, double[] y, int shape) {
        this.addPoints(Tools.toFloat(x), Tools.toFloat(y), shape);
    }

    public void addErrorBars(float[] errorBars) {
        this.plot.addErrorBars(errorBars);
    }

    public void addLabel(double x, double y, String label) {
        this.plot.addLabel(x, y, label);
    }

    public void setColor(Color c) {
        this.plot.setColor(c);
    }

    public void setLineWidth(int lineWidth) {
        this.plot.setLineWidth(lineWidth);
    }

    public void changeFont(Font font) {
        this.plot.changeFont(font);
    }

    public void draw() {
        Panel buttons = new Panel();
        buttons.setLayout(new FlowLayout(2));
        this.list = new Button(IJ.getBundle().getString("List"));
        this.list.addActionListener(this);
        buttons.add(this.list);
        this.save = new Button(IJ.getBundle().getString("Save"));
        this.save.addActionListener(this);
        buttons.add(this.save);
        this.copy = new Button(IJ.getBundle().getString("Copy"));
        this.copy.addActionListener(this);
        buttons.add(this.copy);
        this.coordinates = new Label("X=12345678, Y=12345678");
        this.coordinates.setFont(new Font("Monospaced", 0, 12));
        buttons.add(this.coordinates);
        this.add(buttons);
        this.plot.draw();
        this.pack();
        this.coordinates.setText("                 ");
        ImageProcessor ip = this.plot.getProcessor();
        if (ip instanceof ColorProcessor && this.imp.getProcessor() instanceof ByteProcessor) {
            this.imp.setProcessor(null, ip);
        } else {
            this.imp.updateAndDraw();
        }
        if (listValues) {
            this.showList();
        }
    }

    int getDigits(double n1, double n2) {
        if ((double)Math.round(n1) == n1 && (double)Math.round(n2) == n2) {
            return 0;
        }
        double n = (n1 = Math.abs(n1)) < (n2 = Math.abs(n2)) && n1 > 0.0 ? n1 : n2;
        double diff = Math.abs(n2 - n1);
        if (diff > 0.0 && diff < n) {
            n = diff;
        }
        int digits = 1;
        if (n < 10.0) {
            digits = 2;
        }
        if (n < 0.01) {
            digits = 3;
        }
        if (n < 0.001) {
            digits = 4;
        }
        if (n < 1.0E-4) {
            digits = 5;
        }
        return digits;
    }

    @Override
    public void mouseMoved(int x, int y) {
        super.mouseMoved(x, y);
        if (this.plot != null && this.plot.frame != null && this.coordinates != null) {
            this.coordinates.setText(this.plot.getCoordinates(x, y));
            this.plot.updatePlot(x, y);
        }
    }

    void showList() {
        String headings;
        StringBuffer sb = new StringBuffer();
        this.initDigits();
        if (this.plot.errorBars != null) {
            headings = saveXValues ? "X\tY\tErrorBar" : "Y\tErrorBar";
            for (int i = 0; i < this.plot.nPoints; ++i) {
                if (saveXValues) {
                    sb.append(IJ.d2s(this.plot.xValues[i], this.xdigits) + "\t" + IJ.d2s(this.plot.yValues[i], this.ydigits) + "\t" + IJ.d2s(this.plot.errorBars[i], this.ydigits) + "\n");
                    continue;
                }
                sb.append(IJ.d2s(this.plot.yValues[i], this.ydigits) + "\t" + IJ.d2s(this.plot.errorBars[i], this.ydigits) + "\n");
            }
        } else {
            headings = saveXValues ? "X\tY" : "Y";
            for (int i = 0; i < this.plot.nPoints; ++i) {
                if (saveXValues) {
                    sb.append(IJ.d2s(this.plot.xValues[i], this.xdigits) + "\t" + IJ.d2s(this.plot.yValues[i], this.ydigits) + "\n");
                    continue;
                }
                sb.append(IJ.d2s(this.plot.yValues[i], this.ydigits) + "\n");
            }
        }
        TextWindow tw = new TextWindow(IJ.getBundle().getString("PlotValues"), headings, sb.toString(), 200, 400);
        if (autoClose) {
            this.imp.changes = false;
            this.close();
        }
    }

    void saveAsText() {
        String directory;
        FileDialog fd = new FileDialog((Frame)this, IJ.getBundle().getString("SaveAsText"), 1);
        if (defaultDirectory != null) {
            fd.setDirectory(defaultDirectory);
        }
        fd.show();
        String name = fd.getFile();
        defaultDirectory = directory = fd.getDirectory();
        fd.dispose();
        PrintWriter pw = null;
        try {
            FileOutputStream fos = new FileOutputStream(directory + name);
            BufferedOutputStream bos = new BufferedOutputStream(fos);
            pw = new PrintWriter(bos);
        }
        catch (IOException e) {
            IJ.error("" + e);
            return;
        }
        IJ.wait(250);
        IJ.showStatus(IJ.getBundle().getString("SavePlotValues"));
        this.initDigits();
        for (int i = 0; i < this.plot.nPoints; ++i) {
            if (saveXValues) {
                pw.println(IJ.d2s(this.plot.xValues[i], this.xdigits) + "\t" + IJ.d2s(this.plot.yValues[i], this.ydigits));
                continue;
            }
            pw.println(IJ.d2s(this.plot.yValues[i], this.ydigits));
        }
        pw.close();
        if (autoClose) {
            this.imp.changes = false;
            this.close();
        }
    }

    void copyToClipboard() {
        Clipboard systemClipboard = null;
        try {
            systemClipboard = this.getToolkit().getSystemClipboard();
        }
        catch (Exception e) {
            systemClipboard = null;
        }
        if (systemClipboard == null) {
            IJ.error(IJ.getBundle().getString("ClipCopyErr"));
            return;
        }
        IJ.showStatus(IJ.getBundle().getString("CopyPlotValues"));
        this.initDigits();
        CharArrayWriter aw = new CharArrayWriter(this.plot.nPoints * 4);
        PrintWriter pw = new PrintWriter(aw);
        for (int i = 0; i < this.plot.nPoints; ++i) {
            if (saveXValues) {
                pw.print(IJ.d2s(this.plot.xValues[i], this.xdigits) + "\t" + IJ.d2s(this.plot.yValues[i], this.ydigits) + "\n");
                continue;
            }
            pw.print(IJ.d2s(this.plot.yValues[i], this.ydigits) + "\n");
        }
        String text = aw.toString();
        pw.close();
        StringSelection contents = new StringSelection(text);
        systemClipboard.setContents(contents, this);
        IJ.showStatus(text.length() + IJ.getBundle().getString("CharCopied"));
        if (autoClose) {
            this.imp.changes = false;
            this.close();
        }
    }

    void initDigits() {
        this.ydigits = Analyzer.getPrecision();
        if (this.ydigits == 0) {
            this.ydigits = 2;
        }
        if (this.ydigits != this.defaultDigits) {
            this.realNumbers = false;
            for (int i = 0; i < this.plot.xValues.length; ++i) {
                if ((float)((int)this.plot.xValues[i]) == this.plot.xValues[i]) continue;
                this.realNumbers = true;
            }
            this.defaultDigits = this.ydigits;
        }
        this.xdigits = this.realNumbers ? this.ydigits : 0;
    }

    @Override
    public void lostOwnership(Clipboard clipboard, Transferable contents) {
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object b = e.getSource();
        if (b == this.list) {
            this.showList();
        } else if (b == this.save) {
            this.saveAsText();
        } else if (b != this.setting) {
            if (b == this.setScaleRadio) {
                Base_Line_subtracted = false;
                this.setRadioSpectrumScale();
            } else if (b == this.baseline) {
                this.setRadioSpectrumBaseline();
            } else if (b == this.gauss) {
                if (this.nbgauss < 5) {
                    this.gaussFitting();
                } else {
                    IJ.error(IJ.getBundle().getString("error3"));
                }
            } else if (b == this.subtract) {
                this.subtractBaseline();
            } else if (b == this.setScale) {
                IJ.runPlugIn("ij.plugin.filter.ScaleDialog", "");
                IJ.runPlugIn("ij.plugin.filter.Profiler", "");
            } else if (b == this.option) {
                IJ.runPlugIn("ij.plugin.filter.Profiler", "set");
                IJ.runPlugIn("ij.plugin.filter.Profiler", "");
            } else {
                this.copyToClipboard();
            }
        }
    }

    public float[] getXValues() {
        return this.plot.xValues;
    }

    public float[] getYValues() {
        return this.plot.yValues;
    }

    public void drawPlot(Plot plot) {
    }

    public static void savePreferences(Properties prefs) {
        double min = ProfilePlot.getFixedMin();
        double max = ProfilePlot.getFixedMax();
        if ((min != 0.0 || max != 0.0) && min < max) {
            prefs.put(MIN, Double.toString(min));
            prefs.put(MAX, Double.toString(max));
        }
        if (plotWidth != 450 || plotHeight != 200) {
            prefs.put(PLOT_WIDTH, Integer.toString(plotWidth));
            prefs.put(PLOT_HEIGHT, Integer.toString(plotHeight));
        }
        int options = 0;
        if (saveXValues) {
            options |= 1;
        }
        if (autoClose && !listValues) {
            options |= 2;
        }
        if (listValues) {
            options |= 4;
        }
        if (!interpolate) {
            options |= 8;
        }
        if (noGridLines) {
            options |= 0x10;
        }
        prefs.put(OPTIONS, Integer.toString(options));
    }

    public void setRadioSpectrumBaseline() {
        int i;
        int n = 2;
        if (RadioSpectrum_Reader.SCALETYPE == 0) {
            n = 0;
        }
        GenericDialog gd = new GenericDialog("baseline", this);
        double x1 = 0.0;
        double x2 = 0.0;
        double x3 = 0.0;
        double x4 = 0.0;
        int order = 1;
        gd.addMessage(IJ.getPluginBundle().getString("chooseInter"));
        gd.addMessage("                " + IJ.getPluginBundle().getString("Finter"));
        gd.addNumericField("              Xmin = ", x1, n);
        gd.addNumericField("              Xmax = ", x2, n);
        gd.addMessage("                " + IJ.getPluginBundle().getString("Sinter"));
        gd.addNumericField("              Xmin = ", x3, n);
        gd.addNumericField("              Xmax = ", x4, n);
        gd.addMessage(IJ.getPluginBundle().getString("chooseOder"));
        gd.addNumericField("             " + IJ.getPluginBundle().getString("order") + " = ", order, 0);
        gd.addCheckbox(IJ.getPluginBundle().getString("DisplayZero"), ZERO_LINE);
        gd.showDialog();
        x1 = gd.getNextNumber();
        x2 = gd.getNextNumber();
        x3 = gd.getNextNumber();
        x4 = gd.getNextNumber();
        order = (int)gd.getNextNumber();
        ZERO_LINE = gd.getNextBoolean();
        if (gd.wasCanceled()) {
            return;
        }
        if (x1 > x2) {
            this.change(x1, x2);
        }
        if (x3 > x4) {
            this.change(x3, x4);
        }
        if (order > 4) {
            order = 4;
        }
        if (order < 1) {
            order = 1;
        }
        if (x1 < this.xInitMin || x1 > this.xInitMax) {
            x1 = this.xInitMin;
        }
        if (x2 > this.xInitMax || x2 < this.xInitMin) {
            x2 = this.xInitMax;
        }
        if (x3 < this.xInitMin || x3 > this.xInitMax) {
            x3 = this.xInitMin;
        }
        if (x4 > this.xInitMax || x4 < this.xInitMin) {
            x4 = this.xInitMax;
        }
        int nbp = 0;
        for (int i2 = 0; i2 < this.xValues.length; ++i2) {
            if (!((double)this.xValues[i2] > x1 & (double)this.xValues[i2] < x2) && !((double)this.xValues[i2] > x3 & (double)this.xValues[i2] < x4)) continue;
            ++nbp;
        }
        float[] xbase = new float[nbp];
        float[] ybase = new float[nbp];
        float[] bLine = new float[order + 1];
        int ii = 0;
        for (i = 0; i < this.xValues.length; ++i) {
            if (!((double)this.xValues[i] > x1 & (double)this.xValues[i] < x2) && !((double)this.xValues[i] > x3 & (double)this.xValues[i] < x4)) continue;
            xbase[ii] = this.xValues[i];
            ybase[ii] = this.yValues[i];
            ++ii;
        }
        Tools.fittingData(xbase, ybase, bLine);
        this.yValuesBaseLine = new float[this.xValues.length];
        for (i = 0; i < this.xValues.length; ++i) {
            float poly = bLine[order];
            for (int j = 0; j < order; ++j) {
                poly = poly * this.xValues[i] + bLine[order - j - 1];
            }
            this.yValuesBaseLine[i] = poly;
        }
        Base_Line = true;
        FileInfo fi = this.origin.getOriginalFileInfo();
        PlotWindow pw = new PlotWindow(IJ.getBundle().getString("PlotWinTitle") + "  " + fi.fileName, this.xLabel, this.yLabel, this.xValues, this.yValues, this.yValuesBaseLine, this.origin);
        pw.draw();
        this.close();
    }

    public void setRadioSpectrumScale() {
        GenericDialog gd = new GenericDialog(IJ.getBundle().getString("Set_Scale"), this);
        String[] scales = new String[]{IJ.getPluginBundle().getString("ChannelRS"), IJ.getPluginBundle().getString("VelocityRS"), IJ.getPluginBundle().getString("FrequencyRS"), IJ.getPluginBundle().getString("WavelengthRS")};
        gd.addChoice(" ", scales, IJ.getPluginBundle().getString("ChannelRS"));
        gd.showDialog();
        if (gd.wasCanceled()) {
            return;
        }
        int index = gd.getNextChoiceIndex();
        FileInfo fi = this.origin.getOriginalFileInfo();
        RadioSpectrum_Reader.SCALETYPE = index;
        IJ.runPlugIn("ij.plugin.RadioSpectrum_Reader", fi.directory + fi.fileName);
        this.close();
    }

    void change(double x1, double x2) {
        double l = x1;
        x1 = x2;
        x2 = l;
    }

    public void subtractBaseline() {
        for (int i = 0; i < this.xValues.length; ++i) {
            int n = i;
            this.yValues[n] = this.yValues[n] - this.yValuesBaseLine[i];
        }
        Base_Line = false;
        Base_Line_subtracted = true;
        PlotWindow pw = new PlotWindow(this.getTitle(), this.xLabel, this.yLabel, this.xValues, this.yValues, this.xInitValues, this.yInitValues, this.origin);
        pw.draw();
        this.close();
    }

    public void gaussFitting() {
        int n = 2;
        boolean erase = false;
        if (RadioSpectrum_Reader.SCALETYPE == 0) {
            n = 0;
        }
        GenericDialog gd = new GenericDialog(IJ.getPluginBundle().getString("GaussianfitTitle"), this);
        double x1 = 0.0;
        double x2 = 0.0;
        double ampl = 0.0;
        double center = 0.0;
        double width = 0.0;
        boolean order = true;
        gd.addMessage(IJ.getPluginBundle().getString("ChooseParam"));
        gd.addMessage("                " + IJ.getPluginBundle().getString("interval"));
        gd.addNumericField("              Xmin = ", x1, n);
        gd.addNumericField("              Xmax = ", x2, n);
        gd.addMessage("                ");
        gd.addNumericField("              " + IJ.getPluginBundle().getString("amplitudeRS") + " = ", ampl, n);
        gd.addNumericField("              " + IJ.getPluginBundle().getString("centerRS") + " = ", center, n);
        gd.addNumericField("              " + IJ.getPluginBundle().getString("widthRS") + " = ", width, n);
        gd.addCheckbox(IJ.getPluginBundle().getString("eraseRS"), erase);
        gd.showDialog();
        x1 = gd.getNextNumber();
        x2 = gd.getNextNumber();
        ampl = gd.getNextNumber();
        center = gd.getNextNumber();
        width = gd.getNextNumber();
        erase = gd.getNextBoolean();
        if (gd.wasCanceled()) {
            return;
        }
        if (x1 > x2) {
            this.change(x1, x2);
        }
        int nbp = 0;
        for (int i = 0; i < this.xValues.length; ++i) {
            if (!((double)this.xValues[i] > x1 & (double)this.xValues[i] < x2)) continue;
            ++nbp;
        }
        float[] xgauss = new float[nbp];
        float[] ygauss = new float[nbp];
        int ii = 0;
        for (int i = 0; i < this.xValues.length; ++i) {
            if (!((double)this.xValues[i] > x1 & (double)this.xValues[i] < x2)) continue;
            xgauss[ii] = this.xValues[i];
            ygauss[ii] = this.yValues[i];
            ++ii;
        }
        double[] a = new double[]{ampl, center, width};
        int err = RadioSpectrum_Reader.gaussianFitSpectralLine(xgauss, ygauss, a);
        if (err != 0) {
            if (!erase) {
                ++this.nbgauss;
            }
            this.gaussFitResult[3 * this.nbgauss] = a[0];
            this.gaussFitResult[3 * this.nbgauss + 1] = a[1];
            this.gaussFitResult[3 * this.nbgauss + 2] = a[2];
            FileInfo fi = this.origin.getOriginalFileInfo();
            PlotWindow pw = new PlotWindow(IJ.getBundle().getString("PlotWinTitle") + "  " + fi.fileName, this.xLabel, this.yLabel, this.xValues, this.yValues, this.gaussFitResult, this.nbgauss, this.origin);
            pw.draw();
            RadioSpectrum_Reader.addResult(this.origin, a);
            this.close();
        }
    }

    public void displayGaussianFit() {
        float[] ytmp = new float[this.xValues.length];
        for (int i = 0; i < this.nbgauss + 1; ++i) {
            Tools.Fgauss(this.xValues, this.gaussFitResult, i, ytmp);
            this.addPoints(this.xValues, ytmp, 2);
        }
    }

    public void mergeGaussFitting() {
        GenericDialog gd = new GenericDialog("merge Gaussians fits of spectral line", this);
        gd.addMessage("do you want merge ?");
        gd.showDialog();
        if (gd.wasCanceled()) {
            return;
        }
        float[][] ytmp = new float[this.nbgauss + 1][this.xValues.length];
        for (int i = 0; i < this.nbgauss + 1; ++i) {
            Tools.Fgauss(this.xValues, this.gaussFitResult, i, ytmp[i]);
        }
        this.yValuesMergeGaussFit = new float[this.xValues.length];
        for (int j = 0; j < this.xValues.length; ++j) {
            float max = ytmp[0][j];
            for (int i = 1; i < this.nbgauss + 1; ++i) {
                float tmpmax = Math.abs(ytmp[i][j] - this.yValues[j]);
                if (!(tmpmax < Math.abs(max - this.yValues[j]))) continue;
                max = ytmp[i][j];
            }
            this.yValuesMergeGaussFit[j] = max;
        }
        FileInfo fi = this.origin.getOriginalFileInfo();
        PlotWindow pw = new PlotWindow(IJ.getBundle().getString("PlotWinTitle") + "  " + fi.fileName, this.xLabel, this.yLabel, this.xValues, this.yValues, this.yValuesMergeGaussFit, this.origin);
        pw.draw();
        this.close();
    }

    static {
        plotWidth = 450;
        plotHeight = 200;
        RadioSpectra = false;
        Base_Line = false;
        Base_Line_subtracted = false;
        ZERO_LINE = false;
        IJ.register(PlotWindow.class);
        options = Prefs.getInt(OPTIONS, 1);
        saveXValues = (options & 1) != 0;
        autoClose = (options & 2) != 0;
        listValues = (options & 4) != 0;
        plotWidth = Prefs.getInt(PLOT_WIDTH, 450);
        plotHeight = Prefs.getInt(PLOT_HEIGHT, 200);
        interpolate = (options & 8) == 0;
        noGridLines = (options & 0x10) != 0;
    }
}

