/*
 * Decompiled with CFR 0.152.
 */
package ij.gui;

import ij.IJ;
import ij.ImageJ;
import ij.ImagePlus;
import ij.Menus;
import ij.Prefs;
import ij.WindowManager;
import ij.gui.GenericDialog;
import ij.gui.ImageCanvas;
import ij.gui.Roi;
import ij.macro.Program;
import ij.plugin.MacroInstaller;
import ij.plugin.frame.Editor;
import ij.plugin.frame.Recorder;
import java.awt.Canvas;
import java.awt.CheckboxMenuItem;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.MenuItem;
import java.awt.PopupMenu;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.io.File;
import java.net.URL;
import java.util.Hashtable;
import java.util.ResourceBundle;

public class Toolbar
extends Canvas
implements MouseListener,
MouseMotionListener,
ItemListener,
ActionListener {
    public static final int LINE = 0;
    public static final int POLYLINE = 1;
    public static final int FREELINE = 2;
    public static final int RECTANGLE = 3;
    public static final int OVAL = 4;
    public static final int POLYGON = 5;
    public static final int MAGNIFIER = 6;
    public static final int HAND = 7;
    public static final int SPARE1 = 8;
    public static final int SPARE2 = 9;
    public static final int SPARE3 = 10;
    public static final int SPARE4 = 11;
    public static final int SPARE5 = 12;
    public static final int SPARE6 = 13;
    public static final int SPARE7 = 14;
    public static final int SPARE8 = 15;
    public static final int SPARE9 = 16;
    public static final int DOUBLE_CLICK_THRESHOLD = 650;
    private static final int NUM_TOOLS = 17;
    private static final int NUM_BUTTONS = 17;
    private static final int SIZE = 42;
    private static final int OFFSET = 5;
    private static final String BRUSH_SIZE = "toolbar.brush.size";
    private Dimension ps = new Dimension(646, 47);
    private boolean[] down;
    private static int current;
    private int previous;
    private int x;
    private int y;
    private int xOffset;
    private int yOffset;
    private long mouseDownTime;
    private Graphics g;
    private Graphics gbis;
    private static Toolbar instance;
    private int mpPrevious = 0;
    private String[] names = new String[17];
    private String[] icons = new String[17];
    private Image[] imgs = new Image[17];
    private PopupMenu[] menus = new PopupMenu[17];
    private int pc;
    private String icon;
    private MacroInstaller macroInstaller;
    private int startupTime;
    private PopupMenu drawPopup;
    private PopupMenu linePopup;
    private PopupMenu switchPopup;
    private CheckboxMenuItem ovalItem;
    private CheckboxMenuItem rectangleItem;
    private CheckboxMenuItem polygonItem;
    private CheckboxMenuItem straightLineItem;
    private CheckboxMenuItem polyLineItem;
    private CheckboxMenuItem freeLineItem;
    private CheckboxMenuItem profileLineItem;
    private String currentSet = "Startup Macros";
    private static Color foregroundColor;
    private static Color backgroundColor;
    private static boolean brushEnabled;
    private static int brushSize;
    private int lineType = 0;
    private int drawType = 3;
    private Color gray = ImageJ.backgroundColor;
    private Color brighter = this.gray.brighter();
    private Color darker = new Color(246, 160, 60);
    private Color evenDarker = new Color(150, 100, 40);
    private Color triangleColor = new Color(250, 100, 40);
    private ResourceBundle table;
    private boolean drag = false;

    public Toolbar() {
        this.down = new boolean[17];
        ClassLoader cl = this.getClass().getClassLoader();
        for (int i = 0; i < 17; ++i) {
            URL path = cl.getResource("images/bas-" + i + ".png");
            if (path != null) {
                this.imgs[i] = Toolkit.getDefaultToolkit().getImage(path);
                continue;
            }
            path = cl.getResource("images/none.png");
            this.imgs[i] = Toolkit.getDefaultToolkit().getImage(path);
        }
        this.resetButtons();
        this.down[0] = true;
        this.setForeground(Color.black);
        this.setBackground(this.gray);
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        instance = this;
        this.table = ResourceBundle.getBundle("ij/i18n/ToolBundle", IJ.getLocale());
        this.names[16] = "Switch to alternate macro tool sets";
        this.icons[16] = "Cf60T5c15>Tcc15>";
        this.addPopupMenus();
        if (IJ.isMacOSX() || IJ.isVista()) {
            Prefs.antialiasedTools = true;
        }
    }

    void addPopupMenus() {
        this.linePopup = new PopupMenu();
        if (Menus.getFontSize() != 0) {
            this.linePopup.setFont(Menus.getFont());
        }
        this.straightLineItem = new CheckboxMenuItem(IJ.getBundle().getString("StraightLines"), this.lineType == 0);
        this.straightLineItem.addItemListener(this);
        this.linePopup.add(this.straightLineItem);
        this.polyLineItem = new CheckboxMenuItem(IJ.getBundle().getString("SegmentedLines"), this.lineType == 1);
        this.polyLineItem.addItemListener(this);
        this.linePopup.add(this.polyLineItem);
        this.freeLineItem = new CheckboxMenuItem(IJ.getBundle().getString("FreehandLines"), this.lineType == 2);
        this.freeLineItem.addItemListener(this);
        this.linePopup.add(this.freeLineItem);
        this.add(this.linePopup);
        this.drawPopup = new PopupMenu();
        if (Menus.getFontSize() != 0) {
            this.drawPopup.setFont(Menus.getFont());
        }
        this.rectangleItem = new CheckboxMenuItem(IJ.getBundle().getString("Rectangle"), this.drawType == 3);
        this.rectangleItem.addItemListener(this);
        this.drawPopup.add(this.rectangleItem);
        this.ovalItem = new CheckboxMenuItem(IJ.getBundle().getString("Oval"), this.drawType == 4);
        this.ovalItem.addItemListener(this);
        this.drawPopup.add(this.ovalItem);
        this.polygonItem = new CheckboxMenuItem(IJ.getBundle().getString("Polygon"), this.drawType == 5);
        this.polygonItem.addItemListener(this);
        this.drawPopup.add(this.polygonItem);
        this.add(this.drawPopup);
        this.switchPopup = new PopupMenu();
        if (Menus.getFontSize() != 0) {
            this.switchPopup.setFont(Menus.getFont());
        }
        this.add(this.switchPopup);
    }

    public static int getToolId() {
        return current;
    }

    public int getToolId(String name) {
        int tool = -1;
        for (int i = 0; i <= 16; ++i) {
            if (this.names[i] == null || !this.names[i].startsWith(name)) continue;
            tool = i;
            break;
        }
        return tool;
    }

    public static Toolbar getInstance() {
        return instance;
    }

    private void drawButtons(Graphics g) {
        if (Prefs.antialiasedTools) {
            Graphics2D g2d = (Graphics2D)g;
            g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g2d.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        }
        this.drawButton(g, this.lineType);
        this.drawButton(g, this.drawType);
        for (int i = 6; i < 17; ++i) {
            this.drawButton(g, i);
        }
    }

    private void fill3DRect(Graphics g, int x, int y, int width, int height, boolean raised) {
        if (null == g) {
            return;
        }
        if (raised) {
            g.setColor(this.gray);
        } else {
            g.setColor(this.darker);
        }
        g.fillRect(x + 1, y + 1, width - 1, height - 1);
        g.setColor(this.brighter);
        g.drawLine(x, y, x, y + height - 1);
        g.drawLine(x, y, x + width - 1, y);
        g.setColor(raised ? this.evenDarker : this.brighter);
        g.drawLine(x, y + height - 1, x + width - 1, y + height - 1);
        g.drawLine(x + width - 1, y, x + width - 1, y + height - 1);
    }

    private void drawButton(Graphics g, int tool) {
        if (g == null) {
            return;
        }
        int index = this.toolIndex(tool);
        this.fill3DRect(g, index * 42 + 1, 1, 42, 42, !this.down[tool]);
        g.setColor(Color.black);
        int x = index * 42 + 5 + 5;
        int y = 15;
        if (this.down[tool]) {
            ++x;
            ++y;
        }
        this.g = g;
        if (tool >= 8 && tool <= 16 && this.icons[tool] != null) {
            this.drawIcon(g, tool, x, y);
            return;
        }
        if (this.imgs[tool] == null) {
            this.imgs[tool] = this.createImage(40, 40);
            Graphics gr = this.imgs[tool].getGraphics();
            switch (tool) {
                case 0: {
                    this.xOffset = x + 3;
                    this.yOffset = y + 8;
                    this.m(0, 10);
                    this.d(16, 4, gr);
                    this.drawTriangle(11, 13, gr);
                    return;
                }
                case 1: {
                    this.xOffset = x + 5;
                    this.yOffset = y + 7;
                    this.m(14, 6);
                    this.d(11, 3, gr);
                    this.d(1, 3, gr);
                    this.d(1, 4, gr);
                    this.d(6, 9, gr);
                    this.d(2, 13, gr);
                    this.drawTriangle(11, 13, gr);
                    return;
                }
                case 2: {
                    this.xOffset = x + 5;
                    this.yOffset = y + 7;
                    this.m(16, 4);
                    this.d(14, 6, gr);
                    this.d(12, 6, gr);
                    this.d(9, 3, gr);
                    this.d(8, 3, gr);
                    this.d(6, 7, gr);
                    this.d(2, 11, gr);
                    this.d(1, 11, gr);
                    this.drawTriangle(11, 13, gr);
                    return;
                }
                case 6: {
                    this.xOffset = x + 5;
                    this.yOffset = y + 5;
                    this.m(3, 0);
                    this.d(3, 0, gr);
                    this.d(5, 0, gr);
                    this.d(8, 3, gr);
                    this.d(8, 5, gr);
                    this.d(7, 6, gr);
                    this.d(7, 7, gr);
                    this.d(6, 7, gr);
                    this.d(5, 8, gr);
                    this.d(3, 8, gr);
                    this.d(0, 5, gr);
                    this.d(0, 3, gr);
                    this.d(3, 0, gr);
                    this.m(8, 8);
                    this.d(9, 8, gr);
                    this.d(13, 12, gr);
                    this.d(13, 13, gr);
                    this.d(12, 13, gr);
                    this.d(8, 9, gr);
                    this.d(8, 8, gr);
                    return;
                }
                case 7: {
                    this.xOffset = x + 5;
                    this.yOffset = y + 4;
                    this.m(5, 14);
                    this.d(2, 11, gr);
                    this.d(2, 10, gr);
                    this.d(0, 8, gr);
                    this.d(0, 7, gr);
                    this.d(1, 6, gr);
                    this.d(2, 6, gr);
                    this.d(4, 8, gr);
                    this.d(4, 6, gr);
                    this.d(3, 5, gr);
                    this.d(3, 4, gr);
                    this.d(2, 3, gr);
                    this.d(2, 2, gr);
                    this.d(3, 1, gr);
                    this.d(4, 1, gr);
                    this.d(5, 2, gr);
                    this.d(5, 3, gr);
                    this.m(6, 5);
                    this.d(6, 1, gr);
                    this.d(7, 0, gr);
                    this.d(8, 0, gr);
                    this.d(9, 1, gr);
                    this.d(9, 5, gr);
                    this.m(9, 1);
                    this.d(11, 1, gr);
                    this.d(12, 2, gr);
                    this.d(12, 6, gr);
                    this.m(13, 4);
                    this.d(14, 3, gr);
                    this.d(15, 4, gr);
                    this.d(15, 7, gr);
                    this.d(14, 8, gr);
                    this.d(14, 10, gr);
                    this.d(13, 11, gr);
                    this.d(13, 12, gr);
                    this.d(12, 13, gr);
                    this.d(12, 14, gr);
                    return;
                }
            }
        }
        g.drawImage(this.imgs[tool], index * 42 + 5, 5, this);
    }

    void drawTriangle(int x, int y, Graphics gr) {
        this.g.setColor(this.triangleColor);
        this.xOffset += x;
        this.yOffset += y;
        this.m(0, 0);
        this.d(4, 0, gr);
        this.m(1, 1);
        this.d(3, 1, gr);
        this.dot(2, 2);
    }

    void drawIcon(Graphics g, int tool, int x, int y) {
        if (null == g) {
            return;
        }
        this.icon = this.icon = this.icons[tool];
        int length = this.icon.length();
        this.pc = 0;
        block12: do {
            char command = this.icon.charAt(this.pc++);
            if (this.pc >= length) break;
            switch (command) {
                case 'B': {
                    x += this.v();
                    y += this.v();
                    break;
                }
                case 'R': {
                    g.drawRect(x + this.v(), y + this.v(), this.v(), this.v());
                    break;
                }
                case 'F': {
                    g.fillRect(x + this.v(), y + this.v(), this.v(), this.v());
                    break;
                }
                case 'O': {
                    g.drawOval(x + this.v(), y + this.v(), this.v(), this.v());
                    break;
                }
                case 'o': {
                    g.fillOval(x + this.v(), y + this.v(), this.v(), this.v());
                    break;
                }
                case 'C': {
                    g.setColor(new Color(this.v() * 16, this.v() * 16, this.v() * 16));
                    break;
                }
                case 'L': {
                    g.drawLine(x + this.v(), y + this.v(), x + this.v(), y + this.v());
                    break;
                }
                case 'D': {
                    g.fillRect(x + this.v(), y + this.v(), 1, 1);
                    break;
                }
                case 'P': {
                    int y2;
                    int x2;
                    int x1 = x + this.v();
                    int y1 = y + this.v();
                    while ((x2 = this.v()) != 0 && (y2 = this.v()) != 0) {
                        g.drawLine(x1, y1, x2 += x, y2 += y);
                        x1 = x2;
                        y1 = y2;
                    }
                    continue block12;
                }
                case 'T': {
                    int x2 = x + this.v();
                    int y2 = y + this.v();
                    int size = this.v() * 10 + this.v();
                    char[] c = new char[]{this.pc < this.icon.length() ? (char)this.icon.charAt(this.pc++) : (char)'e'};
                    g.setFont(new Font("SansSerif", 1, size));
                    g.drawString(new String(c), x2, y2);
                    break;
                }
            }
        } while (this.pc < length);
        if (this.menus[tool] != null && this.menus[tool].getItemCount() > 0) {
            this.xOffset = x;
            this.yOffset = y;
            this.drawTriangle(13, 14, g);
        }
    }

    int v() {
        if (this.pc >= this.icon.length()) {
            return 0;
        }
        char c = this.icon.charAt(this.pc++);
        switch (c) {
            case '0': {
                return 0;
            }
            case '1': {
                return 1;
            }
            case '2': {
                return 2;
            }
            case '3': {
                return 3;
            }
            case '4': {
                return 4;
            }
            case '5': {
                return 5;
            }
            case '6': {
                return 6;
            }
            case '7': {
                return 7;
            }
            case '8': {
                return 8;
            }
            case '9': {
                return 9;
            }
            case 'a': {
                return 10;
            }
            case 'b': {
                return 11;
            }
            case 'c': {
                return 12;
            }
            case 'd': {
                return 13;
            }
            case 'e': {
                return 14;
            }
            case 'f': {
                return 15;
            }
        }
        return 0;
    }

    private void showMessage(int tool) {
        if (tool >= 8 && tool <= 16 && this.names[tool] != null) {
            String name = this.names[tool];
            int index = name.indexOf("Action Tool");
            if (index != -1) {
                name = name.substring(0, index);
            } else {
                index = name.indexOf("Menu Tool");
                if (index != -1) {
                    name = name.substring(0, index + 4);
                }
            }
            IJ.showStatus(name);
            return;
        }
        switch (tool) {
            case 0: {
                IJ.showStatus(this.table.getString("StraightSel"));
                return;
            }
            case 1: {
                IJ.showStatus(this.table.getString("SegSel"));
                return;
            }
            case 2: {
                IJ.showStatus(this.table.getString("FreeLineSel"));
                return;
            }
            case 6: {
                IJ.showStatus(this.table.getString("MagTool"));
                return;
            }
            case 7: {
                IJ.showStatus(this.table.getString("ScrollTool"));
                return;
            }
            case 3: {
                IJ.showStatus(this.table.getString("RectSel"));
                return;
            }
            case 4: {
                IJ.showStatus(this.table.getString("OvalSel"));
                return;
            }
            case 5: {
                IJ.showStatus(this.table.getString("PolySel"));
                return;
            }
        }
        IJ.showStatus("");
    }

    private void m(int x, int y) {
        this.x = this.xOffset + x;
        this.y = this.yOffset + y;
    }

    private void d(int x, int y, Graphics gr) {
        gr.drawLine(this.x, this.y, x += this.xOffset, y += this.yOffset);
        this.x = x;
        this.y = y;
    }

    private void dot(int x, int y) {
        this.g.fillRect(x + this.xOffset, y + this.yOffset, 1, 1);
    }

    private void resetButtons() {
        for (int i = 0; i < 17; ++i) {
            this.down[i] = false;
        }
    }

    @Override
    public void paint(Graphics g) {
        if (null == g) {
            return;
        }
        this.drawButtons(g);
    }

    public void setTool(int tool) {
        if (tool == current || tool < 0 || tool >= 17) {
            return;
        }
        if (tool >= 9 && tool <= 16) {
            if (this.names[tool] == null) {
                this.names[tool] = "Spare tool";
            }
            if (this.names[tool].indexOf("Action Tool") != -1) {
                return;
            }
        }
        if (this.isLine(tool)) {
            this.lineType = tool;
        }
        if (this.isDraw(tool)) {
            this.drawType = tool;
        }
        this.setTool2(tool);
    }

    private void setTool2(int tool) {
        if (tool == current || !this.isValidTool(tool)) {
            return;
        }
        current = tool;
        this.down[Toolbar.current] = true;
        this.down[this.previous] = false;
        Graphics g = this.getGraphics();
        if (Prefs.antialiasedTools) {
            Graphics2D g2d = (Graphics2D)g;
            g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        }
        this.drawButton(g, this.previous);
        this.drawButton(g, current);
        if (null == g) {
            return;
        }
        g.dispose();
        this.showMessage(current);
        this.previous = current;
        if (Recorder.record) {
            Recorder.record("setTool", current);
        }
        if (IJ.isMacOSX()) {
            this.repaint();
        }
    }

    boolean isValidTool(int tool) {
        if (tool < 0 || tool >= 17) {
            return false;
        }
        return tool != 8 && (tool < 9 || tool > 16) || this.names[tool] != null;
    }

    public Color getColor() {
        return foregroundColor;
    }

    public void setColor(Color c) {
        if (c != null) {
            foregroundColor = c;
        }
    }

    public static Color getForegroundColor() {
        return foregroundColor;
    }

    public static void setForegroundColor(Color c) {
        if (c != null) {
            foregroundColor = c;
        }
    }

    public static Color getBackgroundColor() {
        return backgroundColor;
    }

    public static void setBackgroundColor(Color c) {
        if (c != null) {
            backgroundColor = c;
        }
    }

    public static int getBrushSize() {
        if (brushEnabled) {
            return brushSize;
        }
        return 0;
    }

    static void repaintTool(int tool) {
        if (IJ.getInstance() != null) {
            Toolbar tb = Toolbar.getInstance();
            Graphics g = tb.getGraphics();
            if (Prefs.antialiasedTools) {
                ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            }
            tb.drawButton(g, tool);
            if (g != null) {
                g.dispose();
            }
        }
    }

    int toolIndex(int tool) {
        switch (tool) {
            case 0: {
                return 0;
            }
            case 1: {
                return 0;
            }
            case 2: {
                return 0;
            }
            case 3: {
                return 1;
            }
            case 4: {
                return 1;
            }
            case 5: {
                return 1;
            }
            case 6: {
                return 2;
            }
            case 7: {
                return 3;
            }
            case 8: {
                return 4;
            }
        }
        return tool - 4;
    }

    int toolID(int index) {
        switch (index) {
            case 0: {
                return this.lineType;
            }
            case 1: {
                return this.drawType;
            }
            case 2: {
                return 6;
            }
            case 3: {
                return 7;
            }
            case 4: {
                return 8;
            }
        }
        return index + 4;
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (this.drag) {
            return;
        }
        int x = e.getX();
        int newTool = 0;
        for (int i = 0; i < 17; ++i) {
            if (x <= i * 42 || x >= i * 42 + 42) continue;
            newTool = this.toolID(i);
        }
        if (newTool == 16) {
            this.showSwitchPopupMenu(e);
            return;
        }
        if (!this.isValidTool(newTool)) {
            return;
        }
        if (this.menus[newTool] != null && this.menus[newTool].getItemCount() > 0) {
            this.menus[newTool].show(e.getComponent(), e.getX(), e.getY());
            return;
        }
        boolean doubleClick = newTool == current && System.currentTimeMillis() - this.mouseDownTime <= 650L;
        this.mouseDownTime = System.currentTimeMillis();
        if (!doubleClick) {
            this.mpPrevious = current;
            if (this.isMacroTool(newTool)) {
                String name = this.names[newTool];
                if (name.indexOf("Unused Tool") != -1) {
                    return;
                }
                if (name.indexOf("Action Tool") != -1) {
                    this.drawTool(newTool, true);
                    IJ.wait(50);
                    this.drawTool(newTool, false);
                    this.runMacroTool(newTool);
                    return;
                }
                name = name.endsWith(" ") ? name : name + " ";
                this.macroInstaller.runMacroTool(name + "Selected");
            }
            this.setTool2(newTool);
            if (this.isLine(current) && (e.isPopupTrigger() || e.isMetaDown())) {
                this.straightLineItem.setState(this.lineType == 0);
                this.polyLineItem.setState(this.lineType == 1);
                this.freeLineItem.setState(this.lineType == 2);
                if (IJ.isMacOSX()) {
                    IJ.wait(10);
                }
                this.linePopup.show(e.getComponent(), x, this.y);
                this.mouseDownTime = 0L;
            }
            if (this.isDraw(current) && (e.isPopupTrigger() || e.isMetaDown())) {
                this.rectangleItem.setState(this.drawType == 3);
                this.ovalItem.setState(this.drawType == 4);
                this.polygonItem.setState(this.drawType == 5);
                if (IJ.isMacOSX()) {
                    IJ.wait(10);
                }
                this.drawPopup.show(e.getComponent(), x, this.y);
                this.mouseDownTime = 0L;
            }
        } else {
            if (this.isMacroTool(current)) {
                String name = this.names[current].endsWith(" ") ? this.names[current] : this.names[current] + " ";
                this.macroInstaller.runMacroTool(name + "Options");
                return;
            }
            ImagePlus imp = WindowManager.getCurrentImage();
            switch (current) {
                case 6: {
                    ImageCanvas ic;
                    if (imp == null || (ic = imp.getCanvas()) == null) break;
                    ic.unzoom();
                    break;
                }
                case 0: 
                case 1: 
                case 2: {
                    IJ.doCommand(Prefs.getCommand("options01"));
                    break;
                }
            }
        }
    }

    void showSwitchPopupMenu(MouseEvent e) {
        int i;
        String[] list;
        String path = IJ.getDirectory("macros") + "toolsets/";
        if (path == null) {
            return;
        }
        boolean applet = IJ.getApplet() != null;
        File f = new File(path);
        if (!applet && f.exists() && f.isDirectory()) {
            list = f.list();
            if (list == null) {
                return;
            }
        } else {
            list = new String[]{};
        }
        boolean stackTools = false;
        for (i = 0; i < list.length; ++i) {
            if (!list[i].equals("Stack Tools.txt")) continue;
            stackTools = true;
            break;
        }
        this.switchPopup.removeAll();
        path = IJ.getDirectory("macros") + "StartupMacros.txt";
        f = new File(path);
        if (!applet && f.exists()) {
            this.addItem("Startup Macros");
        } else {
            this.addItem("StartupMacros*");
        }
        if (!stackTools) {
            this.addItem("Stack Tools*");
        }
        for (i = 0; i < list.length; ++i) {
            String name = list[i];
            if (name.endsWith(".txt")) {
                name = name.substring(0, name.length() - 4);
                this.addItem(name);
                continue;
            }
            if (!name.endsWith(".ijm")) continue;
            name = name.substring(0, name.length() - 4) + " ";
            this.addItem(name);
        }
        this.addItem("Help...");
        if (IJ.isMacOSX()) {
            IJ.wait(10);
        }
        this.switchPopup.show(e.getComponent(), e.getX(), e.getY());
    }

    void addItem(String name) {
        CheckboxMenuItem item = new CheckboxMenuItem(name, name.equals(this.currentSet));
        item.addItemListener(this);
        this.switchPopup.add(item);
    }

    void drawTool(int tool, boolean drawDown) {
        this.down[tool] = drawDown;
        Graphics g = this.getGraphics();
        if (!drawDown && Prefs.antialiasedTools) {
            Graphics2D g2d = (Graphics2D)g;
            g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        }
        this.drawButton(g, tool);
        if (null == g) {
            return;
        }
        g.dispose();
    }

    boolean isLine(int tool) {
        return tool == 0 || tool == 1 || tool == 2;
    }

    boolean isDraw(int tool) {
        return tool == 3 || tool == 4 || tool == 5;
    }

    public void restorePreviousTool() {
        this.setTool2(this.mpPrevious);
    }

    boolean isMacroTool(int tool) {
        return tool >= 8 && tool <= 16 && this.names[tool] != null && this.macroInstaller != null;
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseDragged(MouseEvent e) {
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        CheckboxMenuItem item = (CheckboxMenuItem)e.getSource();
        if (item == this.straightLineItem) {
            this.lineType = 0;
            this.setTool2(0);
            this.showMessage(0);
        } else if (item == this.polyLineItem) {
            this.lineType = 1;
            this.setTool2(1);
            this.showMessage(1);
        } else if (item == this.freeLineItem) {
            this.lineType = 2;
            this.setTool2(2);
            this.showMessage(2);
        } else if (item == this.rectangleItem) {
            this.drawType = 3;
            this.setTool2(3);
            this.showMessage(3);
        } else if (item == this.ovalItem) {
            this.drawType = 4;
            this.setTool2(4);
            this.showMessage(4);
        } else if (item == this.polygonItem) {
            this.drawType = 5;
            this.setTool2(5);
            this.showMessage(5);
        } else {
            String label = item.getActionCommand();
            if (!label.equals("Help...")) {
                this.currentSet = label;
            }
            if (label.equals("Help...")) {
                IJ.showMessage("Tool Switcher", "Use this drop down menu to switch to macro tool\nsets located in the ImageJ/macros/toolsets folder,\nor to revert to the ImageJ/macros/StartupMacros\nset. The default tool sets, which have names\nending in '*', are loaded from ij.jar.\n \nHold the shift key down while selecting a tool\nset to view its source code.\n \nSeveral example tool sets are available at\n<http://rsb.info.nih.gov/ij/macros/toolsets/>.");
                return;
            }
            if (label.endsWith("*")) {
                MacroInstaller mi = new MacroInstaller();
                label = label.substring(0, label.length() - 1) + ".txt";
                String path = "/macros/" + label;
                if (IJ.shiftKeyDown()) {
                    String macros = mi.openFromIJJar(path);
                    Editor ed = new Editor();
                    ed.setSize(350, 300);
                    ed.create(label, macros);
                    IJ.setKeyUp(16);
                } else {
                    mi.installFromIJJar(path);
                }
            } else {
                String path = label.equals("Startup Macros") ? IJ.getDirectory("macros") + "StartupMacros.txt" : (label.endsWith(" ") ? IJ.getDirectory("macros") + "toolsets/" + label.substring(0, label.length() - 1) + ".ijm" : IJ.getDirectory("macros") + "toolsets/" + label + ".txt");
                try {
                    if (IJ.shiftKeyDown()) {
                        IJ.open(path);
                        IJ.setKeyUp(16);
                    } else {
                        new MacroInstaller().run(path);
                    }
                }
                catch (Exception ex) {
                    // empty catch block
                }
            }
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        MenuItem item = (MenuItem)e.getSource();
        String cmd = e.getActionCommand();
        PopupMenu popup = (PopupMenu)item.getParent();
        int tool = -1;
        for (int i = 8; i < 17; ++i) {
            if (popup != this.menus[i]) continue;
            tool = i;
            break;
        }
        if (tool == -1) {
            return;
        }
        if (this.macroInstaller != null) {
            this.macroInstaller.runMenuTool(this.names[tool], cmd);
        }
    }

    @Override
    public Dimension getPreferredSize() {
        return this.ps;
    }

    @Override
    public Dimension getMinimumSize() {
        return this.ps;
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        int x = e.getX();
        x = this.toolID(x / 42);
        this.showMessage(x);
    }

    public int addTool(String toolTip) {
        int index = toolTip.indexOf(45);
        boolean hasIcon = index >= 0 && toolTip.length() - index > 4;
        int tool = -1;
        if (this.names[8] == null) {
            tool = 8;
        }
        if (tool == -1) {
            for (int i = 9; i <= 15; ++i) {
                if (this.names[i] != null) continue;
                tool = i;
                break;
            }
        }
        if (tool == -1) {
            return -1;
        }
        if (hasIcon) {
            this.icons[tool] = toolTip.substring(index + 1);
            this.names[tool] = index > 0 && toolTip.charAt(index - 1) == ' ' ? toolTip.substring(0, index - 1) : toolTip.substring(0, index);
        } else {
            if (toolTip.endsWith("-")) {
                toolTip = toolTip.substring(0, toolTip.length() - 1);
            } else if (toolTip.endsWith("- ")) {
                toolTip = toolTip.substring(0, toolTip.length() - 2);
            }
            this.names[tool] = toolTip;
        }
        if (tool == current && (this.names[tool].indexOf("Action Tool") != -1 || this.names[tool].indexOf("Unused Tool") != -1)) {
            this.setTool(0);
        }
        if (this.names[tool].endsWith(" Menu Tool")) {
            this.installMenu(tool);
        }
        return tool;
    }

    void installMenu(int tool) {
        Program pgm = this.macroInstaller.getProgram();
        Hashtable h = pgm.getMenus();
        if (h == null) {
            return;
        }
        String[] commands = (String[])h.get(this.names[tool]);
        if (commands == null) {
            return;
        }
        if (this.menus[tool] == null) {
            this.menus[tool] = new PopupMenu("");
            if (Menus.getFontSize() != 0) {
                this.menus[tool].setFont(Menus.getFont());
            }
            this.add(this.menus[tool]);
        } else {
            this.menus[tool].removeAll();
        }
        for (int i = 0; i < commands.length; ++i) {
            if (commands[i].equals("-")) {
                this.menus[tool].addSeparator();
                continue;
            }
            MenuItem mi = new MenuItem(commands[i]);
            mi.addActionListener(this);
            this.menus[tool].add(mi);
        }
        if (tool == current) {
            this.setTool(0);
        }
    }

    public void addMacroTool(String name, MacroInstaller macroInstaller, int id) {
        if (id == 0) {
            for (int i = 8; i < 16; ++i) {
                this.names[i] = null;
                this.icons[i] = null;
                if (this.menus[i] == null) continue;
                this.menus[i].removeAll();
            }
        }
        this.macroInstaller = macroInstaller;
        this.addTool(name);
    }

    void runMacroTool(int id) {
        if (this.macroInstaller != null) {
            this.macroInstaller.runMacroTool(this.names[id]);
        }
    }

    void showBrushDialog() {
        GenericDialog gd = new GenericDialog("Selection Brush");
        gd.addCheckbox("Enable Selection Brush", brushEnabled);
        gd.addNumericField("           Size:", brushSize, 0, 4, "pixels");
        gd.showDialog();
        if (gd.wasCanceled()) {
            return;
        }
        brushEnabled = gd.getNextBoolean();
        brushSize = (int)gd.getNextNumber();
        ImagePlus img = WindowManager.getCurrentImage();
        Roi roi = img != null ? img.getRoi() : null;
    }

    static {
        foregroundColor = Prefs.getColor("fcolor", Color.black);
        backgroundColor = Prefs.getColor("bcolor", Color.white);
        brushSize = (int)Prefs.get(BRUSH_SIZE, 15.0);
    }
}

