/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin;

import ij.IJ;
import ij.ImagePlus;
import ij.io.FileInfo;
import ij.io.OpenDialog;
import ij.plugin.BMPDecoder;
import ij.plugin.PlugIn;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.image.MemoryImageSource;
import java.io.FileInputStream;
import java.io.IOException;

public class BMP_Reader
extends ImagePlus
implements PlugIn {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run(String arg) {
        OpenDialog od = new OpenDialog("Open BMP...", arg);
        String directory = od.getDirectory();
        String name = od.getFileName();
        if (name == null) {
            return;
        }
        String path = directory + name;
        BMPDecoder bmp = new BMPDecoder();
        FileInputStream is = null;
        try {
            is = new FileInputStream(path);
            bmp.read(is);
        }
        catch (Exception e) {
            String msg = e.getMessage();
            if (msg == null || msg.equals("")) {
                msg = "" + e;
            }
            IJ.error("BMP Decoder", msg);
            return;
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException e) {}
            }
        }
        MemoryImageSource mis = bmp.makeImageSource();
        if (mis == null) {
            IJ.write("mis=null");
        }
        Image img = Toolkit.getDefaultToolkit().createImage(mis);
        FileInfo fi = new FileInfo();
        fi.fileFormat = 5;
        fi.fileName = name;
        fi.directory = directory;
        this.setImage(img);
        this.setTitle(name);
        this.setFileInfo(fi);
        if (bmp.topDown) {
            this.getProcessor().flipVertical();
        }
        if (arg.equals("")) {
            this.show();
        }
    }
}

