/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin;

import ij.IJ;
import ij.Menus;
import ij.Prefs;
import ij.plugin.PlugIn;
import java.io.File;
import java.util.Vector;

public class ClassChecker
implements PlugIn {
    char separatorChar = Prefs.separator.charAt(0);

    @Override
    public void run(String arg) {
        this.deleteDuplicates();
    }

    void deleteDuplicates() {
        String[] paths = this.getClassFiles();
        if (paths == null) {
            return;
        }
        block0: for (int i = 0; i < paths.length; ++i) {
            String name = this.getName(paths[i]);
            if (name.endsWith("classx")) continue;
            for (int j = i + 1; j < paths.length; ++j) {
                long date2;
                if (!paths[j].endsWith(name)) continue;
                File file1 = new File(paths[i]);
                File file2 = new File(paths[j]);
                if (file1 == null || file2 == null) continue;
                long date1 = file1.lastModified();
                if (date1 < (date2 = file2.lastModified())) {
                    this.write(paths[i]);
                    file1.delete();
                    continue block0;
                }
                if (date2 < date1) {
                    this.write(paths[j]);
                    int n = j;
                    paths[n] = paths[n] + "x";
                    file2.delete();
                    continue;
                }
                if (paths[i].endsWith("plugins" + name)) {
                    this.write(paths[i]);
                    file1.delete();
                    continue block0;
                }
                if (!paths[j].endsWith("plugins" + name)) continue;
                this.write(paths[j]);
                int n = j;
                paths[n] = paths[n] + "x";
                file2.delete();
            }
        }
    }

    void write(String path) {
        IJ.log("Deleting duplicate class: " + path);
    }

    public String getName(String path) {
        int index = path.lastIndexOf(this.separatorChar);
        return index < 0 ? path : path.substring(index);
    }

    String[] getClassFiles() {
        String path = Menus.getPlugInsPath();
        if (path == null) {
            return null;
        }
        File f = new File(path);
        Object[] list = f.list();
        if (list == null) {
            return null;
        }
        Vector<String> v = new Vector<String>();
        for (int i = 0; i < list.length; ++i) {
            String name = list[i];
            boolean isClassFile = name.endsWith(".class");
            if (isClassFile) {
                v.addElement(path + name);
                continue;
            }
            if (isClassFile) continue;
            this.getSubdirectoryClassFiles(path, name, v);
        }
        list = new String[v.size()];
        v.copyInto(list);
        return list;
    }

    void getSubdirectoryClassFiles(String path, String dir, Vector v) {
        if (dir.endsWith(".java")) {
            return;
        }
        File f = new File(path, dir);
        if (!f.isDirectory()) {
            return;
        }
        String[] list = f.list();
        if (list == null) {
            return;
        }
        dir = dir + Prefs.separator;
        for (int i = 0; i < list.length; ++i) {
            String name = list[i];
            if (!name.endsWith(".class")) continue;
            v.addElement(path + dir + name);
        }
    }
}

