/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin;

import ij.IJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.Undo;
import ij.WindowManager;
import ij.gui.GenericDialog;
import ij.measure.Measurements;
import ij.plugin.PlugIn;
import ij.process.ColorProcessor;
import ij.process.FHT;
import ij.process.FloatProcessor;
import ij.process.ImageProcessor;
import ij.process.ImageStatistics;
import ij.process.StackProcessor;
import ij.util.Tools;

public class FFT
implements PlugIn,
Measurements {
    static boolean displayFFT = true;
    public static boolean displayRawPS;
    public static boolean displayFHT;
    public static boolean displayComplex;
    public static String fileName;
    private ImagePlus imp;
    private boolean padded;
    private int originalWidth;
    private int originalHeight;
    private int stackSize = 1;
    private int slice = 1;
    private boolean doFFT;

    @Override
    public void run(String arg) {
        boolean inverse;
        if (arg.equals("options")) {
            this.showDialog();
            if (this.doFFT) {
                arg = "fft";
            } else {
                return;
            }
        }
        this.imp = IJ.getImage();
        if (arg.equals("redisplay")) {
            this.redisplayPowerSpectrum();
            return;
        }
        if (arg.equals("swap")) {
            this.swapQuadrants(this.imp.getStack());
            this.imp.updateAndDraw();
            return;
        }
        if (arg.equals("inverse")) {
            if (this.imp.getTitle().startsWith("FHT of")) {
                this.doFHTInverseTransform();
                return;
            }
            if (this.imp.getStackSize() == 2) {
                this.doComplexInverseTransform();
                return;
            }
        }
        ImageProcessor ip = this.imp.getProcessor();
        Object obj = this.imp.getProperty("FHT");
        FHT fht = obj instanceof FHT ? (FHT)obj : null;
        this.stackSize = this.imp.getStackSize();
        if (fht == null && arg.equals("inverse")) {
            IJ.error("FFT", "Frequency domain image required");
            return;
        }
        if (fht != null) {
            inverse = true;
            this.imp.killRoi();
        } else {
            if (this.imp.getRoi() != null) {
                ip = ip.crop();
            }
            fht = this.newFHT(ip);
            inverse = false;
        }
        if (inverse) {
            this.doInverseTransform(fht);
        } else {
            fileName = this.imp.getTitle();
            this.doForewardTransform(fht);
        }
        IJ.showProgress(1.0);
    }

    void doInverseTransform(FHT fht) {
        ImagePlus imp2;
        String title;
        fht = fht.getCopy();
        this.doMasking(fht);
        this.showStatus("Inverse transform");
        fht.inverseTransform();
        if (fht.quadrantSwapNeeded) {
            fht.swapQuadrants();
        }
        fht.resetMinAndMax();
        ImageProcessor ip2 = fht;
        if (fht.originalWidth > 0) {
            fht.setRoi(0, 0, fht.originalWidth, fht.originalHeight);
            ip2 = fht.crop();
        }
        int bitDepth = fht.originalBitDepth > 0 ? fht.originalBitDepth : this.imp.getBitDepth();
        switch (bitDepth) {
            case 8: {
                ip2 = ip2.convertToByte(false);
                break;
            }
            case 16: {
                ip2 = ip2.convertToShort(false);
                break;
            }
            case 24: {
                this.showStatus("Setting brightness");
                if (fht.rgb == null || ip2 == null) {
                    IJ.error("FFT", "Unable to set brightness");
                    return;
                }
                ColorProcessor rgb = (ColorProcessor)fht.rgb.duplicate();
                rgb.setBrightness((FloatProcessor)ip2);
                ip2 = rgb;
                fht.rgb = null;
                break;
            }
        }
        if (bitDepth != 24 && fht.originalColorModel != null) {
            ip2.setColorModel(fht.originalColorModel);
        }
        if ((title = this.imp.getTitle()).startsWith("FFT of ")) {
            title = title.substring(7, title.length());
        }
        if ((imp2 = new ImagePlus("Inverse FFT of " + title, ip2)).getWidth() == this.imp.getWidth()) {
            imp2.setCalibration(this.imp.getCalibration());
        }
        imp2.show();
    }

    void doForewardTransform(FHT fht) {
        this.showStatus("Foreward transform");
        fht.transform();
        this.showStatus("Calculating power spectrum");
        ImageProcessor ps = fht.getPowerSpectrum();
        if (!displayFHT && !displayComplex) {
            displayFFT = true;
        }
        if (displayFFT) {
            ImagePlus imp2 = new ImagePlus("FFT of " + this.imp.getTitle(), ps);
            imp2.show();
            imp2.setProperty("FHT", fht);
            imp2.setCalibration(this.imp.getCalibration());
        }
    }

    FHT newFHT(ImageProcessor ip) {
        FHT fht;
        if (ip instanceof ColorProcessor) {
            this.showStatus("Extracting brightness");
            FloatProcessor ip2 = ((ColorProcessor)ip).getBrightness();
            fht = new FHT(this.pad(ip2));
            fht.rgb = (ColorProcessor)ip.duplicate();
        } else {
            fht = new FHT(this.pad(ip));
        }
        if (this.padded) {
            fht.originalWidth = this.originalWidth;
            fht.originalHeight = this.originalHeight;
        }
        fht.originalBitDepth = this.imp.getBitDepth();
        fht.originalColorModel = ip.getColorModel();
        return fht;
    }

    ImageProcessor pad(ImageProcessor ip) {
        int i;
        this.originalWidth = ip.getWidth();
        this.originalHeight = ip.getHeight();
        int maxN = Math.max(this.originalWidth, this.originalHeight);
        for (i = 2; i < maxN; i *= 2) {
        }
        if (i == maxN && this.originalWidth == this.originalHeight) {
            this.padded = false;
            return ip;
        }
        maxN = i;
        this.showStatus("Padding to " + maxN + "x" + maxN);
        ImageStatistics stats = ImageStatistics.getStatistics(ip, 2, null);
        ImageProcessor ip2 = ip.createProcessor(maxN, maxN);
        ip2.setValue(stats.mean);
        ip2.fill();
        ip2.insert(ip, 0, 0);
        this.padded = true;
        Undo.reset();
        return ip2;
    }

    void showStatus(String msg) {
        if (this.stackSize > 1) {
            IJ.showStatus("FFT: " + this.slice + "/" + this.stackSize);
        } else {
            IJ.showStatus(msg);
        }
    }

    void doMasking(FHT ip) {
        if (this.stackSize > 1) {
            return;
        }
        float[] fht = (float[])ip.getPixels();
        ImageProcessor mask = this.imp.getProcessor();
        mask = mask.convertToByte(false);
        ImageStatistics stats = ImageStatistics.getStatistics(mask, 16, null);
        if (stats.histogram[0] == 0 && stats.histogram[255] == 0) {
            return;
        }
        boolean passMode = stats.histogram[255] != 0;
        IJ.showStatus("Masking: " + (passMode ? "pass" : "filter"));
        mask = mask.duplicate();
        if (passMode) {
            this.changeValues(mask, 0, 254, 0);
        } else {
            this.changeValues(mask, 1, 255, 255);
        }
        for (int i = 0; i < 3; ++i) {
            mask.smooth();
        }
        ip.swapQuadrants(mask);
        byte[] maskPixels = (byte[])mask.getPixels();
        for (int i = 0; i < fht.length; ++i) {
            fht[i] = (float)((double)(fht[i] * (float)(maskPixels[i] & 0xFF)) / 255.0);
        }
    }

    void changeValues(ImageProcessor ip, int v1, int v2, int v3) {
        byte[] pixels = (byte[])ip.getPixels();
        for (int i = 0; i < pixels.length; ++i) {
            int v = pixels[i] & 0xFF;
            if (v < v1 || v > v2) continue;
            pixels[i] = (byte)v3;
        }
    }

    void redisplayPowerSpectrum() {
        FHT fht = (FHT)this.imp.getProperty("FHT");
        if (fht == null) {
            IJ.error("FFT", "Frequency domain image required");
            return;
        }
        ImageProcessor ps = fht.getPowerSpectrum();
        this.imp.setProcessor(null, ps);
    }

    void swapQuadrants(ImageStack stack) {
        FHT fht = new FHT(new FloatProcessor(1, 1));
        for (int i = 1; i <= stack.getSize(); ++i) {
            fht.swapQuadrants(stack.getProcessor(i));
        }
    }

    void showDialog() {
        GenericDialog gd = new GenericDialog("FFT Options");
        gd.setInsets(0, 20, 0);
        gd.addMessage("Display:");
        gd.setInsets(5, 35, 0);
        gd.addCheckbox("FFT Window", displayFFT);
        gd.setInsets(0, 35, 0);
        gd.addCheckbox("Raw Power Spectrum", displayRawPS);
        gd.setInsets(0, 35, 0);
        gd.addCheckbox("Fast Hartley Transform", displayFHT);
        gd.setInsets(0, 35, 0);
        gd.addCheckbox("Complex Fourier Transform", displayComplex);
        gd.setInsets(8, 20, 0);
        gd.addCheckbox("Do Forward Transform", false);
        gd.showDialog();
        if (gd.wasCanceled()) {
            return;
        }
        displayFFT = gd.getNextBoolean();
        displayRawPS = gd.getNextBoolean();
        displayFHT = gd.getNextBoolean();
        displayComplex = gd.getNextBoolean();
        this.doFFT = gd.getNextBoolean();
    }

    void doFHTInverseTransform() {
        FHT fht = new FHT(this.imp.getProcessor().duplicate());
        fht.inverseTransform();
        fht.resetMinAndMax();
        String name = WindowManager.getUniqueName(this.imp.getTitle().substring(7));
        new ImagePlus(name, fht).show();
    }

    void doComplexInverseTransform() {
        ImageStack stack = this.imp.getStack();
        if (!stack.getSliceLabel(1).equals("Real")) {
            return;
        }
        int maxN = this.imp.getWidth();
        this.swapQuadrants(stack);
        float[] rein = (float[])stack.getPixels(1);
        float[] imin = (float[])stack.getPixels(2);
        float[] reout = new float[maxN * maxN];
        float[] imout = new float[maxN * maxN];
        this.c2c2DFFT(rein, imin, maxN, reout, imout);
        ImageStack stack2 = new ImageStack(maxN, maxN);
        this.swapQuadrants(stack);
        stack2.addSlice("Real", reout);
        stack2.addSlice("Imaginary", imout);
        stack2 = this.unpad(stack2);
        String name = WindowManager.getUniqueName(this.imp.getTitle().substring(10));
        ImagePlus imp2 = new ImagePlus(name, stack2);
        imp2.getProcessor().resetMinAndMax();
        imp2.show();
    }

    ImageStack unpad(ImageStack stack) {
        Object w = this.imp.getProperty("FFT width");
        Object h = this.imp.getProperty("FFT height");
        if (w == null || h == null) {
            return stack;
        }
        int width = (int)Tools.parseDouble((String)w, 0.0);
        int height = (int)Tools.parseDouble((String)h, 0.0);
        if (width == 0 || height == 0 || width == stack.getWidth() && height == stack.getHeight()) {
            return stack;
        }
        StackProcessor sp = new StackProcessor(stack, null);
        ImageStack stack2 = sp.crop(0, 0, width, height);
        return stack2;
    }

    void c2c2DFFT(float[] rein, float[] imin, int maxN, float[] reout, float[] imout) {
        FHT fht = new FHT(new FloatProcessor(maxN, maxN));
        float[] fhtpixels = (float[])fht.getPixels();
        for (int iy = 0; iy < maxN; ++iy) {
            this.cplxFHT(iy, maxN, rein, imin, false, fhtpixels);
        }
        fht.inverseTransform();
        float[] hlp = new float[maxN * maxN];
        System.arraycopy(fhtpixels, 0, hlp, 0, maxN * maxN);
        for (int iy = 0; iy < maxN; ++iy) {
            this.cplxFHT(iy, maxN, rein, imin, true, fhtpixels);
        }
        fht.inverseTransform();
        System.arraycopy(hlp, 0, reout, 0, maxN * maxN);
        System.arraycopy(fhtpixels, 0, imout, 0, maxN * maxN);
    }

    void cplxFHT(int row, int maxN, float[] re, float[] im, boolean reim, float[] fht) {
        int base = row * maxN;
        int offs = (maxN - row) % maxN * maxN;
        if (!reim) {
            for (int c = 0; c < maxN; ++c) {
                int l = offs + (maxN - c) % maxN;
                fht[base + c] = (re[base + c] + re[l] - (im[base + c] - im[l])) * 0.5f;
            }
        } else {
            for (int c = 0; c < maxN; ++c) {
                int l = offs + (maxN - c) % maxN;
                fht[base + c] = (im[base + c] + im[l] + (re[base + c] - re[l])) * 0.5f;
            }
        }
    }
}

