/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin;

import ij.IJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.gui.Plot;
import ij.io.FileInfo;
import ij.io.FileOpener;
import ij.io.OpenDialog;
import ij.measure.Calibration;
import ij.plugin.FitsDecoder;
import ij.plugin.PlugIn;
import ij.plugin.filter.Profiler;
import ij.process.FloatProcessor;
import ij.process.ImageProcessor;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import nom.tam.fits.BasicHDU;
import nom.tam.fits.Fits;
import nom.tam.fits.FitsException;
import nom.tam.fits.Header;
import nom.tam.fits.ImageData;
import skyview.data.CoordinateFormatter;
import skyview.geometry.Util;
import skyview.geometry.WCS;

public class FITS
extends ImagePlus
implements PlugIn {
    private static ResourceBundle bun = IJ.getPluginBundle();
    private WCS wcs;
    private BasicHDU[] BHDU;
    private static FITS instance = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run(String arg) {
        FileOutputStream fis = null;
        try {
            instance = this;
            this.wcs = null;
            ImagePlus imp = null;
            OpenDialog od = new OpenDialog("Open FITS...", arg);
            String directory = od.getDirectory();
            String fileName = od.getFileName();
            if (fileName == null) {
                return;
            }
            IJ.showStatus("Opening: " + directory + File.separator + fileName);
            FitsDecoder fd = new FitsDecoder(directory, fileName);
            FileInfo fi = null;
            try {
                fi = fd.getInfo();
            }
            catch (IOException e) {
                // empty catch block
            }
            Fits myFits = null;
            myFits = new Fits(directory + File.separator + fileName);
            BasicHDU[] bhdu = null;
            try {
                bhdu = myFits.read();
            }
            catch (Exception e) {
                // empty catch block
            }
            try {
                int dim = bhdu[0].getAxes().length;
                System.out.println("Dim= " + dim + "  -- Height= " + fi.height + " pixels -- Width= " + fi.width + " pixels");
                int wi = 0;
                int he = 0;
                if (dim < 2) {
                    wi = fi.width;
                    he = fi.height;
                } else {
                    wi = bhdu[0].getAxes()[dim - 1];
                    he = bhdu[0].getAxes()[dim - 2];
                }
                int bit = bhdu[0].getBitPix();
                Header H = bhdu[0].getHeader();
                String s = new String("");
                if (bhdu[0].getObject() != null) {
                    s = s + IJ.getBundle().getString("OBJECT") + ": " + bhdu[0].getObject() + "\n";
                }
                if (bhdu[0].getTelescop() != null) {
                    s = s + IJ.getBundle().getString("TELESCOP") + ": " + bhdu[0].getTelescop() + "\n";
                }
                if (bhdu[0].getInstrum() != null) {
                    s = s + IJ.getBundle().getString("INSTRUM") + ": " + bhdu[0].getInstrum() + "\n";
                }
                if (bhdu[0].getFilter() != null) {
                    s = s + IJ.getBundle().getString("FILTER") + ": " + bhdu[0].getFilter() + "\n";
                }
                if (bhdu[0].getObserver() != null) {
                    s = s + IJ.getBundle().getString("OBSERVER") + ": " + bhdu[0].getObserver() + "\n";
                }
                if (bhdu[0].getExptime() != null) {
                    s = s + IJ.getBundle().getString("EXPTIME") + ": " + bhdu[0].getExptime() + "\n";
                }
                if (bhdu[0].getDateObs() != null) {
                    s = s + IJ.getBundle().getString("DATE-OBS") + ": " + bhdu[0].getDateObs() + "\n";
                }
                if (bhdu[0].getUT() != null) {
                    s = s + IJ.getBundle().getString("UT") + ": " + bhdu[0].getUT() + "\n";
                }
                if (bhdu[0].getUTC() != null) {
                    s = s + IJ.getBundle().getString("UT") + ": " + bhdu[0].getUTC() + "\n";
                }
                if (bhdu[0].getRA() != null) {
                    s = s + IJ.getBundle().getString("RA") + ": " + bhdu[0].getRA() + "\n";
                }
                if (bhdu[0].getDEC() != null) {
                    s = s + IJ.getBundle().getString("DEC") + ": " + bhdu[0].getDEC() + "\n";
                }
                s = s + "\n\n*************************************************************\n";
                System.out.println("Header: \n" + s);
                ImageData imgData = null;
                if (bhdu[0].getData() != null) {
                    imgData = (ImageData)bhdu[0].getData();
                }
                if (fi != null && fi.width > 0 && fi.height > 0 && fi.offset > 0) {
                    FileOpener fo = new FileOpener(fi);
                    imp = fo.open(false);
                    if (fi.nImages == 1) {
                        String unitX;
                        float[] xValues;
                        ImageProcessor ip = null;
                        if (bhdu[0].getNAXIS() == 2) {
                            float[] imgtab;
                            FloatProcessor imgtmp;
                            int idx;
                            Object itab;
                            Profiler p = new Profiler();
                            if (bhdu[0].getBitPix() == 16) {
                                itab = (short[][])imgData.getKernel();
                                idx = 0;
                                imgtmp = new FloatProcessor(wi, he);
                                imgtab = new float[wi * he];
                                for (int y = 0; y < he; ++y) {
                                    for (int x = 0; x < wi; ++x) {
                                        imgtab[idx] = (float)bhdu[0].getBZero() + (float)bhdu[0].getBScale() * (float)itab[y][x];
                                        ++idx;
                                    }
                                }
                                imgtmp.setPixels(imgtab);
                                imgtmp.resetMinAndMax();
                                if (he == 1) {
                                    imgtmp = (FloatProcessor)imgtmp.resize(wi, 100);
                                }
                                if (wi == 1) {
                                    imgtmp = (FloatProcessor)imgtmp.resize(100, he);
                                }
                                ip = imgtmp;
                            } else if (bhdu[0].getBitPix() == 32) {
                                itab = (int[][])imgData.getKernel();
                                idx = 0;
                                imgtmp = new FloatProcessor(wi, he);
                                imgtab = new float[wi * he];
                                for (int y = 0; y < he; ++y) {
                                    for (int x = 0; x < wi; ++x) {
                                        imgtab[idx] = (float)bhdu[0].getBZero() + (float)bhdu[0].getBScale() * (float)itab[y][x];
                                        ++idx;
                                    }
                                }
                                imgtmp.setPixels(imgtab);
                                imgtmp.resetMinAndMax();
                                if (he == 1) {
                                    imgtmp = (FloatProcessor)imgtmp.resize(wi, 100);
                                }
                                if (wi == 1) {
                                    imgtmp = (FloatProcessor)imgtmp.resize(100, he);
                                }
                                ip = imgtmp;
                            } else if (bhdu[0].getBitPix() == -32) {
                                itab = (float[][])imgData.getKernel();
                                idx = 0;
                                imgtmp = new FloatProcessor(wi, he);
                                imgtab = new float[wi * he];
                                for (int y = 0; y < he; ++y) {
                                    for (int x = 0; x < wi; ++x) {
                                        imgtab[idx] = (float)bhdu[0].getBZero() + (float)bhdu[0].getBScale() * itab[y][x];
                                        ++idx;
                                    }
                                }
                                imgtmp.setPixels(imgtab);
                                imgtmp.resetMinAndMax();
                                if (he == 1) {
                                    imgtmp = (FloatProcessor)imgtmp.resize(wi, 100);
                                }
                                if (wi == 1) {
                                    imgtmp = (FloatProcessor)imgtmp.resize(100, he);
                                }
                                ip = imgtmp;
                                if (bhdu[0].getSTATUS().equals("SPECTRUM") && bhdu[0].getNAXIS() == 2) {
                                    System.out.println("spectre optique");
                                    float[] xValues2 = new float[wi];
                                    float[] yValues = new float[wi];
                                    for (int y = 0; y < wi; ++y) {
                                        yValues[y] = itab[0][y];
                                        if (!(yValues[y] < 0.0f)) continue;
                                        yValues[y] = 0.0f;
                                    }
                                    String unitY = "Intensity ";
                                    unitY = bun.getString("IntensityRS") + " ";
                                    String unitX2 = "Longueur d'onde ";
                                    unitX2 = bun.getString("WavelengthRS") + " ";
                                    float CRVAL1 = 0.0f;
                                    float CRPIX1 = 0.0f;
                                    float CDELT1 = 0.0f;
                                    if (bhdu[0].getCRVAL1() != null) {
                                        CRVAL1 = Float.parseFloat(bhdu[0].getCRVAL1());
                                    }
                                    if (bhdu[0].getCRPIX1() != null) {
                                        CRPIX1 = Float.parseFloat(bhdu[0].getCRPIX1());
                                    }
                                    if (bhdu[0].getCDELT1() != null) {
                                        CDELT1 = Float.parseFloat(bhdu[0].getCDELT1());
                                    }
                                    for (int x = 0; x < wi; ++x) {
                                        xValues2[x] = CRVAL1 + ((float)x - CRPIX1) * CDELT1;
                                    }
                                    float odiv = 1.0f;
                                    if ((double)CRVAL1 < 1.0E-6) {
                                        odiv = 1000000.0f;
                                        unitX2 = unitX2 + "(\u00b5m)";
                                    } else {
                                        unitX2 = unitX2 + "ADU";
                                    }
                                    for (int x = 0; x < wi; ++x) {
                                        xValues2[x] = xValues2[x] * odiv;
                                    }
                                    Plot P = new Plot(IJ.getBundle().getString("PlotWinTitle") + " " + fileName, "X: " + unitX2, "Y: " + unitY, xValues2, yValues);
                                    P.show();
                                }
                            } else {
                                ip = imp.getProcessor();
                            }
                            ip.flipVertical();
                            this.setProcessor(fileName, ip);
                        } else if (bhdu[0].getNAXIS() == 3 && bhdu[0].getAxes()[dim - 2] == 1 && bhdu[0].getAxes()[dim - 3] == 1) {
                            System.out.println("Spectre radio Onsala");
                            short[][][] itab = (short[][][])imgData.getKernel();
                            xValues = new float[wi];
                            float[] yValues = new float[wi];
                            for (int y = 0; y < wi; ++y) {
                                yValues[y] = (float)bhdu[0].getBZero() + (float)bhdu[0].getBScale() * (float)itab[0][0][y];
                            }
                            String unitY = "Intensity ";
                            unitY = bun.getString("IntensityRS") + " ";
                            unitX = "Freq ";
                            unitX = bun.getString("FrequencyRS") + " ";
                            float CRVAL1 = 0.0f;
                            float CRPIX1 = 0.0f;
                            float CDELT1 = 0.0f;
                            if (bhdu[0].getCRVAL1() != null) {
                                CRVAL1 = Float.parseFloat(bhdu[0].getCRVAL1());
                            }
                            if (bhdu[0].getCRPIX1() != null) {
                                CRPIX1 = Float.parseFloat(bhdu[0].getCRPIX1());
                            }
                            if (bhdu[0].getCDELT1() != null) {
                                CDELT1 = Float.parseFloat(bhdu[0].getCDELT1());
                            }
                            for (int x = 0; x < wi; ++x) {
                                xValues[x] = CRVAL1 + ((float)x - CRPIX1) * CDELT1;
                            }
                            int div = 1;
                            if (CRVAL1 > 2.0E9f) {
                                div = 1000000000;
                                unitX = unitX + "(Ghz)";
                            } else if (CRVAL1 > 1.0E9f) {
                                div = 1000000;
                                unitX = unitX + "(Mhz)";
                            } else if (CRVAL1 > 1000000.0f) {
                                div = 1000;
                                unitX = unitX + "(Khz)";
                            } else {
                                unitX = unitX + "(Hz)";
                            }
                            for (int x = 0; x < wi; ++x) {
                                xValues[x] = xValues[x] / (float)div;
                            }
                            Plot P = new Plot(IJ.getBundle().getString("PlotWinTitle") + " " + fileName, "X: " + unitX, "Y: " + unitY, xValues, yValues);
                            P.show();
                            FloatProcessor imgtmp = new FloatProcessor(wi, he);
                            imgtmp.setPixels(yValues);
                            imgtmp.resetMinAndMax();
                            if (he == 1) {
                                imgtmp = (FloatProcessor)imgtmp.resize(wi, 100);
                            }
                            if (wi == 1) {
                                imgtmp = (FloatProcessor)imgtmp.resize(100, he);
                            }
                            ip = imgtmp;
                            ip.flipVertical();
                            this.setProcessor(fileName, ip);
                        }
                        if (bhdu[0].getTelescop() != null && bhdu[0].getTelescop().equals("SRT-PARIS")) {
                            System.out.println("For radiotelescope UPMC/OBSPM spectra");
                            short[] Upmcitab = (short[])imgData.getKernel();
                            xValues = new float[wi];
                            float[] yValues = new float[wi];
                            for (int y = 0; y < wi; ++y) {
                                yValues[y] = Upmcitab[y];
                            }
                            String unitY = "Intensity ";
                            unitY = bun.getString("IntensityRS") + " ";
                            unitX = "Freq ";
                            unitX = bun.getString("FrequencyRS") + " ";
                            float CRVAL1 = 0.0f;
                            float CRPIX1 = 0.0f;
                            float CDELT1 = 0.0f;
                            if (bhdu[0].getCRVAL1() != null) {
                                CRVAL1 = Float.parseFloat(bhdu[0].getCRVAL1());
                            }
                            if (bhdu[0].getCRPIX1() != null) {
                                CRPIX1 = Float.parseFloat(bhdu[0].getCRPIX1());
                            }
                            if (bhdu[0].getCDELT1() != null) {
                                CDELT1 = Float.parseFloat(bhdu[0].getCDELT1());
                            }
                            for (int x = 0; x < wi; ++x) {
                                xValues[x] = (CRVAL1 + ((float)x - CRPIX1) * CDELT1) / 1000000.0f;
                            }
                            FloatProcessor Upmcimgtmp = new FloatProcessor(wi, he);
                            Upmcimgtmp.setPixels(yValues);
                            Upmcimgtmp.resetMinAndMax();
                            Upmcimgtmp = (FloatProcessor)Upmcimgtmp.resize(wi, 100);
                            ip = Upmcimgtmp;
                            ip.flipVertical();
                            this.setProcessor(fileName, ip);
                            double OliFrqMin = 1419.9;
                            double OliFrqMax = 1420.9;
                            System.out.println(OliFrqMin + "  " + OliFrqMax);
                            int x = 1;
                            while ((double)xValues[x] < OliFrqMin) {
                                ++x;
                            }
                            float Olicut = yValues[x];
                            System.out.println("X= " + x + "  X(x)= " + xValues[x] + " Y(x)= " + Olicut);
                            while ((double)xValues[x] < OliFrqMax) {
                                ++x;
                            }
                            System.out.println("X= " + x + " X(x)= " + xValues[x] + " Y(x)= " + yValues[x - 1]);
                            Olicut = (Olicut + yValues[x - 1]) / 2.0f;
                            for (int y = 0; y < wi; ++y) {
                                if (!(yValues[y] < Olicut)) continue;
                                yValues[y] = Olicut;
                            }
                            unitX = unitX + "(MHz)";
                            Plot P = new Plot(IJ.getBundle().getString("PlotWinTitle") + " " + fileName, "X: " + unitX, "Y: " + unitY, xValues, yValues);
                            P.show();
                        }
                        if (ip == null) {
                            ip = imp.getProcessor();
                            ip.flipVertical();
                            this.setProcessor(fileName, ip);
                        }
                    } else {
                        ImageStack stack = imp.getStack();
                        for (int i = 1; i <= stack.getSize(); ++i) {
                            stack.getProcessor(i).flipVertical();
                        }
                        this.setStack(fileName, stack);
                    }
                    Calibration cal = imp.getCalibration();
                    this.setProperty("Info", s + fd.getHeaderInfo());
                    this.setFileInfo(fi);
                    if (arg.equals("")) {
                        this.show();
                    }
                } else {
                    IJ.error("This does not appear to be a FITS file.");
                }
                IJ.showStatus("");
                File file = new File("tmp.fits");
                fis = new FileOutputStream(file);
                DataOutputStream dos = new DataOutputStream(fis);
                myFits.write(dos);
                try {
                    this.wcs = new WCS(H);
                    System.out.println("Reading the Wcs");
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            catch (FileNotFoundException ex) {
                Logger.getLogger(FITS.class.getName()).log(Level.SEVERE, null, ex);
            }
            catch (FitsException ex) {
                Logger.getLogger(FITS.class.getName()).log(Level.SEVERE, null, ex);
            }
            finally {
                try {
                    fis.close();
                }
                catch (IOException ex) {
                    Logger.getLogger(FITS.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
        }
        catch (Exception e) {
            System.out.println("This is the exception case");
            OpenDialog od = new OpenDialog("Open FITS...", arg);
            String directory = od.getDirectory();
            String fileName = od.getFileName();
            if (fileName == null) {
                return;
            }
            IJ.showStatus("Opening: " + directory + fileName);
            FitsDecoder fd = new FitsDecoder(directory, fileName);
            FileInfo fi = null;
            try {
                fi = fd.getInfo();
            }
            catch (IOException er) {
                // empty catch block
            }
            if (fi != null && fi.width > 0 && fi.height > 0 && fi.offset > 0) {
                FileOpener fo = new FileOpener(fi);
                ImagePlus imp = fo.open(false);
                if (fi.nImages == 1) {
                    ImageProcessor ip = imp.getProcessor();
                    ip.flipVertical();
                    this.setProcessor(fileName, ip);
                } else {
                    ImageStack stack = imp.getStack();
                    for (int i = 1; i <= stack.getSize(); ++i) {
                        stack.getProcessor(i).flipVertical();
                    }
                    this.setStack(fileName, stack);
                }
                Calibration cal = imp.getCalibration();
                if (fi.fileType == 1 && fd.getBscale() == 1.0 && fd.getBzero() == 32768.0) {
                    cal.setFunction(20, null, "Gray Value");
                }
                System.out.println("File Type= " + fi.fileType);
                System.out.println("fd.getBscale() " + fd.getBscale());
                System.out.println("fd.getBzero() " + fd.getBzero());
                if (fi.fileType == 1 && fd.getBscale() == 1.0 && fd.getBzero() == 0.0) {
                    cal.setFunction(20, null, "Gray Value");
                }
                this.setCalibration(cal);
                this.setProperty("Info", fd.getHeaderInfo());
                System.out.println(fd.getHeaderInfo());
                try {
                    BasicHDU[] bhduExc = null;
                    Fits myFits = null;
                    myFits = new Fits(directory + File.separator + fileName);
                    bhduExc = myFits.read();
                    Header HH = bhduExc[0].getHeader();
                    this.wcs = new WCS(HH);
                    System.out.println("Reading the Wcs in the exception");
                    String s = new String("");
                    if (bhduExc[0].getObject() != null) {
                        s = s + IJ.getBundle().getString("OBJECT") + ": " + bhduExc[0].getObject() + "\n";
                    }
                    if (bhduExc[0].getTelescop() != null) {
                        s = s + IJ.getBundle().getString("TELESCOP") + ": " + bhduExc[0].getTelescop() + "\n";
                    }
                    if (bhduExc[0].getInstrum() != null) {
                        s = s + IJ.getBundle().getString("INSTRUM") + ": " + bhduExc[0].getInstrum() + "\n";
                    }
                    if (bhduExc[0].getFilter() != null) {
                        s = s + IJ.getBundle().getString("FILTER") + ": " + bhduExc[0].getFilter() + "\n";
                    }
                    if (bhduExc[0].getObserver() != null) {
                        s = s + IJ.getBundle().getString("OBSERVER") + ": " + bhduExc[0].getObserver() + "\n";
                    }
                    if (bhduExc[0].getExptime() != null) {
                        s = s + IJ.getBundle().getString("EXPTIME") + ": " + bhduExc[0].getExptime() + "\n";
                    }
                    if (bhduExc[0].getDateObs() != null) {
                        s = s + IJ.getBundle().getString("DATE-OBS") + ": " + bhduExc[0].getDateObs() + "\n";
                    }
                    if (bhduExc[0].getUT() != null) {
                        s = s + IJ.getBundle().getString("UT") + ": " + bhduExc[0].getUT() + "\n";
                    }
                    if (bhduExc[0].getUTC() != null) {
                        s = s + IJ.getBundle().getString("UT") + ": " + bhduExc[0].getUTC() + "\n";
                    }
                    if (bhduExc[0].getRA() != null) {
                        s = s + IJ.getBundle().getString("RA") + ": " + bhduExc[0].getRA() + "\n";
                    }
                    if (bhduExc[0].getDEC() != null) {
                        s = s + IJ.getBundle().getString("DEC") + ": " + bhduExc[0].getDEC() + "\n";
                    }
                    s = s + "\n\n*************************************************************\n";
                    this.setProperty("Info", s + fd.getHeaderInfo());
                }
                catch (Exception ee) {
                    // empty catch block
                }
                this.setFileInfo(fi);
                if (arg.equals("")) {
                    this.show();
                }
            } else {
                IJ.error("This does not appear to be a FITS file.");
            }
            IJ.showStatus("");
        }
    }

    public static String getkeyword(String keyword, String path) throws IOException {
        ImagePlus imp = null;
        imp = new ImagePlus(path);
        FileInfo fi = imp.getFileInfo();
        ImageProcessor ip = imp.getProcessor();
        File file = new File(path);
        RandomAccessFile f = new RandomAccessFile(file, "r");
        f.seek(0L);
        String s = FITS.getString(80, f);
        while (!s.startsWith("END")) {
            if (s.startsWith(keyword)) {
                f.close();
                return s;
            }
            s = FITS.getString(80, f);
        }
        f.close();
        s = "";
        return s;
    }

    @Override
    public String getLocationAsString(int x, int y) {
        String s;
        if (this.wcs != null) {
            double[] in = new double[]{x, (double)(this.getProcessor().getHeight() - y) - 1.0};
            double[] out = this.wcs.inverse().transform(in);
            double[] coord = new double[2];
            Util.coord(out, coord);
            CoordinateFormatter cf = new CoordinateFormatter();
            String[] ra = cf.sexagesimal(Math.toDegrees(coord[0]) / 15.0, 8).split(" ");
            String[] dec = cf.sexagesimal(Math.toDegrees(coord[1]), 8).split(" ");
            s = "x=" + x + ",y=" + y + " (RA=" + ra[0] + "h" + ra[1] + "m" + ra[2] + "s,  DEC=" + dec[0] + "\u00b0 " + dec[1] + "' " + dec[2] + "\"" + ")";
        } else {
            s = "x=" + x + " y=" + y;
        }
        if (this.getStackSize() > 1) {
            s = s + " z=" + (this.getCurrentSlice() - 1);
        }
        return s;
    }

    static String getString(int length, RandomAccessFile f) throws IOException {
        byte[] b = new byte[length];
        f.read(b);
        return new String(b);
    }

    public BasicHDU[] getBHDU() {
        return this.BHDU;
    }

    public static FITS getInstance() {
        return instance;
    }
}

