/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin;

import ij.IJ;
import ij.ImagePlus;
import ij.WindowManager;
import ij.gui.GenericDialog;
import ij.gui.NewImage;
import ij.gui.Roi;
import ij.measure.Calibration;
import ij.plugin.PlugIn;
import ij.plugin.jRenderer3D.JRenderer3D;
import ij.plugin.jRenderer3D.Line3D;
import ij.plugin.jRenderer3D.Text3D;
import ij.process.ImageProcessor;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.awt.image.ConvolveOp;
import java.awt.image.Kernel;
import java.awt.image.MemoryImageSource;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class Interactive_3D_Surface_Plot
implements PlugIn,
MouseListener,
MouseMotionListener,
ItemListener {
    private final String version = " v2.22 ";
    private final String DOTS = "Dots";
    private final String LINES = "Lines";
    private final String MESH = "Mesh";
    private final String ISOLINES = "Isolines";
    private final String FILLED = "Filled";
    protected String plotType = "Lines";
    private final String ORIGINAL = "Original Colors";
    private final String GRAYSCALE = "Grayscale";
    private final String SPECTRUM = "Spectrum LUT";
    private final String FIRE = "Fire LUT";
    private final String THERMAL = "Thermal LUT";
    private final String GRADIENT = "Gradient";
    private final String ORANGE = "Orange";
    private final String BLUE = "Blue";
    private String colorType = "Original Colors";
    private JFrame frame;
    private JPanel mainPanel;
    private JPanel settingsPanel1;
    private JPanel settingsPanel2;
    private JComboBox comboDisplayType;
    private JComboBox comboDisplayColors;
    private JSlider sliderLight;
    private JSlider sliderGridSize;
    private JSlider sliderSmoothing;
    private JSlider sliderScale;
    private JSlider sliderZRatio;
    private JSlider sliderPerspective;
    private JSlider sliderMin;
    private JSlider sliderMax;
    private JCheckBox checkInverse;
    private JCheckBox checkAxes;
    private JCheckBox checkText;
    private JCheckBox checkLines;
    private JCheckBox checkAuto;
    private ImageRegion imageRegion;
    private ImagePlus image;
    private JRenderer3D jRenderer3D;
    static final int SIZE = 600;
    private int startWindowWidth = 600;
    private int startWindowHeight = 600;
    private int windowWidth = 600;
    private int windowHeight = 600;
    private double scaleWindow = 1.0;
    private int xStart;
    private int yStart;
    private boolean drag;
    private int xdiff;
    private int ydiff;
    private double light = 0.2;
    private double smoothOld = 0.0;
    private boolean invertZ = false;
    private boolean isExamplePlot = false;
    private int imageWidth;
    private int imageHeight;
    private double scaleInit = 1.0;
    private double zRatioInit = 1.0;
    private double scaledWidth;
    private double scaledHeight;
    private double minVal;
    private double maxVal;
    private String units;
    private double maxDistance;
    private Calibration cal;
    private boolean isEqualxyzRatio = false;
    private double zAspectRatioSlider = 1.0;
    private double zAspectRatio = 1.0;
    private int maxS = 100;
    private int minS = 0;

    public static void main(String[] args) {
        Interactive_3D_Surface_Plot sp = new Interactive_3D_Surface_Plot();
        sp.generateSampleImage();
        sp.runApplication("Example Plot");
    }

    private void generateSampleImage() {
        this.imageWidth = 256;
        this.imageHeight = 256;
        int[] pixels = new int[this.imageWidth * this.imageHeight];
        for (int y = 0; y < this.imageHeight; ++y) {
            int dy1 = y - 80;
            int dy2 = y - 60;
            for (int x = 0; x < this.imageWidth; ++x) {
                int dx1 = x - 90;
                int dx2 = x - 180;
                double r1 = Math.sqrt(dx1 * dx1 + dy1 * dy1) / 60.0;
                double r2 = Math.sqrt(dx2 * dx2 + dy2 * dy2) / 100.0;
                int v1 = (int)(255.0 * Math.exp(-r2 * r2));
                int v2 = (int)(255.0 * Math.exp(-r1 * r1));
                pixels[y * this.imageWidth + x] = 0xFF000000 | v2 + v1 << 16 | v2 << 8 | y / 4;
            }
        }
        MemoryImageSource source = new MemoryImageSource(this.imageWidth, this.imageHeight, pixels, 0, this.imageWidth);
        Image awtImage = Toolkit.getDefaultToolkit().createImage(source);
        BufferedImage bufferedImage = new BufferedImage(this.imageWidth, this.imageHeight, 1);
        Graphics2D g2D = bufferedImage.createGraphics();
        g2D.drawImage(awtImage, 0, 0, null);
        float ninth = 0.11111111f;
        float[] blurKernel = new float[]{ninth, ninth, ninth, ninth, ninth, ninth, ninth, ninth, ninth};
        ConvolveOp op = new ConvolveOp(new Kernel(3, 3, blurKernel));
        bufferedImage = op.filter(bufferedImage, null);
        bufferedImage = op.filter(bufferedImage, null);
        g2D = bufferedImage.createGraphics();
        g2D.setColor(new Color(0x3300FF));
        Font font = new Font("Sans", 1, 60);
        g2D.setFont(font);
        g2D.drawString("ImageJ", 20, 220);
        bufferedImage = op.filter(bufferedImage, null);
        bufferedImage = op.filter(bufferedImage, null);
        g2D.dispose();
        this.image = new ImagePlus("Example Plot", (Image)bufferedImage);
        this.isExamplePlot = true;
    }

    @Override
    public void run(String arg) {
        if (IJ.versionLessThan("1.36b")) {
            return;
        }
        this.image = WindowManager.getCurrentImage();
        if (this.image != null) {
            Roi roi = this.image.getRoi();
            if (roi != null) {
                Rectangle rect = roi.getBoundingRect();
                if (rect.x < 0) {
                    rect.x = 0;
                }
                if (rect.y < 0) {
                    rect.y = 0;
                }
                this.imageWidth = rect.width;
                this.imageHeight = rect.height;
                if (this.imageWidth == 0 || this.imageHeight == 0) {
                    this.image.killRoi();
                    this.imageWidth = this.image.getWidth();
                    this.imageHeight = this.image.getHeight();
                }
            } else {
                this.imageWidth = this.image.getWidth();
                this.imageHeight = this.image.getHeight();
            }
        } else {
            this.generateSampleImage();
        }
        this.runApplication(this.image.getTitle());
    }

    private void runApplication(String name) {
        String str = "Interactive 3D Surface Plot v2.22  (" + name + ")";
        this.frame = new JFrame(str);
        this.createGUI();
        this.create3DRenderer();
        this.frame.pack();
    }

    private void create3DRenderer() {
        int gridWidth;
        int gridHeight;
        double wc = (double)this.imageWidth / 2.0;
        double hc = (double)this.imageHeight / 2.0;
        double dc = 128.0;
        this.cal = this.image.getCalibration();
        ImageProcessor ip = this.image.getProcessor();
        this.scaledWidth = this.cal.getX(this.imageWidth);
        this.scaledHeight = this.cal.getY(this.imageHeight);
        this.minVal = ip.getMin();
        this.maxVal = ip.getMax();
        this.units = this.cal.getUnits();
        this.jRenderer3D = new JRenderer3D(wc, hc, dc);
        this.jRenderer3D.setBufferSize(this.startWindowWidth, this.startWindowHeight);
        this.setScaleAndZRatio();
        int grid = 128;
        if (this.imageHeight > this.imageWidth) {
            gridHeight = grid;
            gridWidth = grid * this.imageWidth / this.imageHeight;
        } else {
            gridWidth = grid;
            gridHeight = grid * this.imageHeight / this.imageWidth;
        }
        this.jRenderer3D.setSurfacePlotGridSize(gridWidth, gridHeight);
        this.jRenderer3D.setSurfacePlot(this.image);
        if (this.isExamplePlot) {
            this.colorType = "Gradient";
            this.jRenderer3D.setSurfacePlotLut(58);
            this.plotType = "Filled";
            this.jRenderer3D.setSurfacePlotMode(14);
            this.jRenderer3D.setTransformRotationXYZ(60.0, 0.0, -20.0);
        } else {
            this.colorType = "Original Colors";
            this.jRenderer3D.setSurfacePlotLut(50);
            this.plotType = "Lines";
            this.jRenderer3D.setSurfacePlotMode(12);
            this.jRenderer3D.setTransformRotationXYZ(65.0, 0.0, 39.0);
        }
        double smooth = (double)this.sliderSmoothing.getValue() * ((double)grid / 512.0);
        this.jRenderer3D.setSurfaceSmoothingFactor(smooth);
        this.jRenderer3D.setSurfacePlotLight((double)this.sliderLight.getValue() / 100.0);
        this.renderAndUpdateDisplay();
    }

    private void setScaleAndZRatio() {
        if (this.isEqualxyzRatio) {
            this.zRatioInit = (this.maxVal - this.minVal) / (255.0 * this.scaledWidth / (double)this.imageWidth);
            this.scaleInit = 0.55 * (double)Math.max(this.startWindowHeight, this.startWindowWidth) / Math.max((double)this.imageWidth, Math.max(255.0 * this.zRatioInit, (double)this.imageHeight));
        } else {
            this.scaleInit = 0.55 * (double)Math.max(this.startWindowHeight, this.startWindowWidth) / (double)Math.max(this.imageHeight, this.imageWidth);
            this.zRatioInit = 0.55 * (double)this.startWindowHeight / (256.0 * this.scaleInit);
        }
        this.zAspectRatio = this.zRatioInit * this.zAspectRatioSlider;
        this.scaleWindow = (double)Math.min(this.windowHeight, this.windowWidth) / (double)this.startWindowHeight;
        this.jRenderer3D.setTransformZAspectRatio(this.zAspectRatio);
        double scaleSlider = (double)this.sliderScale.getValue() / 100.0;
        double scale = this.scaleInit * scaleSlider * this.scaleWindow;
        this.jRenderer3D.setTransformScale(scale);
        this.jRenderer3D.setTransformPerspective((double)this.sliderPerspective.getValue() / 100.0);
        this.maxDistance = Math.max(this.scaledWidth, Math.max(this.scaledHeight, 256.0 * Math.max(this.zAspectRatio, 1.0)));
        this.jRenderer3D.setTransformMaxDistance(this.maxDistance);
        this.addCoordinateSystem();
    }

    private void addCoordinateSystem() {
        String s;
        double value;
        this.jRenderer3D.clearText();
        this.jRenderer3D.clearLines();
        this.jRenderer3D.clearCubes();
        int id = 256;
        double min = this.minVal + (double)this.minS / 100.0 * (this.maxVal - this.minVal);
        double max = this.maxVal - (100.0 - (double)this.maxS) / 100.0 * (this.maxVal - this.minVal);
        double off = 12.0 / this.scaleInit;
        double fontSize = 10.0 / this.scaleInit;
        double offZ = off / this.zAspectRatio;
        int ticksDist = 40;
        Color textColor = Color.white;
        Color lineColor = new Color(90, 90, 100);
        double x1 = 0.0;
        double y1 = 0.0;
        double z1 = 0.0;
        double x2 = this.imageWidth;
        double y2 = this.imageHeight;
        double z2 = id;
        int numTicks = (int)Math.round((double)this.imageHeight * this.scaleInit / (double)ticksDist);
        double pos = 0.0;
        double stepValue = this.calcStepSize(this.scaledHeight, numTicks);
        for (value = 0.0; value <= this.scaledHeight; value += stepValue) {
            s = Math.floor(value) - value == 0.0 ? "" + (int)value : "" + (double)((int)Math.round(value * 1000.0)) / 1000.0;
            if (value + stepValue > this.scaledHeight || value == this.scaledHeight) {
                s = !this.units.equals("pixels") ? "y/" + this.units : "y";
            }
            y1 = y2 = (pos = value * (double)this.imageHeight / this.scaledHeight);
            this.jRenderer3D.addText3D(new Text3D(s, x1 - off, y1, z1 - offZ, textColor, fontSize, 2));
            this.jRenderer3D.addText3D(new Text3D(s, x2 + off, y2, z1 - offZ, textColor, fontSize));
            this.jRenderer3D.addLine3D(new Line3D(x1, y1, z1, x1, y1, z2, lineColor, true));
            this.jRenderer3D.addLine3D(new Line3D(x2, y2, z1, x2, y2, z2, lineColor));
            this.jRenderer3D.addLine3D(new Line3D(x1, y1, z1, x2, y2, z1, lineColor, true));
            this.jRenderer3D.addLine3D(new Line3D(x1, y1, z2, x2, y2, z2, lineColor));
        }
        numTicks = (int)Math.round((double)this.imageWidth * this.scaleInit / (double)ticksDist);
        stepValue = this.calcStepSize(this.scaledWidth, numTicks);
        y1 = 0.0;
        y2 = this.imageHeight;
        for (value = 0.0; value <= this.scaledWidth; value += stepValue) {
            s = Math.floor(value) - value == 0.0 ? "" + (int)value : "" + (double)((int)Math.round(value * 1000.0)) / 1000.0;
            if (value + stepValue > this.scaledWidth || value == this.scaledWidth) {
                s = !this.units.equals("pixels") ? "x/" + this.units : "x";
            }
            x1 = x2 = (pos = value * (double)this.imageWidth / this.scaledWidth);
            this.jRenderer3D.addText3D(new Text3D(s, x1, y1 - off, z1 - offZ, textColor, fontSize, 2));
            this.jRenderer3D.addText3D(new Text3D(s, x2, y2 + off, z1 - offZ, textColor, fontSize));
            this.jRenderer3D.addLine3D(new Line3D(x1, y1, z1, x1, y1, z2, lineColor, true));
            this.jRenderer3D.addLine3D(new Line3D(x2, y2, z1, x2, y2, z2, lineColor));
            this.jRenderer3D.addLine3D(new Line3D(x1, y1, z1, x2, y2, z1, lineColor, true));
            this.jRenderer3D.addLine3D(new Line3D(x1, y1, z2, x2, y2, z2, lineColor));
        }
        double d = max - min;
        numTicks = (int)Math.round(255.0 * this.zAspectRatio * this.scaleInit / ((double)ticksDist / 1.3));
        stepValue = this.calcStepSize(d, numTicks);
        x1 = 0.0;
        y1 = 0.0;
        x2 = this.imageWidth;
        y2 = this.imageHeight;
        double minStart = Math.floor(min / stepValue) * stepValue;
        double delta = minStart - min;
        double value2 = 0.0;
        while (value2 + delta <= d) {
            String s2 = Math.floor(minStart + value2) - (minStart + value2) == 0.0 ? "" + (int)(minStart + value2) : "" + (double)((int)Math.round((minStart + value2) * 1000.0)) / 1000.0;
            pos = (value2 + delta) * (double)id / d;
            if (pos >= 0.0) {
                z1 = z2 = pos;
                if (this.invertZ) {
                    z1 = z2 = 255.0 - pos;
                }
                this.jRenderer3D.addText3D(new Text3D(s2, x1 - off, y1 - off, z1, textColor, fontSize, 4));
                this.jRenderer3D.addText3D(new Text3D(s2, x2 + off, y2 + off, z2, textColor, fontSize));
                this.jRenderer3D.addText3D(new Text3D(s2, x1 - off, y2 + off, z1, textColor, fontSize));
                this.jRenderer3D.addText3D(new Text3D(s2, x2 + off, y1 - off, z2, textColor, fontSize));
                this.jRenderer3D.addLine3D(new Line3D(x1, y1, z1, x1, y2, z2, lineColor, true));
                this.jRenderer3D.addLine3D(new Line3D(x2, y1, z1, x2, y2, z2, lineColor));
                this.jRenderer3D.addLine3D(new Line3D(x1, y1, z1, x2, y1, z2, lineColor, true));
                this.jRenderer3D.addLine3D(new Line3D(x1, y2, z1, x2, y2, z2, lineColor));
            }
            value2 += stepValue;
        }
        this.jRenderer3D.add3DCube(0, 0, 0, this.imageWidth, this.imageHeight, id, Color.white);
    }

    double calcStepSize(double range, double targetSteps) {
        double tempStep = range / targetSteps;
        double mag = Math.floor(Math.log(tempStep) / Math.log(10.0));
        double magPow = Math.pow(10.0, mag);
        double magMsd = (int)(tempStep / magPow + 0.5);
        if (magMsd > 6.0) {
            magMsd = 10.0;
        } else if (magMsd > 3.0) {
            magMsd = 5.0;
        } else if (magMsd > 2.0) {
            magMsd = 4.0;
        } else if (magMsd > 1.0) {
            magMsd = 2.0;
        }
        return magMsd * magPow;
    }

    private void renderAndUpdateDisplay() {
        this.jRenderer3D.doRendering();
        this.imageRegion.setImage(this.jRenderer3D);
        this.imageRegion.repaint();
    }

    @Override
    public void mouseClicked(MouseEvent arg0) {
        Object source = arg0.getSource();
        if (source == this.imageRegion) {
            if (arg0.getClickCount() == 2) {
                this.jRenderer3D.setTransformRotationXYZ(0.0, 0.0, 0.0);
                this.renderAndUpdateDisplay();
            } else if (arg0.getClickCount() >= 3) {
                this.jRenderer3D.setTransformRotationXYZ(90.0, 0.0, 0.0);
                this.renderAndUpdateDisplay();
            }
        }
    }

    @Override
    public void mouseMoved(MouseEvent arg0) {
    }

    @Override
    public void mousePressed(MouseEvent arg0) {
        Object source = arg0.getSource();
        if (source == this.imageRegion) {
            this.xStart = arg0.getX();
            this.yStart = arg0.getY();
            this.xdiff = 0;
            this.ydiff = 0;
            this.drag = true;
            this.renderAndUpdateDisplay();
        }
    }

    @Override
    public void mouseReleased(MouseEvent arg0) {
        this.drag = false;
        this.setPlotType(this.plotType);
        this.setColorType(this.colorType);
        this.jRenderer3D.setSurfacePlotLight(this.light);
        this.renderAndUpdateDisplay();
    }

    @Override
    public void mouseDragged(MouseEvent arg0) {
        Object source = arg0.getSource();
        if (source == this.imageRegion && this.drag) {
            this.jRenderer3D.setSurfacePlotMode(10);
            int xAct = arg0.getX();
            int yAct = arg0.getY();
            this.xdiff = xAct - this.xStart;
            this.ydiff = yAct - this.yStart;
            this.xStart = xAct;
            this.yStart = yAct;
            this.jRenderer3D.changeTransformRotationXZ((double)(-this.ydiff) / 2.0, (double)this.xdiff / 2.0);
            this.renderAndUpdateDisplay();
        }
    }

    @Override
    public void mouseEntered(MouseEvent arg0) {
    }

    @Override
    public void mouseExited(MouseEvent arg0) {
    }

    private void setPlotType(String type) {
        if (type.equals("Dots")) {
            this.jRenderer3D.setSurfacePlotMode(11);
        } else if (type.equals("Lines")) {
            this.jRenderer3D.setSurfacePlotMode(12);
        } else if (type.equals("Mesh")) {
            this.jRenderer3D.setSurfacePlotMode(13);
        } else if (type.equals("Isolines")) {
            this.jRenderer3D.setSurfacePlotMode(15);
        } else if (type.equals("Filled")) {
            this.jRenderer3D.setSurfacePlotMode(14);
        }
        this.renderAndUpdateDisplay();
    }

    private void setColorType(String type) {
        this.colorType = type;
        if (type.equals("Original Colors")) {
            this.jRenderer3D.setSurfacePlotLut(50);
        } else if (type.equals("Grayscale")) {
            this.jRenderer3D.setSurfacePlotLut(51);
        } else if (type.equals("Spectrum LUT")) {
            this.jRenderer3D.setSurfacePlotLut(52);
        } else if (type.equals("Fire LUT")) {
            this.jRenderer3D.setSurfacePlotLut(53);
        } else if (type.equals("Thermal LUT")) {
            this.jRenderer3D.setSurfacePlotLut(54);
        } else if (type.equals("Gradient")) {
            this.jRenderer3D.setSurfacePlotLut(58);
        } else if (type.equals("Orange")) {
            this.jRenderer3D.setSurfacePlotLut(55);
        } else if (type.equals("Blue")) {
            this.jRenderer3D.setSurfacePlotLut(56);
        }
        this.renderAndUpdateDisplay();
    }

    private void sliderChange(JSlider slider) {
        if (slider == this.sliderLight) {
            this.light = (double)this.sliderLight.getValue() / 100.0;
            this.jRenderer3D.setSurfacePlotLight(this.light);
            String str = "Lighting: " + this.light;
            this.setSliderTitle(this.sliderLight, Color.black, str);
        } else if (slider == this.sliderGridSize) {
            int gridWidth;
            int gridHeight;
            int grid = 1 << this.sliderGridSize.getValue();
            if (this.imageHeight > this.imageWidth) {
                gridHeight = grid;
                gridWidth = grid * this.imageWidth / this.imageHeight;
            } else {
                gridWidth = grid;
                gridHeight = grid * this.imageHeight / this.imageWidth;
            }
            this.jRenderer3D.setSurfacePlotGridSize(gridWidth, gridHeight);
            this.jRenderer3D.setInverse(this.invertZ);
            double smooth = (double)this.sliderSmoothing.getValue() * ((double)grid / 512.0);
            if (!slider.getValueIsAdjusting() || grid <= 256) {
                this.jRenderer3D.setSurfaceSmoothingFactor(smooth);
                this.smoothOld = smooth;
            }
            String str = "Grid Size: " + grid;
            this.setSliderTitle(this.sliderGridSize, Color.black, str);
            str = "Smoothing: " + (double)((int)(smooth * 100.0)) / 100.0;
            this.setSliderTitle(this.sliderSmoothing, Color.black, str);
        } else if (slider == this.sliderSmoothing) {
            int grid = 1 << this.sliderGridSize.getValue();
            double smooth = (double)this.sliderSmoothing.getValue() * ((double)grid / 512.0);
            if (!(smooth == this.smoothOld || slider.getValueIsAdjusting() && 1 << this.sliderGridSize.getValue() > 256)) {
                this.jRenderer3D.setSurfaceSmoothingFactor(smooth);
                this.smoothOld = smooth;
            }
            String str = "Smoothing: " + (double)((int)(smooth * 100.0)) / 100.0;
            this.setSliderTitle(this.sliderSmoothing, Color.black, str);
        } else if (slider == this.sliderScale) {
            double scaleSlider = (double)this.sliderScale.getValue() / 100.0;
            String str = "Scale: " + (double)((int)(scaleSlider * 100.0)) / 100.0;
            this.setSliderTitle(this.sliderScale, Color.black, str);
            double scale = this.scaleInit * this.scaleWindow * scaleSlider;
            this.jRenderer3D.setTransformScale(scale);
        } else if (slider == this.sliderPerspective) {
            double p = (double)this.sliderPerspective.getValue() / 100.0;
            this.jRenderer3D.setTransformPerspective(p);
            String str = "Perspective: " + p;
            this.setSliderTitle(this.sliderPerspective, Color.black, str);
        } else if (slider == this.sliderMin) {
            this.maxS = this.sliderMax.getValue();
            this.minS = this.sliderMin.getValue();
            if (this.minS >= this.maxS) {
                this.maxS = Math.min(255, this.minS + 1);
                this.sliderMax.setValue(this.maxS);
                this.sliderMax.repaint();
            }
            String str = "Min: " + this.minS + " %";
            this.setSliderTitle(this.sliderMin, Color.black, str);
            str = "Max: " + this.maxS + " %";
            this.setSliderTitle(this.sliderMax, Color.black, str);
            this.jRenderer3D.setSurfacePlotMinMax(this.minS, this.maxS);
            this.addCoordinateSystem();
        } else if (slider == this.sliderMax) {
            this.maxS = this.sliderMax.getValue();
            this.minS = this.sliderMin.getValue();
            if (this.maxS <= this.minS) {
                this.minS = Math.max(-1, this.maxS - 1);
                this.sliderMin.setValue(this.minS);
                this.sliderMin.repaint();
            }
            String str = "Min: " + this.minS + " %";
            this.setSliderTitle(this.sliderMin, Color.black, str);
            str = "Max: " + this.maxS + " %";
            this.setSliderTitle(this.sliderMax, Color.black, str);
            this.jRenderer3D.setSurfacePlotMinMax(this.minS, this.maxS);
            this.addCoordinateSystem();
        } else if (slider == this.sliderZRatio) {
            this.zAspectRatioSlider = (double)this.sliderZRatio.getValue() / 100.0;
            String str = "z-Ratio:" + this.zAspectRatioSlider;
            this.setSliderTitle(this.sliderZRatio, Color.black, str);
            this.zAspectRatio = this.zAspectRatioSlider * this.zRatioInit;
            this.jRenderer3D.setTransformZAspectRatio(this.zAspectRatio);
            this.maxDistance = Math.max(this.scaledWidth, Math.max(this.scaledHeight, 256.0 * Math.max(this.zAspectRatio, 1.0)));
            this.jRenderer3D.setTransformMaxDistance(this.maxDistance);
            this.addCoordinateSystem();
        }
        this.renderAndUpdateDisplay();
    }

    public void resizeImagePanel(int width, int height) {
        if (this.jRenderer3D != null) {
            this.scaleWindow = (double)Math.min(width, height) / (double)this.startWindowHeight;
            this.jRenderer3D.setBufferSize(width, height);
            this.setScaleAndZRatio();
            this.renderAndUpdateDisplay();
        }
    }

    private void createGUI() {
        this.frame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent event) {
                Interactive_3D_Surface_Plot.this.frame.dispose();
            }
        });
        this.mainPanel = this.createMainPanel();
        this.frame.getContentPane().add(this.mainPanel);
        this.frame.setSize(this.startWindowWidth, this.startWindowHeight);
        this.frame.pack();
        this.frame.setResizable(true);
        this.frame.setVisible(true);
        this.frame.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent event) {
                Insets insetsFrame = Interactive_3D_Surface_Plot.this.frame.getInsets();
                Interactive_3D_Surface_Plot.this.windowWidth = Interactive_3D_Surface_Plot.this.frame.getWidth() - insetsFrame.left - insetsFrame.right - Interactive_3D_Surface_Plot.this.settingsPanel2.getWidth();
                Interactive_3D_Surface_Plot.this.windowHeight = Interactive_3D_Surface_Plot.this.frame.getHeight() - insetsFrame.bottom - insetsFrame.top - Interactive_3D_Surface_Plot.this.settingsPanel1.getHeight();
                if (Interactive_3D_Surface_Plot.this.windowHeight > 0 && Interactive_3D_Surface_Plot.this.windowWidth > 0) {
                    Interactive_3D_Surface_Plot.this.resizeImagePanel(Interactive_3D_Surface_Plot.this.windowWidth, Interactive_3D_Surface_Plot.this.windowHeight);
                }
                Interactive_3D_Surface_Plot.this.frame.pack();
            }
        });
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        Dimension screenSize = toolkit.getScreenSize();
        int screenWidth = screenSize.width;
        int screenHeight = screenSize.height;
        int centerX = screenWidth / 2 - this.startWindowWidth / 2;
        int centerY = screenHeight / 2 - this.startWindowHeight / 2;
        this.frame.setLocation(centerX, centerY);
    }

    private JPanel createMainPanel() {
        JPanel imagePanel = this.createImagePanel();
        this.settingsPanel1 = this.createSettingsPanelTop();
        this.settingsPanel2 = this.createSettingsPanelRight();
        JPanel mainPanel = new JPanel();
        mainPanel.setLayout(new BorderLayout());
        mainPanel.add((Component)this.settingsPanel1, "North");
        mainPanel.add((Component)this.settingsPanel2, "East");
        mainPanel.add((Component)imagePanel, "Center");
        return mainPanel;
    }

    private JPanel createImagePanel() {
        this.imageRegion = new ImageRegion();
        this.imageRegion.setWidth(this.startWindowWidth);
        this.imageRegion.setHeight(this.startWindowHeight);
        this.imageRegion.addMouseListener(this);
        this.imageRegion.addMouseMotionListener(this);
        JPanel panel = new JPanel();
        panel.setLayout(new BorderLayout());
        panel.add((Component)this.imageRegion, "Center");
        return panel;
    }

    private JPanel createSettingsPanelTop() {
        Dimension comboDim = new Dimension(400, 25);
        Dimension sliderDim1 = new Dimension(400, 50);
        JPanel comboPanel = this.createComboPanel();
        comboPanel.setPreferredSize(comboDim);
        JPanel sliderPanel1 = this.createSliderPanel1();
        sliderPanel1.setPreferredSize(sliderDim1);
        this.settingsPanel1 = new JPanel();
        this.settingsPanel1.setLayout(new BorderLayout());
        this.settingsPanel1.add((Component)comboPanel, "North");
        this.settingsPanel1.add((Component)sliderPanel1, "South");
        return this.settingsPanel1;
    }

    private JPanel createSettingsPanelRight() {
        Dimension sliderDim2 = new Dimension(70, 400);
        JPanel sliderPanel2 = this.createSliderPanel2();
        sliderPanel2.setPreferredSize(sliderDim2);
        this.settingsPanel2 = new JPanel();
        this.settingsPanel2.setLayout(new BorderLayout());
        this.settingsPanel2.add((Component)sliderPanel2, "Center");
        return this.settingsPanel2;
    }

    void createComboDisplay() {
        this.comboDisplayColors = new JComboBox();
        this.comboDisplayColors.addItem("Original Colors");
        this.comboDisplayColors.addItem("Grayscale");
        this.comboDisplayColors.addItem("Spectrum LUT");
        this.comboDisplayColors.addItem("Fire LUT");
        this.comboDisplayColors.addItem("Thermal LUT");
        this.comboDisplayColors.addItem("Gradient");
        this.comboDisplayColors.addItem("Blue");
        this.comboDisplayColors.addItem("Orange");
        this.comboDisplayColors.setSelectedIndex(this.isExamplePlot ? 5 : 0);
        this.comboDisplayColors.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Interactive_3D_Surface_Plot.this.setColorType(Interactive_3D_Surface_Plot.this.comboDisplayColors.getSelectedItem().toString());
            }
        });
    }

    private JPanel createComboPanel() {
        this.comboDisplayType = new JComboBox();
        this.comboDisplayType.addItem("Dots");
        this.comboDisplayType.addItem("Lines");
        this.comboDisplayType.addItem("Mesh");
        this.comboDisplayType.addItem("Filled");
        this.comboDisplayType.addItem("Isolines");
        this.comboDisplayType.setSelectedIndex(this.isExamplePlot ? 3 : 1);
        this.comboDisplayType.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Interactive_3D_Surface_Plot.this.plotType = Interactive_3D_Surface_Plot.this.comboDisplayType.getSelectedItem().toString();
                Interactive_3D_Surface_Plot.this.setPlotType(Interactive_3D_Surface_Plot.this.plotType);
            }
        });
        this.createComboDisplay();
        JButton saveButton = new JButton("Save Plot");
        saveButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Interactive_3D_Surface_Plot.this.imageRegion.saveToImageJImage();
            }
        });
        JButton textureButton = new JButton("Load Texture");
        textureButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Interactive_3D_Surface_Plot.this.loadTextureImage();
            }
        });
        JPanel panel = new JPanel();
        panel.setLayout(new GridLayout(1, 5, 0, 0));
        panel.add(this.comboDisplayType);
        panel.add(this.comboDisplayColors);
        panel.add(textureButton);
        panel.add(saveButton);
        this.checkAuto = new JCheckBox("z-Ratio = xy-Ratio");
        this.checkAuto.setFont(new Font("Sans", 0, 11));
        this.checkAuto.setSelected(this.isEqualxyzRatio);
        this.checkAuto.addItemListener(this);
        panel.add(this.checkAuto);
        return panel;
    }

    private void loadTextureImage() {
        JFileChooser fc;
        ImagePlus impTexture = null;
        int[] wList = WindowManager.getIDList();
        boolean loadFromDisk = false;
        if (wList == null) {
            loadFromDisk = true;
        } else {
            String[] titles = new String[wList.length + 1];
            for (int i = 0; i < wList.length; ++i) {
                ImagePlus imp = WindowManager.getImage(wList[i]);
                titles[i] = imp != null ? imp.getTitle() : "";
            }
            titles[wList.length] = "\"Load File from Disk\"";
            GenericDialog gd = new GenericDialog("Load texture", IJ.getInstance());
            gd.addMessage("Please select an Image to be used as texture");
            String defaultItem = titles[0];
            gd.addChoice("Open Image:", titles, defaultItem);
            gd.showDialog();
            if (gd.wasCanceled()) {
                return;
            }
            int index = gd.getNextChoiceIndex();
            if (titles[index].equals("\"Load File from Disk\"")) {
                loadFromDisk = true;
            } else {
                impTexture = WindowManager.getImage(wList[index]);
            }
        }
        if (loadFromDisk && (fc = new JFileChooser()).showOpenDialog(null) == 0) {
            String str = fc.getSelectedFile().getPath();
            try {
                IJ.run("Open...", "path='" + str + "'");
                impTexture = WindowManager.getCurrentImage();
            }
            catch (RuntimeException e) {
                JOptionPane.showMessageDialog(null, "Error opening Image", "", -1);
                return;
            }
        }
        if (impTexture != null) {
            this.jRenderer3D.setSurfacePlotTexture(impTexture);
            this.setPlotType(this.plotType);
            this.jRenderer3D.setSurfacePlotLight(this.light);
            this.setColorType(this.colorType);
            int max = this.sliderMax.getValue();
            int min = this.sliderMin.getValue();
            this.jRenderer3D.setSurfacePlotMinMax(min, max);
            this.jRenderer3D.setInverse(this.invertZ);
            int grid = 1 << this.sliderGridSize.getValue();
            double smooth = (double)this.sliderSmoothing.getValue() * ((double)grid / 512.0);
            if (smooth < 1.0) {
                smooth = 0.0;
            }
            this.jRenderer3D.setSurfaceSmoothingFactor(smooth);
            this.smoothOld = smooth;
            this.setColorType("Original Colors");
            this.comboDisplayColors.setSelectedIndex(0);
            this.renderAndUpdateDisplay();
        }
    }

    private JPanel createSliderPanel1() {
        this.sliderGridSize = this.createSliderHorizontal("Grid Size: 128", 5, 9, 7);
        int grid = 128;
        int smooth = this.isExamplePlot ? 5 : 3;
        String str = "Smoothing: " + (double)(smooth * 100) / 100.0;
        this.sliderSmoothing = this.createSliderHorizontal(str, 0, 100, smooth *= 512 / grid);
        int perspective = 0;
        str = "Perspective: " + (double)perspective / 100.0;
        this.sliderPerspective = this.createSliderHorizontal(str, 0, 100, perspective);
        int light_ = (int)(this.light * 100.0);
        this.sliderLight = this.createSliderHorizontal("Lighting: " + (double)light_ / 100.0, 0, 100, light_);
        JPanel miniPanel = new JPanel();
        miniPanel.setLayout(new GridLayout(2, 2, 0, 3));
        this.checkAxes = new JCheckBox("Axes");
        this.checkAxes.setFont(new Font("Sans", 0, 11));
        this.checkAxes.setSelected(true);
        this.checkAxes.addItemListener(this);
        this.checkInverse = new JCheckBox("Invert");
        this.checkInverse.setFont(new Font("Sans", 0, 11));
        this.checkInverse.setSelected(false);
        this.checkInverse.addItemListener(this);
        this.checkText = new JCheckBox("Text");
        this.checkText.setFont(new Font("Sans", 0, 11));
        this.checkText.setSelected(true);
        this.checkText.addItemListener(this);
        this.checkLines = new JCheckBox("Lines");
        this.checkLines.setFont(new Font("Sans", 0, 11));
        this.checkLines.setSelected(true);
        this.checkLines.addItemListener(this);
        miniPanel.add(this.checkInverse);
        miniPanel.add(this.checkAxes);
        miniPanel.add(this.checkText);
        miniPanel.add(this.checkLines);
        JPanel panel = new JPanel();
        panel.setLayout(new GridLayout(1, 5));
        panel.add(this.sliderGridSize);
        panel.add(this.sliderSmoothing);
        panel.add(this.sliderPerspective);
        panel.add(this.sliderLight);
        panel.add(miniPanel);
        return panel;
    }

    @Override
    public synchronized void itemStateChanged(ItemEvent e) {
        if (e.getSource() == this.checkInverse) {
            this.invertZ = this.checkInverse.isSelected();
            this.jRenderer3D.setInverse(this.invertZ);
            this.maxS = this.sliderMax.getValue();
            this.minS = this.sliderMin.getValue();
            this.jRenderer3D.setSurfacePlotMinMax(this.minS, this.maxS);
            this.addCoordinateSystem();
        }
        if (e.getSource() == this.checkAxes) {
            if (this.checkAxes.isSelected()) {
                this.jRenderer3D.setAxes(true);
            } else {
                this.jRenderer3D.setAxes(false);
            }
        }
        if (e.getSource() == this.checkText) {
            if (this.checkText.isSelected()) {
                this.jRenderer3D.setText(true);
            } else {
                this.jRenderer3D.setText(false);
            }
        }
        if (e.getSource() == this.checkLines) {
            if (this.checkLines.isSelected()) {
                this.jRenderer3D.setLines(true);
            } else {
                this.jRenderer3D.setLines(false);
            }
        }
        if (e.getSource() == this.checkAuto) {
            this.isEqualxyzRatio = this.checkAuto.isSelected();
            this.setScaleAndZRatio();
            this.renderAndUpdateDisplay();
        }
        this.renderAndUpdateDisplay();
    }

    private JPanel createSliderPanel2() {
        this.sliderScale = this.createSliderVertical("Scale: 1.0", 25, 300, 100);
        this.sliderZRatio = this.createSliderVertical("z-Ratio: 1.0", 10, 400, 100);
        this.sliderMin = this.createSliderVertical("Min:  0 %", 0, 100, 0);
        this.sliderMax = this.createSliderVertical("Max: 100 %", 0, 100, 100);
        JPanel panel = new JPanel();
        panel.setLayout(new GridLayout(4, 1));
        panel.add(this.sliderScale);
        panel.add(this.sliderZRatio);
        panel.add(this.sliderMax);
        panel.add(this.sliderMin);
        return panel;
    }

    private JSlider createSliderHorizontal(String borderTitle, int min, int max, int value) {
        TitledBorder empty = BorderFactory.createTitledBorder(BorderFactory.createEmptyBorder());
        Font sliderFont = new Font("Sans", 0, 11);
        JSlider slider = new JSlider(0, min, max, value);
        slider.setBorder(new TitledBorder(empty, borderTitle, 2, 3, sliderFont));
        slider.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent event) {
                Interactive_3D_Surface_Plot.this.sliderChange((JSlider)event.getSource());
            }
        });
        return slider;
    }

    private JSlider createSliderVertical(String borderTitle, int min, int max, int value) {
        TitledBorder empty = BorderFactory.createTitledBorder(BorderFactory.createEmptyBorder());
        Font sliderFont = new Font("Sans", 0, 11);
        JSlider slider = new JSlider(1, min, max, value);
        slider.setBorder(new TitledBorder(empty, borderTitle, 2, 3, sliderFont));
        slider.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent event) {
                Interactive_3D_Surface_Plot.this.sliderChange((JSlider)event.getSource());
            }
        });
        return slider;
    }

    private void setSliderTitle(JSlider slider, Color color, String str) {
        TitledBorder empty = BorderFactory.createTitledBorder(BorderFactory.createEmptyBorder());
        Font sliderFont = new Font("Sans", 0, 11);
        slider.setBorder(new TitledBorder(empty, str, 2, 3, sliderFont));
    }

    class ImageRegion
    extends JPanel {
        private Image image;
        private int width;
        private int height;

        ImageRegion() {
        }

        @Override
        public Dimension getPreferredSize() {
            return new Dimension(this.width, this.height);
        }

        @Override
        public Dimension getMinimumSize() {
            return new Dimension(this.width, this.height);
        }

        public void setImage(JRenderer3D pic) {
            this.height = pic.getHeight();
            this.width = pic.getWidth();
            this.image = pic.getImage();
        }

        public void setImage(Image image) {
            this.image = image;
        }

        @Override
        public void paint(Graphics g) {
            if (this.image != null) {
                g.drawImage(this.image, 0, 0, this.width, this.height, this);
            }
        }

        synchronized void saveToImageJImage() {
            BufferedImage bufferedImage = new BufferedImage(this.width, this.height, 1);
            this.paint(bufferedImage.createGraphics());
            ImagePlus plotImage = NewImage.createRGBImage("ImageJ 3D", this.width, this.height, 1, 1);
            ImageProcessor ip = plotImage.getProcessor();
            int[] pixels = (int[])ip.getPixels();
            bufferedImage.getRGB(0, 0, this.width, this.height, pixels, 0, this.width);
            plotImage.show();
            plotImage.updateAndDraw();
        }

        @Override
        public void update(Graphics g) {
            this.paint(g);
        }

        @Override
        public int getHeight() {
            return this.height;
        }

        public void setHeight(int height) {
            this.height = height;
        }

        @Override
        public int getWidth() {
            return this.width;
        }

        public void setWidth(int width) {
            this.width = width;
        }
    }
}

