/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin;

import ij.CompositeImage;
import ij.IJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.WindowManager;
import ij.gui.GenericDialog;
import ij.gui.ImageWindow;
import ij.gui.StackWindow;
import ij.io.FileInfo;
import ij.macro.Interpreter;
import ij.measure.Calibration;
import ij.plugin.PlugIn;
import ij.process.ImageProcessor;

public class StackEditor
implements PlugIn {
    static final int C = 0;
    static final int Z = 1;
    static final int T = 2;
    ImagePlus imp;
    int nSlices;
    int width;
    int height;

    @Override
    public void run(String arg) {
        this.imp = WindowManager.getCurrentImage();
        if (this.imp == null) {
            IJ.noImage();
            return;
        }
        this.nSlices = this.imp.getStackSize();
        this.width = this.imp.getWidth();
        this.height = this.imp.getHeight();
        if (arg.equals("tostack")) {
            this.convertImagesToStack();
        } else if (arg.equals("add")) {
            this.addSlice();
        } else if (arg.equals("delete")) {
            this.deleteSlice();
        } else if (arg.equals("toimages")) {
            this.convertStackToImages(this.imp);
        } else if (arg.equals("stackto5d")) {
            this.convertStackTo5D(this.imp);
        } else if (arg.equals("5dtostack")) {
            this.convert5DToStack(this.imp);
        }
    }

    void addSlice() {
        if (!this.imp.lock()) {
            return;
        }
        int id = 0;
        ImageStack stack = this.imp.getStack();
        if (stack.getSize() == 1) {
            String label = stack.getSliceLabel(1);
            if (label != null && label.indexOf("\n") != -1) {
                stack.setSliceLabel(null, 1);
            }
            id = this.imp.getID();
        }
        ImageProcessor ip = this.imp.getProcessor();
        int n = this.imp.getCurrentSlice();
        if (IJ.altKeyDown()) {
            --n;
        }
        stack.addSlice(null, ip.createProcessor(this.width, this.height), n);
        this.imp.setStack(null, stack);
        this.imp.setSlice(n + 1);
        this.imp.unlock();
        if (id != 0) {
            IJ.selectWindow(id);
        }
    }

    void deleteSlice() {
        if (this.nSlices < 2) {
            IJ.error("\"Delete Slice\" requires a stack");
            return;
        }
        if (!this.imp.lock()) {
            return;
        }
        ImageStack stack = this.imp.getStack();
        int n = this.imp.getCurrentSlice();
        stack.deleteSlice(n);
        this.imp.setStack(null, stack);
        if (n-- < 1) {
            n = 1;
        }
        this.imp.setSlice(n);
        this.imp.unlock();
    }

    public void convertImagesToStack() {
        int[] wList = WindowManager.getIDList();
        if (wList == null) {
            IJ.error("No images are open.");
            return;
        }
        int count = 0;
        ImagePlus[] image = new ImagePlus[wList.length];
        for (int i = 0; i < wList.length; ++i) {
            ImagePlus imp = WindowManager.getImage(wList[i]);
            if (imp.getStackSize() != 1) continue;
            image[count++] = imp;
        }
        if (count < 2) {
            IJ.error("There must be at least two open images.");
            return;
        }
        Calibration cal2 = image[0].getCalibration();
        for (int i = 0; i < count - 1; ++i) {
            if (image[i].getType() != image[i + 1].getType()) {
                IJ.error("All open images must be the same type.");
                return;
            }
            if (image[i].getWidth() != image[i + 1].getWidth() || image[i].getHeight() != image[i + 1].getHeight()) {
                IJ.error("All open images must be the same size.");
                return;
            }
            Calibration cal = image[i].getCalibration();
            if (image[i].getCalibration().equals(cal2)) continue;
            cal2 = null;
        }
        int width = image[0].getWidth();
        int height = image[0].getHeight();
        double min = Double.MAX_VALUE;
        double max = -1.7976931348623157E308;
        ImageStack stack = new ImageStack(width, height);
        FileInfo fi = image[0].getOriginalFileInfo();
        if (fi != null && fi.directory == null) {
            fi = null;
        }
        for (int i = 0; i < count; ++i) {
            FileInfo fi2;
            ImageProcessor ip = image[i].getProcessor();
            if (ip.getMin() < min) {
                min = ip.getMin();
            }
            if (ip.getMax() > max) {
                max = ip.getMax();
            }
            String label = image[i].getTitle();
            String info = (String)image[i].getProperty("Info");
            if (info != null) {
                label = label + "\n" + info;
            }
            if (fi != null && (fi2 = image[i].getOriginalFileInfo()) != null && !fi.directory.equals(fi2.directory)) {
                fi = null;
            }
            stack.addSlice(label, ip);
            image[i].changes = false;
            image[i].close();
        }
        ImagePlus imp = new ImagePlus("Stack", stack);
        if (imp.getType() == 1 || imp.getType() == 2) {
            imp.getProcessor().setMinAndMax(min, max);
        }
        if (cal2 != null) {
            imp.setCalibration(cal2);
        }
        if (fi != null) {
            fi.fileName = "";
            fi.nImages = imp.getStackSize();
            imp.setFileInfo(fi);
        }
        imp.show();
    }

    public void convertStackToImages(ImagePlus imp) {
        boolean ok;
        if (this.nSlices < 2) {
            IJ.error("\"Convert Stack to Images\" requires a stack");
            return;
        }
        if (!imp.lock()) {
            return;
        }
        ImageStack stack = imp.getStack();
        int size = stack.getSize();
        if (size > 30 && !IJ.macroRunning() && !(ok = IJ.showMessageWithCancel("Convert to Images?", "Are you sure you want to convert this\nstack to " + size + " separate windows?"))) {
            imp.unlock();
            return;
        }
        Calibration cal = imp.getCalibration();
        CompositeImage cimg = imp instanceof CompositeImage ? (CompositeImage)imp : null;
        for (int i = 1; i <= size; ++i) {
            String label = stack.getShortSliceLabel(i);
            String title = label != null && !label.equals("") ? label : this.getTitle(imp, i);
            ImageProcessor ip = stack.getProcessor(i);
            if (cimg != null) {
                ip.setMinAndMax(cimg.getMin(i), cimg.getMax(i));
            }
            ImagePlus imp2 = new ImagePlus(title, ip);
            imp2.setCalibration(cal);
            imp2.show();
        }
        imp.changes = false;
        ImageWindow win = imp.getWindow();
        if (win != null) {
            win.close();
        } else if (Interpreter.isBatchMode()) {
            Interpreter.removeBatchModeImage(imp);
        }
        imp.unlock();
    }

    String getTitle(ImagePlus imp, int n) {
        String digits = "00000000" + n;
        return imp.getShortTitle() + "-" + digits.substring(digits.length() - 4, digits.length());
    }

    void convertStackTo5D(ImagePlus imp) {
        int nChannels = imp.getNChannels();
        int nSlices = imp.getNSlices();
        int nFrames = imp.getNFrames();
        int stackSize = imp.getStackSize();
        if (stackSize == 1) {
            IJ.error("Stack to 5D", "Stack required");
            return;
        }
        int first = 0;
        int middle = 1;
        int last = 2;
        int nFirst = nChannels;
        int nMiddle = nSlices;
        int nLast = nFrames;
        if (nChannels <= 1 && nSlices <= 1 && nFrames > 1) {
            first = 2;
            middle = 1;
            last = 0;
            nFirst = stackSize;
            nMiddle = 1;
            nLast = 1;
        } else if (nChannels <= 1 && nFrames <= 1 && nSlices > 1) {
            first = 1;
            middle = 0;
            last = 2;
            nFirst = stackSize;
            nMiddle = 1;
            nLast = 1;
        }
        String[] dimensions = new String[]{"c", "z", "t"};
        boolean goOn = true;
        do {
            double dLast;
            goOn = true;
            GenericDialog gd = new GenericDialog("Convert Stack to 5D");
            gd.addChoice("3rd Dimension:", dimensions, dimensions[first]);
            gd.addChoice("4th Dimension:", dimensions, dimensions[middle]);
            gd.addNumericField("3rd_Dimension_Size:", nFirst, 0, 8, "");
            gd.addNumericField("4th_Dimension_Size:", nMiddle, 0, 8, "");
            gd.showDialog();
            if (gd.wasCanceled()) {
                return;
            }
            first = gd.getNextChoiceIndex();
            middle = gd.getNextChoiceIndex();
            nFirst = (int)gd.getNextNumber();
            nMiddle = (int)gd.getNextNumber();
            if (first == middle) {
                IJ.error("Please do not select two identical dimensions!");
                goOn = false;
                continue;
            }
            boolean[] thirdChoice = new boolean[]{true, true, true};
            thirdChoice[first] = false;
            thirdChoice[middle] = false;
            for (int i = 0; i < 3; ++i) {
                if (!thirdChoice[i]) continue;
                last = i;
                break;
            }
            if ((double)(nLast = (int)(dLast = (double)stackSize / (double)nFirst / (double)nMiddle)) == dLast) continue;
            IJ.error("channels*slices*frames!=stackSize");
            goOn = false;
        } while (!goOn);
        nChannels = 1;
        nSlices = 1;
        nFrames = 1;
        switch (first) {
            case 0: {
                nChannels = nFirst;
                break;
            }
            case 1: {
                nSlices = nFirst;
                break;
            }
            case 2: {
                nFrames = nFirst;
            }
        }
        switch (middle) {
            case 0: {
                nChannels = nMiddle;
                break;
            }
            case 1: {
                nSlices = nMiddle;
                break;
            }
            case 2: {
                nFrames = nMiddle;
            }
        }
        switch (last) {
            case 0: {
                nChannels = nLast;
                break;
            }
            case 1: {
                nSlices = nLast;
                break;
            }
            case 2: {
                nFrames = nLast;
            }
        }
        Object[] images1 = imp.getStack().getImageArray();
        Object[] images2 = new Object[images1.length];
        System.arraycopy(images1, 0, images2, 0, images1.length);
        int[] index = new int[3];
        index[2] = 0;
        while (index[2] < nFrames) {
            index[1] = 0;
            while (index[1] < nSlices) {
                index[0] = 0;
                while (index[0] < nChannels) {
                    int dstIndex = index[0] + index[1] * nChannels + index[2] * nChannels * nSlices;
                    int srcIndex = index[first] + index[middle] * nFirst + index[last] * nFirst * nMiddle;
                    images1[dstIndex] = images2[srcIndex];
                    index[0] = index[0] + 1;
                }
                index[1] = index[1] + 1;
            }
            index[2] = index[2] + 1;
        }
        imp.setDimensions(index[0], index[1], index[2]);
        imp.setOpenAsHyperVolume(true);
        new StackWindow(imp);
    }

    void convert5DToStack(ImagePlus imp) {
        imp.setOpenAsHyperVolume(false);
        new StackWindow(imp);
    }
}

