/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin.filter;

import ij.IJ;
import ij.ImagePlus;
import ij.WindowManager;
import ij.gui.GenericDialog;
import ij.gui.PlotWindow;
import ij.io.OpenDialog;
import ij.io.SaveDialog;
import ij.measure.Calibration;
import ij.measure.CurveFitter;
import ij.measure.Measurements;
import ij.plugin.TextReader;
import ij.plugin.filter.Analyzer;
import ij.plugin.filter.PlugInFilter;
import ij.process.ImageProcessor;
import ij.util.Tools;
import java.awt.Button;
import java.awt.FlowLayout;
import java.awt.Panel;
import java.awt.TextArea;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.StringTokenizer;

public class Calibrator
implements PlugInFilter,
Measurements,
ActionListener {
    private static final String NONE = "None";
    private static final String INVERTER = "Pixel Inverter";
    private static final String UNCALIBRATED_OD = "Uncalibrated OD";
    private static final String CUSTOM = "Custom";
    private static boolean showSettings;
    private boolean global1;
    private boolean global2;
    private ImagePlus imp;
    private int choiceIndex;
    private String[] functions;
    private int nFits = CurveFitter.fitList.length;
    private int spacerIndex = this.nFits + 1;
    private int inverterIndex = this.nFits + 2;
    private int odIndex = this.nFits + 3;
    private int customIndex = this.nFits + 4;
    private static String xText;
    private static String yText;
    private static boolean importedValues;
    private String unit;
    private double lx = 0.02;
    private double ly = 0.1;
    private int oldFunction;
    private String sumResiduals;
    private String fitGoodness;
    private Button open;
    private Button save;
    private GenericDialog gd;

    @Override
    public int setup(String arg, ImagePlus imp) {
        this.imp = imp;
        IJ.register(Calibrator.class);
        return 143;
    }

    @Override
    public void run(ImageProcessor ip) {
        boolean bl = this.global1 = this.imp.getGlobalCalibration() != null;
        if (!this.showDialog(this.imp)) {
            return;
        }
        if (this.choiceIndex == this.customIndex) {
            this.showPlot(null, null, this.imp.getCalibration(), null);
            return;
        }
        if (this.imp.getType() == 2) {
            if (this.choiceIndex == 0) {
                this.imp.getCalibration().setValueUnit(this.unit);
            } else {
                IJ.error("Calibrate", "Function must be \"None\" for 32-bit images,\nbut you can change the Unit.");
            }
        } else {
            this.calibrate(this.imp);
        }
    }

    public boolean showDialog(ImagePlus imp) {
        int function;
        Calibration cal = imp.getCalibration();
        this.functions = this.getFunctionList(cal.getFunction() == 22);
        this.oldFunction = function = cal.getFunction();
        double[] p = cal.getCoefficients();
        this.unit = cal.getValueUnit();
        String defaultChoice = function == 20 ? NONE : (function < this.nFits && function == 0 && p != null && p[0] == 255.0 && p[1] == -1.0 ? INVERTER : (function < this.nFits ? CurveFitter.fitList[function] : (function == 21 ? UNCALIBRATED_OD : (function == 22 ? CUSTOM : NONE))));
        String tmpText = this.getMeans();
        if (!importedValues) {
            xText = tmpText;
        }
        this.gd = new GenericDialog("Calibrate...");
        this.gd.addChoice("Function:", this.functions, defaultChoice);
        this.gd.addStringField("Unit:", this.unit, 16);
        this.gd.addTextAreas(xText, yText, 20, 14);
        this.gd.addPanel(this.makeButtonPanel(this.gd));
        this.gd.addCheckbox("Global Calibration", this.global1);
        this.gd.showDialog();
        if (this.gd.wasCanceled()) {
            return false;
        }
        this.choiceIndex = this.gd.getNextChoiceIndex();
        this.unit = this.gd.getNextString();
        xText = this.gd.getNextText();
        yText = this.gd.getNextText();
        this.global2 = this.gd.getNextBoolean();
        return true;
    }

    Panel makeButtonPanel(GenericDialog gd) {
        Panel buttons = new Panel();
        buttons.setLayout(new FlowLayout(1, 5, 0));
        this.open = new Button("Open...");
        this.open.addActionListener(this);
        buttons.add(this.open);
        this.save = new Button("Save...");
        this.save.addActionListener(this);
        buttons.add(this.save);
        return buttons;
    }

    public void calibrate(ImagePlus imp) {
        Calibration cal = imp.getCalibration();
        Calibration calOrig = cal.copy();
        int function = 20;
        boolean is16Bits = imp.getType() == 1;
        double[] parameters = null;
        double[] x = null;
        double[] y = null;
        boolean zeroClip = false;
        if (this.choiceIndex <= 0) {
            if (this.oldFunction == 20 && !yText.equals("") && !xText.equals("")) {
                IJ.error("Calibrate", "Please select a function");
            }
            function = 20;
        } else if (this.choiceIndex <= this.nFits) {
            function = this.choiceIndex - 1;
            x = this.getData(xText);
            y = this.getData(yText);
            if (!(cal.calibrated() && y.length == 0 && function == this.oldFunction || (parameters = this.doCurveFitting(x, y, function)) != null)) {
                return;
            }
            zeroClip = true;
            for (int i = 0; i < y.length; ++i) {
                if (!(y[i] < 0.0)) continue;
                zeroClip = false;
            }
        } else if (this.choiceIndex == this.inverterIndex) {
            function = 0;
            parameters = new double[]{is16Bits ? 65535.0 : 255.0, -1.0};
            this.unit = "Inverted Gray Value";
        } else if (this.choiceIndex == this.odIndex) {
            if (is16Bits) {
                IJ.error("Calibrate", "Uncalibrated OD is not supported on 16-bit images.");
                return;
            }
            function = 21;
            this.unit = UNCALIBRATED_OD;
        }
        cal.setFunction(function, parameters, this.unit, zeroClip);
        if (!cal.equals(calOrig)) {
            imp.setCalibration(cal);
        }
        imp.setGlobalCalibration(this.global2 ? cal : null);
        if (this.global2 || this.global2 != this.global1) {
            WindowManager.repaintImageWindows();
        } else {
            imp.repaintWindow();
        }
        if (function != 20) {
            this.showPlot(x, y, cal, this.fitGoodness);
        }
    }

    double[] doCurveFitting(double[] x, double[] y, int fitType) {
        if (x.length != y.length || y.length == 0) {
            IJ.error("Calibrate", "To create a calibration curve, the left column must\ncontain a list of measured mean pixel values and the\nright column must contain the same number of calibration\nstandard values. Use the Measure command to add mean\npixel value measurements to the left column.\n \n    Left column: " + x.length + " values\n" + "    Right column: " + y.length + " values\n");
            return null;
        }
        int n = x.length;
        double xmin = 0.0;
        double xmax = this.imp.getType() == 1 ? 65535.0 : 255.0;
        double[] a = Tools.getMinMax(y);
        double ymin = a[0];
        double ymax = a[1];
        CurveFitter cf = new CurveFitter(x, y);
        cf.doFit(fitType, showSettings);
        int np = cf.getNumParams();
        double[] p = cf.getParams();
        this.fitGoodness = IJ.d2s(cf.getRSquared(), 6);
        double[] parameters = new double[np];
        for (int i = 0; i < np; ++i) {
            parameters[i] = p[i];
        }
        return parameters;
    }

    void showPlot(double[] x, double[] y, Calibration cal, String rSquared) {
        int i;
        int xmax;
        boolean xmin;
        if (!cal.calibrated()) {
            return;
        }
        float[] ctable = cal.getCTable();
        if (ctable.length == 256) {
            xmin = false;
            xmax = 255;
        } else {
            xmin = false;
            xmax = 65535;
        }
        int range = 256;
        float[] px = new float[range];
        float[] py = new float[range];
        for (i = 0; i < range; ++i) {
            px[i] = (float)((double)i / 255.0 * (double)xmax);
        }
        for (i = 0; i < range; ++i) {
            py[i] = ctable[(int)px[i]];
        }
        double[] a = Tools.getMinMax(py);
        double ymin = a[0];
        double ymax = a[1];
        int fit = cal.getFunction();
        String unit = cal.getValueUnit();
        PlotWindow pw = new PlotWindow("Calibration Function", "pixel value", unit, px, py);
        pw.setLimits((double)xmin, xmax, ymin, ymax);
        if (x != null && y != null && x.length > 0 && y.length > 0) {
            pw.addPoints(x, y, 0);
        }
        double[] p = cal.getCoefficients();
        if (fit <= 9) {
            this.drawLabel(pw, CurveFitter.fList[fit]);
            this.ly += 0.04;
        }
        if (p != null) {
            int np = p.length;
            this.drawLabel(pw, "a=" + IJ.d2s(p[0], 6));
            this.drawLabel(pw, "b=" + IJ.d2s(p[1], 6));
            if (np >= 3) {
                this.drawLabel(pw, "c=" + IJ.d2s(p[2], 6));
            }
            if (np >= 4) {
                this.drawLabel(pw, "d=" + IJ.d2s(p[3], 6));
            }
            if (np >= 5) {
                this.drawLabel(pw, "e=" + IJ.d2s(p[4], 6));
            }
            this.ly += 0.04;
        }
        if (rSquared != null) {
            this.drawLabel(pw, "R^2=" + rSquared);
            rSquared = null;
        }
        pw.draw();
    }

    void drawLabel(PlotWindow pw, String label) {
        pw.addLabel(this.lx, this.ly, label);
        this.ly += 0.08;
    }

    double sqr(double x) {
        return x * x;
    }

    String[] getFunctionList(boolean custom) {
        int n = this.nFits + 4;
        if (custom) {
            ++n;
        }
        String[] list = new String[n];
        list[0] = NONE;
        for (int i = 0; i < this.nFits; ++i) {
            list[1 + i] = CurveFitter.fitList[i];
        }
        list[this.spacerIndex] = "-";
        list[this.inverterIndex] = INVERTER;
        list[this.odIndex] = UNCALIBRATED_OD;
        if (custom) {
            list[this.customIndex] = CUSTOM;
        }
        return list;
    }

    String getMeans() {
        float[] umeans = Analyzer.getUMeans();
        int count = Analyzer.getCounter();
        if (umeans == null || count == 0) {
            return "";
        }
        if (count > 20) {
            count = 20;
        }
        String s = "";
        for (int i = 0; i < count; ++i) {
            s = s + IJ.d2s(umeans[i], 2) + "\n";
        }
        importedValues = false;
        return s;
    }

    double[] getData(String xData) {
        StringTokenizer st = new StringTokenizer(xData);
        int nTokens = st.countTokens();
        if (nTokens < 1) {
            return new double[0];
        }
        int n = nTokens;
        double[] data = new double[n];
        for (int i = 0; i < n; ++i) {
            data[i] = this.getNum(st);
        }
        return data;
    }

    double getNum(StringTokenizer st) {
        Double d;
        String token = st.nextToken();
        try {
            d = new Double(token);
        }
        catch (NumberFormatException e) {
            d = null;
        }
        if (d != null) {
            return d;
        }
        return 0.0;
    }

    void save() {
        TextArea ta1 = this.gd.getTextArea1();
        TextArea ta2 = this.gd.getTextArea2();
        ta1.selectAll();
        String text1 = ta1.getText();
        ta1.select(0, 0);
        ta2.selectAll();
        String text2 = ta2.getText();
        ta2.select(0, 0);
        double[] x = this.getData(text1);
        double[] y = this.getData(text2);
        SaveDialog sd = new SaveDialog("Save as Text...", "calibration", ".txt");
        String name = sd.getFileName();
        if (name == null) {
            return;
        }
        String directory = sd.getDirectory();
        PrintWriter pw = null;
        try {
            FileOutputStream fos = new FileOutputStream(directory + name);
            BufferedOutputStream bos = new BufferedOutputStream(fos);
            pw = new PrintWriter(bos);
        }
        catch (IOException e) {
            IJ.error("" + e);
            return;
        }
        IJ.wait(250);
        int n = Math.max(x.length, y.length);
        for (int i = 0; i < n; ++i) {
            String xs;
            String string = x.length == 0 ? "" : (xs = i < x.length ? "" + x[i] : "0");
            String ys = y.length == 0 ? "" : (i < y.length ? "" + y[i] : "0");
            pw.println(xs + "\t" + ys);
        }
        pw.close();
    }

    void open() {
        OpenDialog od = new OpenDialog("Open Calibration...", "");
        String directory = od.getDirectory();
        String name = od.getFileName();
        if (name == null) {
            return;
        }
        TextReader tr = new TextReader();
        String path = directory + name;
        ImageProcessor ip = tr.open(path);
        if (ip == null) {
            return;
        }
        int width = ip.getWidth();
        int height = ip.getHeight();
        if (width != 1 && width != 2 || height <= 1) {
            IJ.error("Calibrate", "This appears to not be a one or two column text file");
            return;
        }
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < height; ++i) {
            sb.append("" + ip.getPixelValue(0, i));
            sb.append("\n");
        }
        String s1 = null;
        String s2 = null;
        if (width == 2) {
            s1 = new String(sb);
            sb = new StringBuffer();
            for (int i = 0; i < height; ++i) {
                sb.append("" + ip.getPixelValue(1, i));
                sb.append("\n");
            }
            s2 = new String(sb);
        } else {
            s2 = new String(sb);
        }
        if (s1 != null) {
            TextArea ta1 = this.gd.getTextArea1();
            ta1.selectAll();
            ta1.setText(s1);
        }
        TextArea ta2 = this.gd.getTextArea2();
        ta2.selectAll();
        ta2.setText(s2);
        importedValues = true;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        if (source == this.save) {
            this.save();
        } else if (source == this.open) {
            this.open();
        }
    }

    static {
        xText = "";
        yText = "";
    }
}

