/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin.filter;

import ij.IJ;
import ij.ImagePlus;
import ij.gui.PlotWindow;
import ij.measure.Calibration;
import ij.measure.Measurements;
import ij.measure.ResultsTable;
import ij.plugin.filter.ParticleAnalyzer;
import ij.plugin.filter.PlugInFilter;
import ij.process.ByteProcessor;
import ij.process.ImageProcessor;
import ij.util.Tools;
import java.awt.Color;

public class LineGraphAnalyzer
implements PlugInFilter,
Measurements {
    ImagePlus imp;

    @Override
    public int setup(String arg, ImagePlus imp) {
        this.imp = imp;
        return 129;
    }

    @Override
    public void run(ImageProcessor ip) {
        this.analyze(this.imp);
    }

    public void analyze(ImagePlus imp) {
        int maxSize;
        boolean minSize;
        ResultsTable rt;
        int measurements;
        int options;
        ParticleAnalyzer pa;
        double ph;
        ByteProcessor ip = (ByteProcessor)imp.getProcessor();
        ImageProcessor ip2 = ip.crop();
        int width = ip2.getWidth();
        int height = ip2.getHeight();
        ip2.setColor(Color.white);
        for (int i = 1; i < width; i += 2) {
            ip2.moveTo(i, 0);
            ip2.lineTo(i, height - 1);
        }
        ip2 = ip2.rotateRight();
        ImagePlus imp2 = imp.createImagePlus();
        ip2.setThreshold(ip.getMinThreshold(), ip.getMaxThreshold(), 2);
        imp2.setProcessor("Temp", ip2);
        Calibration cal = imp2.getCalibration();
        double pw = cal.pixelWidth;
        cal.pixelWidth = ph = cal.pixelHeight;
        cal.pixelHeight = pw;
        imp2.setCalibration(cal);
        if (IJ.altKeyDown()) {
            imp2.show();
        }
        if (!(pa = new ParticleAnalyzer(options = 32, measurements = 32, rt = new ResultsTable(), (double)(minSize = true), maxSize = 999999)).analyze(imp2)) {
            return;
        }
        float[] y = rt.getColumn(6);
        if (y == null) {
            return;
        }
        float[] x = rt.getColumn(7);
        double[] a = Tools.getMinMax(x);
        double xmin = a[0];
        double xmax = a[1];
        a = Tools.getMinMax(y);
        double ymin = a[0];
        double ymax = a[1];
        String units = " (" + cal.getUnits() + ")";
        String xLabel = "X" + units;
        String yLabel = "Y" + units;
        PlotWindow plot = new PlotWindow("Line Graph", xLabel, yLabel, x, y);
        plot.setLimits(0.0, (double)width * ph, 0.0, (double)height * pw);
        plot.draw();
    }
}

