/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin.frame;

import ij.LookUpTable;
import ij.WindowManager;
import ij.process.ImageStatistics;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;

class ContrastPlot
extends Canvas
implements MouseListener {
    static final int WIDTH = 256;
    static final int HEIGHT = 64;
    double defaultMin = 0.0;
    double defaultMax = 255.0;
    double min = 0.0;
    double max = 255.0;
    int[] histogram;
    int hmax;
    Image os;
    Graphics osg;
    Color color = Color.gray;

    public ContrastPlot() {
        this.addMouseListener(this);
        this.setSize(257, 65);
    }

    @Override
    public Dimension getPreferredSize() {
        return new Dimension(257, 65);
    }

    void setHistogram(ImageStatistics stats, Color color) {
        this.color = color;
        this.histogram = stats.histogram;
        if (this.histogram.length != 256) {
            this.histogram = null;
            return;
        }
        int maxCount = 0;
        int mode = 0;
        for (int i = 0; i < 256; ++i) {
            if (this.histogram[i] <= maxCount) continue;
            maxCount = this.histogram[i];
            mode = i;
        }
        int maxCount2 = 0;
        for (int i = 0; i < 256; ++i) {
            if (this.histogram[i] <= maxCount2 || i == mode) continue;
            maxCount2 = this.histogram[i];
        }
        this.hmax = stats.maxCount;
        if (this.hmax > maxCount2 * 2 && maxCount2 != 0) {
            this.histogram[mode] = this.hmax = (int)((double)maxCount2 * 1.5);
        }
        this.os = null;
    }

    @Override
    public void update(Graphics g) {
        this.paint(g);
    }

    @Override
    public void paint(Graphics g) {
        int y2;
        int x2;
        int y1;
        int x1;
        double scale = 256.0 / (this.defaultMax - this.defaultMin);
        double slope = 0.0;
        if (this.max != this.min) {
            slope = 64.0 / (this.max - this.min);
        }
        if (this.min >= this.defaultMin) {
            x1 = (int)(scale * (this.min - this.defaultMin));
            y1 = 64;
        } else {
            x1 = 0;
            boolean x12 = false;
            y1 = this.max > this.min ? 64 - (int)((this.defaultMin - this.min) * slope) : 64;
        }
        if (this.max <= this.defaultMax) {
            x2 = (int)(scale * (this.max - this.defaultMin));
            y2 = 0;
        } else {
            x2 = 256;
            int x22 = 256;
            y2 = this.max > this.min ? 64 - (int)((this.defaultMax - this.min) * slope) : 0;
        }
        if (this.histogram != null) {
            this.os = this.createImage(256, 64);
            this.osg = this.os.getGraphics();
            this.osg.setColor(Color.orange);
            this.osg.fillRect(0, 0, 256, 64);
            this.osg.setColor(this.color);
            int idx = 0;
            LookUpTable lut = WindowManager.getCurrentImage().createLut();
            byte[] reds = null;
            byte[] greens = null;
            byte[] blues = null;
            if (lut != null) {
                reds = lut.getReds();
                greens = lut.getGreens();
                blues = lut.getBlues();
            }
            System.out.println("lut=" + lut + " r=" + reds);
            for (int i = 0; i < 256; ++i) {
                idx = i <= x1 ? 0 : (i >= x2 ? 255 : 255 * (i - x1) / (x2 - x1 - 1));
                if (reds != null) {
                    this.osg.setColor(new Color(reds[idx] & 0xFF, greens[idx] & 0xFF, blues[idx] & 0xFF));
                } else {
                    this.osg.setColor(new Color(idx, idx, idx));
                }
                this.osg.drawLine(i, 64, i, 64 - 64 * this.histogram[i] / this.hmax);
            }
            this.osg.dispose();
            if (this.os != null) {
                g.drawImage(this.os, 0, 0, this);
            }
        } else {
            g.setColor(Color.white);
            g.fillRect(0, 0, 256, 64);
        }
        g.setColor(Color.red);
        g.drawRect(x1, 0, 256 - x1, 64);
        g.setColor(Color.blue);
        g.drawRect(0, 0, x2, 64);
        g.setColor(Color.green);
        g.drawRect(0, 0, 256, 64);
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }
}

