/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin.jRenderer3D;

import ij.IJ;
import ij.ImagePlus;
import ij.gui.Roi;
import ij.measure.Calibration;
import ij.plugin.filter.GaussianBlur;
import ij.plugin.jRenderer3D.Lut;
import ij.plugin.jRenderer3D.SurfacePlotData;
import ij.plugin.jRenderer3D.Transform;
import ij.process.FloatProcessor;
import ij.process.ImageProcessor;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.image.PixelGrabber;

class SurfacePlot {
    private int gridWidth = 256;
    private int gridHeight = 256;
    private SurfacePlotData[] plotList = null;
    Image image;
    private int[] bufferPixels;
    private double[] zbufferPixels;
    private int bufferWidth;
    private int bufferHeight;
    private int lutNr = 50;
    private Lut lut;
    private Transform tr;
    private double light;
    private int surfacePlotMode;
    private double xCenter;
    private double yCenter;
    private double zCenter;
    private int min = 0;
    private int max = 100;
    private int inversefactor = 1;
    private int[] pixelsOrigColor;
    private int[] pixelsOrigLum;
    private int widthOrig;
    private int heightOrig;
    private int widthTex;
    private int heightTex;
    private int[] pixelsTexColor;
    private byte[] maskPixels;

    SurfacePlot() {
    }

    protected void draw() {
        if (this.surfacePlotMode == 14) {
            this.surfacePlotFilled();
        } else if (this.surfacePlotMode == 15) {
            this.surfacePlotIsoLines();
        } else if (this.surfacePlotMode == 13) {
            this.surfacePlotMesh();
        } else if (this.surfacePlotMode == 12) {
            this.surfacePlotLines();
        } else if (this.surfacePlotMode == 11) {
            this.surfacePlotDots();
        } else if (this.surfacePlotMode == 10) {
            this.surfacePlotDotsNoLight();
        }
    }

    protected void setSurfacePlotImage(ImagePlus imp) {
        Roi roi;
        int widthTmp = imp.getWidth();
        int heightTmp = imp.getHeight();
        ImageProcessor ip = imp.getProcessor();
        this.lut = new Lut();
        int[] pixelsTmp = new int[widthTmp * heightTmp];
        this.image = imp.getImage();
        PixelGrabber pg = new PixelGrabber(this.image, 0, 0, widthTmp, heightTmp, pixelsTmp, 0, widthTmp);
        try {
            pg.grabPixels();
        }
        catch (InterruptedException ex) {
            IJ.error("error grabbing pixels");
        }
        boolean isLut = ip.isColorLut();
        byte[] lutPixels = null;
        int bitDepth = imp.getBitDepth();
        if (isLut) {
            if (bitDepth == 8) {
                lutPixels = (byte[])ip.getPixels();
            } else {
                int x;
                int y;
                int pos;
                Object[] pixels;
                lutPixels = new byte[widthTmp * heightTmp];
                double min_ = ip.getMin();
                double max_ = ip.getMax();
                double a = 0.0;
                double b = 1.0;
                Calibration cal = imp.getCalibration();
                if (cal != null && cal.calibrated()) {
                    min_ = cal.getCValue((int)min_);
                    max_ = cal.getCValue((int)max_);
                    double[] coef = cal.getCoefficients();
                    if (coef != null) {
                        a = coef[0];
                        b = coef[1];
                    }
                }
                float scale = (float)(255.0 / (max_ - min_));
                if (bitDepth == 16) {
                    pixels = (short[])ip.getPixels();
                    pos = 0;
                    for (y = 0; y < heightTmp; ++y) {
                        for (x = 0; x < widthTmp; ++x) {
                            int n = pos++;
                            int val = (int)((double)(0xFFFF & pixels[n]) * b + a - min_);
                            if ((float)val < 0.0f) {
                                val = 0;
                            }
                            if ((val = (int)((float)val * scale)) > 255) {
                                val = 255;
                            }
                            lutPixels[y * widthTmp + x] = (byte)val;
                        }
                    }
                }
                if (bitDepth == 32) {
                    pixels = (float[])ip.getPixels();
                    pos = 0;
                    for (y = 0; y < heightTmp; ++y) {
                        for (x = 0; x < widthTmp; ++x) {
                            int ivalue;
                            int n = pos++;
                            int value = pixels[n] - (float)this.min;
                            if (value < 0.0f) {
                                value = (int)0.0f;
                            }
                            if ((ivalue = (int)(value * scale)) > 255) {
                                ivalue = 255;
                            }
                            lutPixels[y * widthTmp + x] = (byte)ivalue;
                        }
                    }
                }
            }
        }
        if ((roi = imp.getRoi()) != null) {
            ImageProcessor mask = roi.getMask();
            this.maskPixels = null;
            if (mask != null) {
                ImageProcessor ipMask = mask.duplicate();
                this.maskPixels = (byte[])ipMask.getPixels();
            }
            Rectangle rect = roi.getBoundingRect();
            if (rect.x < 0) {
                rect.x = 0;
            }
            if (rect.y < 0) {
                rect.y = 0;
            }
            this.widthOrig = rect.width;
            this.heightOrig = rect.height;
            this.pixelsOrigColor = new int[this.widthOrig * this.heightOrig];
            this.pixelsOrigLum = new int[this.widthOrig * this.heightOrig];
            int j = 0;
            for (int y = rect.y; y < rect.y + rect.height; ++y) {
                int offset = y * widthTmp;
                int x = rect.x;
                while (x < rect.x + rect.width) {
                    int lum;
                    int i = offset + x;
                    int c = this.pixelsOrigColor[j] = pixelsTmp[i];
                    if (!isLut) {
                        int r = c >> 16 & 0xFF;
                        int g = c >> 8 & 0xFF;
                        int b = c & 0xFF;
                        lum = (int)(0.299 * (double)r + 0.587 * (double)g + 0.114 * (double)b);
                    } else {
                        lum = 0xFF & lutPixels[i];
                    }
                    this.pixelsOrigLum[j] = lum;
                    ++x;
                    ++j;
                }
            }
        } else {
            this.widthOrig = widthTmp;
            this.heightOrig = heightTmp;
            this.pixelsOrigColor = new int[this.widthOrig * this.heightOrig];
            this.pixelsOrigLum = new int[this.widthOrig * this.heightOrig];
            for (int y = 0; y < heightTmp; ++y) {
                for (int x = 0; x < widthTmp; ++x) {
                    int pos = y * widthTmp + x;
                    int c = this.pixelsOrigColor[pos] = pixelsTmp[pos];
                    int r = c >> 16 & 0xFF;
                    int g = c >> 8 & 0xFF;
                    int b = c & 0xFF;
                    int lum = !isLut ? (int)Math.round(0.299 * (double)r + 0.587 * (double)g + 0.114 * (double)b) : 0xFF & lutPixels[pos];
                    this.pixelsOrigLum[pos] = lum;
                }
            }
        }
    }

    protected void setSurfacePlotImage_orig(ImagePlus imp) {
        Roi roi;
        int widthTmp = imp.getWidth();
        int heightTmp = imp.getHeight();
        ImageProcessor ip = imp.getProcessor();
        this.lut = new Lut();
        int[] pixelsTmp = new int[widthTmp * heightTmp];
        this.image = imp.getImage();
        PixelGrabber pg = new PixelGrabber(this.image, 0, 0, widthTmp, heightTmp, pixelsTmp, 0, widthTmp);
        try {
            pg.grabPixels();
        }
        catch (InterruptedException ex) {
            IJ.error("error grabbing pixels");
        }
        boolean isLut = ip.isColorLut();
        byte[] lutPixels = null;
        int bitDepth = imp.getBitDepth();
        if (isLut) {
            if (bitDepth == 8) {
                lutPixels = (byte[])ip.getPixels();
            } else {
                int x;
                int y;
                int pos;
                Object[] pixels;
                lutPixels = new byte[widthTmp * heightTmp];
                double min_ = ip.getMin();
                double max_ = ip.getMax();
                double a = 0.0;
                double b = 1.0;
                Calibration cal = imp.getCalibration();
                if (cal != null && cal.calibrated()) {
                    min_ = cal.getCValue((int)min_);
                    max_ = cal.getCValue((int)max_);
                    double[] coef = cal.getCoefficients();
                    if (coef != null) {
                        a = coef[0];
                        b = coef[1];
                    }
                }
                float scale = (float)(255.0 / (max_ - min_));
                if (bitDepth == 16) {
                    pixels = (short[])ip.getPixels();
                    pos = 0;
                    for (y = 0; y < heightTmp; ++y) {
                        for (x = 0; x < widthTmp; ++x) {
                            int n = pos++;
                            int val = (int)((double)(0xFFFF & pixels[n]) * b + a - min_);
                            if ((float)val < 0.0f) {
                                val = 0;
                            }
                            if ((val = (int)((float)val * scale)) > 255) {
                                val = 255;
                            }
                            lutPixels[y * widthTmp + x] = (byte)val;
                        }
                    }
                }
                if (bitDepth == 32) {
                    pixels = (float[])ip.getPixels();
                    pos = 0;
                    for (y = 0; y < heightTmp; ++y) {
                        for (x = 0; x < widthTmp; ++x) {
                            int ivalue;
                            int n = pos++;
                            int value = pixels[n] - (float)this.min;
                            if (value < 0.0f) {
                                value = (int)0.0f;
                            }
                            if ((ivalue = (int)(value * scale)) > 255) {
                                ivalue = 255;
                            }
                            lutPixels[y * widthTmp + x] = (byte)ivalue;
                        }
                    }
                }
            }
        }
        if ((roi = imp.getRoi()) != null) {
            ImageProcessor mask = roi.getMask();
            this.maskPixels = null;
            int mWidth = 0;
            if (mask != null) {
                ImageProcessor ipMask = mask.duplicate();
                this.maskPixels = (byte[])ipMask.getPixels();
                mWidth = ipMask.getWidth();
            }
            Rectangle rect = roi.getBoundingRect();
            if (rect.x < 0) {
                rect.x = 0;
            }
            if (rect.y < 0) {
                rect.y = 0;
            }
            this.widthOrig = rect.width;
            this.heightOrig = rect.height;
            this.pixelsOrigColor = new int[this.widthOrig * this.heightOrig];
            this.pixelsOrigLum = new int[this.widthOrig * this.heightOrig];
            int j = 0;
            for (int y = rect.y; y < rect.y + rect.height; ++y) {
                int offset = y * widthTmp;
                int x = rect.x;
                while (x < rect.x + rect.width) {
                    int lum;
                    int c;
                    int i = offset + x;
                    if (mask != null) {
                        int mx = x - rect.x;
                        int my = y - rect.y;
                        c = this.pixelsOrigColor[j] = pixelsTmp[i];
                    } else {
                        c = this.pixelsOrigColor[j] = pixelsTmp[i];
                    }
                    if (!isLut) {
                        int r = c >> 16 & 0xFF;
                        int g = c >> 8 & 0xFF;
                        int b = c & 0xFF;
                        lum = (int)(0.299 * (double)r + 0.587 * (double)g + 0.114 * (double)b);
                    } else {
                        lum = 0xFF & lutPixels[i];
                    }
                    this.pixelsOrigLum[j] = lum;
                    ++x;
                    ++j;
                }
            }
        } else {
            this.widthOrig = widthTmp;
            this.heightOrig = heightTmp;
            this.pixelsOrigColor = new int[this.widthOrig * this.heightOrig];
            this.pixelsOrigLum = new int[this.widthOrig * this.heightOrig];
            for (int y = 0; y < heightTmp; ++y) {
                for (int x = 0; x < widthTmp; ++x) {
                    int pos = y * widthTmp + x;
                    int c = this.pixelsOrigColor[pos] = pixelsTmp[pos];
                    int r = c >> 16 & 0xFF;
                    int g = c >> 8 & 0xFF;
                    int b = c & 0xFF;
                    int lum = !isLut ? (int)Math.round(0.299 * (double)r + 0.587 * (double)g + 0.114 * (double)b) : 0xFF & lutPixels[pos];
                    this.pixelsOrigLum[pos] = lum;
                }
            }
        }
    }

    protected void setSurfacePlotTextureImage(ImagePlus imp) {
        this.widthTex = imp.getWidth();
        this.heightTex = imp.getHeight();
        this.pixelsTexColor = new int[this.widthTex * this.heightTex];
        this.image = imp.getImage();
        PixelGrabber pg = new PixelGrabber(this.image, 0, 0, this.widthTex, this.heightTex, this.pixelsTexColor, 0, this.widthTex);
        try {
            pg.grabPixels();
        }
        catch (InterruptedException ex) {
            IJ.error("error grabbing pixels");
            this.pixelsTexColor = null;
        }
    }

    protected void resample() {
        this.plotList = new SurfacePlotData[this.gridWidth * this.gridHeight];
        if (this.pixelsOrigColor != null && this.pixelsOrigLum != null) {
            double xOffset = this.xCenter;
            double yOffset = this.yCenter;
            double sx = (double)this.widthOrig / (double)this.gridWidth;
            double sy = (double)this.heightOrig / (double)this.gridHeight;
            for (int y = 0; y < this.gridHeight; ++y) {
                int yB = (int)((double)y * sy);
                for (int x = 0; x < this.gridWidth; ++x) {
                    int posGrid = y * this.gridWidth + x;
                    int xB = (int)((double)x * sx);
                    int posOrig = yB * this.widthOrig + xB;
                    this.plotList[posGrid] = new SurfacePlotData();
                    this.plotList[posGrid].color = this.pixelsOrigColor[posOrig];
                    this.plotList[posGrid].x = sx * ((double)x + 0.5) - xOffset;
                    this.plotList[posGrid].y = sy * ((double)y + 0.5) - yOffset;
                    this.plotList[posGrid].zf = this.plotList[posGrid].lum = (double)this.pixelsOrigLum[posOrig] - this.zCenter;
                    this.plotList[posGrid].z = this.plotList[posGrid].lum;
                    if (this.maskPixels != null) {
                        if (this.maskPixels[posOrig] != 0) {
                            this.plotList[posGrid].isVisible = true;
                            continue;
                        }
                        this.plotList[posGrid].isVisible = false;
                        continue;
                    }
                    this.plotList[posGrid].isVisible = true;
                }
            }
        }
        if (this.pixelsTexColor != null) {
            double sx = (double)this.widthTex / (double)this.gridWidth;
            double sy = (double)this.heightTex / (double)this.gridHeight;
            for (int y = 0; y < this.gridHeight; ++y) {
                int yB = (int)((double)y * sy);
                for (int x = 0; x < this.gridWidth; ++x) {
                    int pos = y * this.gridWidth + x;
                    int xB = (int)((double)x * sx);
                    this.plotList[pos].color = this.pixelsTexColor[yB * this.widthTex + xB];
                }
            }
        }
        this.computeNormals();
    }

    private void computeNormals() {
        for (int y = 0; y < this.gridHeight; ++y) {
            for (int x = 0; x < this.gridWidth; ++x) {
                int i = y * this.gridWidth + x;
                double dx1 = 0.0;
                double dy1 = 0.0;
                double dz1 = 0.0;
                for (int y_ = -1; y_ <= 1; ++y_) {
                    int yn = y + y_;
                    if (yn < 0) {
                        yn = 0;
                    }
                    if (yn >= this.gridHeight) {
                        yn = this.gridHeight - 1;
                    }
                    for (int x_ = -1; x_ < 1; ++x_) {
                        int xn1;
                        int xn = x + x_;
                        if (xn < 0) {
                            xn = 0;
                        }
                        if (xn >= this.gridWidth) {
                            xn = this.gridWidth - 1;
                        }
                        if ((xn1 = xn + 1) < 0) {
                            xn1 = 0;
                        }
                        if (xn1 >= this.gridWidth) {
                            xn1 = this.gridWidth - 1;
                        }
                        int posn = yn * this.gridWidth + xn;
                        int posn1 = yn * this.gridWidth + xn1;
                        dx1 += this.plotList[posn1].x - this.plotList[posn].x;
                        dz1 += this.plotList[posn1].z - this.plotList[posn].z;
                    }
                }
                double dx2 = 0.0;
                double dy2 = 0.0;
                double dz2 = 0.0;
                for (int y_ = -1; y_ < 1; ++y_) {
                    int yn1;
                    int yn = y + y_;
                    if (yn < 0) {
                        yn = 0;
                    }
                    if (yn >= this.gridHeight) {
                        yn = this.gridHeight - 1;
                    }
                    if ((yn1 = yn + 1) < 0) {
                        yn1 = 0;
                    }
                    if (yn1 >= this.gridHeight) {
                        yn1 = this.gridHeight - 1;
                    }
                    for (int x_ = -1; x_ <= 1; ++x_) {
                        int xn = x + x_;
                        if (xn < 0) {
                            xn = 0;
                        }
                        if (xn >= this.gridWidth) {
                            xn = this.gridWidth - 1;
                        }
                        int posn = yn * this.gridWidth + xn;
                        int posn1 = yn1 * this.gridWidth + xn;
                        dy2 += this.plotList[posn1].y - this.plotList[posn].y;
                        dz2 += this.plotList[posn1].z - this.plotList[posn].z;
                    }
                }
                double dx = dy1 * dz2 - dz1 * dy2;
                double dy = dz1 * dx2 - dx1 * dz2;
                double dz = dx1 * dy2 - dy1 * dx2;
                double len = Math.sqrt(dx * dx + dy * dy + dz * dz);
                this.plotList[i].dx = dx / len;
                this.plotList[i].dy = dy / len;
                this.plotList[i].dz = dz / len;
            }
        }
    }

    protected void applyMinMax() {
        for (int i = 0; i < this.gridHeight * this.gridWidth; ++i) {
            int add = 0;
            if (this.inversefactor == -1) {
                add = -1;
            }
            double val = 100.0 * (this.plotList[i].zf + this.zCenter - 2.55 * (double)this.min) / (double)(this.max - this.min) - this.zCenter;
            this.plotList[i].z = (double)this.inversefactor * Math.min(Math.max(-128.0, val), 127.0) + (double)add;
        }
        this.computeNormals();
    }

    protected void applySmoothingFilter(double rad) {
        float[] pixels = new float[this.gridHeight * this.gridWidth];
        for (int i = 0; i < this.gridHeight * this.gridWidth; ++i) {
            pixels[i] = (float)this.plotList[i].lum;
        }
        FloatProcessor ip = new FloatProcessor(this.gridWidth, this.gridHeight, pixels, null);
        new GaussianBlur().blur(ip, rad);
        pixels = (float[])((ImageProcessor)ip).getPixels();
        for (int i = 0; i < this.gridHeight * this.gridWidth; ++i) {
            this.plotList[i].z = this.plotList[i].zf = (double)pixels[i];
        }
        this.applyMinMax();
    }

    private int getColor(SurfacePlotData p0) {
        int c0;
        if (this.lutNr == 50) {
            c0 = p0.color;
        } else if (this.lutNr == 58) {
            c0 = (int)(p0.dx * 127.0 + 127.0) << 16 | (int)(p0.dy * 127.0 + 127.0) << 8 | (int)(p0.dz * 127.0 + 127.0);
        } else if (this.lutNr == 59) {
            c0 = (int)(p0.dx2 * 127.0 + 127.0) << 16 | (int)(p0.dy2 * 127.0 + 127.0) << 8 | 0;
        } else {
            int index = (int)(p0.z + 128.0);
            if (index > 255) {
                index = 255;
            }
            if (index < 0) {
                index = 0;
            }
            c0 = this.lut.colors[index];
        }
        return c0;
    }

    private void surfacePlotFilled() {
        for (int row = 0; row < this.gridHeight - 1; ++row) {
            for (int col = 0; col < this.gridWidth - 1; ++col) {
                int i = row * this.gridWidth + col;
                SurfacePlotData p0 = this.plotList[i];
                if (!p0.isVisible) continue;
                SurfacePlotData p1 = this.plotList[i + 1];
                SurfacePlotData p2 = this.plotList[i + this.gridWidth];
                SurfacePlotData p3 = this.plotList[i + this.gridWidth + 1];
                if (!p1.isVisible || !p2.isVisible || !p3.isVisible) continue;
                this.tr.transform(p0);
                double x0 = this.tr.X;
                double y0 = this.tr.Y;
                double z0 = this.tr.Z;
                this.tr.x = p0.dx;
                this.tr.y = p0.dy;
                double light0 = this.tr.getScalarProduct();
                this.tr.transform(p1);
                double x1 = this.tr.X;
                double y1 = this.tr.Y;
                double z1 = this.tr.Z;
                this.tr.x = p1.dx;
                this.tr.y = p1.dy;
                double light1 = this.tr.getScalarProduct();
                this.tr.transform(p2);
                double x2 = this.tr.X;
                double y2 = this.tr.Y;
                double z2 = this.tr.Z;
                this.tr.x = p2.dx;
                this.tr.y = p2.dy;
                double light2 = this.tr.getScalarProduct();
                this.tr.transform(p3);
                double x3 = this.tr.X;
                double y3 = this.tr.Y;
                double z3 = this.tr.Z;
                this.tr.x = p3.dx;
                this.tr.y = p3.dy;
                double light3 = this.tr.getScalarProduct();
                if (x0 >= (double)this.bufferWidth && x0 < 0.0 && y0 >= (double)this.bufferHeight && y0 < 0.0 && x1 >= (double)this.bufferWidth && x1 < 0.0 && y1 >= (double)this.bufferHeight && y1 < 0.0 && x2 >= (double)this.bufferWidth && x2 < 0.0 && y2 >= (double)this.bufferHeight && y2 < 0.0 && x3 >= (double)this.bufferWidth && x3 < 0.0 && y3 >= (double)this.bufferHeight && y3 < 0.0) continue;
                int c0 = this.getColor(p0);
                int c1 = this.getColor(p1);
                int c2 = this.getColor(p2);
                int c3 = this.getColor(p3);
                int r0 = c0 >> 16 & 0xFF;
                int g0 = c0 >> 8 & 0xFF;
                int b0 = c0 & 0xFF;
                int r1 = c1 >> 16 & 0xFF;
                int g1 = c1 >> 8 & 0xFF;
                int b1 = c1 & 0xFF;
                int r2 = c2 >> 16 & 0xFF;
                int g2 = c2 >> 8 & 0xFF;
                int b2 = c2 & 0xFF;
                int r3 = c3 >> 16 & 0xFF;
                int g3 = c3 >> 8 & 0xFF;
                int b3 = c3 & 0xFF;
                double n13 = Math.abs(x1 - x3) + Math.abs(y1 - y3);
                double n02 = Math.abs(x0 - x2) + Math.abs(y0 - y2);
                int stepsY = (int)(Math.max(n13, n02) + 1.0);
                double dy = 1.0 / (double)stepsY;
                double dx02 = (x2 - x0) * dy;
                double dy02 = (y2 - y0) * dy;
                double dx13 = (x3 - x1) * dy;
                double dy13 = (y3 - y1) * dy;
                double x02 = x0;
                double y02 = y0;
                double x13 = x1;
                double y13 = y1;
                double v = 0.0;
                int sy = 0;
                while (sy < stepsY) {
                    int stepsX = (int)(Math.abs((x02 += dx02) - (x13 += dx13)) + Math.abs((y02 += dy02) - (y13 += dy13)) + 1.0);
                    double dx = 1.0 / (double)stepsX;
                    double dx0213 = (x13 - x02) * dx;
                    double dy0213 = (y13 - y02) * dx;
                    double x0213 = x02;
                    double y0213 = y02;
                    double h = 0.0;
                    int sx = 0;
                    while (sx < stepsX) {
                        int pos;
                        x0213 += dx0213;
                        y0213 += dy0213;
                        double d0 = (1.0 - h) * (1.0 - v);
                        double d1 = h * (1.0 - v);
                        double d2 = (1.0 - h) * v;
                        double d3 = h * v;
                        double z = d0 * z0 + d1 * z1 + d2 * z2 + d3 * z3;
                        if (x0213 >= 0.0 && x0213 < (double)this.bufferWidth && y0213 >= 0.0 && y0213 < (double)this.bufferHeight && z < this.zbufferPixels[pos = (int)y0213 * this.bufferWidth + (int)x0213]) {
                            this.zbufferPixels[pos] = z;
                            int r = (int)((double)r3 * d3 + (double)r2 * d2 + (double)r1 * d1 + (double)r0 * d0);
                            int g = (int)((double)g3 * d3 + (double)g2 * d2 + (double)g1 * d1 + (double)g0 * d0);
                            int b = (int)((double)b3 * d3 + (double)b2 * d2 + (double)b1 * d1 + (double)b0 * d0);
                            double light0123 = d3 * light3 + d2 * light2 + d1 * light1 + d0 * light0;
                            double l = -this.light * light0123 * 255.0;
                            r = (int)Math.min(255.0, Math.max(0.0, (double)r + l));
                            g = (int)Math.min(255.0, Math.max(0.0, (double)g + l));
                            b = (int)Math.min(255.0, Math.max(0.0, (double)b + l));
                            this.bufferPixels[pos] = 0xFF000000 | r << 16 | g << 8 | b;
                        }
                        ++sx;
                        h += dx;
                    }
                    ++sy;
                    v += dy;
                }
            }
        }
    }

    private void surfacePlotIsoLines() {
        for (int row = 0; row < this.gridHeight - 1; ++row) {
            for (int col = 0; col < this.gridWidth - 1; ++col) {
                int i = row * this.gridWidth + col;
                SurfacePlotData p0 = this.plotList[i];
                if (!p0.isVisible) continue;
                SurfacePlotData p1 = this.plotList[i + 1];
                SurfacePlotData p2 = this.plotList[i + this.gridWidth];
                SurfacePlotData p3 = this.plotList[i + this.gridWidth + 1];
                if (!p1.isVisible || !p2.isVisible || !p3.isVisible) continue;
                this.tr.transform(p0);
                double x0 = this.tr.X;
                double y0 = this.tr.Y;
                double z0 = this.tr.Z;
                this.tr.x = p0.dx;
                this.tr.y = p0.dy;
                double light0 = this.tr.getScalarProduct();
                this.tr.transform(p1);
                double x1 = this.tr.X;
                double y1 = this.tr.Y;
                double z1 = this.tr.Z;
                this.tr.x = p1.dx;
                this.tr.y = p1.dy;
                double light1 = this.tr.getScalarProduct();
                this.tr.transform(p2);
                double x2 = this.tr.X;
                double y2 = this.tr.Y;
                double z2 = this.tr.Z;
                this.tr.x = p2.dx;
                this.tr.y = p2.dy;
                double light2 = this.tr.getScalarProduct();
                this.tr.transform(p3);
                double x3 = this.tr.X;
                double y3 = this.tr.Y;
                double z3 = this.tr.Z;
                this.tr.x = p3.dx;
                this.tr.y = p3.dy;
                double light3 = this.tr.getScalarProduct();
                if (x0 >= (double)this.bufferWidth && x0 < 0.0 && y0 >= (double)this.bufferHeight && y0 < 0.0 && x1 >= (double)this.bufferWidth && x1 < 0.0 && y1 >= (double)this.bufferHeight && y1 < 0.0 && x2 >= (double)this.bufferWidth && x2 < 0.0 && y2 >= (double)this.bufferHeight && y2 < 0.0 && x3 >= (double)this.bufferWidth && x3 < 0.0 && y3 >= (double)this.bufferHeight && y3 < 0.0) continue;
                int c0 = this.getColor(p0);
                int c1 = this.getColor(p1);
                int c2 = this.getColor(p2);
                int c3 = this.getColor(p3);
                double lum0 = p0.z;
                double lum1 = p1.z;
                double lum2 = p2.z;
                double lum3 = p3.z;
                int r0 = c0 >> 16 & 0xFF;
                int g0 = c0 >> 8 & 0xFF;
                int b0 = c0 & 0xFF;
                int r1 = c1 >> 16 & 0xFF;
                int g1 = c1 >> 8 & 0xFF;
                int b1 = c1 & 0xFF;
                int r2 = c2 >> 16 & 0xFF;
                int g2 = c2 >> 8 & 0xFF;
                int b2 = c2 & 0xFF;
                int r3 = c3 >> 16 & 0xFF;
                int g3 = c3 >> 8 & 0xFF;
                int b3 = c3 & 0xFF;
                double n13 = Math.abs(x1 - x3) + Math.abs(y1 - y3);
                double n02 = Math.abs(x0 - x2) + Math.abs(y0 - y2);
                int stepsY = (int)(Math.max(n13, n02) + 1.0);
                double dy = 1.0 / (double)stepsY;
                double dx02 = (x2 - x0) * dy;
                double dy02 = (y2 - y0) * dy;
                double dx13 = (x3 - x1) * dy;
                double dy13 = (y3 - y1) * dy;
                double x02 = x0;
                double y02 = y0;
                double x13 = x1;
                double y13 = y1;
                double v = 0.0;
                int sy = 0;
                while (sy < stepsY) {
                    int stepsX = (int)(Math.abs((x02 += dx02) - (x13 += dx13)) + Math.abs((y02 += dy02) - (y13 += dy13)) + 1.0);
                    double dx = 1.0 / (double)stepsX;
                    double dx0213 = (x13 - x02) * dx;
                    double dy0213 = (y13 - y02) * dx;
                    double x0213 = x02;
                    double y0213 = y02;
                    double h = 0.0;
                    int sx = 0;
                    while (sx < stepsX) {
                        double lum;
                        int pos;
                        x0213 += dx0213;
                        y0213 += dy0213;
                        double d0 = (1.0 - h) * (1.0 - v);
                        double d1 = h * (1.0 - v);
                        double d2 = (1.0 - h) * v;
                        double d3 = h * v;
                        double z = d0 * z0 + d1 * z1 + d2 * z2 + d3 * z3;
                        if (x0213 >= 0.0 && x0213 < (double)this.bufferWidth && y0213 >= 0.0 && y0213 < (double)this.bufferHeight && z < this.zbufferPixels[pos = (int)y0213 * this.bufferWidth + (int)x0213] && (lum = d0 * lum0 + d1 * lum1 + d2 * lum2 + d3 * lum3 + 132.0) - (double)(12 * (int)(lum / 12.0)) < 1.5) {
                            this.zbufferPixels[pos] = z;
                            int r = (int)((double)r3 * d3 + (double)r2 * d2 + (double)r1 * d1 + (double)r0 * d0);
                            int g = (int)((double)g3 * d3 + (double)g2 * d2 + (double)g1 * d1 + (double)g0 * d0);
                            int b = (int)((double)b3 * d3 + (double)b2 * d2 + (double)b1 * d1 + (double)b0 * d0);
                            double light0123 = d3 * light3 + d2 * light2 + d1 * light1 + d0 * light0;
                            double l = -this.light * light0123 * 255.0;
                            r = (int)Math.min(255.0, Math.max(0.0, (double)r + l));
                            g = (int)Math.min(255.0, Math.max(0.0, (double)g + l));
                            b = (int)Math.min(255.0, Math.max(0.0, (double)b + l));
                            this.bufferPixels[pos] = 0xFF000000 | r << 16 | g << 8 | b;
                        }
                        ++sx;
                        h += dx;
                    }
                    ++sy;
                    v += dy;
                }
            }
        }
    }

    private void surfacePlotMesh() {
        for (int row = 0; row < this.gridHeight; ++row) {
            for (int col = 0; col < this.gridWidth; ++col) {
                SurfacePlotData p2;
                SurfacePlotData p1;
                int i = row * this.gridWidth + col;
                SurfacePlotData p0 = this.plotList[i];
                if (!p0.isVisible) continue;
                this.tr.transform(p0);
                double x0 = this.tr.X;
                double y0 = this.tr.Y;
                double z0 = this.tr.Z;
                int c0 = this.getColor(p0);
                int r0 = c0 >> 16 & 0xFF;
                int g0 = c0 >> 8 & 0xFF;
                int b0 = c0 & 0xFF;
                SurfacePlotData surfacePlotData = p1 = col < this.gridWidth - 1 ? this.plotList[i + 1] : this.plotList[i];
                if (p1.isVisible) {
                    this.tr.transform(p1);
                    double x1 = this.tr.X;
                    double y1 = this.tr.Y;
                    double z1 = this.tr.Z;
                    double dx10 = x1 - x0;
                    double dy10 = y1 - y0;
                    double dz10 = z1 - z0;
                    int c1 = this.getColor(p1);
                    int r1 = c1 >> 16 & 0xFF;
                    int g1 = c1 >> 8 & 0xFF;
                    int b1 = c1 & 0xFF;
                    int numSteps = (int)(Math.max(Math.abs(dx10), Math.abs(dy10)) + 1.0);
                    double step = 1.0 / (double)numSteps;
                    for (int s = 0; s < numSteps; ++s) {
                        int pos;
                        int z;
                        double f = (double)s * step;
                        int x = (int)(x0 + f * dx10);
                        int y = (int)(y0 + f * dy10);
                        if (x < 0 || y < 0 || x >= this.bufferWidth || y >= this.bufferHeight || !((double)(z = (int)(z0 + f * dz10)) < this.zbufferPixels[pos = y * this.bufferWidth + x])) continue;
                        this.zbufferPixels[pos] = z;
                        int r = (int)(f * (double)r1 + (1.0 - f) * (double)r0);
                        int g = (int)(f * (double)g1 + (1.0 - f) * (double)g0);
                        int b = (int)(f * (double)b1 + (1.0 - f) * (double)b0);
                        this.tr.x = p0.dx;
                        this.tr.y = p0.dy;
                        double l = -this.light * this.tr.getScalarProduct() * 255.0;
                        r = (int)Math.min(255.0, Math.max(0.0, (double)r + l));
                        g = (int)Math.min(255.0, Math.max(0.0, (double)g + l));
                        b = (int)Math.min(255.0, Math.max(0.0, (double)b + l));
                        this.bufferPixels[pos] = 0xFF000000 | r << 16 | g << 8 | b;
                    }
                }
                SurfacePlotData surfacePlotData2 = p2 = row < this.gridHeight - 1 ? this.plotList[i + this.gridWidth] : this.plotList[i];
                if (!p2.isVisible) continue;
                this.tr.transform(p2);
                double x2 = this.tr.X;
                double y2 = this.tr.Y;
                double z2 = this.tr.Z;
                double dx20 = x2 - x0;
                double dy20 = y2 - y0;
                double dz20 = z2 - z0;
                int c2 = this.getColor(p2);
                int r2 = c2 >> 16 & 0xFF;
                int g2 = c2 >> 8 & 0xFF;
                int b2 = c2 & 0xFF;
                int numSteps = (int)(Math.max(Math.abs(dx20), Math.abs(dy20)) + 1.0);
                double step = 1.0 / (double)numSteps;
                for (int s = 0; s < numSteps; ++s) {
                    int pos;
                    int z;
                    double f = (double)s * step;
                    int x = (int)(x0 + f * dx20);
                    int y = (int)(y0 + f * dy20);
                    if (x < 0 || y < 0 || x >= this.bufferWidth || y >= this.bufferHeight || !((double)(z = (int)(z0 + f * dz20)) < this.zbufferPixels[pos = y * this.bufferWidth + x])) continue;
                    this.zbufferPixels[pos] = z;
                    int r = (int)(f * (double)r2 + (1.0 - f) * (double)r0);
                    int g = (int)(f * (double)g2 + (1.0 - f) * (double)g0);
                    int b = (int)(f * (double)b2 + (1.0 - f) * (double)b0);
                    this.tr.x = p0.dx;
                    this.tr.y = p0.dy;
                    double l = -this.light * this.tr.getScalarProduct() * 255.0;
                    r = (int)Math.min(255.0, Math.max(0.0, (double)r + l));
                    g = (int)Math.min(255.0, Math.max(0.0, (double)g + l));
                    b = (int)Math.min(255.0, Math.max(0.0, (double)b + l));
                    this.bufferPixels[pos] = 0xFF000000 | r << 16 | g << 8 | b;
                }
            }
        }
    }

    private void surfacePlotLines() {
        for (int row = 0; row < this.gridHeight; ++row) {
            for (int col = 0; col < this.gridWidth - 1; ++col) {
                int i = row * this.gridWidth + col;
                SurfacePlotData p0 = this.plotList[i];
                SurfacePlotData p1 = this.plotList[i + 1];
                if (!p0.isVisible || !p1.isVisible) continue;
                this.tr.transform(p0);
                double x0 = this.tr.X;
                double y0 = this.tr.Y;
                double z0 = this.tr.Z;
                int c0 = this.getColor(p0);
                int r0 = c0 >> 16 & 0xFF;
                int g0 = c0 >> 8 & 0xFF;
                int b0 = c0 & 0xFF;
                this.tr.transform(p1);
                double x1 = this.tr.X;
                double y1 = this.tr.Y;
                double z1 = this.tr.Z;
                double dx1 = x1 - x0;
                double dy1 = y1 - y0;
                double dz1 = z1 - z0;
                int numSteps = (int)(Math.max(Math.abs(dx1), Math.abs(dy1)) + 1.0);
                int c1 = this.getColor(p1);
                int r1 = c1 >> 16 & 0xFF;
                int g1 = c1 >> 8 & 0xFF;
                int b1 = c1 & 0xFF;
                double step = 1.0 / (double)numSteps;
                for (int s = 0; s < numSteps; ++s) {
                    int pos;
                    double z;
                    double f = (double)s * step;
                    int x = (int)(x0 + f * dx1);
                    int y = (int)(y0 + f * dy1);
                    if (x < 0 || y < 0 || x >= this.bufferWidth || y >= this.bufferHeight || !((z = z0 + f * dz1) < this.zbufferPixels[pos = y * this.bufferWidth + x])) continue;
                    this.zbufferPixels[pos] = z;
                    int r = (int)((1.0 - f) * (double)r0 + f * (double)r1);
                    int g = (int)((1.0 - f) * (double)g0 + f * (double)g1);
                    int b = (int)((1.0 - f) * (double)b0 + f * (double)b1);
                    this.tr.x = p0.dx;
                    this.tr.y = p0.dy;
                    double l = -this.light * this.tr.getScalarProduct() * 255.0;
                    r = (int)Math.min(255.0, Math.max(0.0, (double)r + l));
                    g = (int)Math.min(255.0, Math.max(0.0, (double)g + l));
                    b = (int)Math.min(255.0, Math.max(0.0, (double)b + l));
                    this.bufferPixels[pos] = 0xFF000000 | r << 16 | g << 8 | b;
                }
            }
        }
    }

    private void surfacePlotDots() {
        for (int i = this.plotList.length - 1; i >= 0; --i) {
            int pos;
            int z;
            SurfacePlotData p0 = this.plotList[i];
            if (!p0.isVisible) continue;
            this.tr.transform(p0);
            int x = (int)this.tr.X;
            int y = (int)this.tr.Y;
            if (x < 0 || y < 0 || x >= this.bufferWidth || y >= this.bufferHeight || !((double)(z = (int)this.tr.Z) < this.zbufferPixels[pos = y * this.bufferWidth + x])) continue;
            this.zbufferPixels[pos] = z;
            int c0 = this.getColor(p0);
            int r0 = c0 >> 16 & 0xFF;
            int g0 = c0 >> 8 & 0xFF;
            int b0 = c0 & 0xFF;
            this.tr.x = p0.dx;
            this.tr.y = p0.dy;
            double l = -this.light * this.tr.getScalarProduct() * 255.0;
            int r = (int)Math.min(255.0, Math.max(0.0, (double)r0 + l));
            int g = (int)Math.min(255.0, Math.max(0.0, (double)g0 + l));
            int b = (int)Math.min(255.0, Math.max(0.0, (double)b0 + l));
            this.bufferPixels[pos] = 0xFF000000 | r << 16 | g << 8 | b;
        }
    }

    private void surfacePlotDotsNoLight() {
        int delta = Math.max(this.gridHeight, this.gridWidth) / 128;
        if (delta < 1) {
            delta = 1;
        }
        for (int row = 0; row < this.gridHeight; row += delta) {
            for (int col = 0; col < this.gridWidth; col += delta) {
                int pos;
                int z;
                int i = row * this.gridWidth + col;
                SurfacePlotData p0 = this.plotList[i];
                if (!p0.isVisible) continue;
                this.tr.transform(p0);
                int x = (int)this.tr.X;
                int y = (int)this.tr.Y;
                if (x < 0 || y < 0 || x >= this.bufferWidth - 1 || y >= this.bufferHeight - 1 || !((double)(z = (int)this.tr.Z) < this.zbufferPixels[pos = y * this.bufferWidth + x])) continue;
                int c0 = 0xFF000000 | this.getColor(p0);
                this.zbufferPixels[pos] = z;
                this.zbufferPixels[pos + 1] = z;
                this.zbufferPixels[pos + this.bufferWidth] = z;
                this.zbufferPixels[pos + this.bufferWidth + 1] = z;
                this.bufferPixels[pos] = c0;
                this.bufferPixels[pos + 1] = c0;
                this.bufferPixels[pos + this.bufferWidth] = c0;
                this.bufferPixels[pos + this.bufferWidth + 1] = c0;
            }
        }
    }

    protected void setSurfacePLotSetLight(double light) {
        this.light = light;
    }

    protected void setSurfaceGridSize(int width, int height) {
        this.gridWidth = width;
        this.gridHeight = height;
    }

    protected void setSurfacePlotMode(int surfacePlotMode) {
        this.surfacePlotMode = surfacePlotMode;
    }

    protected void setBuffers(int[] bufferPixels, double[] zbufferPixels, int bufferWidth, int bufferHeight) {
        this.bufferPixels = bufferPixels;
        this.zbufferPixels = zbufferPixels;
        this.bufferWidth = bufferWidth;
        this.bufferHeight = bufferHeight;
    }

    protected void setTransform(Transform transform) {
        this.tr = transform;
    }

    protected void setSurfacePlotCenter(double xCenter, double yCenter, double zCenter) {
        this.xCenter = xCenter;
        this.yCenter = yCenter;
        this.zCenter = zCenter;
    }

    protected void setSurfacePlotLut(int lutNr) {
        this.lutNr = lutNr;
        if (this.lut != null) {
            this.lut.setLut(lutNr);
        }
    }

    protected void setMinMax(int min, int max) {
        this.min = min;
        this.max = max;
    }

    protected void setInverse(boolean b) {
        this.inversefactor = b ? -1 : 1;
        for (int i = 0; i < this.plotList.length; ++i) {
            this.plotList[i].z = (double)this.inversefactor * this.plotList[i].zf;
        }
    }
}

