/*
 * Decompiled with CFR 0.152.
 */
package nom.tam.fits;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.List;
import java.util.Map;
import nom.tam.fits.FitsException;
import nom.tam.util.RandomAccess;

public class FitsUtil {
    public static void reposition(Object o, long offset) throws FitsException {
        if (o == null) {
            throw new FitsException("Attempt to reposition null stream");
        }
        if (!(o instanceof RandomAccess) || offset < 0L) {
            throw new FitsException("Invalid attempt to reposition stream " + o + " of type " + o.getClass().getName() + " to " + offset);
        }
        try {
            ((RandomAccess)o).seek(offset);
        }
        catch (IOException e) {
            throw new FitsException("Unable to repostion stream " + o + " of type " + o.getClass().getName() + " to " + offset + "   Exception:" + e);
        }
    }

    public static long findOffset(Object o) {
        if (o instanceof RandomAccess) {
            return ((RandomAccess)o).getFilePointer();
        }
        return -1L;
    }

    public static int padding(int size) {
        int mod = size % 2880;
        if (mod > 0) {
            mod = 2880 - mod;
        }
        return mod;
    }

    public static int addPadding(int size) {
        return size + FitsUtil.padding(size);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isCompressed(String filename) {
        int len;
        if (filename == null) {
            return false;
        }
        FileInputStream fis = null;
        try {
            File test = new File(filename);
            if (test.exists()) {
                fis = new FileInputStream(test);
                if (fis.read() == 31 && fis.read() == 139) {
                    boolean bl = true;
                    return bl;
                }
                boolean bl = false;
                return bl;
            }
        }
        catch (IOException e) {
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (IOException e) {}
            }
        }
        return (len = filename.length()) > 2 && filename.substring(len - 3).equalsIgnoreCase(".gz");
    }

    public static int maxLength(String[] o) throws FitsException {
        int max = 0;
        for (int i = 0; i < o.length; ++i) {
            if (o[i] == null || o[i].length() <= max) continue;
            max = o[i].length();
        }
        return max;
    }

    public static byte[] stringsToByteArray(String[] o, int maxLen) {
        byte[] res = new byte[o.length * maxLen];
        for (int i = 0; i < o.length; ++i) {
            byte[] bstr = o[i] == null ? new byte[]{} : o[i].getBytes();
            int cnt = bstr.length;
            if (cnt > maxLen) {
                cnt = maxLen;
            }
            System.arraycopy(bstr, 0, res, i * maxLen, cnt);
            for (int j = cnt; j < maxLen; ++j) {
                res[i * maxLen + j] = 32;
            }
        }
        return res;
    }

    public static String[] byteArrayToStrings(byte[] o, int maxLen) {
        String[] res = new String[o.length / maxLen];
        for (int i = 0; i < res.length; ++i) {
            res[i] = new String(o, i * maxLen, maxLen).trim();
        }
        return res;
    }

    static byte[] booleanToByte(boolean[] bool) {
        byte[] byt = new byte[bool.length];
        for (int i = 0; i < bool.length; ++i) {
            byt[i] = bool[i] ? 84 : 70;
        }
        return byt;
    }

    static boolean[] byteToBoolean(byte[] byt) {
        boolean[] bool = new boolean[byt.length];
        for (int i = 0; i < byt.length; ++i) {
            bool[i] = byt[i] == 84;
        }
        return bool;
    }

    public static InputStream getURLStream(URL url, int level) throws IOException {
        if (level > 5) {
            throw new IOException("Two many levels of redirection in URL");
        }
        URLConnection conn = url.openConnection();
        Map<String, List<String>> hdrs = conn.getHeaderFields();
        for (String key : hdrs.keySet()) {
            String val;
            if (key == null || !key.toLowerCase().equals("location") || (val = hdrs.get(key).get(0)) == null || (val = val.trim()).length() <= 0) continue;
            return FitsUtil.getURLStream(new URL(val), level + 1);
        }
        return conn.getInputStream();
    }
}

