/*
 * Decompiled with CFR 0.152.
 */
package skyview.geometry;

import skyview.Component;
import skyview.geometry.Rotater;
import skyview.geometry.SphereDistorter;
import skyview.geometry.csys.BesselianCoordinateSystem;
import skyview.geometry.csys.EclipticCoordinateSystem;
import skyview.geometry.csys.GalacticCoordinateSystem;
import skyview.geometry.csys.HelioeclipticCoordinateSystem;
import skyview.geometry.csys.ICRSCoordinateSystem;
import skyview.geometry.csys.JulianCoordinateSystem;

public abstract class CoordinateSystem
implements Component {
    public static final CoordinateSystem J2000 = new JulianCoordinateSystem(2000.0);
    public static final CoordinateSystem B1950 = new BesselianCoordinateSystem(1950.0);
    public static final CoordinateSystem Galactic = new GalacticCoordinateSystem();
    public static final CoordinateSystem ICRS = new ICRSCoordinateSystem();

    public abstract Rotater getRotater();

    public SphereDistorter getSphereDistorter() {
        return null;
    }

    public static CoordinateSystem factory(String name) {
        return CoordinateSystem.factory(name, null);
    }

    public static CoordinateSystem factory(String name, String equinox) {
        if ((name = name.toUpperCase()).equals("ICRS")) {
            return ICRS;
        }
        char c = name.charAt(0);
        if (c == 'G') {
            return Galactic;
        }
        String sepoch = name.substring(1);
        double epoch = -1.0;
        try {
            epoch = Double.parseDouble(name.substring(1));
        }
        catch (Exception e) {
            try {
                if (equinox != null) {
                    epoch = Double.parseDouble(equinox);
                }
            }
            catch (Exception f) {
                // empty catch block
            }
        }
        switch (c) {
            case 'J': {
                if (epoch < 0.0) {
                    epoch = 2000.0;
                }
                return new JulianCoordinateSystem(epoch);
            }
            case 'B': {
                if (epoch < 0.0) {
                    epoch = 1950.0;
                }
                return new BesselianCoordinateSystem(epoch);
            }
            case 'E': {
                return new EclipticCoordinateSystem(epoch);
            }
            case 'H': {
                return new HelioeclipticCoordinateSystem(epoch);
            }
        }
        return null;
    }
}

