/*
 * Decompiled with CFR 0.152.
 */
package skyview.geometry;

import skyview.geometry.Distorter;
import skyview.geometry.Projecter;
import skyview.geometry.Rotater;
import skyview.geometry.TransformationException;

public class Projection {
    private double[] refProj = new double[]{0.0, 1.5707963267948966};
    private Rotater rotation;
    private Projecter proj;
    private Distorter dist = null;

    public Rotater getRotater() {
        return this.rotation;
    }

    public void setRotater(Rotater rot) {
        this.rotation = rot;
    }

    public Projecter getProjecter() {
        return this.proj;
    }

    public Distorter getDistorter() {
        return this.dist;
    }

    protected void setDistorter(Distorter dist) {
        this.dist = dist;
    }

    protected double[] specialReference() {
        return null;
    }

    public Projection(String type) throws TransformationException {
        if (!(type.equals("Car") || type.equals("Ait") || type.equals("Csc"))) {
            throw new TransformationException("Invalid non-parametrized projection:" + type);
        }
        String projClass = "skyview.geometry.projecter." + type + "Projecter";
        try {
            this.proj = (Projecter)Class.forName(projClass).newInstance();
        }
        catch (Exception e) {
            throw new TransformationException("Error creating non-parametrized projection:" + type);
        }
        this.rotation = null;
    }

    public Projection(String type, double[] reference) throws TransformationException {
        String projClass = "skyview.geometry.projecter." + type + "Projecter";
        try {
            this.proj = (Projecter)Class.forName(projClass).newInstance();
        }
        catch (Exception e) {
            throw new TransformationException("Cannot create parametrized projection:" + type + "\n" + e);
        }
        this.rotation = new Rotater("ZYZ", reference[0], -reference[1] + 1.5707963267948966, 1.5707963267948966);
        if (this.specialReference() != null) {
            double[] spec = this.specialReference();
            this.rotation = this.rotation.add(new Rotater("ZYZ", spec[0], spec[1], spec[2]));
        }
    }
}

