/*
 * Decompiled with CFR 0.152.
 */
package skyview.geometry;

import skyview.Component;
import skyview.geometry.TransformationException;
import skyview.geometry.Transformer;

public class Scaler
extends Transformer
implements Component {
    double x0 = 0.0;
    double y0 = 0.0;
    double a00 = 1.0;
    double a01 = 0.0;
    double a10 = 0.0;
    double a11 = 1.0;

    public Scaler(double x0, double y0, double a00, double a01, double a10, double a11) {
        this.x0 = x0;
        this.y0 = y0;
        this.a00 = a00;
        this.a01 = a01;
        this.a10 = a10;
        this.a11 = a11;
    }

    public double[] getParams() {
        return new double[]{this.x0, this.y0, this.a00, this.a01, this.a10, this.a11};
    }

    @Override
    protected int getOutputDimension() {
        return 2;
    }

    @Override
    protected int getInputDimension() {
        return 2;
    }

    @Override
    public String getName() {
        return "Scaler";
    }

    @Override
    public String getDescription() {
        return "General Affine Transformation for 2-d points";
    }

    @Override
    public void transform(double[] x, double[] y) {
        double t = this.x0 + this.a00 * x[0] + this.a01 * x[1];
        y[1] = this.y0 + this.a10 * x[0] + this.a11 * x[1];
        y[0] = t;
    }

    @Override
    public Scaler inverse() throws TransformationException {
        double sum = Math.abs(this.a00) + Math.abs(this.a01) + Math.abs(this.a10) + Math.abs(this.a11);
        if (sum == 0.0) {
            throw new TransformationException("Zero matrix in Scaler");
        }
        double det = this.a00 * this.a11 - this.a01 * this.a10;
        if (det == 0.0) {
            throw new TransformationException("Non-invertible transformation in Scaler");
        }
        if (Math.abs(det) / Math.abs(sum) < 1.0E-10) {
            System.err.println("Scaler transformation is likely not invertible");
        }
        return new Scaler(-this.x0 * this.a11 / det + this.y0 * this.a01 / det, this.x0 * this.a10 / det - this.y0 * this.a00 / det, this.a11 / det, -this.a01 / det, -this.a10 / det, this.a00 / det);
    }

    public Scaler add(Scaler trans) {
        if (trans == null) {
            return new Scaler(this.x0, this.y0, this.a00, this.a01, this.a10, this.a11);
        }
        return new Scaler(trans.x0 + trans.a00 * this.x0 + trans.a01 * this.y0, trans.y0 + trans.a10 * this.x0 + trans.a11 * this.y0, trans.a00 * this.a00 + trans.a01 * this.a10, trans.a00 * this.a01 + trans.a01 * this.a11, trans.a10 * this.a00 + trans.a11 * this.a10, trans.a10 * this.a01 + trans.a11 * this.a11);
    }

    @Override
    public boolean isInverse(Transformer trans) {
        if (!(trans instanceof Scaler)) {
            return false;
        }
        Scaler sum = this.add((Scaler)trans);
        return sum.isUnit();
    }

    public double scale() {
        return Math.sqrt((this.a00 + this.a01) * (this.a00 + this.a01) + (this.a10 + this.a11) * (this.a10 + this.a11)) / Math.sqrt(2.0);
    }

    public void interchangeAxes() {
        double temp = this.x0;
        this.x0 = this.y0;
        this.y0 = temp;
        temp = this.a00;
        this.a00 = this.a10;
        this.a10 = temp;
        temp = this.a01;
        this.a01 = this.a11;
        this.a11 = temp;
    }

    private boolean isUnit() {
        return Math.abs(this.x0) + Math.abs(this.y0) + Math.abs(this.a01) + Math.abs(this.a10) + Math.abs(1.0 - this.a00) + Math.abs(1.0 - this.a11) < 1.0E-10;
    }
}

