/*
 * Decompiled with CFR 0.152.
 */
package skyview.geometry.csys;

import skyview.Component;
import skyview.geometry.CoordinateSystem;
import skyview.geometry.Rotater;
import skyview.geometry.SphereDistorter;
import skyview.geometry.spheredistorter.BesselianDistorter;

public class BesselianCoordinateSystem
extends CoordinateSystem
implements Component {
    private static final double D2PI = Math.PI * 2;
    private static final double pmf = 2.0626480624709636E7;
    private double epoch;

    public BesselianCoordinateSystem(double epoch) {
        this.epoch = epoch;
    }

    public boolean isRotation() {
        return false;
    }

    @Override
    public String getName() {
        return "B" + this.epoch;
    }

    @Override
    public String getDescription() {
        return "A Beseelian (FK4 based) equatorial coordinate system.  Dynamic terms are not included.";
    }

    @Override
    public Rotater getRotater() {
        return this.precession(this.epoch);
    }

    @Override
    public SphereDistorter getSphereDistorter() {
        return new BesselianDistorter();
    }

    private Rotater precession(double epoch) {
        double DAS2R = 4.84813681109536E-6;
        double bigt = 1.0;
        double t = (epoch - 1950.0) / 100.0;
        double tas2r = t * DAS2R;
        double w = 2303.5548 + (1.3972 + 5.9E-5 * bigt) * bigt;
        double zeta = (w + (0.30242 - 2.69E-4 * bigt + 0.017996 * t) * t) * tas2r;
        double z = (w + (1.09478 + 3.87E-4 * bigt + 0.018324 * t) * t) * tas2r;
        double theta = (2005.1125 + (-0.85294 - 3.65E-4 * bigt) * bigt + (-0.42647 - 3.65E-4 * bigt - 0.041802 * t) * t) * tas2r;
        return new Rotater("ZYZ", -zeta, theta, -z);
    }
}

