/*
 * Decompiled with CFR 0.152.
 */
package skyview.geometry.csys;

import skyview.Component;
import skyview.geometry.CoordinateSystem;
import skyview.geometry.Rotater;
import skyview.geometry.csys.JulianCoordinateSystem;

public class EclipticCoordinateSystem
extends CoordinateSystem
implements Component {
    private double epoch;
    private double elon;

    @Override
    public String getName() {
        return "E" + this.epoch;
    }

    @Override
    public String getDescription() {
        return "A coordinate system with the ecliptic as the equator at epoch of equinox" + this.epoch;
    }

    public EclipticCoordinateSystem(double epoch) {
        this(epoch, 0.0);
    }

    protected EclipticCoordinateSystem(double epoch, double elon) {
        this.epoch = epoch;
        this.elon = elon;
    }

    @Override
    public Rotater getRotater() {
        double DAS2R = 4.84813681109536E-6;
        double t = (this.epoch - 2000.0) / 100.0;
        double eps0 = DAS2R * (84381.448 + (-46.815 + (-5.9E-4 + 0.001813 * t) * t) * t);
        Rotater r1 = new JulianCoordinateSystem(this.epoch).getRotater();
        Rotater r2 = new Rotater("XZ", eps0, this.elon, 0.0);
        if (r1 == null) {
            return r2;
        }
        return r1.add(r2);
    }
}

