/*
 * Decompiled with CFR 0.152.
 */
package skyview.geometry.csys;

import skyview.Component;
import skyview.geometry.csys.EclipticCoordinateSystem;

public class HelioeclipticCoordinateSystem
extends EclipticCoordinateSystem
implements Component {
    private double epoch;

    @Override
    public String getName() {
        return "H" + this.epoch;
    }

    @Override
    public String getDescription() {
        return "A coordinate system with the equator along  the ecliptic and the Sun at the center. The position of the sun is inferred from the epoch.";
    }

    public HelioeclipticCoordinateSystem(double epoch) {
        super(epoch, HelioeclipticCoordinateSystem.sunlong(epoch));
        this.epoch = epoch;
    }

    public static double sunlong(double epoch) {
        double dtor = 0.017453292519444445;
        double t = ((epoch - 2000.0) * 365.25 + 2451544.5 - 2415020.0) / 36525.0;
        double l = (279.696678 + 36000.768925 * t % 360.0) * 3600.0;
        double me = 358.475844 + 35999.04975 * t % 360.0;
        double ellcor = (6910.1 - 17.2 * t) * Math.sin(me * dtor) + 72.3 * Math.sin(2.0 * me * dtor);
        l += ellcor;
        double mv = 212.603219 + 58517.803875 * t % 360.0;
        double vencorr = 4.8 * Math.cos((299.1017 + mv - me) * dtor) + 5.5 * Math.cos((148.3133 + 2.0 * mv - 2.0 * me) * dtor) + 2.5 * Math.cos((315.9433 + 2.0 * mv - 3.0 * me) * dtor) + 1.6 * Math.cos((345.2533 + 3.0 * mv - 4.0 * me) * dtor) + 1.0 * Math.cos((318.15 + 3.0 * mv - 5.0 * me) * dtor);
        l += vencorr;
        double mm = 319.529425 + 19139.8585 * t % 360.0;
        double marscorr = 2.0 * Math.cos((343.8883 - 2.0 * mm + 2.0 * me) * dtor) + 1.8 * Math.cos((200.4017 - 2.0 * mm + me) * dtor);
        l += marscorr;
        double mj = 225.328328 + 3034.6920239 * t % 360.0;
        double jupcorr = 7.2 * Math.cos((179.5317 - mj + me) * dtor) + 2.6 * Math.cos((263.2167 - mj) * dtor) + 2.7 * Math.cos((87.145 - 2.0 * mj + 2.0 * me) * dtor) + 1.6 * Math.cos((109.4933 - 2.0 * mj + me) * dtor);
        l += jupcorr;
        double d = 350.7376814 + 445267.11422 * t % 360.0;
        double mooncorr = 6.5 * Math.sin(d * dtor);
        l += mooncorr;
        double longterm = 6.4 * Math.sin((231.19 + 20.2 * t) * dtor);
        l += longterm;
        l = (l + 2592000.0) % 1296000.0;
        double longmed = l / 3600.0 * dtor;
        return longmed;
    }
}

