/*
 * Decompiled with CFR 0.152.
 */
package skyview.geometry.distorter;

import skyview.Component;
import skyview.geometry.Distorter;
import skyview.geometry.TransformationException;
import skyview.geometry.Transformer;

public class DSSDistorter
extends Distorter
implements Component {
    private double CONS2R = Math.toDegrees(1.0) * 3600.0;
    private double COND2R = 0.01745329252;
    private double TWOPI = Math.PI * 2;
    private double TOLERANCE = 5.0E-7;
    private double xmm;
    private double ymm;
    private double xy;
    private double x2;
    private double y2;
    private double x2y;
    private double y2x;
    private double x2y2;
    private double x4y4;
    private double x3;
    private double y3;
    private double x4;
    private double y4;
    private double plate_ra;
    private double plate_dec;
    private double plate_scale;
    private double x_pixel_size;
    private double y_pixel_size;
    private double[] ppo_coeff;
    private double[] x_coeff;
    private double[] y_coeff;

    public DSSDistorter(double plate_ra, double plate_dec, double x_pixel_size, double y_pixel_size, double plate_scale, double[] ppo_coeff, double[] x_coeff, double[] y_coeff) {
        this.plate_ra = plate_ra;
        this.plate_dec = plate_dec;
        this.x_pixel_size = x_pixel_size;
        this.y_pixel_size = y_pixel_size;
        this.plate_scale = plate_scale;
        this.ppo_coeff = ppo_coeff;
        this.x_coeff = x_coeff;
        this.y_coeff = y_coeff;
    }

    private void setPosition(double xmm, double ymm) {
        this.xmm = xmm;
        this.ymm = ymm;
        this.xy = xmm * ymm;
        this.x2 = xmm * xmm;
        this.y2 = ymm * ymm;
        this.x2y = this.x2 * ymm;
        this.y2x = this.y2 * xmm;
        this.x2y2 = this.x2 + this.y2;
        this.x4y4 = this.x2y2 * this.x2y2;
        this.x3 = this.x2 * xmm;
        this.y3 = this.y2 * ymm;
        this.x4 = this.x2 * this.x2;
        this.y4 = this.y2 * this.y2;
    }

    @Override
    public void transform(double[] x, double[] y) {
        int i;
        int max_iterations = 50;
        double xi = x[0] * this.CONS2R;
        double eta = x[1] * this.CONS2R;
        double xmm = xi / this.plate_scale;
        double ymm = eta / this.plate_scale;
        double ft = 0.0;
        double fx = 0.0;
        double fy = 0.0;
        double gt = 0.0;
        double gx = 0.0;
        double gy = 0.0;
        for (i = 0; i < max_iterations; ++i) {
            this.setPosition(xmm, ymm);
            ft = this.f();
            gt = this.g();
            fx = this.dfdx();
            fy = this.dfdy();
            gx = this.dgdx();
            gy = this.dgdy();
            double df = ft - xi;
            double dg = gt - eta;
            double dx = (-df * gy + dg * fy) / (fx * gy - fy * gx);
            double dy = (-dg * fx + df * gx) / (fx * gy - fy * gx);
            xmm += dx;
            ymm += dy;
            if (Math.abs(dx) < this.TOLERANCE && Math.abs(dy) < this.TOLERANCE) break;
        }
        if (i > max_iterations) {
            y[0] = Double.NaN;
            y[1] = Double.NaN;
        } else {
            y[0] = xmm * this.plate_scale / this.CONS2R;
            y[1] = ymm * this.plate_scale / this.CONS2R;
        }
    }

    @Override
    public String getName() {
        return "DSS Distorter";
    }

    @Override
    public String getDescription() {
        return "Transform from a fiducial projection plane to the DSS distorted projection plane.";
    }

    protected boolean preserves() {
        return false;
    }

    private double f() {
        return this.x_coeff[0] * this.xmm + this.x_coeff[1] * this.ymm + this.x_coeff[2] + this.x_coeff[3] * this.x2 + this.x_coeff[4] * this.xy + this.x_coeff[5] * this.y2 + this.x_coeff[6] * this.x2y2 + this.x_coeff[7] * this.x3 + this.x_coeff[8] * this.x2y + this.x_coeff[9] * this.y2x + this.x_coeff[10] * this.y3 + this.x_coeff[11] * this.xmm * this.x2y2 + this.x_coeff[12] * this.xmm * this.x4y4;
    }

    private double dfdx() {
        return this.x_coeff[0] + this.x_coeff[3] * 2.0 * this.xmm + this.x_coeff[4] * this.ymm + this.x_coeff[6] * 2.0 * this.xmm + this.x_coeff[7] * 3.0 * this.x2 + this.x_coeff[8] * 2.0 * this.xy + this.x_coeff[9] * this.y2 + this.x_coeff[11] * (3.0 * this.x2 + this.y2) + this.x_coeff[12] * (5.0 * this.x4 + 6.0 * this.x2 * this.y2 + this.y4);
    }

    private double dfdy() {
        return this.x_coeff[1] + this.x_coeff[4] * this.xmm + this.x_coeff[5] * 2.0 * this.ymm + this.x_coeff[6] * 2.0 * this.ymm + this.x_coeff[8] * this.x2 + this.x_coeff[9] * 2.0 * this.xy + this.x_coeff[10] * 3.0 * this.y2 + this.x_coeff[11] * 2.0 * this.xy + this.x_coeff[12] * 4.0 * this.xy * this.x2y2;
    }

    private double g() {
        return this.y_coeff[0] * this.ymm + this.y_coeff[1] * this.xmm + this.y_coeff[2] + this.y_coeff[3] * this.y2 + this.y_coeff[4] * this.xy + this.y_coeff[5] * this.x2 + this.y_coeff[6] * this.x2y2 + this.y_coeff[7] * this.y3 + this.y_coeff[8] * this.y2x + this.y_coeff[9] * this.x2y + this.y_coeff[10] * this.x3 + this.y_coeff[11] * this.ymm * this.x2y2 + this.y_coeff[12] * this.ymm * this.x4y4;
    }

    private double dgdx() {
        return this.y_coeff[1] + this.y_coeff[4] * this.ymm + this.y_coeff[5] * 2.0 * this.xmm + this.y_coeff[6] * 2.0 * this.xmm + this.y_coeff[8] * this.y2 + this.y_coeff[9] * 2.0 * this.xy + this.y_coeff[10] * 3.0 * this.x2 + this.y_coeff[11] * 2.0 * this.xy + this.y_coeff[12] * 4.0 * this.xy * this.x2y2;
    }

    private double dgdy() {
        return this.y_coeff[0] + this.y_coeff[3] * 2.0 * this.ymm + this.y_coeff[4] * this.xmm + this.y_coeff[6] * 2.0 * this.ymm + this.y_coeff[7] * 3.0 * this.y2 + this.y_coeff[8] * 2.0 * this.xy + this.y_coeff[9] * this.x2 + this.y_coeff[11] * (this.x2 + 3.0 * this.y2) + this.y_coeff[12] * (5.0 * this.y4 + 6.0 * this.x2 * this.y2 + this.x4);
    }

    @Override
    public Distorter inverse() {
        return new DSSInvDistorter();
    }

    @Override
    public boolean isInverse(Transformer t) {
        try {
            return t.inverse() == this;
        }
        catch (TransformationException e) {
            return false;
        }
    }

    public class DSSInvDistorter
    extends Distorter {
        public Distorter invert() {
            return DSSDistorter.this;
        }

        @Override
        public String getName() {
            return "DSSInvDistorter";
        }

        @Override
        public String getDescription() {
            return "Transform from DSS distorted coordinates to the ficucial projection plane";
        }

        @Override
        public Distorter inverse() {
            return DSSDistorter.this;
        }

        @Override
        public boolean isInverse(Transformer t) {
            return t == DSSDistorter.this;
        }

        @Override
        public void transform(double[] x, double[] y) {
            double xmm = x[0] * DSSDistorter.this.CONS2R / DSSDistorter.this.plate_scale;
            double ymm = x[1] * DSSDistorter.this.CONS2R / DSSDistorter.this.plate_scale;
            DSSDistorter.this.setPosition(xmm, ymm);
            double xi = DSSDistorter.this.f();
            double eta = DSSDistorter.this.g();
            y[0] = xi / DSSDistorter.this.CONS2R;
            y[1] = eta / DSSDistorter.this.CONS2R;
        }
    }
}

