/*
 * Decompiled with CFR 0.152.
 */
package skyview.geometry.projecter;

import skyview.geometry.Deprojecter;
import skyview.geometry.Projecter;
import skyview.geometry.Transformer;

public final class CarProjecter
extends Projecter {
    @Override
    public String getName() {
        return "CarProjecter";
    }

    @Override
    public String getDescription() {
        return "Transform from the celestial sphere to the plane described by Lon/Lat directly";
    }

    @Override
    public Deprojecter inverse() {
        return new CarDeprojecter();
    }

    @Override
    public boolean isInverse(Transformer t) {
        return t.getName().equals("CarDeprojecter");
    }

    @Override
    public final void transform(double[] sphere, double[] plane) {
        if (Double.isNaN(sphere[2])) {
            plane[0] = Double.NaN;
            plane[1] = Double.NaN;
        } else {
            plane[0] = Math.atan2(sphere[1], sphere[0]);
            plane[1] = Math.atan2(sphere[2], Math.sqrt(sphere[0] * sphere[0] + sphere[1] * sphere[1]));
        }
    }

    public class CarDeprojecter
    extends Deprojecter {
        @Override
        public String getName() {
            return "CarDeprojecter";
        }

        @Override
        public boolean isInverse(Transformer t) {
            return t.getName().equals("CarProjecter");
        }

        @Override
        public String getDescription() {
            return "Transform from the Lat/Lon to the corresponding unit vector.";
        }

        @Override
        public Projecter inverse() {
            return CarProjecter.this;
        }

        @Override
        public final void transform(double[] plane, double[] sphere) {
            if (Double.isNaN(plane[0])) {
                sphere[0] = Double.NaN;
                sphere[1] = Double.NaN;
                sphere[2] = Double.NaN;
            } else {
                double sr = Math.sin(plane[0]);
                double cr = Math.cos(plane[0]);
                double sd = Math.sin(plane[1]);
                double cd = Math.cos(plane[1]);
                sphere[0] = cr * cd;
                sphere[1] = sr * cd;
                sphere[2] = sd;
            }
        }
    }
}

