/*
 * Decompiled with CFR 0.152.
 */
package skyview.geometry.projecter;

import skyview.geometry.Deprojecter;
import skyview.geometry.Projecter;
import skyview.geometry.Transformer;

public final class SinProjecter
extends Projecter {
    @Override
    public String getName() {
        return "SinProjecter";
    }

    @Override
    public String getDescription() {
        return "Project as if seeing the sphere from a great distance";
    }

    @Override
    public Deprojecter inverse() {
        return new SinDeprojecter();
    }

    @Override
    public boolean isInverse(Transformer t) {
        return t.getName().equals("SinDeprojecter");
    }

    @Override
    public final void transform(double[] sphere, double[] plane) {
        if (Double.isNaN(sphere[2]) || sphere[2] <= 0.0) {
            plane[0] = Double.NaN;
            plane[1] = Double.NaN;
        } else {
            plane[0] = sphere[0];
            plane[1] = sphere[1];
        }
    }

    public class SinDeprojecter
    extends Deprojecter {
        @Override
        public String getName() {
            return "SinDeprojection";
        }

        @Override
        public String getDescription() {
            return "Invert the sine projection";
        }

        @Override
        public Projecter inverse() {
            return SinProjecter.this;
        }

        @Override
        public boolean isInverse(Transformer t) {
            return t.getName().equals("SinProjecter");
        }

        @Override
        public final void transform(double[] plane, double[] sphere) {
            if (Double.isNaN(plane[0])) {
                sphere[0] = Double.NaN;
                sphere[1] = Double.NaN;
                sphere[2] = Double.NaN;
            } else {
                sphere[0] = plane[0];
                sphere[1] = plane[1];
                sphere[2] = Math.sqrt(1.0 - plane[0] * plane[0] - plane[1] * plane[1]);
            }
        }
    }
}

