/*
 * Decompiled with CFR 0.152.
 */
package skyview.geometry.projecter;

import skyview.geometry.Deprojecter;
import skyview.geometry.Projecter;
import skyview.geometry.Transformer;

public class StgProjecter
extends Projecter {
    @Override
    public String getName() {
        return "StgProjecter";
    }

    @Override
    public String getDescription() {
        return "Project from antipodes to a tanget plane touching the sphere";
    }

    @Override
    public final void transform(double[] sphere, double[] plane) {
        if (Double.isNaN(sphere[2]) || sphere[2] < 0.0) {
            plane[0] = Double.NaN;
            plane[1] = Double.NaN;
        } else {
            double fac = 2.0 / (1.0 + sphere[2]);
            plane[0] = fac * sphere[0];
            plane[1] = fac * sphere[1];
        }
    }

    @Override
    public Deprojecter inverse() {
        return new TanDeprojecter();
    }

    @Override
    public boolean isInverse(Transformer t) {
        return t.getName().equals("StgDeprojecter");
    }

    public class TanDeprojecter
    extends Deprojecter {
        @Override
        public String getName() {
            return "StgDeprojecter";
        }

        @Override
        public String getDescription() {
            return "Transform from the stereoscopic tangent plane to the sphere";
        }

        @Override
        public Projecter inverse() {
            return StgProjecter.this;
        }

        @Override
        public boolean isInverse(Transformer t) {
            return t.getName().equals("StgProjecter");
        }

        @Override
        public final void transform(double[] plane, double[] sphere) {
            if (Double.isNaN(plane[0])) {
                sphere[0] = Double.NaN;
                sphere[1] = Double.NaN;
                sphere[2] = Double.NaN;
            } else {
                double z;
                double x = plane[0];
                double y = plane[1];
                double r = Math.sqrt(x * x + y * y);
                double theta = 2.0 * Math.atan2(r, 2.0);
                sphere[2] = z = Math.cos(theta);
                if (Math.abs(z) != 1.0) {
                    sphere[0] = plane[0] * (1.0 + z) / 2.0;
                    sphere[1] = plane[1] * (1.0 + z) / 2.0;
                } else {
                    sphere[0] = 0.0;
                    sphere[1] = 0.0;
                }
            }
        }
    }
}

