/*
 * Decompiled with CFR 0.152.
 */
import ij.IJ;
import ij.ImagePlus;
import ij.WindowManager;
import ij.gui.GUI;
import ij.process.ImageProcessor;
import java.awt.Button;
import java.awt.Checkbox;
import java.awt.Choice;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Label;
import java.awt.Panel;
import java.awt.Scrollbar;
import java.awt.TextField;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.Locale;
import java.util.ResourceBundle;

public class Align_RGB_planes
extends Dialog
implements ActionListener,
AdjustmentListener,
ItemListener,
WindowListener,
Runnable {
    private Thread threadProcess = null;
    protected int par1 = 1;
    protected double par2 = 0.0;
    protected double par3 = 0.0;
    protected ImagePlus imp;
    protected ImageProcessor ip;
    protected int xe;
    protected int ye;
    protected int p;
    protected int x;
    protected int y;
    protected int[] f = new int[]{1, 1, 1};
    protected int[][] c = new int[3][2];
    protected int[][] mp = new int[3][2];
    protected double[] rp = new double[3];
    protected double[][] sp = new double[3][2];
    protected double[] xep = new double[3];
    protected double[] yep = new double[3];
    protected int[][] r;
    protected int[][] g;
    protected int[][] b;
    private ResourceBundle myBundle;
    private Locale lang = Locale.getDefault();
    private GridBagLayout layout;
    private GridBagConstraints constraint;
    private Button bnHelp;
    private Button bnUp;
    private Button bnDn;
    private Button bnRt;
    private Button bnLt;
    private Button bnRvt;
    private Button bnRot;
    private Button bnWid;
    private Button bnHei;
    private TextField txtpar1;
    private TextField txtpar2;
    private TextField txtpar3;
    private Choice choiceLUT;
    private Scrollbar scrpar1;
    private Scrollbar scrpar2;
    private Scrollbar scrpar3;
    private Checkbox chkRed;
    private Checkbox chkGreen;
    private Checkbox chkBlue;
    private Checkbox chkLog;

    public Align_RGB_planes() {
        super(new Frame(), "Align RGB");
        if (this.lang == null) {
            this.lang = Locale.ENGLISH;
        }
        this.myBundle = ResourceBundle.getBundle("AlignRGBBundle", this.lang);
        this.imp = WindowManager.getCurrentImage();
        if (this.imp == null) {
            IJ.showMessage((String)this.myBundle.getString("ImageRequired"));
            return;
        }
        if (this.imp.getType() != 4) {
            IJ.showMessage((String)this.myBundle.getString("RGBRequired"));
            return;
        }
        this.ip = this.imp.getProcessor();
        this.xe = this.ip.getWidth();
        this.xep[1] = this.xep[2] = (double)this.xe;
        this.xep[0] = this.xep[2];
        this.ye = this.ip.getHeight();
        this.yep[1] = this.yep[2] = (double)this.ye;
        this.yep[0] = this.yep[2];
        this.r = new int[this.xe][this.ye];
        this.g = new int[this.xe][this.ye];
        this.b = new int[this.xe][this.ye];
        this.y = 0;
        while (this.y < this.ye) {
            this.x = 0;
            while (this.x < this.xe) {
                this.p = this.ip.getPixel(this.x, this.y);
                this.r[this.x][this.y] = (this.p & 0xFF0000) >> 16;
                this.g[this.x][this.y] = (this.p & 0xFF00) >> 8;
                this.b[this.x][this.y] = this.p & 0xFF;
                ++this.x;
            }
            ++this.y;
        }
        this.doDialog();
    }

    public void run() {
    }

    void align() {
        int sx = 0;
        int ex = 0;
        int sy = 0;
        int ey = 0;
        int plane = this.choiceLUT.getSelectedIndex();
        if (plane == 0) {
            this.y = 0;
            while (this.y < this.ye) {
                this.x = 0;
                while (this.x < this.xe) {
                    this.ip.putPixel(this.x, this.y, 0 + ((this.g[this.x][this.y] & 0xFF) << 8) + (this.b[this.x][this.y] & 0xFF));
                    ++this.x;
                }
                ++this.y;
            }
            if (this.c[0][0] >= 0 && this.c[0][1] >= 0) {
                sx = this.c[0][0];
                ex = this.xe;
                sy = this.c[0][1];
                ey = this.ye;
            } else if (this.c[0][0] <= 0 && this.c[0][1] <= 0) {
                sx = 0;
                ex = this.xe + this.c[0][0];
                sy = 0;
                ey = this.ye + this.c[0][1];
            } else if (this.c[0][0] <= 0 && this.c[0][1] >= 0) {
                sx = 0;
                ex = this.xe + this.c[0][0];
                sy = this.c[0][1];
                ey = this.ye;
            } else if (this.c[0][0] >= 0 && this.c[0][1] <= 0) {
                sx = this.c[0][0];
                ex = this.xe;
                sy = 0;
                ey = this.ye + this.c[0][1];
            }
            this.y = sy;
            while (this.y < ey) {
                this.x = sx;
                while (this.x < ex) {
                    this.ip.putPixel(this.x, this.y, ((this.r[this.x - this.c[0][0]][this.y - this.c[0][1]] & 0xFF) << 16) + ((this.g[this.x][this.y] & 0xFF) << 8) + (this.b[this.x][this.y] & 0xFF));
                    ++this.x;
                }
                ++this.y;
            }
        } else if (plane == 1) {
            this.y = 0;
            while (this.y < this.ye) {
                this.x = 0;
                while (this.x < this.xe) {
                    this.ip.putPixel(this.x, this.y, ((this.r[this.x][this.y] & 0xFF) << 16) + 0 + (this.b[this.x][this.y] & 0xFF));
                    ++this.x;
                }
                ++this.y;
            }
            if (this.c[1][0] >= 0 && this.c[1][1] >= 0) {
                sx = this.c[1][0];
                ex = this.xe;
                sy = this.c[1][1];
                ey = this.ye;
            } else if (this.c[1][0] <= 0 && this.c[1][1] <= 0) {
                sx = 0;
                ex = this.xe + this.c[1][0];
                sy = 0;
                ey = this.ye + this.c[1][1];
            } else if (this.c[1][0] <= 0 && this.c[1][1] >= 0) {
                sx = 0;
                ex = this.xe + this.c[1][0];
                sy = this.c[1][1];
                ey = this.ye;
            } else if (this.c[1][0] >= 0 && this.c[1][1] <= 0) {
                sx = this.c[1][0];
                ex = this.xe;
                sy = 0;
                ey = this.ye + this.c[1][1];
            }
            this.y = sy;
            while (this.y < ey) {
                this.x = sx;
                while (this.x < ex) {
                    this.ip.putPixel(this.x, this.y, ((this.r[this.x][this.y] & 0xFF) << 16) + ((this.g[this.x - this.c[1][0]][this.y - this.c[1][1]] & 0xFF) << 8) + (this.b[this.x][this.y] & 0xFF));
                    ++this.x;
                }
                ++this.y;
            }
        } else if (plane == 2) {
            this.y = 0;
            while (this.y < this.ye) {
                this.x = 0;
                while (this.x < this.xe) {
                    this.ip.putPixel(this.x, this.y, ((this.r[this.x][this.y] & 0xFF) << 16) + ((this.g[this.x][this.y] & 0xFF) << 8) + 0);
                    ++this.x;
                }
                ++this.y;
            }
            if (this.c[2][0] >= 0 && this.c[2][1] >= 0) {
                sx = this.c[2][0];
                ex = this.xe;
                sy = this.c[2][1];
                ey = this.ye;
            } else if (this.c[2][0] <= 0 && this.c[2][1] <= 0) {
                sx = 0;
                ex = this.xe + this.c[2][0];
                sy = 0;
                ey = this.ye + this.c[2][1];
            } else if (this.c[2][0] <= 0 && this.c[2][1] >= 0) {
                sx = 0;
                ex = this.xe + this.c[2][0];
                sy = this.c[2][1];
                ey = this.ye;
            } else if (this.c[2][0] >= 0 && this.c[2][1] <= 0) {
                sx = this.c[2][0];
                ex = this.xe;
                sy = 0;
                ey = this.ye + this.c[2][1];
            }
            this.y = sy;
            while (this.y < ey) {
                this.x = sx;
                while (this.x < ex) {
                    this.ip.putPixel(this.x, this.y, ((this.r[this.x][this.y] & 0xFF) << 16) + ((this.g[this.x][this.y] & 0xFF) << 8) + (this.b[this.x - this.c[2][0]][this.y - this.c[2][1]] & 0xFF));
                    ++this.x;
                }
                ++this.y;
            }
        }
        this.imp.updateAndDraw();
    }

    void updatergb() {
        this.y = 0;
        while (this.y < this.ye) {
            this.x = 0;
            while (this.x < this.xe) {
                this.p = this.ip.getPixel(this.x, this.y);
                this.r[this.x][this.y] = (this.p & 0xFF0000) >> 16;
                this.g[this.x][this.y] = (this.p & 0xFF00) >> 8;
                this.b[this.x][this.y] = this.p & 0xFF;
                ++this.x;
            }
            ++this.y;
        }
    }

    private void doDialog() {
        this.layout = new GridBagLayout();
        this.constraint = new GridBagConstraints();
        this.bnHelp = new Button(this.myBundle.getString("Help"));
        this.bnUp = new Button(this.myBundle.getString("Up"));
        this.bnDn = new Button(this.myBundle.getString("Down"));
        this.bnRt = new Button(this.myBundle.getString("Right"));
        this.bnLt = new Button(this.myBundle.getString("Left"));
        this.bnRvt = new Button(this.myBundle.getString("Revert"));
        this.bnRot = new Button(this.myBundle.getString("Rotate"));
        this.bnWid = new Button(this.myBundle.getString("Width"));
        this.bnHei = new Button(this.myBundle.getString("Height"));
        this.txtpar1 = new TextField("" + this.par1, 3);
        this.txtpar2 = new TextField("" + this.par2, 3);
        this.txtpar3 = new TextField("" + this.par3, 3);
        this.chkRed = new Checkbox(this.myBundle.getString("Red"), null, true);
        this.chkGreen = new Checkbox(this.myBundle.getString("Green"), null, true);
        this.chkBlue = new Checkbox(this.myBundle.getString("Blue"), null, true);
        this.chkLog = new Checkbox(this.myBundle.getString("Log"), null, false);
        this.choiceLUT = new Choice();
        this.choiceLUT.add("Red");
        this.choiceLUT.add("Green");
        this.choiceLUT.add("Blue");
        this.choiceLUT.select(0);
        this.scrpar1 = new Scrollbar(0, 1, 1, 1, 101);
        this.scrpar2 = new Scrollbar(0, 0, 1, -180, 181);
        this.scrpar3 = new Scrollbar(0, 0, 1, -100, 101);
        Panel pnMain = new Panel();
        pnMain.setLayout(this.layout);
        this.addComponent(pnMain, 0, 0, 1, 1, 2, new Label(this.myBundle.getString("Plane") + " ---"));
        this.addComponent(pnMain, 0, 1, 1, 1, 3, this.choiceLUT);
        this.addComponent(pnMain, 1, 0, 1, 1, 3, new Label("  " + this.myBundle.getString("Distance")));
        this.addComponent(pnMain, 1, 1, 1, 1, 3, this.txtpar1);
        this.addComponent(pnMain, 1, 2, 1, 1, 3, this.scrpar1);
        this.addComponent(pnMain, 4, 1, 1, 1, 3, this.bnUp);
        this.addComponent(pnMain, 5, 0, 1, 1, 3, this.bnLt);
        this.addComponent(pnMain, 5, 2, 1, 1, 3, this.bnRt);
        this.addComponent(pnMain, 6, 1, 1, 1, 3, this.bnDn);
        this.addComponent(pnMain, 7, 0, 1, 1, 1, new Label(" --------"));
        this.addComponent(pnMain, 7, 1, 1, 1, 1, new Label(" --------"));
        this.addComponent(pnMain, 7, 2, 1, 1, 1, new Label(" --------"));
        this.addComponent(pnMain, 8, 0, 1, 1, 3, this.bnRot);
        this.addComponent(pnMain, 8, 1, 1, 1, 3, this.txtpar2);
        this.addComponent(pnMain, 8, 2, 1, 1, 3, this.scrpar2);
        this.addComponent(pnMain, 9, 0, 1, 1, 1, new Label(" --------"));
        this.addComponent(pnMain, 9, 1, 1, 1, 1, new Label(" --------"));
        this.addComponent(pnMain, 9, 2, 1, 1, 1, new Label(" --------"));
        this.addComponent(pnMain, 10, 0, 1, 1, 3, this.bnWid);
        this.addComponent(pnMain, 10, 1, 1, 1, 3, this.txtpar3);
        this.addComponent(pnMain, 10, 2, 1, 1, 3, this.scrpar3);
        this.addComponent(pnMain, 11, 0, 1, 1, 3, this.bnHei);
        this.addComponent(pnMain, 12, 0, 1, 1, 1, new Label(" --------"));
        this.addComponent(pnMain, 12, 1, 1, 1, 1, new Label(" --------"));
        this.addComponent(pnMain, 12, 2, 1, 1, 1, new Label(" --------"));
        this.addComponent(pnMain, 13, 0, 1, 1, 1, this.chkRed);
        this.addComponent(pnMain, 13, 2, 1, 1, 1, this.chkLog);
        this.addComponent(pnMain, 14, 0, 1, 1, 1, this.chkGreen);
        this.addComponent(pnMain, 14, 1, 1, 1, 1, this.bnRvt);
        this.addComponent(pnMain, 15, 0, 1, 1, 1, this.chkBlue);
        this.addComponent(pnMain, 16, 1, 1, 1, 4, this.bnHelp);
        this.bnUp.addActionListener(this);
        this.bnDn.addActionListener(this);
        this.bnRt.addActionListener(this);
        this.bnLt.addActionListener(this);
        this.bnHelp.addActionListener(this);
        this.scrpar1.addAdjustmentListener(this);
        this.scrpar1.setUnitIncrement(1);
        this.txtpar2.addActionListener(this);
        this.scrpar2.addAdjustmentListener(this);
        this.scrpar2.setUnitIncrement(1);
        this.txtpar3.addActionListener(this);
        this.scrpar3.addAdjustmentListener(this);
        this.scrpar3.setUnitIncrement(1);
        this.choiceLUT.addItemListener(this);
        this.chkRed.addItemListener(this);
        this.chkGreen.addItemListener(this);
        this.chkBlue.addItemListener(this);
        this.chkLog.addItemListener(this);
        this.bnRvt.addActionListener(this);
        this.bnRot.addActionListener(this);
        this.bnWid.addActionListener(this);
        this.bnHei.addActionListener(this);
        this.addWindowListener(this);
        this.add(pnMain);
        this.pack();
        this.setResizable(false);
        GUI.center((Window)this);
        this.setVisible(true);
        IJ.wait((int)250);
    }

    private final void addComponent(Panel pn, int row, int col, int width, int height, int space, Component comp) {
        this.constraint.gridx = col;
        this.constraint.gridy = row;
        this.constraint.gridwidth = width;
        this.constraint.gridheight = height;
        this.constraint.anchor = 18;
        this.constraint.insets = new Insets(space, space, space, space);
        this.constraint.weightx = IJ.isMacintosh() ? 90.0 : 100.0;
        this.constraint.fill = 2;
        this.layout.setConstraints(comp, this.constraint);
        pn.add(comp);
    }

    public synchronized void adjustmentValueChanged(AdjustmentEvent e) {
        if (e.getSource() == this.scrpar1) {
            this.par1 = this.scrpar1.getValue();
            this.txtpar1.setText("" + this.par1);
        } else if (e.getSource() == this.scrpar2) {
            this.par2 = this.scrpar2.getValue();
            this.txtpar2.setText("" + this.par2);
        } else if (e.getSource() == this.scrpar3) {
            this.par3 = this.scrpar3.getValue();
            this.txtpar3.setText("" + this.par3);
        }
        this.notify();
    }

    public synchronized void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.bnUp) {
            if (this.f[0] + this.f[1] + this.f[2] < 3) {
                IJ.error((String)this.myBundle.getString("SwitchChannels"));
                return;
            }
            int[] nArray = this.c[this.choiceLUT.getSelectedIndex()];
            nArray[1] = nArray[1] - this.par1;
            int[] nArray2 = this.mp[this.choiceLUT.getSelectedIndex()];
            nArray2[1] = nArray2[1] - this.par1;
        } else if (e.getSource() == this.bnDn) {
            if (this.f[0] + this.f[1] + this.f[2] < 3) {
                IJ.error((String)this.myBundle.getString("SwitchChannels"));
                return;
            }
            int[] nArray = this.c[this.choiceLUT.getSelectedIndex()];
            nArray[1] = nArray[1] + this.par1;
            int[] nArray3 = this.mp[this.choiceLUT.getSelectedIndex()];
            nArray3[1] = nArray3[1] + this.par1;
        } else if (e.getSource() == this.bnRt) {
            if (this.f[0] + this.f[1] + this.f[2] < 3) {
                IJ.error((String)this.myBundle.getString("SwitchChannels"));
                return;
            }
            int[] nArray = this.c[this.choiceLUT.getSelectedIndex()];
            nArray[0] = nArray[0] + this.par1;
            int[] nArray4 = this.mp[this.choiceLUT.getSelectedIndex()];
            nArray4[0] = nArray4[0] + this.par1;
        } else if (e.getSource() == this.bnLt) {
            if (this.f[0] + this.f[1] + this.f[2] < 3) {
                IJ.error((String)this.myBundle.getString("SwitchChannels"));
                return;
            }
            int[] nArray = this.c[this.choiceLUT.getSelectedIndex()];
            nArray[0] = nArray[0] - this.par1;
            int[] nArray5 = this.mp[this.choiceLUT.getSelectedIndex()];
            nArray5[0] = nArray5[0] - this.par1;
        } else if (e.getSource() == this.bnRvt) {
            IJ.run((String)this.myBundle.getString("Revert"));
            this.imp = WindowManager.getCurrentImage();
            this.ip = this.imp.getProcessor();
            this.y = 0;
            while (this.y < this.ye) {
                this.x = 0;
                while (this.x < this.xe) {
                    this.p = this.ip.getPixel(this.x, this.y);
                    this.r[this.x][this.y] = (this.p & 0xFF0000) >> 16;
                    this.g[this.x][this.y] = (this.p & 0xFF00) >> 8;
                    this.b[this.x][this.y] = this.p & 0xFF;
                    ++this.x;
                }
                ++this.y;
            }
            this.c[1][0] = 0;
            this.c[0][1] = 0;
            this.c[0][0] = 0;
            this.c[2][1] = 0;
            this.c[2][0] = 0;
            this.c[1][1] = 0;
            this.mp[1][0] = 0;
            this.mp[0][1] = 0;
            this.mp[0][0] = 0;
            this.mp[2][1] = 0;
            this.mp[2][0] = 0;
            this.mp[1][1] = 0;
            this.rp[2] = 0.0;
            this.rp[1] = 0.0;
            this.rp[0] = 0.0;
            this.sp[1][0] = 0.0;
            this.sp[0][1] = 0.0;
            this.sp[0][0] = 0.0;
            this.sp[2][1] = 0.0;
            this.sp[2][0] = 0.0;
            this.sp[1][1] = 0.0;
            this.xep[1] = this.xep[2] = (double)this.xe;
            this.xep[0] = this.xep[2];
            this.yep[1] = this.yep[2] = (double)this.ye;
            this.yep[0] = this.yep[2];
            this.chkRed.setState(true);
            this.chkGreen.setState(true);
            this.chkBlue.setState(true);
            this.f[0] = 1;
            this.f[1] = 1;
            this.f[2] = 1;
        } else if (e.getSource() == this.txtpar2) {
            this.par2 = Double.parseDouble(this.txtpar2.getText().trim());
        } else if (e.getSource() == this.bnRot) {
            if (this.f[0] + this.f[1] + this.f[2] < 3) {
                IJ.error((String)this.myBundle.getString("SwitchChannels"));
                return;
            }
            IJ.run((String)this.myBundle.getString("RGBStack"));
            int n = this.x = this.choiceLUT.getSelectedIndex();
            this.rp[n] = this.rp[n] + this.par2;
            if (this.rp[this.x] > 360.0) {
                int n2 = this.x;
                this.rp[n2] = this.rp[n2] - 360.0;
            } else if (this.rp[this.x] < -360.0) {
                int n3 = this.x;
                this.rp[n3] = this.rp[n3] + 360.0;
            }
            IJ.run((String)this.myBundle.getString("PreviousSlice"));
            IJ.run((String)this.myBundle.getString("PreviousSlice"));
            IJ.run((String)this.myBundle.getString("PreviousSlice"));
            this.y = 0;
            while (this.y < this.x) {
                IJ.run((String)this.myBundle.getString("NextSlice"));
                ++this.y;
            }
            IJ.run((String)this.myBundle.getString("RotateArbitrarily"), (String)("slice angle=" + this.par2 + " interpolate fill"));
            IJ.run((String)this.myBundle.getString("RGBColor"));
            this.imp = WindowManager.getCurrentImage();
            this.ip = this.imp.getProcessor();
            this.y = 0;
            while (this.y < this.ye) {
                this.x = 0;
                while (this.x < this.xe) {
                    this.p = this.ip.getPixel(this.x, this.y);
                    this.r[this.x][this.y] = (this.p & 0xFF0000) >> 16;
                    this.g[this.x][this.y] = (this.p & 0xFF00) >> 8;
                    this.b[this.x][this.y] = this.p & 0xFF;
                    ++this.x;
                }
                ++this.y;
            }
            this.c[0][0] = 0;
            this.c[0][1] = 0;
            this.c[1][0] = 0;
            this.c[1][1] = 0;
            this.c[2][0] = 0;
            this.c[2][1] = 0;
        } else if (e.getSource() == this.txtpar3) {
            this.par3 = Double.parseDouble(this.txtpar3.getText().trim());
        } else if (e.getSource() == this.bnWid) {
            if (this.f[0] + this.f[1] + this.f[2] < 3) {
                IJ.error((String)this.myBundle.getString("SwitchChannels"));
                return;
            }
            IJ.run((String)this.myBundle.getString("RGBStack"));
            this.x = this.choiceLUT.getSelectedIndex();
            double[] dArray = this.sp[this.x];
            dArray[0] = dArray[0] + this.par3;
            IJ.run((String)this.myBundle.getString("PreviousSlice"));
            IJ.run((String)this.myBundle.getString("PreviousSlice"));
            IJ.run((String)this.myBundle.getString("PreviousSlice"));
            this.y = 0;
            while (this.y < this.x) {
                IJ.run((String)this.myBundle.getString("NextSlice"));
                ++this.y;
            }
            IJ.run((String)this.myBundle.getString("Scale"), (String)("x=" + (this.xep[this.x] + this.par3) / this.xep[this.x] + " y=1 interpolate fill title=Untitled"));
            IJ.run((String)this.myBundle.getString("RGBColor"));
            int n = this.x;
            this.xep[n] = this.xep[n] + this.par3;
            this.imp = WindowManager.getCurrentImage();
            this.ip = this.imp.getProcessor();
            this.y = 0;
            while (this.y < this.ye) {
                this.x = 0;
                while (this.x < this.xe) {
                    this.p = this.ip.getPixel(this.x, this.y);
                    this.r[this.x][this.y] = (this.p & 0xFF0000) >> 16;
                    this.g[this.x][this.y] = (this.p & 0xFF00) >> 8;
                    this.b[this.x][this.y] = this.p & 0xFF;
                    ++this.x;
                }
                ++this.y;
            }
            this.c[0][0] = 0;
            this.c[0][1] = 0;
            this.c[1][0] = 0;
            this.c[1][1] = 0;
            this.c[2][0] = 0;
            this.c[2][1] = 0;
        } else if (e.getSource() == this.bnHei) {
            if (this.f[0] + this.f[1] + this.f[2] < 3) {
                IJ.error((String)this.myBundle.getString("SwitchChannels"));
                return;
            }
            IJ.run((String)this.myBundle.getString("RGBStack"));
            this.x = this.choiceLUT.getSelectedIndex();
            double[] dArray = this.sp[this.x];
            dArray[1] = dArray[1] + this.par3;
            IJ.run((String)this.myBundle.getString("PreviousSlice"));
            IJ.run((String)this.myBundle.getString("PreviousSlice"));
            IJ.run((String)this.myBundle.getString("PreviousSlice"));
            this.y = 0;
            while (this.y < this.x) {
                IJ.run((String)this.myBundle.getString("NextSlice"));
                ++this.y;
            }
            IJ.run((String)this.myBundle.getString("Scale"), (String)("x=1 y=" + (this.yep[this.x] + this.par3) / this.yep[this.x] + " interpolate fill title=Untitled"));
            IJ.run((String)this.myBundle.getString("RGBColor"));
            int n = this.x;
            this.yep[n] = this.yep[n] + this.par3;
            this.imp = WindowManager.getCurrentImage();
            this.ip = this.imp.getProcessor();
            this.y = 0;
            while (this.y < this.ye) {
                this.x = 0;
                while (this.x < this.xe) {
                    this.p = this.ip.getPixel(this.x, this.y);
                    this.r[this.x][this.y] = (this.p & 0xFF0000) >> 16;
                    this.g[this.x][this.y] = (this.p & 0xFF00) >> 8;
                    this.b[this.x][this.y] = this.p & 0xFF;
                    ++this.x;
                }
                ++this.y;
            }
            this.c[0][0] = 0;
            this.c[0][1] = 0;
            this.c[1][0] = 0;
            this.c[1][1] = 0;
            this.c[2][0] = 0;
            this.c[2][1] = 0;
        } else if (e.getSource() == this.bnHelp) {
            IJ.showMessage((String)"Help", (String)"Align RGB planes v1.6 by G.Landini\nChanges the alignment of the RGB planes independently.\n \n'Red' 'Green' and 'Blue' checkboxes switch ON and OFF the\nplanes and undo the alignment since last plane change.\n \nNote that when switching planes, the portion of the previously\nedited plane left outside the image frame is lost.\nRotation, Width and Height changes are interpolated (so there is\nsome loss of sharpness) and do not retain the image portions\noutside the image frame.  You can use the 'Resize2Rotate' macro\nto avoid loosing any image data.\n \nThe 'Rotate', 'Width' and 'Height' sliders set integer values,\nbut fractional values can also be typed in the entry boxes.\nJust make sure you press [RETURN] after the number is typed.");
        }
        this.notify();
        this.align();
        if (this.chkLog.getState()) {
            IJ.log((String)("Red Plane ---" + (this.mp[0][0] > 0 ? "\n   [right]: " + this.mp[0][0] : (this.mp[0][0] < 0 ? "\n   [left]: " + Math.abs(this.mp[0][0]) : "")) + (this.mp[0][1] > 0 ? "\n   [down]: " + this.mp[0][1] : (this.mp[0][1] < 0 ? "\n   [up]: " + Math.abs(this.mp[0][1]) : "")) + (this.rp[0] != 0.0 ? "\n   [rotate]: " + this.rp[0] : "") + (this.sp[0][0] != 0.0 ? "\n   [width]: " + this.sp[0][0] : "") + (this.sp[0][1] != 0.0 ? "\n   [height]: " + this.sp[0][1] : "") + "\nGreen Plane ---" + (this.mp[1][0] > 0 ? "\n   [right]: " + this.mp[1][0] : (this.mp[1][0] < 0 ? "\n   [left]: " + Math.abs(this.mp[1][0]) : "")) + (this.mp[1][1] > 0 ? "\n   [down]: " + this.mp[1][1] : (this.mp[1][1] < 0 ? "\n   [up]: " + Math.abs(this.mp[1][1]) : "")) + (this.rp[1] != 0.0 ? "\n   [rotate]: " + this.rp[1] : "") + (this.sp[1][0] != 0.0 ? "\n   [width]: " + this.sp[1][0] : "") + (this.sp[1][1] != 0.0 ? "\n   [height]: " + this.sp[1][1] : "") + "\nBlue Plane ---" + (this.mp[2][0] > 0 ? "\n   [right]: " + this.mp[2][0] : (this.mp[2][0] < 0 ? "\n   [left]: " + Math.abs(this.mp[2][0]) : "")) + (this.mp[2][1] > 0 ? "\n   [down]: " + this.mp[2][1] : (this.mp[2][1] < 0 ? "\n   [up]: " + Math.abs(this.mp[2][1]) : "")) + (this.rp[2] != 0.0 ? "\n   [rotate]: " + this.rp[2] : "") + (this.sp[2][0] != 0.0 ? "\n   [width]: " + this.sp[2][0] : "") + (this.sp[2][1] != 0.0 ? "\n   [height]: " + this.sp[2][1] : "") + "\n---------------"));
        }
    }

    public synchronized void itemStateChanged(ItemEvent e) {
        if (e.getSource() == this.chkLog) {
            IJ.beep();
        } else {
            if (e.getSource() == this.choiceLUT) {
                this.updatergb();
            } else if (e.getSource() == this.chkRed) {
                this.f[0] = this.chkRed.getState() ? 1 : 0;
            } else if (e.getSource() == this.chkGreen) {
                this.f[1] = this.chkGreen.getState() ? 1 : 0;
            } else if (e.getSource() == this.chkBlue) {
                this.f[2] = this.chkBlue.getState() ? 1 : 0;
            }
            this.y = 0;
            while (this.y < this.ye) {
                this.x = 0;
                while (this.x < this.xe) {
                    this.ip.putPixel(this.x, this.y, ((this.f[0] * this.r[this.x][this.y] & 0xFF) << 16) + ((this.f[1] * this.g[this.x][this.y] & 0xFF) << 8) + (this.f[2] * this.b[this.x][this.y] & 0xFF));
                    ++this.x;
                }
                ++this.y;
            }
            this.c[0][0] = 0;
            this.c[0][1] = 0;
            this.c[1][0] = 0;
            this.c[1][1] = 0;
            this.c[2][0] = 0;
            this.c[2][1] = 0;
            this.imp.updateAndDraw();
        }
        this.notify();
    }

    public void windowActivated(WindowEvent e) {
    }

    public void windowClosing(WindowEvent e) {
        this.dispose();
    }

    public void windowClosed(WindowEvent e) {
    }

    public void windowDeactivated(WindowEvent e) {
    }

    public void windowDeiconified(WindowEvent e) {
    }

    public void windowIconified(WindowEvent e) {
    }

    public void windowOpened(WindowEvent e) {
    }
}

