/*
 * Decompiled with CFR 0.152.
 */
import ij.IJ;
import ij.ImageListener;
import ij.ImagePlus;
import ij.WindowManager;
import ij.gui.ImageCanvas;
import ij.gui.ImageWindow;
import ij.gui.Line;
import ij.gui.Plot;
import ij.gui.PlotWindow;
import ij.gui.ProfilePlot;
import ij.gui.Roi;
import ij.measure.Calibration;
import ij.plugin.PlugIn;
import ij.process.ImageProcessor;
import ij.util.Tools;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;

public class Dynamic_Profiler
implements PlugIn,
MouseListener,
MouseMotionListener,
KeyListener,
ImageListener,
Runnable {
    private ImagePlus imp;
    private ImagePlus plotImage;
    private Thread bgThread;
    private boolean doUpdate;

    public void run(String arg) {
        this.imp = WindowManager.getCurrentImage();
        if (this.imp == null) {
            IJ.noImage();
            return;
        }
        if (!this.isSelection()) {
            IJ.error((String)"Dynamic Profiler", (String)"Line or Rectangular Selection Required");
            return;
        }
        ImageProcessor ip = this.getProfilePlot();
        if (ip == null) {
            IJ.error((String)"Dynamic Profiler", (String)"No Profile Obtained");
            return;
        }
        this.plotImage = new ImagePlus("Profile of " + this.imp.getShortTitle(), ip);
        this.plotImage.show();
        IJ.wait((int)50);
        this.positionPlotWindow();
        this.bgThread = new Thread((Runnable)this, "Dynamic Profiler Plot");
        this.bgThread.setPriority(Math.max(this.bgThread.getPriority() - 3, 1));
        this.bgThread.start();
        this.createListeners();
    }

    public synchronized void mousePressed(MouseEvent e) {
        this.doUpdate = true;
        this.notify();
    }

    public synchronized void mouseDragged(MouseEvent e) {
        this.doUpdate = true;
        this.notify();
    }

    public synchronized void mouseClicked(MouseEvent e) {
        this.doUpdate = true;
        this.notify();
    }

    public synchronized void keyPressed(KeyEvent e) {
        this.doUpdate = true;
        this.notify();
    }

    public void mouseReleased(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseMoved(MouseEvent e) {
    }

    public void keyTyped(KeyEvent e) {
    }

    public void keyReleased(KeyEvent e) {
    }

    public void imageOpened(ImagePlus imp) {
    }

    public synchronized void imageUpdated(ImagePlus imp) {
        if (imp == this.imp) {
            if (!this.isSelection()) {
                this.doUpdate = true;
            }
            this.notify();
        }
    }

    public void imageClosed(ImagePlus imp) {
        if (imp == this.imp || imp == this.plotImage) {
            this.removeListeners();
            this.closePlotImage();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        while (true) {
            IJ.wait((int)50);
            ImageProcessor ip = this.getProfilePlot();
            if (ip != null) {
                this.plotImage.setProcessor(null, ip);
            }
            Dynamic_Profiler dynamic_Profiler = this;
            synchronized (dynamic_Profiler) {
                if (this.doUpdate) {
                    this.doUpdate = false;
                } else {
                    try {
                        this.wait();
                    }
                    catch (InterruptedException e) {
                        return;
                    }
                }
            }
        }
    }

    private synchronized void closePlotImage() {
        this.bgThread.interrupt();
        this.plotImage.getWindow().close();
    }

    private void createListeners() {
        ImageWindow win = this.imp.getWindow();
        ImageCanvas canvas = win.getCanvas();
        canvas.addMouseListener((MouseListener)this);
        canvas.addMouseMotionListener((MouseMotionListener)this);
        canvas.addKeyListener((KeyListener)this);
        ImagePlus.addImageListener((ImageListener)this);
        ImagePlus.addImageListener((ImageListener)this);
    }

    private void removeListeners() {
        ImageWindow win = this.imp.getWindow();
        ImageCanvas canvas = win.getCanvas();
        canvas.removeMouseListener((MouseListener)this);
        canvas.removeMouseMotionListener((MouseMotionListener)this);
        canvas.removeKeyListener((KeyListener)this);
        ImagePlus.removeImageListener((ImageListener)this);
        ImagePlus.removeImageListener((ImageListener)this);
    }

    void positionPlotWindow() {
        IJ.wait((int)500);
        if (this.plotImage == null || this.imp == null) {
            return;
        }
        ImageWindow pwin = this.plotImage.getWindow();
        ImageWindow iwin = this.imp.getWindow();
        if (pwin == null || iwin == null) {
            return;
        }
        Dimension screen = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension plotSize = pwin.getSize();
        Dimension imageSize = iwin.getSize();
        if (plotSize.width == 0 || imageSize.width == 0) {
            return;
        }
        Point imageLoc = iwin.getLocation();
        int x = imageLoc.x + imageSize.width + 10;
        if (x + plotSize.width > screen.width) {
            x = screen.width - plotSize.width;
        }
        pwin.setLocation(x, imageLoc.y);
        ImageCanvas canvas = iwin.getCanvas();
        canvas.requestFocus();
    }

    ImageProcessor getProfilePlot() {
        if (!this.isSelection()) {
            return null;
        }
        ImageProcessor ip = this.imp.getProcessor();
        Roi roi = this.imp.getRoi();
        if (ip == null || roi == null) {
            return null;
        }
        if (roi.getType() == 5) {
            ip.setInterpolate(PlotWindow.interpolate);
        } else {
            ip.setInterpolate(false);
        }
        ProfilePlot profileP = new ProfilePlot(this.imp);
        if (profileP == null) {
            return null;
        }
        double[] profile = profileP.getProfile();
        if (profile == null || profile.length < 2) {
            return null;
        }
        String xUnit = "pixels";
        double xInc = 1.0;
        Calibration cal = this.imp.getCalibration();
        if (roi.getType() == 5) {
            Line line = (Line)roi;
            if (cal != null) {
                double dx = cal.pixelWidth * (double)(line.x2 - line.x1);
                double dy = cal.pixelHeight * (double)(line.y2 - line.y1);
                double length = Math.sqrt(dx * dx + dy * dy);
                xInc = length / (double)(profile.length - 1);
                xUnit = cal.getUnits();
            }
        } else if (roi.getType() == 0) {
            if (cal != null) {
                xInc = roi.getBounds().getWidth() * cal.pixelWidth / (double)(profile.length - 1);
                xUnit = cal.getUnits();
            }
        } else {
            return null;
        }
        String xLabel = "Distance (" + xUnit + ")";
        String yLabel = cal != null && cal.getValueUnit() != null && !cal.getValueUnit().equals("Gray Value") ? "Value (" + cal.getValueUnit() + ")" : "Value";
        int n = profile.length;
        double[] x = new double[n];
        for (int i = 0; i < n; ++i) {
            x[i] = (double)i * xInc;
        }
        Plot plot = new Plot("profile", xLabel, yLabel, x, profile);
        double fixedMin = ProfilePlot.getFixedMin();
        double fixedMax = ProfilePlot.getFixedMax();
        if (fixedMin != 0.0 || fixedMax != 0.0) {
            double[] a = Tools.getMinMax((double[])x);
            plot.setLimits(a[0], a[1], fixedMin, fixedMax);
        }
        return plot.getProcessor();
    }

    boolean isSelection() {
        if (this.imp == null) {
            return false;
        }
        Roi roi = this.imp.getRoi();
        if (roi == null) {
            return false;
        }
        return roi.getType() == 5 || roi.getType() == 0;
    }
}

