/*
 * Decompiled with CFR 0.152.
 */
import ij.IJ;
import ij.ImagePlus;
import ij.LookUpTable;
import ij.WindowManager;
import ij.gui.ImageWindow;
import ij.gui.NewImage;
import ij.measure.Calibration;
import ij.measure.Measurements;
import ij.plugin.filter.Analyzer;
import ij.process.ByteProcessor;
import ij.process.ColorProcessor;
import ij.process.ImageProcessor;
import ij.process.ImageStatistics;
import ij.process.ShortProcessor;
import ij.text.TextWindow;
import java.awt.Button;
import java.awt.Checkbox;
import java.awt.CheckboxGroup;
import java.awt.Choice;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Label;
import java.awt.Panel;
import java.awt.Rectangle;
import java.awt.TextField;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.WindowEvent;
import java.io.CharArrayWriter;
import java.io.PrintWriter;

class LiveHistogram
extends ImageWindow
implements Measurements,
ActionListener,
FocusListener,
ClipboardOwner,
Runnable {
    static final int WIN_WIDTH = 328;
    static final int WIN_HEIGHT = 240;
    static final int HIST_WIDTH = 256;
    static final int HIST_HEIGHT = 128;
    static final int BAR_HEIGHT = 12;
    static final int XMARGIN = 20;
    static final int YMARGIN = 10;
    protected ImageStatistics stats;
    protected int[] histogramL;
    protected LookUpTable lut;
    protected Rectangle frame = null;
    protected Button list;
    protected Button save;
    protected Button copy;
    protected Choice display;
    protected TextField minHistTF;
    protected TextField maxHistTF;
    protected TextField minBinTF;
    protected TextField maxBinTF;
    protected CheckboxGroup controlGroup;
    protected Checkbox auto;
    protected Checkbox manual;
    private GridBagLayout grid;
    private GridBagConstraints c;
    protected Label value;
    protected Label count;
    protected static String defaultDirectory = null;
    protected int decimalPlaces;
    protected int digits;
    protected int newMaxCount;
    protected Calibration cal;
    public int numBins;
    protected Thread thread;
    protected ImagePlus impData;
    protected boolean done;
    protected boolean color;
    protected int minHist = 0;
    protected int maxHist = 1000;
    protected int minBin = 0;
    protected int maxBin = 255;
    protected double hist_dB_range;
    protected int total;
    protected boolean messageMin = true;
    protected boolean messageMax = true;

    public LiveHistogram(String title, ImagePlus imp, int numBins) {
        super(NewImage.createByteImage((String)title, (int)328, (int)240, (int)1, (int)4));
        this.numBins = numBins;
        this.impData = imp;
        this.thread = new Thread((Runnable)this, "HistogramLive");
        this.setup();
        this.thread.start();
    }

    public void showHistogram() {
        ImagePlus imp1;
        ImagePlus impCurr = WindowManager.getCurrentImage();
        ImagePlus imagePlus = imp1 = impCurr == this.imp ? this.impData : impCurr;
        if (imp1 == null) {
            this.shutDown();
            return;
        }
        try {
            this.cal = imp1.getCalibration();
            ImageProcessor ipData = imp1.getProcessor();
            this.stats = this.minBin == 0 && this.maxBin == 255 ? imp1.getStatistics(283, this.numBins) : (ipData instanceof ShortProcessor ? new LS(ipData, 283, imp1.getCalibration()) : imp1.getStatistics(283, this.numBins));
            this.histogramL = this.stats.histogram;
            double hmin = this.cal.getCValue(this.stats.histMin);
            double hmax = this.cal.getCValue(this.stats.histMax);
            double minThresh = ipData.getMinThreshold();
            double maxThresh = ipData.getMaxThreshold();
            if (hmax != hmin) {
                int indexMinThresh = (int)(255.0 * (minThresh - hmin) / (hmax - hmin));
                int indexMaxThresh = (int)(255.0 * (maxThresh - hmin) / (hmax - hmin));
                if (indexMinThresh != this.minBin && indexMinThresh >= 0 && indexMinThresh <= 255) {
                    this.minBin = indexMinThresh;
                    this.minBinTF.setText(this.d2s(this.minBin));
                }
                if (indexMaxThresh != this.maxBin && indexMaxThresh >= 0 && indexMaxThresh <= 255) {
                    this.maxBin = indexMaxThresh;
                    this.maxBinTF.setText(this.d2s(this.maxBin));
                }
            }
            if (this.histogramL.length != this.numBins) {
                IJ.showMessage((String)("Error: numBins = " + this.numBins + " histogram.length = " + this.histogramL.length));
                this.shutDown();
                return;
            }
            this.lut = imp1.createLut();
            int type = imp1.getType();
            boolean fixedRange = type == 0 || type == 3 || type == 4;
            ImageProcessor ip = this.imp.getProcessor();
            if (ip == null) {
                this.shutDown();
                return;
            }
            boolean bl = this.color = !(imp1.getProcessor() instanceof ColorProcessor) && !this.lut.isGrayscale();
            if (this.color) {
                ip = ip.convertToRGB();
            }
            this.drawHistogram(ip, fixedRange);
            if (imp1 != this.impData) {
                this.impData = imp1;
                this.imp.setTitle("Live histogram of " + imp1.getShortTitle());
            }
            if (this.color) {
                this.imp.setProcessor(null, ip);
            } else {
                this.imp.updateAndDraw();
            }
        }
        catch (NullPointerException e) {
            this.imp.setTitle("Live histogram of: No Image");
        }
        catch (IllegalArgumentException ea) {
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            // empty catch block
        }
    }

    public void run() {
        while (!this.done) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.showHistogram();
        }
    }

    public void windowClosing(WindowEvent e) {
        super.windowClosing(e);
        this.shutDown();
    }

    public void shutDown() {
        this.done = true;
    }

    public void setup() {
        Label highThresh;
        Label lowThresh;
        Label highLabel;
        Label lowLabel;
        Panel buttons = new Panel();
        buttons.setLayout(new FlowLayout(2));
        this.list = new Button("List");
        this.list.addActionListener(this);
        buttons.add(this.list);
        this.copy = new Button("Copy");
        this.copy.addActionListener(this);
        buttons.add(this.copy);
        this.display = new Choice();
        this.display.add("Linear");
        this.display.add("Log");
        this.display.add("Sqrt");
        this.display.add("Lin fxd");
        this.display.add("Sqrt fxd");
        this.display.add("30 dB");
        this.display.add("40 dB");
        this.display.add("50 dB");
        buttons.add(this.display);
        Panel valueAndCount = new Panel();
        valueAndCount.setLayout(new GridLayout(2, 1));
        this.value = new Label("                  ");
        this.value.setFont(new Font("Monospaced", 0, 12));
        valueAndCount.add(this.value);
        this.count = new Label("                  ");
        this.count.setFont(new Font("Monospaced", 0, 12));
        valueAndCount.add(this.count);
        buttons.add(valueAndCount);
        this.add(buttons);
        Panel limits = new Panel();
        limits.setLayout(new GridLayout(2, 6));
        if (IJ.isMacintosh()) {
            lowLabel = new Label("Min Plot ");
            highLabel = new Label("Max Plot ");
        } else {
            lowLabel = new Label("Min Plot");
            highLabel = new Label("Max Plot");
        }
        this.minHistTF = new TextField(this.d2s(this.minHist));
        this.minHistTF.addActionListener(this);
        this.minHistTF.addFocusListener(this);
        this.maxHistTF = new TextField(this.d2s(this.maxHist));
        this.maxHistTF.addActionListener(this);
        this.maxHistTF.addFocusListener(this);
        limits.add(lowLabel);
        limits.add(this.minHistTF);
        limits.add(highLabel);
        limits.add(this.maxHistTF);
        this.controlGroup = new CheckboxGroup();
        this.auto = new Checkbox("Auto");
        this.auto.setCheckboxGroup(this.controlGroup);
        limits.add(this.auto);
        this.manual = new Checkbox("Manual");
        this.manual.setCheckboxGroup(this.controlGroup);
        limits.add(this.manual);
        this.auto.setState(true);
        if (IJ.isMacintosh()) {
            lowThresh = new Label("Min Bin ");
            highThresh = new Label("Max Bin ");
        } else {
            lowThresh = new Label("Min Bin");
            highThresh = new Label("Max Bin");
        }
        this.minBinTF = new TextField(this.d2s(this.minBin));
        this.minBinTF.addActionListener(this);
        this.minBinTF.addFocusListener(this);
        this.maxBinTF = new TextField(this.d2s(this.maxBin));
        this.maxBinTF.addActionListener(this);
        this.maxBinTF.addFocusListener(this);
        limits.add(lowThresh);
        limits.add(this.minBinTF);
        limits.add(highThresh);
        limits.add(this.maxBinTF);
        limits.add(new Label(" "));
        limits.add(new Label(" "));
        this.add(limits);
        this.pack();
    }

    public void mouseMoved(int x, int y) {
        if (this.value == null || this.count == null) {
            return;
        }
        if (this.frame != null && x >= this.frame.x && x <= this.frame.x + this.frame.width) {
            if ((x -= this.frame.x) > 255) {
                x = 255;
            }
            int index = (int)((double)x * (double)this.histogramL.length / 256.0);
            this.value.setText("  Value: " + IJ.d2s((double)this.cal.getCValue(this.stats.histMin + (double)index * this.stats.binSize), (int)this.digits));
            this.count.setText("  Count: " + this.histogramL[index]);
        } else {
            this.value.setText("");
            this.count.setText("");
        }
    }

    protected void drawHistogram(ImageProcessor ip, boolean fixedRange) {
        int maxCount2 = 0;
        if (ip == null) {
            this.shutDown();
            return;
        }
        ip.setColor(Color.black);
        ip.setLineWidth(1);
        this.decimalPlaces = Analyzer.getPrecision();
        this.digits = this.cal.calibrated() || this.stats.binSize != 1.0 ? this.decimalPlaces : 0;
        this.total = 0;
        for (int i = this.minBin; i <= this.maxBin; ++i) {
            this.total += this.histogramL[i];
            if (this.histogramL[i] <= maxCount2 || i == this.stats.mode) continue;
            maxCount2 = this.histogramL[i];
        }
        this.newMaxCount = this.stats.maxCount;
        if (this.newMaxCount > maxCount2 * 2 && maxCount2 != 0) {
            this.newMaxCount = (int)((double)maxCount2 * 1.5);
        }
        int disp = this.display.getSelectedIndex();
        if (this.auto.getState()) {
            this.maxHist = disp <= 2 ? this.newMaxCount : this.total;
            this.maxHistTF.setText(this.d2s(this.maxHist));
            this.minHist = disp == 5 ? this.maxHist / 1000 : (disp == 6 ? this.maxHist / 10000 : (disp == 7 ? this.maxHist / 100000 : 0));
            this.minHistTF.setText(this.d2s(this.minHist));
        } else if (disp == 5) {
            this.minHist = this.maxHist / 1000;
            this.minHistTF.setText(this.d2s(this.minHist));
        } else if (disp == 6) {
            this.minHist = this.maxHist / 10000;
            this.minHistTF.setText(this.d2s(this.minHist));
        } else if (disp == 7) {
            this.minHist = this.maxHist / 100000;
            this.minHistTF.setText(this.d2s(this.minHist));
        }
        if (this.newMaxCount > 0) {
            if (disp == 0) {
                this.clear(ip);
                this.drawPlot(ip);
            } else if (disp == 1) {
                this.clear(ip);
                this.drawLogPlot(ip);
                this.drawPlot(ip);
            } else if (disp == 2) {
                this.clear(ip);
                this.drawSqrtPlot(ip);
                this.drawPlot(ip);
            } else if (disp == 3) {
                this.clear(ip);
                this.drawPlot(ip);
            } else if (disp == 4) {
                this.clear(ip);
                this.drawSqrtPlot(ip);
                this.drawPlot(ip);
            } else if (disp == 5) {
                this.hist_dB_range = 30.0;
                this.clear(ip);
                this.drawdBPlot(ip);
            } else if (disp == 6) {
                this.hist_dB_range = 40.0;
                this.clear(ip);
                this.drawdBPlot(ip);
            } else if (disp == 7) {
                this.hist_dB_range = 50.0;
                this.clear(ip);
                this.drawdBPlot(ip);
            }
        } else {
            this.clear(ip);
        }
        int x = 21;
        int y = 140;
        this.lut.drawUnscaledColorBar(ip, x - 1, y, 256, 12);
        this.drawText(ip, x, y += 27, fixedRange);
    }

    void clear(ImageProcessor ip) {
        if (ip == null) {
            return;
        }
        if (this.color) {
            int white = 0xFFFFFF;
            int[] pixels = (int[])ip.getPixels();
            int n = pixels.length;
            for (int i = 0; i < n; ++i) {
                pixels[i] = white;
            }
        } else {
            int white = -1;
            byte[] pixels = (byte[])ip.getPixels();
            int n = pixels.length;
            for (int i = 0; i < n; ++i) {
                pixels[i] = white;
            }
        }
    }

    void drawPlot(ImageProcessor ip) {
        this.frame = new Rectangle(20, 10, 256, 128);
        ip.drawRect(this.frame.x - 1, this.frame.y, this.frame.width + 2, this.frame.height + 1);
        int histRange = this.maxHist - this.minHist;
        if (histRange <= 0) {
            return;
        }
        for (int i = 0; i < 256; ++i) {
            int y;
            int index = (int)((double)i * (double)this.histogramL.length / 256.0);
            if (index < this.minBin || index > this.maxBin) {
                y = 0;
            } else {
                y = 128 * (this.histogramL[index] - this.minHist) / histRange;
                if (y > 128) {
                    y = 128;
                }
                if (y < 0) {
                    y = 0;
                }
            }
            ip.drawLine(i + 20, 138, i + 20, 138 - y);
        }
    }

    void drawSqrtPlot(ImageProcessor ip) {
        double min;
        this.frame = new Rectangle(20, 10, 256, 128);
        ip.drawRect(this.frame.x - 1, this.frame.y, this.frame.width + 2, this.frame.height + 1);
        if (this.maxHist <= 0) {
            return;
        }
        if (this.minHist < 0) {
            return;
        }
        double max = Math.sqrt(this.maxHist);
        double histRange = max - (min = Math.sqrt(this.minHist));
        if (histRange <= 0.0) {
            return;
        }
        ip.setColor(Color.gray);
        for (int i = 0; i < 256; ++i) {
            int y;
            int index = (int)((double)i * (double)this.histogramL.length / 256.0);
            if (index < this.minBin || index > this.maxBin) {
                y = 0;
            } else {
                y = (int)(128.0 * (Math.sqrt(this.histogramL[index]) - min) / histRange);
                if (y > 128) {
                    y = 128;
                }
                if (y < 0) {
                    y = 0;
                }
            }
            ip.drawLine(i + 20, 138, i + 20, 138 - y);
        }
        ip.setColor(Color.black);
    }

    void drawLogPlot(ImageProcessor ip) {
        this.frame = new Rectangle(20, 10, 256, 128);
        ip.drawRect(this.frame.x - 1, this.frame.y, this.frame.width + 2, this.frame.height + 1);
        if (this.maxHist <= 0) {
            return;
        }
        double max = Math.log(this.maxHist);
        ip.setColor(Color.gray);
        for (int i = 0; i < 256; ++i) {
            int y;
            int index = (int)((double)i * (double)this.histogramL.length / 256.0);
            if (index < this.minBin || index > this.maxBin) {
                y = 0;
            } else {
                int n = y = this.histogramL[index] <= 0 ? 0 : (int)(128.0 * Math.log(this.histogramL[index]) / max);
                if (y > 128) {
                    y = 128;
                }
            }
            ip.drawLine(i + 20, 138, i + 20, 138 - y);
        }
        ip.setColor(Color.black);
    }

    void drawdBPlot(ImageProcessor ip) {
        this.frame = new Rectangle(20, 10, 256, 128);
        ip.drawRect(this.frame.x - 1, this.frame.y, this.frame.width + 2, this.frame.height + 1);
        ip.setColor(Color.gray);
        double scale = 128.0 / this.hist_dB_range * (10.0 / Math.log(10.0));
        if (this.maxHist <= 0) {
            return;
        }
        for (int i = 0; i < 256; ++i) {
            int y;
            int index = (int)((double)i * (double)this.histogramL.length / 256.0);
            if (index < this.minBin || index > this.maxBin) {
                y = 0;
            } else {
                int n = y = this.histogramL[index] <= 0 ? 0 : (int)(128.0 + scale * Math.log((double)this.histogramL[index] / (double)this.maxHist));
                if (y < 0) {
                    y = 0;
                }
                if (y > 128) {
                    y = 128;
                }
            }
            ip.drawLine(i + 20, 138, i + 20, 138 - y);
        }
        ip.setColor(Color.black);
    }

    void drawText(ImageProcessor ip, int x, int y, boolean fixedRange) {
        ip.setFont(new Font("SansSerif", 0, 12));
        double hmin = this.cal.getCValue(this.stats.histMin);
        double hmax = this.cal.getCValue(this.stats.histMax);
        double binWidth = fixedRange && !this.cal.calibrated() ? this.stats.binSize : (hmax - hmin) / (double)this.stats.nBins;
        binWidth = Math.abs(binWidth);
        boolean showBins = binWidth != 1.0 || !fixedRange;
        int col1 = 25;
        int col2 = 148;
        int row1 = y + 25;
        if (showBins) {
            row1 -= 8;
        }
        int row2 = row1 + 15;
        int row3 = row2 + 15;
        int row4 = row3 + 15;
        ip.drawString("Count: " + this.stats.pixelCount, col1, row1);
        ip.drawString("Mean: " + this.d2s(this.stats.mean), col1, row2);
        ip.drawString("StdDev: " + this.d2s(this.stats.stdDev), col1, row3);
        ip.drawString("Mode: " + this.d2s(this.stats.dmode) + " (" + this.stats.maxCount + ")", col2, row3);
        ip.drawString("Min: " + this.d2s(this.stats.min), col2, row1);
        ip.drawString("Max: " + this.d2s(this.stats.max), col2, row2);
        ip.setFont(new Font("SansSerif", 0, 10));
        ip.drawString(this.d2s(hmin), x - 4, y);
        ip.drawString(this.d2s(hmax), x + 256 - this.getWidth(hmax, ip) + 10, y);
        int right = 1;
        int up = 22;
        ip.drawString(this.d2s(this.minHist), x + 256 + right, y - up);
        ip.drawString(this.d2s(this.maxHist), x + 256 + right, y - up - 128);
        if (showBins) {
            ip.drawString("Bins: " + this.d2s(this.stats.nBins), col1, row4);
            ip.drawString("Bin Width: " + this.d2s(binWidth), col2, row4);
        }
    }

    String d2s(double d) {
        if ((double)((int)d) == d) {
            return IJ.d2s((double)d, (int)0);
        }
        return IJ.d2s((double)d, (int)this.decimalPlaces);
    }

    int getWidth(double d, ImageProcessor ip) {
        return ip.getStringWidth(this.d2s(d));
    }

    void showList() {
        StringBuffer sb = new StringBuffer();
        for (int i = this.minBin; i <= this.maxBin; ++i) {
            sb.append(IJ.d2s((double)this.cal.getCValue(this.stats.histMin + (double)i * this.stats.binSize), (int)this.digits) + "\t" + this.histogramL[i] + "\n");
        }
        TextWindow tw = new TextWindow(this.getTitle(), "value\tcount", sb.toString(), 200, 400);
    }

    void copyToClipboard() {
        Clipboard systemClipboard = null;
        try {
            systemClipboard = this.getToolkit().getSystemClipboard();
        }
        catch (Exception e) {
            systemClipboard = null;
        }
        if (systemClipboard == null) {
            IJ.error((String)"Unable to copy to Clipboard.");
            return;
        }
        IJ.showStatus((String)"Copying histogram values...");
        CharArrayWriter aw = new CharArrayWriter(this.stats.nBins * 4);
        PrintWriter pw = new PrintWriter(aw);
        for (int i = this.minBin; i <= this.maxBin; ++i) {
            pw.print(IJ.d2s((double)this.cal.getCValue(this.stats.histMin + (double)i * this.stats.binSize), (int)this.digits) + "\t" + this.histogramL[i] + "\n");
        }
        String text = aw.toString();
        pw.close();
        StringSelection contents = new StringSelection(text);
        systemClipboard.setContents(contents, this);
        IJ.showStatus((String)(text.length() + " characters copied to Clipboard"));
    }

    public void actionPerformed(ActionEvent e) {
        Object b = e.getSource();
        if (b instanceof TextField) {
            this.handleText((TextField)b);
        } else if (b == this.list) {
            this.showList();
        } else if (b == this.copy) {
            this.copyToClipboard();
        }
    }

    public void focusGained(FocusEvent e) {
        Component c = e.getComponent();
        if (c instanceof TextField) {
            ((TextField)c).selectAll();
        }
    }

    public void focusLost(FocusEvent e) {
        Component c = e.getComponent();
        if (c instanceof TextField) {
            this.handleText((TextField)c);
        }
    }

    protected void handleText(TextField b) {
        try {
            if (WindowManager.getWindowCount() < 2) {
                return;
            }
            if (this.impData == null) {
                return;
            }
            if (this.impData == this.imp) {
                return;
            }
            if (b == this.minHistTF) {
                int newMin = this.readNumber(this.minHistTF);
                if (this.auto.getState()) {
                    this.minHistTF.setText(this.d2s(this.minHist));
                } else if (newMin < 0) {
                    IJ.beep();
                    this.minHistTF.setText(this.d2s(this.minHist));
                } else {
                    this.minHist = newMin;
                }
            } else if (b == this.maxHistTF) {
                int newMax = this.readNumber(this.maxHistTF);
                if (this.auto.getState()) {
                    this.maxHistTF.setText(this.d2s(this.maxHist));
                } else if (newMax < 0) {
                    IJ.beep();
                    this.maxHistTF.setText(this.d2s(this.maxHist));
                } else {
                    this.maxHist = newMax;
                }
            } else if (b == this.minBinTF) {
                int newMin = this.readNumber(this.minBinTF);
                if (newMin < 0 || newMin > 255) {
                    IJ.beep();
                    this.minBin = 0;
                    this.minBinTF.setText(this.d2s(this.minBin));
                } else {
                    boolean typeOK;
                    ImageProcessor ip = this.impData.getProcessor();
                    boolean bl = typeOK = ip instanceof ByteProcessor || ip instanceof ShortProcessor;
                    if (newMin != 0 && !typeOK) {
                        if (this.messageMin) {
                            this.messageMin = false;
                            IJ.showMessage((String)"Min Bin adjustments are limited to 8-bit and 16-bit images.");
                        }
                        this.minBin = 0;
                        this.minBinTF.setText(this.d2s(this.minBin));
                    } else {
                        this.minBin = newMin;
                    }
                }
                this.impData.getProcessor().setThreshold((double)this.minBin, (double)this.maxBin, 2);
            } else if (b == this.maxBinTF) {
                int newMax = this.readNumber(this.maxBinTF);
                if (newMax < 0 || newMax > 255) {
                    IJ.beep();
                    this.maxBin = 255;
                    this.maxBinTF.setText(this.d2s(this.maxBin));
                } else {
                    boolean typeOK;
                    ImageProcessor ip = this.impData.getProcessor();
                    boolean bl = typeOK = ip instanceof ByteProcessor || ip instanceof ShortProcessor;
                    if (newMax != 255 && !typeOK) {
                        if (this.messageMax) {
                            this.messageMax = false;
                            IJ.showMessage((String)"Max Bin adjustments are limited to 8-bit and 16-bit images.");
                        }
                        this.maxBin = 255;
                        this.maxBinTF.setText(this.d2s(this.maxBin));
                    } else {
                        this.maxBin = newMax;
                    }
                }
                this.impData.getProcessor().setThreshold((double)this.minBin, (double)this.maxBin, 2);
            }
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public int readNumber(TextField tf) {
        int result;
        String s = tf.getText();
        try {
            Integer Int = new Integer(s.trim());
            result = Int;
        }
        catch (NumberFormatException e) {
            result = -1;
        }
        return result;
    }

    public void lostOwnership(Clipboard clipboard, Transferable contents) {
    }

    public class LS
    extends ImageStatistics {
        public LS(ImageProcessor ip, int mOptions, Calibration cal) {
            this.width = ip.getWidth();
            this.height = ip.getHeight();
            this.setupSS(ip, cal);
            double minT = ip.getMinThreshold();
            int[] hist = ip.getHistogram();
            int minThreshold = LiveHistogram.this.minBin;
            int maxThreshold = LiveHistogram.this.maxBin;
            float[] cTable = cal != null ? cal.getCTable() : null;
            this.getRawMinAndMax(hist);
            this.histMin = this.min;
            this.histMax = this.max;
            this.getStatistics(hist, (int)this.min, (int)this.max, minThreshold, maxThreshold, cTable);
            this.getMode(minThreshold, maxThreshold, cTable);
            this.getFinalMinAndMax(hist, (int)this.min, (int)this.max, minThreshold, maxThreshold, cTable);
        }

        void setupSS(ImageProcessor ip, Calibration cal) {
            this.width = ip.getWidth();
            this.height = ip.getHeight();
            Rectangle roi = ip.getRoi();
            if (roi != null) {
                this.rx = roi.x;
                this.ry = roi.y;
                this.rw = roi.width;
                this.rh = roi.height;
            } else {
                this.rx = 0;
                this.ry = 0;
                this.rw = this.width;
                this.rh = this.height;
            }
            if (cal != null) {
                this.pw = cal.pixelWidth;
                this.ph = cal.pixelHeight;
            } else {
                this.pw = 1.0;
                this.ph = 1.0;
            }
            this.roiX = (double)this.rx * this.pw;
            this.roiY = (double)this.ry * this.ph;
            this.roiWidth = (double)this.rw * this.pw;
            this.roiHeight = (double)this.rh * this.ph;
        }

        void getRawMinAndMax(int[] hist) {
            int max;
            int min;
            for (min = 0; hist[min] == 0 && min < 65535; ++min) {
            }
            this.min = min;
            for (max = 65535; hist[max] == 0 && max > 0; --max) {
            }
            this.max = max;
        }

        void getStatistics(int[] hist, int min, int max, int minThreshold, int maxThreshold, float[] cTable) {
            double sum = 0.0;
            double sum2 = 0.0;
            double scale = (double)this.nBins / (this.histMax - this.histMin);
            int hMin = (int)this.histMin;
            this.binSize = (this.histMax - this.histMin) / (double)this.nBins;
            this.histogram = new int[this.nBins];
            for (int i = min; i <= max; ++i) {
                int count = hist[i];
                int index = (int)(scale * (double)(i - hMin));
                if (index >= this.nBins) {
                    index = this.nBins - 1;
                }
                int n = index;
                this.histogram[n] = this.histogram[n] + count;
                if (!(index >= minThreshold & index <= maxThreshold)) continue;
                this.pixelCount += count;
                double value = cTable == null ? (double)i : (double)cTable[i];
                sum += value * (double)count;
                sum2 += value * value * (double)count;
            }
            this.area = (double)this.pixelCount * this.pw * this.ph;
            this.mean = this.pixelCount > 0 ? sum / (double)this.pixelCount : 0.0;
            this.umean = this.mean;
            this.calculateStdDevSS(this.pixelCount, sum, sum2);
        }

        void getMode(int minThreshold, int maxThreshold, float[] cTable) {
            this.maxCount = 0;
            for (int i = minThreshold; i <= maxThreshold; ++i) {
                int count = this.histogram[i];
                if (count <= this.maxCount) continue;
                this.maxCount = count;
                this.mode = i;
            }
            this.dmode = this.histMin + (double)this.mode * this.binSize;
            if (cTable != null) {
                this.dmode = cTable[(int)this.dmode];
            }
        }

        void calculateStdDevSS(int n, double sum, double sum2) {
            if (n > 0) {
                this.stdDev = ((double)n * sum2 - sum * sum) / (double)n;
                this.stdDev = this.stdDev > 0.0 ? Math.sqrt(this.stdDev / ((double)n - 1.0)) : 0.0;
            } else {
                this.stdDev = 0.0;
            }
        }

        void getFinalMinAndMax(int[] hist, int minValue, int maxValue, int minThreshold, int maxThreshold, float[] cTable) {
            this.min = Double.MAX_VALUE;
            this.max = -1.7976931348623157E308;
            double v = 0.0;
            double scale = (double)this.nBins / (this.histMax - this.histMin);
            int hMin = (int)this.histMin;
            if (cTable != null) {
                for (int i = minValue; i <= maxValue; ++i) {
                    int index = (int)(scale * (double)(i - hMin));
                    if (index >= this.nBins) {
                        index = this.nBins - 1;
                    }
                    if (!(index >= minThreshold & index <= maxThreshold) || hist[i] <= 0) continue;
                    v = cTable[i];
                    if (v < this.min) {
                        this.min = v;
                    }
                    if (!(v > this.max)) continue;
                    this.max = v;
                }
            } else {
                for (int i = minValue; i <= maxValue; ++i) {
                    int index = (int)(scale * (double)(i - hMin));
                    if (index >= this.nBins) {
                        index = this.nBins - 1;
                    }
                    if (!(index >= minThreshold & index <= maxThreshold) || hist[i] <= 0) continue;
                    if ((double)i < this.min) {
                        this.min = i;
                    }
                    if (!((double)i > this.max)) continue;
                    this.max = i;
                }
            }
        }
    }
}

