/*
 * Decompiled with CFR 0.152.
 */
import ij.IJ;
import ij.ImagePlus;
import ij.gui.GenericDialog;
import ij.gui.Plot;
import ij.measure.Calibration;
import ij.plugin.filter.PlugInFilter;
import ij.process.ImageProcessor;
import java.awt.Frame;
import java.awt.Rectangle;

public class Radial_Profile
implements PlugInFilter {
    ImagePlus imp;
    boolean canceled = false;
    double X0;
    double Y0;
    double mR;
    Rectangle rct;
    int nBins = 100;
    static boolean useCalibration = false;

    public int setup(String arg, ImagePlus imp) {
        this.imp = imp;
        return 1311;
    }

    public void run(ImageProcessor ip) {
        this.setXYcenter();
        IJ.makeOval((int)((int)(this.X0 - this.mR)), (int)((int)(this.Y0 - this.mR)), (int)((int)(2.0 * this.mR)), (int)((int)(2.0 * this.mR)));
        this.doDialog();
        IJ.makeOval((int)((int)(this.X0 - this.mR)), (int)((int)(this.Y0 - this.mR)), (int)((int)(2.0 * this.mR)), (int)((int)(2.0 * this.mR)));
        this.imp.startTiming();
        if (this.canceled) {
            return;
        }
        this.doRadialDistribution(ip);
    }

    private void setXYcenter() {
        this.rct = this.imp.getRoi().getBoundingRect();
        this.X0 = (double)this.rct.x + (double)this.rct.width / 2.0;
        this.Y0 = (double)this.rct.y + (double)this.rct.height / 2.0;
        this.mR = (double)(this.rct.width + this.rct.height) / 4.0;
    }

    private void doRadialDistribution(ImageProcessor ip) {
        this.nBins = (int)(3.0 * this.mR / 4.0);
        float[][] Accumulator = new float[2][this.nBins];
        double xmin = this.X0 - this.mR;
        double xmax = this.X0 + this.mR;
        double ymin = this.Y0 - this.mR;
        double ymax = this.Y0 + this.mR;
        for (double i = xmin; i < xmax; i += 1.0) {
            for (double j = ymin; j < ymax; j += 1.0) {
                double R = Math.sqrt((i - this.X0) * (i - this.X0) + (j - this.Y0) * (j - this.Y0));
                int thisBin = (int)Math.floor(R / this.mR * (double)this.nBins);
                if (thisBin == 0) {
                    thisBin = 1;
                }
                if (--thisBin > this.nBins - 1) {
                    thisBin = this.nBins - 1;
                }
                Accumulator[0][thisBin] = Accumulator[0][thisBin] + 1.0f;
                Accumulator[1][thisBin] = Accumulator[1][thisBin] + ip.getPixelValue((int)i, (int)j);
            }
        }
        Calibration cal = this.imp.getCalibration();
        if (cal.getUnit() == "pixel") {
            useCalibration = false;
        }
        Plot plot = null;
        if (useCalibration) {
            for (int i = 0; i < this.nBins; ++i) {
                Accumulator[1][i] = Accumulator[1][i] / Accumulator[0][i];
                Accumulator[0][i] = (float)(cal.pixelWidth * this.mR * ((double)(i + 1) / (double)this.nBins));
            }
            plot = new Plot("Radial Profile Plot", "Radius [" + cal.getUnits() + "]", "Normalized Integrated Intensity", Accumulator[0], Accumulator[1]);
        } else {
            for (int i = 0; i < this.nBins; ++i) {
                Accumulator[1][i] = Accumulator[1][i] / Accumulator[0][i];
                Accumulator[0][i] = (float)(this.mR * ((double)(i + 1) / (double)this.nBins));
            }
            plot = new Plot("Radial Profile Plot", "Radius [pixels]", "Normalized Integrated Intensity", Accumulator[0], Accumulator[1]);
        }
        plot.show();
    }

    private void doDialog() {
        this.canceled = false;
        GenericDialog gd = new GenericDialog("Radial Distribution...", (Frame)IJ.getInstance());
        gd.addNumericField("X center (pixels):", this.X0, 2);
        gd.addNumericField("Y center (pixels):", this.Y0, 2);
        gd.addNumericField("Radius (pixels):", this.mR, 2);
        gd.addCheckbox("Use Spatial Calibration", useCalibration);
        gd.showDialog();
        if (gd.wasCanceled()) {
            this.canceled = true;
            return;
        }
        this.X0 = gd.getNextNumber();
        this.Y0 = gd.getNextNumber();
        this.mR = gd.getNextNumber();
        useCalibration = gd.getNextBoolean();
        if (gd.invalidNumber()) {
            IJ.showMessage((String)"Error", (String)"Invalid input Number");
            this.canceled = true;
            return;
        }
    }
}

