/*
 * Decompiled with CFR 0.152.
 */
package com.sun.net.ssl;

import com.sun.net.ssl.KeyManager;
import com.sun.net.ssl.SSLContextSpi;
import com.sun.net.ssl.SSLSecurity;
import com.sun.net.ssl.TrustManager;
import com.sun.net.ssl.internal.ssl.ExportControl;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.SecureRandom;
import javax.net.ssl.SSLServerSocketFactory;
import javax.net.ssl.SSLSocketFactory;

public class SSLContext {
    private Provider provider;
    private SSLContextSpi contextSpi;
    private String protocol;

    protected SSLContext(SSLContextSpi sSLContextSpi, Provider provider, String string) {
        this.contextSpi = sSLContextSpi;
        this.provider = provider;
        this.protocol = string;
    }

    public static SSLContext getInstance(String string) throws NoSuchAlgorithmException {
        try {
            Object[] objectArray = SSLSecurity.getImpl(string, "SSLContext", (String)null);
            return new SSLContext((SSLContextSpi)objectArray[0], (Provider)objectArray[1], string);
        }
        catch (NoSuchProviderException noSuchProviderException) {
            throw new NoSuchAlgorithmException(string + " not found");
        }
    }

    public static SSLContext getInstance(String string, String string2) throws NoSuchAlgorithmException, NoSuchProviderException {
        if (string2 == null || string2.length() == 0) {
            throw new IllegalArgumentException("missing provider");
        }
        Object[] objectArray = SSLSecurity.getImpl(string, "SSLContext", string2);
        return new SSLContext((SSLContextSpi)objectArray[0], (Provider)objectArray[1], string);
    }

    public static SSLContext getInstance(String string, Provider provider) throws NoSuchAlgorithmException {
        if (provider == null) {
            throw new IllegalArgumentException("missing provider");
        }
        Object[] objectArray = SSLSecurity.getImpl(string, "SSLContext", provider);
        return new SSLContext((SSLContextSpi)objectArray[0], (Provider)objectArray[1], string);
    }

    public final String getProtocol() {
        return this.protocol;
    }

    public final Provider getProvider() {
        return this.provider;
    }

    public final void init(KeyManager[] keyManagerArray, TrustManager[] trustManagerArray, SecureRandom secureRandom) throws KeyManagementException {
        this.contextSpi.engineInit(keyManagerArray, trustManagerArray, secureRandom);
    }

    public final SSLSocketFactory getSocketFactory() {
        SSLSocketFactory sSLSocketFactory = this.contextSpi.engineGetSocketFactory();
        ExportControl.checkCipherSuites(sSLSocketFactory);
        return sSLSocketFactory;
    }

    public final SSLServerSocketFactory getServerSocketFactory() {
        SSLServerSocketFactory sSLServerSocketFactory = this.contextSpi.engineGetServerSocketFactory();
        ExportControl.checkCipherSuites(sSLServerSocketFactory);
        return sSLServerSocketFactory;
    }
}

