/*
 * Decompiled with CFR 0.152.
 */
import com.sun.media.ExclusiveUse;
import com.sun.media.util.Registry;
import java.awt.Frame;
import java.awt.TextArea;
import java.util.Vector;
import javax.media.Format;
import javax.media.PlugInManager;
import javax.media.Renderer;
import javax.media.format.AudioFormat;

public class JMFInit
extends Frame
implements Runnable {
    private String tempDir = "/tmp";
    private TextArea textBox;
    private boolean done = false;
    private String userHome;

    public JMFInit(String[] args) {
        super("Initializing JMF...");
        this.createGUI();
        this.updateTemp(args);
        if (args.length > 2) {
            boolean allow = false;
            if (args[2].equals("1")) {
                allow = true;
            }
            Registry.set("secure.allowCaptureFromApplets", new Boolean(allow));
            allow = false;
            if (args.length > 3) {
                if (args[3].equals("1")) {
                    allow = true;
                }
                Registry.set("secure.allowSaveFileFromApplets", new Boolean(allow));
            }
            try {
                Registry.commit();
            }
            catch (Exception e2) {
                // empty catch block
            }
        }
        Thread detectThread = new Thread(this);
        detectThread.run();
        for (int slept = 0; !this.done && slept < 120000; slept += 500) {
            try {
                Thread.currentThread();
                Thread.sleep(500L);
                continue;
            }
            catch (InterruptedException ie) {
                // empty catch block
            }
        }
        if (!this.done) {
            this.message("Aborting detection!");
        }
        try {
            Thread.currentThread();
            Thread.sleep(2000L);
        }
        catch (InterruptedException ie) {
            // empty catch block
        }
    }

    public void run() {
        this.detectDirectAudio();
        this.detectS8DirectAudio();
        this.detectCaptureDevices();
        this.done = true;
    }

    private void updateTemp(String[] args) {
        if (args.length > 0) {
            this.tempDir = args[0];
            this.message("Setting cache directory to " + this.tempDir);
            Registry r = new Registry();
            try {
                Registry.set("secure.cacheDir", this.tempDir);
                r.commit();
                this.message("Updated registry");
            }
            catch (Exception e2) {
                this.message("Couldn't update registry!");
            }
        }
    }

    private void detectCaptureDevices() {
        this.message("Looking for Audio capturer");
        Class<?> dsauto = null;
        try {
            dsauto = Class.forName("DirectSoundAuto");
            dsauto.newInstance();
            this.message("Finished detecting DirectSound capturer");
        }
        catch (ThreadDeath td) {
            throw td;
        }
        catch (Throwable t) {
            // empty catch block
        }
        Class<?> jsauto = null;
        try {
            jsauto = Class.forName("JavaSoundAuto");
            jsauto.newInstance();
            this.message("Finished detecting javasound capturer");
        }
        catch (ThreadDeath td) {
            throw td;
        }
        catch (Throwable t) {
            this.message("JavaSound capturer detection failed!");
        }
        this.message("Looking for video capture devices");
        Class<?> auto = null;
        Class<?> autoPlus = null;
        try {
            auto = Class.forName("VFWAuto");
        }
        catch (Exception e2) {
            // empty catch block
        }
        if (auto == null) {
            try {
                auto = Class.forName("SunVideoAuto");
            }
            catch (Exception ee) {
                // empty catch block
            }
            try {
                autoPlus = Class.forName("SunVideoPlusAuto");
            }
            catch (Exception ee) {
                // empty catch block
            }
        }
        if (auto == null) {
            try {
                auto = Class.forName("V4LAuto");
            }
            catch (Exception ee) {
                // empty catch block
            }
        }
        try {
            Object instance = auto.newInstance();
            if (autoPlus != null) {
                Object instancePlus = autoPlus.newInstance();
            }
            this.message("Finished detecting video capture devices");
        }
        catch (ThreadDeath td) {
            throw td;
        }
        catch (Throwable t) {
            this.message("Capture device detection failed!");
        }
    }

    private void detectDirectAudio() {
        int plType = 4;
        String dar = "com.sun.media.renderer.audio.DirectAudioRenderer";
        try {
            Class<?> cls = Class.forName("VFWAuto");
            cls = Class.forName("com.sun.media.protocol.dsound.DSound");
            cls = Class.forName(dar);
            Renderer rend = (Renderer)cls.newInstance();
            try {
                AudioFormat af = new AudioFormat("LINEAR", 44100.0, 16, 2);
                rend.setInputFormat(af);
                rend.open();
                Format[] inputFormats = rend.getSupportedInputFormats();
                PlugInManager.addPlugIn(dar, inputFormats, new Format[0], plType);
                Vector rendList = PlugInManager.getPlugInList(null, null, plType);
                int listSize = rendList.size();
                if (rendList.elementAt(listSize - 1).equals(dar)) {
                    rendList.removeElementAt(listSize - 1);
                    rendList.insertElementAt(dar, 0);
                    PlugInManager.setPlugInList(rendList, plType);
                    PlugInManager.commit();
                }
                rend.close();
            }
            catch (Throwable t) {}
        }
        catch (Throwable tt) {
            // empty catch block
        }
    }

    private void detectS8DirectAudio() {
        int plType = 4;
        String dar = "com.sun.media.renderer.audio.DirectAudioRenderer";
        try {
            Class<?> cls = Class.forName("SunVideoAuto");
            cls = Class.forName(dar);
            Renderer rend = (Renderer)cls.newInstance();
            if (rend instanceof ExclusiveUse && !((ExclusiveUse)((Object)rend)).isExclusive()) {
                Vector rendList = PlugInManager.getPlugInList(null, null, plType);
                int listSize = rendList.size();
                boolean found = false;
                String rname = null;
                for (int i2 = 0; i2 < listSize; ++i2) {
                    rname = (String)rendList.elementAt(i2);
                    if (!rname.equals(dar)) continue;
                    found = true;
                    rendList.removeElementAt(i2);
                    break;
                }
                if (found) {
                    rendList.insertElementAt(dar, 0);
                    PlugInManager.setPlugInList(rendList, plType);
                    PlugInManager.commit();
                }
            }
        }
        catch (Throwable tt) {
            // empty catch block
        }
    }

    private void message(String mesg) {
        this.textBox.append(mesg + "\n");
    }

    private void createGUI() {
        this.textBox = new TextArea(5, 50);
        this.add("Center", this.textBox);
        this.textBox.setEditable(false);
        this.addNotify();
        this.setVisible(true);
        this.pack();
    }

    public static void main(String[] args) {
        new JMFInit(args);
        System.exit(0);
    }
}

