/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media;

import com.sun.media.JMFSecurity;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.Permission;
import java.security.PrivilegedAction;

public class JDK12Security
implements JMFSecurity {
    public static final JMFSecurity security;
    private static Class cls;
    private static Method dummyMethodRef;
    private static Permission threadPermission;
    private static Permission threadGroupPermission;
    private static Permission connectPermission;
    private static Permission multicastPermission;
    private static Permission readAllFilesPermission;
    private static Constructor filepermcons;

    public static Permission getReadFilePermission(String name) {
        try {
            return (Permission)filepermcons.newInstance(name, "read");
        }
        catch (Exception e2) {
            return null;
        }
    }

    public static Permission getWriteFilePermission(String name) {
        try {
            return (Permission)filepermcons.newInstance(name, "read, write");
        }
        catch (Exception e2) {
            return null;
        }
    }

    public static void dummyMethod() {
    }

    private JDK12Security() {
    }

    public String getName() {
        return "jdk12";
    }

    public static Permission getThreadPermission() {
        return threadPermission;
    }

    public static Permission getThreadGroupPermission() {
        return threadGroupPermission;
    }

    public static Permission getConnectPermission() {
        return connectPermission;
    }

    public static Permission getMulticastPermission() {
        return multicastPermission;
    }

    public static Permission getReadAllFilesPermission() {
        return readAllFilesPermission;
    }

    public void requestPermission(Method[] m2, Class[] c2, Object[][] args, int request) throws SecurityException {
        m2[0] = dummyMethodRef;
        c2[0] = cls;
        args[0] = null;
    }

    public void requestPermission(Method[] m2, Class[] c2, Object[][] args, int request, String parameter) throws SecurityException {
        this.requestPermission(m2, c2, args, request);
    }

    public boolean isLinkPermissionEnabled() {
        return true;
    }

    public void permissionFailureNotification(int permission) {
    }

    public void loadLibrary(final String name) throws UnsatisfiedLinkError {
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                System.loadLibrary(name);
                return null;
            }
        });
    }

    static {
        cls = null;
        dummyMethodRef = null;
        threadPermission = null;
        threadGroupPermission = null;
        connectPermission = null;
        multicastPermission = null;
        readAllFilesPermission = null;
        security = new JDK12Security();
        try {
            cls = security.getClass();
            dummyMethodRef = cls.getMethod("dummyMethod", new Class[0]);
            Class<?> rtperm = Class.forName("java.lang.RuntimePermission");
            Class<?> socketperm = Class.forName("java.net.SocketPermission");
            Class<?> fileperm = Class.forName("java.io.FilePermission");
            filepermcons = fileperm.getConstructor(String.class, String.class);
            Constructor<?> cons = rtperm.getConstructor(String.class);
            threadPermission = (Permission)cons.newInstance("modifyThread");
            threadGroupPermission = (Permission)cons.newInstance("modifyThreadGroup");
            cons = socketperm.getConstructor(String.class, String.class);
            connectPermission = (Permission)cons.newInstance("*", "connect");
            multicastPermission = (Permission)cons.newInstance("*", "accept,connect");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

