/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media;

import com.sun.media.BasicPlugIn;
import com.sun.media.BasicTrackControl;
import com.sun.media.GraphInspector;
import com.sun.media.GraphNode;
import com.sun.media.Log;
import com.sun.media.codec.audio.mpa.DePacketizer;
import com.sun.media.codec.audio.mpa.Packetizer;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.media.Codec;
import javax.media.Format;
import javax.media.Multiplexer;
import javax.media.PlugIn;
import javax.media.PlugInManager;
import javax.media.Renderer;
import javax.media.ResourceUnavailableException;
import javax.media.format.AudioFormat;
import javax.media.format.VideoFormat;

public class SimpleGraphBuilder {
    protected int STAGES = 4;
    protected Hashtable plugIns = new Hashtable(40);
    protected GraphNode[] targetPlugins = null;
    protected Vector targetPluginNames = null;
    protected int targetType = -1;
    int indent = 0;
    protected static GraphInspector inspector;

    public static void setGraphInspector(GraphInspector insp) {
        inspector = insp;
    }

    public void reset() {
        Enumeration enumeration = this.plugIns.elements();
        while (enumeration.hasMoreElements()) {
            GraphNode n2 = (GraphNode)enumeration.nextElement();
            n2.resetAttempted();
        }
    }

    boolean buildGraph(BasicTrackControl tc) {
        Log.comment("Input: " + tc.getOriginalFormat());
        Vector<GraphNode> candidates = new Vector<GraphNode>();
        GraphNode node = new GraphNode(null, null, tc.getOriginalFormat(), null, 0);
        this.indent = 1;
        Log.setIndent(this.indent);
        if (!this.setDefaultTargets(tc.getOriginalFormat())) {
            return false;
        }
        candidates.addElement(node);
        while ((node = this.buildGraph(candidates)) != null) {
            GraphNode failed = this.buildTrackFromGraph(tc, node);
            if (failed == null) {
                this.indent = 0;
                Log.setIndent(this.indent);
                return true;
            }
            this.removeFailure(candidates, failed, tc.getOriginalFormat());
        }
        this.indent = 0;
        Log.setIndent(this.indent);
        return false;
    }

    protected GraphNode buildTrackFromGraph(BasicTrackControl tc, GraphNode node) {
        return null;
    }

    GraphNode buildGraph(Format input) {
        Log.comment("Input: " + input);
        Vector<GraphNode> candidates = new Vector<GraphNode>();
        GraphNode node = new GraphNode(null, null, input, null, 0);
        this.indent = 1;
        Log.setIndent(this.indent);
        if (!this.setDefaultTargets(input)) {
            return null;
        }
        candidates.addElement(node);
        while ((node = this.buildGraph(candidates)) != null) {
            GraphNode failed = this.verifyGraph(node);
            if (failed == null) {
                this.indent = 0;
                Log.setIndent(this.indent);
                return node;
            }
            this.removeFailure(candidates, failed, input);
        }
        this.indent = 0;
        Log.setIndent(this.indent);
        return node;
    }

    GraphNode buildGraph(Vector candidates) {
        GraphNode node;
        while ((node = this.doBuildGraph(candidates)) == null && !candidates.isEmpty()) {
        }
        return node;
    }

    GraphNode doBuildGraph(Vector candidates) {
        Format input;
        Format[] outs;
        if (candidates.isEmpty()) {
            return null;
        }
        GraphNode node = (GraphNode)candidates.firstElement();
        candidates.removeElementAt(0);
        if (!(node.input != null || node.plugin != null && node.plugin instanceof Codec)) {
            Log.error("Internal error: doBuildGraph");
            return null;
        }
        int oldIndent = this.indent;
        Log.setIndent(node.level + 1);
        if (node.plugin != null && SimpleGraphBuilder.verifyInput(node.plugin, node.input) == null) {
            return null;
        }
        GraphNode n2 = this.findTarget(node);
        if (n2 != null) {
            this.indent = oldIndent;
            Log.setIndent(this.indent);
            return n2;
        }
        if (node.level >= this.STAGES) {
            this.indent = oldIndent;
            Log.setIndent(this.indent);
            return null;
        }
        boolean mp3Pkt = false;
        if (node.plugin != null) {
            if (node.output != null) {
                outs = new Format[]{node.output};
            } else {
                outs = node.getSupportedOutputs(node.input);
                if (outs == null || outs.length == 0) {
                    this.indent = oldIndent;
                    Log.setIndent(this.indent);
                    return null;
                }
            }
            input = node.input;
            if (node.plugin instanceof Packetizer) {
                mp3Pkt = true;
            }
        } else {
            outs = new Format[]{node.input};
            input = null;
        }
        boolean foundSomething = false;
        for (int i2 = 0; i2 < outs.length; ++i2) {
            Vector cnames;
            if (!node.custom && input != null && input.equals(outs[i2])) continue;
            if (node.plugin != null) {
                if (SimpleGraphBuilder.verifyOutput(node.plugin, outs[i2]) == null) {
                    if (inspector == null || !inspector.detailMode()) continue;
                    inspector.verifyOutputFailed(node.plugin, outs[i2]);
                    continue;
                }
                if (inspector != null && !inspector.verify((Codec)node.plugin, node.input, outs[i2])) continue;
            }
            if ((cnames = PlugInManager.getPlugInList(outs[i2], null, 2)) == null || cnames.size() == 0) continue;
            for (int j2 = 0; j2 < cnames.size(); ++j2) {
                GraphNode gn = SimpleGraphBuilder.getPlugInNode((String)cnames.elementAt(j2), 2, this.plugIns);
                if (gn == null || mp3Pkt && gn.plugin instanceof DePacketizer || gn.checkAttempted(outs[i2])) continue;
                Format[] ins = gn.getSupportedInputs();
                Format fmt = SimpleGraphBuilder.matches(outs[i2], ins, null, gn.plugin);
                if (fmt == null) {
                    if (inspector == null || !inspector.detailMode()) continue;
                    inspector.verifyInputFailed(gn.plugin, outs[i2]);
                    continue;
                }
                if (inspector != null && inspector.detailMode() && !inspector.verify((Codec)gn.plugin, fmt, null)) continue;
                n2 = new GraphNode(gn, fmt, node, node.level + 1);
                candidates.addElement(n2);
                foundSomething = true;
            }
        }
        this.indent = oldIndent;
        Log.setIndent(this.indent);
        return null;
    }

    GraphNode findTarget(GraphNode node) {
        GraphNode n2;
        Format[] outs;
        if (node.plugin == null) {
            outs = new Format[]{node.input};
        } else if (node.output != null) {
            outs = new Format[]{node.output};
        } else {
            outs = node.getSupportedOutputs(node.input);
            if (outs == null || outs.length == 0) {
                return null;
            }
        }
        if (this.targetPlugins != null && (n2 = this.verifyTargetPlugins(node, outs)) != null) {
            return n2;
        }
        return null;
    }

    GraphNode verifyTargetPlugins(GraphNode node, Format[] outs) {
        for (int i2 = 0; i2 < this.targetPlugins.length; ++i2) {
            Format fmt;
            GraphNode gn = this.targetPlugins[i2];
            if (gn == null) {
                Format[] base;
                String name = (String)this.targetPluginNames.elementAt(i2);
                if (name == null || SimpleGraphBuilder.matches(outs, base = PlugInManager.getSupportedInputFormats(name, this.targetType), null, null) == null) continue;
                gn = SimpleGraphBuilder.getPlugInNode(name, this.targetType, this.plugIns);
                if (gn == null) {
                    this.targetPluginNames.setElementAt(null, i2);
                    continue;
                }
                this.targetPlugins[i2] = gn;
            }
            if ((fmt = SimpleGraphBuilder.matches(outs, gn.getSupportedInputs(), node.plugin, gn.plugin)) == null || inspector != null && (node.plugin != null && !inspector.verify((Codec)node.plugin, node.input, fmt) || ((gn.type == -1 || gn.type == 2) && gn.plugin instanceof Codec ? !inspector.verify((Codec)gn.plugin, fmt, null) : (gn.type == -1 || gn.type == 4) && gn.plugin instanceof Renderer && !inspector.verify((Renderer)gn.plugin, fmt)))) continue;
            return new GraphNode(gn, fmt, node, node.level + 1);
        }
        return null;
    }

    boolean setDefaultTargets(Format in) {
        return this.setDefaultTargetRenderer(in);
    }

    boolean setDefaultTargetRenderer(Format in) {
        this.targetPluginNames = in instanceof AudioFormat ? PlugInManager.getPlugInList(new AudioFormat(null, -1.0, -1, -1, -1, -1, -1, -1.0, null), null, 4) : (in instanceof VideoFormat ? PlugInManager.getPlugInList(new VideoFormat(null, null, -1, null, -1.0f), null, 4) : PlugInManager.getPlugInList(null, null, 4));
        if (this.targetPluginNames == null || this.targetPluginNames.size() == 0) {
            return false;
        }
        this.targetPlugins = new GraphNode[this.targetPluginNames.size()];
        this.targetType = 4;
        return true;
    }

    protected GraphNode verifyGraph(GraphNode node) {
        Format prevFormat = null;
        Vector<PlugIn> used = new Vector<PlugIn>(5);
        if (node.plugin == null) {
            return null;
        }
        Log.setIndent(this.indent++);
        while (node != null && node.plugin != null) {
            if (used.contains(node.plugin)) {
                PlugIn p;
                if (node.cname == null || (p = SimpleGraphBuilder.createPlugIn(node.cname, -1)) == null) {
                    Log.write("Failed to instantiate " + node.cname);
                    return node;
                }
                node.plugin = p;
            } else {
                used.addElement(node.plugin);
            }
            if ((node.type == -1 || node.type == 4) && node.plugin instanceof Renderer) {
                ((Renderer)node.plugin).setInputFormat(node.input);
            } else if ((node.type == -1 || node.type == 2) && node.plugin instanceof Codec) {
                ((Codec)node.plugin).setInputFormat(node.input);
                if (prevFormat != null) {
                    ((Codec)node.plugin).setOutputFormat(prevFormat);
                } else if (node.output != null) {
                    ((Codec)node.plugin).setOutputFormat(node.output);
                }
            }
            if (node.type != -1 && node.type != 4 || !(node.plugin instanceof Renderer)) {
                try {
                    node.plugin.open();
                }
                catch (Exception e2) {
                    Log.warning("Failed to open: " + node.plugin);
                    node.failed = true;
                    return node;
                }
            }
            prevFormat = node.input;
            node = node.prev;
        }
        Log.setIndent(this.indent--);
        return null;
    }

    void removeFailure(Vector candidates, GraphNode failed, Format input) {
        if (failed.plugin == null) {
            return;
        }
        Log.comment("Failed to open plugin " + failed.plugin + ". Will re-build the graph allover again");
        candidates.removeAllElements();
        GraphNode hsyn = new GraphNode(null, null, input, null, 0);
        this.indent = 1;
        Log.setIndent(this.indent);
        candidates.addElement(hsyn);
        failed.failed = true;
        this.plugIns.put(failed.plugin.getClass().getName(), failed);
        Enumeration e2 = this.plugIns.keys();
        while (e2.hasMoreElements()) {
            String ss = (String)e2.nextElement();
            GraphNode nn = (GraphNode)this.plugIns.get(ss);
            if (nn.failed) continue;
            this.plugIns.remove(ss);
        }
    }

    public static GraphNode getPlugInNode(String name, int type, Hashtable plugIns) {
        GraphNode gn = null;
        Object obj = null;
        boolean add = false;
        if (plugIns == null || (gn = (GraphNode)plugIns.get(name)) == null) {
            PlugIn p = SimpleGraphBuilder.createPlugIn(name, type);
            gn = new GraphNode(name, p, null, null, 0);
            if (plugIns != null) {
                plugIns.put(name, gn);
            }
            if (p == null) {
                gn.failed = true;
                return null;
            }
            return gn;
        }
        if (gn.failed) {
            return null;
        }
        if (SimpleGraphBuilder.verifyClass(gn.plugin, type)) {
            return gn;
        }
        return null;
    }

    public static Codec findCodec(Format in, Format out, Format[] selectedIn, Format[] selectedOut) {
        Vector cnames = PlugInManager.getPlugInList(in, out, 2);
        if (cnames == null) {
            return null;
        }
        Codec c2 = null;
        for (int i2 = 0; i2 < cnames.size(); ++i2) {
            Format[] fmts;
            Format matched;
            c2 = (Codec)SimpleGraphBuilder.createPlugIn((String)cnames.elementAt(i2), 2);
            if (c2 == null || (matched = SimpleGraphBuilder.matches(in, fmts = c2.getSupportedInputFormats(), null, (PlugIn)c2)) == null) continue;
            if (selectedIn != null && selectedIn.length > 0) {
                selectedIn[0] = matched;
            }
            if ((fmts = c2.getSupportedOutputFormats(matched)) == null || fmts.length == 0) continue;
            boolean success = false;
            for (int j2 = 0; j2 < fmts.length; ++j2) {
                if (out != null) {
                    if (!out.matches(fmts[j2]) || (matched = out.intersects(fmts[j2])) == null) {
                        continue;
                    }
                } else {
                    matched = fmts[j2];
                }
                if (c2.setOutputFormat(matched) == null) continue;
                success = true;
                break;
            }
            if (!success) continue;
            try {
                c2.open();
            }
            catch (ResourceUnavailableException e2) {
                // empty catch block
            }
            if (selectedOut != null && selectedOut.length > 0) {
                selectedOut[0] = matched;
            }
            return c2;
        }
        return null;
    }

    public static Renderer findRenderer(Format in) {
        Vector names = PlugInManager.getPlugInList(in, null, 4);
        if (names == null) {
            return null;
        }
        Renderer r = null;
        for (int i2 = 0; i2 < names.size(); ++i2) {
            Format[] fmts;
            Format matched;
            r = (Renderer)SimpleGraphBuilder.createPlugIn((String)names.elementAt(i2), 4);
            if (r == null || (matched = SimpleGraphBuilder.matches(in, fmts = r.getSupportedInputFormats(), null, (PlugIn)r)) == null) continue;
            try {
                r.open();
            }
            catch (ResourceUnavailableException e2) {
                // empty catch block
            }
            return r;
        }
        return null;
    }

    public static Vector findRenderingChain(Format in, Vector formats) {
        SimpleGraphBuilder gb = new SimpleGraphBuilder();
        GraphNode n2 = gb.buildGraph(in);
        if (n2 == null) {
            return null;
        }
        Vector<PlugIn> list = new Vector<PlugIn>(10);
        while (n2 != null && n2.plugin != null) {
            list.addElement(n2.plugin);
            if (formats != null) {
                formats.addElement(n2.input);
            }
            n2 = n2.prev;
        }
        return list;
    }

    public static PlugIn createPlugIn(String name, int type) {
        Object obj;
        try {
            Class cls = BasicPlugIn.getClassForName(name);
            obj = cls.newInstance();
        }
        catch (Exception e2) {
            return null;
        }
        catch (Error e3) {
            return null;
        }
        if (SimpleGraphBuilder.verifyClass(obj, type)) {
            return (PlugIn)obj;
        }
        return null;
    }

    public static boolean verifyClass(Object obj, int type) {
        Class cls;
        switch (type) {
            case 2: {
                cls = Codec.class;
                break;
            }
            case 4: {
                cls = Renderer.class;
                break;
            }
            case 5: {
                cls = Multiplexer.class;
                break;
            }
            default: {
                Class clazz = cls = PlugIn.class;
            }
        }
        return cls.isInstance(obj);
    }

    public static Format matches(Format[] outs, Format[] ins, PlugIn up, PlugIn down) {
        if (outs == null) {
            return null;
        }
        for (int i2 = 0; i2 < outs.length; ++i2) {
            Format fmt = SimpleGraphBuilder.matches(outs[i2], ins, up, down);
            if (fmt == null) continue;
            return fmt;
        }
        return null;
    }

    public static Format matches(Format out, Format[] ins, PlugIn up, PlugIn down) {
        if (out == null || ins == null) {
            return null;
        }
        for (int i2 = 0; i2 < ins.length; ++i2) {
            Format fmt;
            if (ins[i2] == null || !ins[i2].getClass().isAssignableFrom(out.getClass()) || !out.matches(ins[i2]) || (fmt = out.intersects(ins[i2])) == null || down != null && (fmt = SimpleGraphBuilder.verifyInput(down, fmt)) == null) continue;
            Format refined = fmt;
            if (up != null && (refined = SimpleGraphBuilder.verifyOutput(up, fmt)) == null || down != null && refined != fmt && SimpleGraphBuilder.verifyInput(down, refined) == null) continue;
            return refined;
        }
        return null;
    }

    public static Format matches(Format[] outs, Format in, PlugIn up, PlugIn down) {
        Format[] ins = new Format[]{in};
        return SimpleGraphBuilder.matches(outs, ins, up, down);
    }

    public static Format verifyInput(PlugIn p, Format in) {
        if (p instanceof Codec) {
            return ((Codec)p).setInputFormat(in);
        }
        if (p instanceof Renderer) {
            return ((Renderer)p).setInputFormat(in);
        }
        return null;
    }

    public static Format verifyOutput(PlugIn p, Format out) {
        if (p instanceof Codec) {
            return ((Codec)p).setOutputFormat(out);
        }
        return null;
    }
}

