/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.content.application.x_jmx;

import com.sun.media.BasicPlayer;
import com.sun.media.Log;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.Panel;
import java.io.File;
import java.io.IOException;
import java.util.Vector;
import javax.media.ControllerErrorEvent;
import javax.media.ControllerEvent;
import javax.media.ControllerListener;
import javax.media.IncompatibleSourceException;
import javax.media.IncompatibleTimeBaseException;
import javax.media.Manager;
import javax.media.MediaLocator;
import javax.media.Player;
import javax.media.RealizeCompleteEvent;
import javax.media.TimeBase;
import javax.media.protocol.DataSource;
import javax.media.protocol.PullDataSource;
import javax.media.protocol.PullSourceStream;
import javax.media.renderer.VisualContainer;

public class Handler
extends BasicPlayer {
    Player[] players = null;
    Player master = null;
    boolean[] realized = null;
    Vector locators = new Vector();
    ControllerListener listener = new PlayerListener(this);
    boolean playersRealized = false;
    Object realizedSync = new Object();
    private boolean closed = false;
    private boolean audioEnabled = false;
    private boolean videoEnabled = false;
    String sessionError = "Cannot create a Player for: ";
    private Container container = null;

    public Handler() {
        this.framePositioning = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean doRealize() {
        super.doRealize();
        MediaLocator ml = null;
        try {
            this.players = new Player[this.locators.size()];
            this.realized = new boolean[this.locators.size()];
            for (int i2 = 0; i2 < this.locators.size(); ++i2) {
                ml = (MediaLocator)this.locators.elementAt(i2);
                this.players[i2] = Manager.createPlayer(ml);
                this.players[i2].addControllerListener(this.listener);
                this.realized[i2] = false;
                this.players[i2].realize();
            }
        }
        catch (Exception e2) {
            Log.error(this.sessionError + ml);
            this.processError = this.sessionError + ml;
            return false;
        }
        try {
            Object e2 = this.realizedSync;
            synchronized (e2) {
                while (!(this.playersRealized || this.isInterrupted() || this.closed)) {
                    this.realizedSync.wait();
                }
            }
        }
        catch (Exception e3) {
            // empty catch block
        }
        if (this.closed || this.isInterrupted()) {
            this.resetInterrupt();
            this.processError = "Realize interrupted";
            return false;
        }
        try {
            this.master = this.players[0];
            for (int i3 = 1; i3 < this.players.length; ++i3) {
                this.master.addController(this.players[i3]);
            }
        }
        catch (IncompatibleTimeBaseException e4) {
            this.processError = "AddController failed";
            return false;
        }
        this.manageController(this.master);
        return true;
    }

    protected void completeRealize() {
        this.state = 300;
        super.completeRealize();
    }

    protected void doStart() {
        super.doStart();
    }

    protected void doStop() {
        super.doStop();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doDeallocate() {
        Object object = this.realizedSync;
        synchronized (object) {
            this.realizedSync.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doClose() {
        this.closed = true;
        Object object = this.realizedSync;
        synchronized (object) {
            this.realizedSync.notify();
        }
        this.stop();
        super.doClose();
    }

    protected TimeBase getMasterTimeBase() {
        return this.master.getTimeBase();
    }

    protected boolean audioEnabled() {
        return this.audioEnabled;
    }

    protected boolean videoEnabled() {
        return this.videoEnabled;
    }

    private void sendMyEvent(ControllerEvent e2) {
        super.sendEvent(e2);
    }

    public void setSource(DataSource source) throws IOException, IncompatibleSourceException {
        String content;
        super.setSource(source);
        if (!(source instanceof PullDataSource)) {
            throw new IncompatibleSourceException();
        }
        PullSourceStream[] pss = ((PullDataSource)source).getStreams();
        if (pss.length != 1) {
            throw new IncompatibleSourceException();
        }
        source.start();
        int len = (int)pss[0].getContentLength();
        if ((long)len == -1L) {
            throw new IncompatibleSourceException();
        }
        byte[] barray = new byte[len];
        try {
            len = pss[0].read(barray, 0, len);
            content = new String(barray);
        }
        catch (Exception e2) {
            throw new IncompatibleSourceException();
        }
        int start = 0;
        int size = content.length();
        String relPath = null;
        char ch = content.charAt(start);
        while (start < size) {
            while ((ch == ' ' || ch == '\n') && ++start < size) {
                ch = content.charAt(start);
            }
            if (start >= size) break;
            int idx = start;
            while (++idx < size && (ch = content.charAt(idx)) != '\n') {
            }
            String str = content.substring(start, idx);
            if (str.indexOf(58) == -1) {
                if (relPath == null) {
                    MediaLocator loc = source.getLocator();
                    if (loc == null) {
                        throw new IncompatibleSourceException();
                    }
                    relPath = loc.toString();
                    int i2 = relPath.lastIndexOf(47);
                    if (i2 < 0) {
                        i2 = relPath.lastIndexOf(File.separator);
                    }
                    relPath = relPath.substring(0, i2 + 1);
                }
                str = relPath + str;
            }
            this.locators.addElement(new MediaLocator(str));
            start = idx;
        }
        if (this.locators.size() < 1) {
            throw new IncompatibleSourceException();
        }
    }

    private void invalidateComp() {
        this.controlComp = null;
        this.controls = null;
    }

    public Component getVisualComponent() {
        Vector<Component> visuals = new Vector<Component>(1);
        for (int i2 = 0; i2 < this.players.length; ++i2) {
            Component comp = this.players[i2].getVisualComponent();
            if (comp == null) continue;
            visuals.addElement(comp);
        }
        if (visuals.size() == 0) {
            return null;
        }
        if (visuals.size() == 1) {
            return (Component)visuals.elementAt(0);
        }
        return this.createVisualContainer(visuals);
    }

    protected Component createVisualContainer(Vector visuals) {
        Boolean hint = (Boolean)Manager.getHint(3);
        if (this.container == null) {
            this.container = hint == null || hint == false ? new HeavyPanel(visuals) : new LightPanel(visuals);
            this.container.setLayout(new FlowLayout());
            this.container.setBackground(Color.black);
            for (int i2 = 0; i2 < visuals.size(); ++i2) {
                Component c2 = (Component)visuals.elementAt(i2);
                this.container.add(c2);
                c2.setSize(c2.getPreferredSize());
            }
        }
        return this.container;
    }

    public void updateStats() {
        for (int i2 = 0; i2 < this.players.length; ++i2) {
            if (this.players[i2] == null) continue;
            ((BasicPlayer)this.players[i2]).updateStats();
        }
    }

    class PlayerListener
    implements ControllerListener {
        Handler handler;

        public PlayerListener(Handler handler2) {
            this.handler = handler2;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public synchronized void controllerUpdate(ControllerEvent ce) {
            int idx;
            Player p = (Player)ce.getSourceController();
            if (p == null) {
                return;
            }
            for (idx = 0; idx < Handler.this.players.length && Handler.this.players[idx] != p; ++idx) {
            }
            if (idx >= Handler.this.players.length) {
                System.err.println("Unknown player: " + p);
                return;
            }
            if (ce instanceof RealizeCompleteEvent) {
                Handler.this.realized[idx] = true;
                for (int i2 = 0; i2 < Handler.this.realized.length; ++i2) {
                    if (Handler.this.realized[i2]) continue;
                    return;
                }
                Object object = Handler.this.realizedSync;
                synchronized (object) {
                    Handler.this.playersRealized = true;
                    Handler.this.realizedSync.notifyAll();
                }
            }
            if (ce instanceof ControllerErrorEvent) {
                Handler.this.players[idx].removeControllerListener(this);
                Log.error("Meta Handler internal error: " + ce);
                Handler.this.players[idx] = null;
            }
        }
    }

    class LightPanel
    extends Container
    implements VisualContainer {
        public LightPanel(Vector visuals) {
        }
    }

    class HeavyPanel
    extends Panel
    implements VisualContainer {
        public HeavyPanel(Vector visuals) {
        }
    }
}

