/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.protocol;

import com.ms.security.PermissionID;
import com.ms.security.PolicyEngine;
import com.sun.media.JMFSecurity;
import com.sun.media.JMFSecurityManager;
import com.sun.media.Log;
import com.sun.media.protocol.BasicPullSourceStream;
import com.sun.media.protocol.CachedPullSourceStream;
import com.sun.media.ui.CacheControlComponent;
import com.sun.media.util.ContentType;
import com.sun.media.util.JMFI18N;
import com.sun.media.util.Registry;
import com.sun.media.util.jdk12;
import com.sun.media.util.jdk12ConnectionAction;
import java.awt.Component;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.Random;
import javax.media.DownloadProgressListener;
import javax.media.ExtendedCachingControl;
import javax.media.Manager;
import javax.media.MediaLocator;
import javax.media.Time;
import javax.media.protocol.ContentDescriptor;
import javax.media.protocol.PullDataSource;
import javax.media.protocol.PullSourceStream;

public class DataSource
extends PullDataSource {
    protected boolean connected = false;
    private String contentType = null;
    private PullSourceStream[] pssArray = new PullSourceStream[1];
    private CachedPullSourceStream cachedStream = null;
    private long contentLength = -1L;
    private InputStream inputStream;
    private String fileSeparator = System.getProperty("file.separator");
    private boolean downLoadThreadStarted = false;
    private boolean isEnabledCaching = false;
    private ExtendedCachingControl[] cachingControls = new ExtendedCachingControl[0];
    private static JMFSecurity jmfSecurity = null;
    private static boolean securityPrivelege = false;
    private Method[] m = new Method[1];
    private Class[] cl = new Class[1];
    private Object[][] args = new Object[1][0];

    public String getContentType() {
        if (!this.connected) {
            return null;
        }
        return this.contentType;
    }

    public void connect() throws IOException {
        Object allowCachingObj;
        URLConnection urlC;
        URL url;
        if (this.connected) {
            return;
        }
        MediaLocator locator = this.getLocator();
        if (locator == null) {
            throw new IOException(this + ": connect() failed");
        }
        try {
            url = locator.getURL();
            urlC = url.openConnection();
            urlC.setAllowUserInteraction(true);
        }
        catch (MalformedURLException e2) {
            throw new IOException(this + ": connect() failed");
        }
        String protocol = url.getProtocol();
        boolean needConnectPermission = true;
        try {
            this.inputStream = urlC.getInputStream();
            needConnectPermission = false;
        }
        catch (Throwable e3) {
            // empty catch block
        }
        if (this.inputStream == null) {
            if (jmfSecurity != null) {
                try {
                    if (jmfSecurity.getName().startsWith("jmf-security")) {
                        jmfSecurity.requestPermission(this.m, this.cl, this.args, 128);
                        this.m[0].invoke((Object)this.cl[0], this.args[0]);
                    } else if (jmfSecurity.getName().startsWith("internet")) {
                        PolicyEngine.checkPermission((PermissionID)PermissionID.NETIO);
                        PolicyEngine.assertPermission((PermissionID)PermissionID.NETIO);
                    }
                }
                catch (Exception e4) {
                    jmfSecurity.permissionFailureNotification(128);
                    throw new IOException("Unable to get connect permission" + e4.getMessage());
                }
            }
            try {
                if (jmfSecurity != null && jmfSecurity.getName().startsWith("jdk12")) {
                    Constructor cons = jdk12ConnectionAction.cons;
                    this.inputStream = (InputStream)jdk12.doPrivM.invoke((Object)jdk12.ac, cons.newInstance(urlC));
                } else {
                    this.inputStream = urlC.getInputStream();
                }
            }
            catch (Throwable e5) {
                throw new IOException(JMFI18N.getResource("error.connectionerror") + e5.getMessage());
            }
        }
        if (this.inputStream == null) {
            throw new IOException(JMFI18N.getResource("error.connectionerror") + "Unable to open a URL connection");
        }
        if (protocol.equals("ftp")) {
            this.contentType = "content/unknown";
        } else {
            this.contentType = urlC.getContentType();
            this.contentLength = urlC.getContentLength();
        }
        this.contentType = ContentType.getCorrectedContentType(this.contentType, locator.getRemainder());
        this.contentType = ContentDescriptor.mimeTypeToPackageName(this.contentType);
        boolean cachingRequested = (Boolean)Manager.getHint(2);
        if (this.contentType.endsWith(".mvr") || this.contentType.endsWith("x_shockwave_flash") || this.contentType.endsWith("futuresplash")) {
            cachingRequested = false;
        }
        String filePrefix = null;
        if (cachingRequested && (filePrefix = Manager.getCacheDirectory()) != null && (allowCachingObj = Registry.get("secure.allowCaching")) != null) {
            this.isEnabledCaching = (Boolean)allowCachingObj;
        }
        if (this.isEnabledCaching) {
            String fileName = filePrefix + this.fileSeparator + DataSource.generateFileName(this.getLocator().getRemainder());
            try {
                this.cachedStream = new CachedPullSourceStream(this.inputStream, fileName, this.contentLength, protocol);
                this.pssArray[0] = this.cachedStream;
                this.cachingControls = new ExtendedCachingControl[1];
                this.cachingControls[0] = new CachingControl(this.cachedStream);
                Log.comment("Caching in " + filePrefix);
            }
            catch (IOException e6) {
                this.isEnabledCaching = false;
            }
        }
        if (!this.isEnabledCaching) {
            try {
                this.pssArray[0] = new BasicPullSourceStream(url, this.inputStream, this.contentLength, needConnectPermission);
                this.cachedStream = null;
            }
            catch (Exception ie) {
                this.pssArray[0] = null;
                throw new IOException(JMFI18N.getResource("error.connectionerror") + ie.getMessage());
            }
        }
        this.connected = true;
    }

    public void disconnect() {
        if (!this.connected) {
            return;
        }
        if (this.cachedStream != null) {
            this.cachedStream.close();
            this.cachedStream = null;
        }
        this.pssArray[0] = null;
        this.connected = false;
    }

    public void start() throws IOException {
        if (!this.connected) {
            return;
        }
        if (this.cachedStream != null) {
            if (!this.downLoadThreadStarted) {
                this.cachedStream.startDownload();
                this.downLoadThreadStarted = true;
            } else {
                this.cachedStream.resumeDownload();
            }
        }
    }

    public void stop() throws IOException {
        if (!this.connected) {
            return;
        }
    }

    public PullSourceStream[] getStreams() {
        return this.pssArray;
    }

    public Time getDuration() {
        return null;
    }

    public Object[] getControls() {
        return this.cachingControls;
    }

    public Object getControl(String controlType) {
        if (this.cachingControls.length > 0 && controlType.equals("javax.media.CachingControl")) {
            return this.cachingControls[0];
        }
        return null;
    }

    public static String generateFileName(String infile) {
        String ext = null;
        int sepindex = 0;
        Random generator = new Random();
        int dotindex = infile.lastIndexOf(46);
        int suffix = generator.nextInt();
        if (dotindex != -1) {
            ext = new String(infile.substring(dotindex));
        } else {
            dotindex = infile.length();
        }
        sepindex = infile.lastIndexOf(File.separatorChar);
        sepindex = Math.max(infile.lastIndexOf(47), sepindex);
        if (sepindex >= dotindex) {
            dotindex = infile.length();
            ext = null;
        }
        String filename = infile.substring(sepindex + 1, dotindex);
        String in = ext != null ? new String(filename + suffix + ext) : new String(filename + suffix);
        return DataSource.convertNonAlphaNumericToUnderscore(in);
    }

    private static String convertNonAlphaNumericToUnderscore(String in) {
        if (in == null) {
            return null;
        }
        int len = in.length();
        char[] nm = new char[len];
        in.getChars(0, len, nm, 0);
        for (int i2 = 0; i2 < len; ++i2) {
            char c2 = nm[i2];
            if (c2 == '.' || 'A' <= c2 && c2 <= 'Z' || 'a' <= c2 && c2 <= 'z' || '0' <= c2 && c2 <= '9') continue;
            nm[i2] = 95;
        }
        return new String(nm);
    }

    static {
        try {
            jmfSecurity = JMFSecurityManager.getJMFSecurity();
            securityPrivelege = true;
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
    }

    class CachingControl
    implements ExtendedCachingControl {
        private CacheControlComponent controlComponent;
        private Component progressBar;
        private CachedPullSourceStream cpss;

        CachingControl(CachedPullSourceStream cpss) {
            this.cpss = cpss;
            this.controlComponent = new CacheControlComponent(this, null);
            this.progressBar = this.controlComponent.getProgressBar();
        }

        public boolean isDownloading() {
            return this.cpss.isDownloading();
        }

        public long getContentLength() {
            return DataSource.this.contentLength;
        }

        public long getContentProgress() {
            return this.cpss.getContentProgress();
        }

        public Component getProgressBarComponent() {
            return this.progressBar;
        }

        public Component getControlComponent() {
            return this.controlComponent;
        }

        public void pauseDownload() {
            this.cpss.pauseDownload();
        }

        public void resumeDownload() {
            this.cpss.resumeDownload();
        }

        public long getStartOffset() {
            return this.cpss.getStartOffset();
        }

        public long getEndOffset() {
            return this.cpss.getEndOffset();
        }

        public void setBufferSize(Time t) {
        }

        public Time getBufferSize() {
            return null;
        }

        public void addDownloadProgressListener(DownloadProgressListener l2, int numKiloBytes) {
            this.cpss.addDownloadProgressListener(l2, numKiloBytes);
        }

        public void removeDownloadProgressListener(DownloadProgressListener l2) {
            this.cpss.removeDownloadProgressListener(l2);
        }
    }
}

