/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.protocol.v4l;

import java.awt.Canvas;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Graphics;
import java.awt.Image;
import java.io.IOException;
import javax.media.Buffer;
import javax.media.format.VideoFormat;
import javax.media.protocol.PushBufferStream;
import javax.media.util.BufferToImage;
import javax.swing.JFrame;

public class V4LPreviewWindow
extends JFrame
implements Runnable {
    private Component component = null;
    private volatile boolean enabled = false;
    private PushBufferStream dataSource = null;
    private Buffer cbuffer = new Buffer();

    public V4LPreviewWindow(PushBufferStream dataSource) {
        super("Camera preview");
        this.dataSource = dataSource;
        Container cp = this.getContentPane();
        cp.setLayout(new FlowLayout());
        Dimension size = ((VideoFormat)dataSource.getFormat()).getSize();
        this.component = new MyCanvas(size);
        this.component.setSize(size);
        cp.add(this.component);
        this.pack();
        this.setVisible(true);
    }

    public void stopPreview() {
        this.enabled = false;
    }

    public void run() {
        this.enabled = true;
        BufferToImage bti = null;
        while (this.enabled) {
            try {
                this.dataSource.read(this.cbuffer);
            }
            catch (IOException ioe) {
                return;
            }
            if (bti == null) {
                VideoFormat vf = (VideoFormat)this.cbuffer.getFormat();
                bti = new BufferToImage(vf);
            }
            if (bti != null && this.component != null) {
                Image im = bti.createImage(this.cbuffer);
                Graphics g2 = this.component.getGraphics();
                Dimension size = this.component.getSize();
                if (g2 != null) {
                    g2.drawImage(im, 0, 0, this.component);
                }
            }
            try {
                Thread.sleep(50L);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    class MyCanvas
    extends Canvas {
        Dimension size;

        public MyCanvas(Dimension size) {
            this.size = size;
        }

        public Dimension getPreferredSize() {
            return this.size;
        }
    }
}

