/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.protocol.v4l;

import com.sun.media.protocol.v4l.Suwak;
import com.sun.media.protocol.v4l.V4LCapture;
import com.sun.media.protocol.v4l.V4LSourceStream;
import java.awt.Container;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;

public class V4LSourceDialog
extends JDialog
implements ActionListener {
    private V4LSourceStream dataSource = null;
    private V4LCapture capture = null;
    private JButton bOk;
    private JButton bApply;
    private JButton bCancel;
    private JButton bStoreSettings;
    private JButton bRestoreSettings;
    private JButton bFactoryDefaults;
    private Suwak sFramerate;
    private Suwak sShuttter;
    private Suwak sGain;

    public V4LSourceDialog(Frame owner, V4LSourceStream dataSource) {
        super(owner, "Camera advanced settings", true);
        this.dataSource = dataSource;
        this.capture = dataSource.capture;
        Container cp = this.getContentPane();
        cp.setLayout(new BoxLayout(cp, 1));
        cp.add(Box.createGlue());
        this.sFramerate = new Suwak("Framerate", 0, 30, 10.0, 5, 1);
        cp.add(this.sFramerate);
        cp.add(Box.createGlue());
        this.sShuttter = new Suwak("Shutter", -1, 65535, -1.0);
        cp.add(this.sShuttter);
        cp.add(Box.createGlue());
        this.sGain = new Suwak("Gain", -1, 65535, -1.0);
        cp.add(this.sGain);
        JPanel pButtons = new JPanel();
        pButtons.setLayout(new GridLayout(2, 3, 20, 20));
        this.bStoreSettings = new JButton("Store settings");
        this.bStoreSettings.addActionListener(this);
        this.bRestoreSettings = new JButton("Restore settings");
        this.bRestoreSettings.addActionListener(this);
        this.bFactoryDefaults = new JButton("Factory defaults");
        this.bFactoryDefaults.addActionListener(this);
        this.bOk = new JButton("OK");
        this.bOk.addActionListener(this);
        this.bApply = new JButton("Apply");
        this.bApply.addActionListener(this);
        this.bCancel = new JButton("Cancel");
        this.bCancel.addActionListener(this);
        pButtons.add(this.bStoreSettings);
        pButtons.add(this.bRestoreSettings);
        pButtons.add(this.bFactoryDefaults);
        pButtons.add(this.bOk);
        pButtons.add(this.bApply);
        pButtons.add(this.bCancel);
        cp.add(Box.createGlue());
        cp.add(pButtons);
        cp.add(Box.createGlue());
        this.pack();
        this.setVisible(true);
    }

    public void actionPerformed(ActionEvent e2) {
        if (e2.getSource() instanceof JButton) {
            if (e2.getSource() == this.bStoreSettings) {
                this.capture.storeSettings();
            } else if (e2.getSource() == this.bRestoreSettings) {
                this.capture.restoreSettings();
            } else if (e2.getSource() == this.bFactoryDefaults) {
                this.capture.restoreFactorySettings();
            } else if (e2.getSource() == this.bOk) {
                this.applySettings();
                this.dispose();
            } else if (e2.getSource() == this.bApply) {
                this.applySettings();
            } else if (e2.getSource() == this.bCancel) {
                this.dispose();
            }
        }
    }

    private void applySettings() {
        this.capture.setFramerate((int)this.sFramerate.getValue());
        this.capture.setAutomaticGainControl((int)this.sGain.getValue());
        this.capture.setShutterSpeed((int)this.sShuttter.getValue());
    }
}

