/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.renderer.audio;

import com.sun.media.BasicPlugIn;
import com.sun.media.Log;
import com.sun.media.MediaTimeBase;
import com.sun.media.renderer.audio.device.AudioOutput;
import java.awt.Component;
import javax.media.Buffer;
import javax.media.Clock;
import javax.media.ClockStoppedException;
import javax.media.Control;
import javax.media.Drainable;
import javax.media.Format;
import javax.media.GainControl;
import javax.media.IncompatibleTimeBaseException;
import javax.media.Owned;
import javax.media.Prefetchable;
import javax.media.Renderer;
import javax.media.Time;
import javax.media.TimeBase;
import javax.media.control.BufferControl;
import javax.media.format.AudioFormat;

public abstract class AudioRenderer
extends BasicPlugIn
implements Renderer,
Prefetchable,
Drainable,
Clock {
    Format[] supportedFormats;
    protected AudioFormat inputFormat;
    protected AudioFormat devFormat;
    protected AudioOutput device = null;
    protected TimeBase timeBase = null;
    protected boolean started = false;
    protected boolean prefetched = false;
    protected boolean resetted = false;
    protected boolean devicePaused = true;
    protected GainControl gainControl;
    protected BufferControl bufferControl;
    protected Control peakVolumeMeter = null;
    protected long bytesWritten = 0L;
    protected int bytesPerSec;
    private Object writeLock = new Object();
    long mediaTimeAnchor = 0L;
    long startTime = Long.MAX_VALUE;
    long stopTime = Long.MAX_VALUE;
    long ticksSinceLastReset = 0L;
    float rate = 1.0f;
    TimeBase master = null;
    static int DefaultMinBufferSize = 62;
    static int DefaultMaxBufferSize = 4000;
    long bufLenReq = 200L;

    public AudioRenderer() {
        this.timeBase = new AudioTimeBase(this);
        this.bufferControl = new BC(this);
    }

    public Format[] getSupportedInputFormats() {
        return this.supportedFormats;
    }

    public Format setInputFormat(Format format) {
        for (int i2 = 0; i2 < this.supportedFormats.length; ++i2) {
            if (!this.supportedFormats[i2].matches(format)) continue;
            this.inputFormat = (AudioFormat)format;
            return format;
        }
        return null;
    }

    public void close() {
        this.stop();
        if (this.device != null) {
            this.pauseDevice();
            this.device.flush();
            this.mediaTimeAnchor = this.getMediaNanoseconds();
            this.ticksSinceLastReset = 0L;
            this.device.dispose();
        }
        this.device = null;
    }

    public void reset() {
        this.resetted = true;
        this.mediaTimeAnchor = this.getMediaNanoseconds();
        if (this.device != null) {
            this.device.flush();
            this.ticksSinceLastReset = this.device.getMediaNanoseconds();
        } else {
            this.ticksSinceLastReset = 0L;
        }
        this.prefetched = false;
    }

    synchronized void pauseDevice() {
        if (!this.devicePaused && this.device != null) {
            this.device.pause();
            this.devicePaused = true;
        }
        if (this.timeBase instanceof AudioTimeBase) {
            ((AudioTimeBase)this.timeBase).mediaStopped();
        }
    }

    synchronized void resumeDevice() {
        if (this.timeBase instanceof AudioTimeBase) {
            ((AudioTimeBase)this.timeBase).mediaStarted();
        }
        if (this.devicePaused && this.device != null) {
            this.device.resume();
            this.devicePaused = false;
        }
    }

    public void start() {
        this.syncStart(this.getTimeBase().getTime());
    }

    public synchronized void drain() {
        if (this.started && this.device != null) {
            this.device.drain();
        }
        this.prefetched = false;
    }

    public int process(Buffer buffer) {
        int rtn = this.processData(buffer);
        if (buffer.isEOM() && rtn != 2) {
            this.drain();
            this.pauseDevice();
        }
        return rtn;
    }

    protected boolean checkInput(Buffer buffer) {
        Format format = buffer.getFormat();
        if (this.device == null || this.devFormat == null || !this.devFormat.equals(format)) {
            if (!this.initDevice((AudioFormat)format)) {
                buffer.setDiscard(true);
                return false;
            }
            this.devFormat = (AudioFormat)format;
        }
        return true;
    }

    protected int processData(Buffer buffer) {
        if (!this.checkInput(buffer)) {
            return 1;
        }
        return this.doProcessData(buffer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int doProcessData(Buffer buffer) {
        int remain;
        byte[] data = (byte[])buffer.getData();
        int off = buffer.getOffset();
        int len = 0;
        Object object = this;
        synchronized (object) {
            if (!this.started) {
                if (!this.devicePaused) {
                    this.pauseDevice();
                }
                this.resetted = false;
                int available = this.device.bufferAvailable();
                if (available > remain) {
                    available = remain;
                }
                if (available > 0) {
                    len = this.device.write(data, off, available);
                    this.bytesWritten += (long)len;
                }
                buffer.setLength(remain - len);
                if (buffer.getLength() > 0 || buffer.isEOM()) {
                    buffer.setOffset(off + len);
                    this.prefetched = true;
                    return 2;
                }
                return 0;
            }
        }
        object = this.writeLock;
        synchronized (object) {
            if (this.devicePaused) {
                return 2;
            }
            try {
                for (remain = buffer.getLength(); remain > 0 && !this.resetted; remain -= len) {
                    len = this.device.write(data, off, remain);
                    this.bytesWritten += (long)len;
                    off += len;
                }
            }
            catch (NullPointerException e2) {
                return 0;
            }
        }
        buffer.setLength(0);
        buffer.setOffset(0);
        return 0;
    }

    protected boolean initDevice(AudioFormat format) {
        if (format == null) {
            System.err.println("AudioRenderer: ERROR: Unknown AudioFormat");
            return false;
        }
        if (format.getSampleRate() == -1.0 || format.getSampleSizeInBits() == -1) {
            Log.error("Cannot initialize audio renderer with format: " + format);
            return false;
        }
        if (this.device != null) {
            this.device.drain();
            this.pauseDevice();
            this.mediaTimeAnchor = this.getMediaNanoseconds();
            this.ticksSinceLastReset = 0L;
            this.device.dispose();
            this.device = null;
        }
        AudioFormat audioFormat = new AudioFormat(format.getEncoding(), format.getSampleRate(), format.getSampleSizeInBits(), format.getChannels(), format.getEndian(), format.getSigned());
        this.device = this.createDevice(audioFormat);
        if (this.device == null || !this.device.initialize(audioFormat, this.computeBufferSize(audioFormat))) {
            this.device = null;
            return false;
        }
        this.device.setMute(this.gainControl.getMute());
        this.device.setGain(this.gainControl.getDB());
        if (this.rate != 1.0f && this.rate != this.device.setRate(this.rate)) {
            System.err.println("The AudioRenderer does not support the given rate: " + this.rate);
            this.device.setRate(1.0f);
        }
        if (this.started) {
            this.resumeDevice();
        }
        this.bytesPerSec = (int)(format.getSampleRate() * (double)format.getChannels() * (double)format.getSampleSizeInBits() / 8.0);
        return true;
    }

    protected abstract AudioOutput createDevice(AudioFormat var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processByWaiting(Buffer buffer) {
        AudioRenderer audioRenderer = this;
        synchronized (audioRenderer) {
            if (!this.started) {
                this.prefetched = true;
                return;
            }
        }
        AudioFormat format = (AudioFormat)buffer.getFormat();
        int sampleRate = (int)format.getSampleRate();
        int sampleSize = format.getSampleSizeInBits();
        int channels = format.getChannels();
        long duration = buffer.getLength() * 1000 / (sampleSize / 8 * sampleRate * channels);
        int timeToWait = (int)((float)duration / this.getRate());
        try {
            Thread.currentThread();
            Thread.sleep(timeToWait);
        }
        catch (Exception e2) {
            // empty catch block
        }
        buffer.setLength(0);
        buffer.setOffset(0);
        this.mediaTimeAnchor += duration * 1000000L;
    }

    public Object[] getControls() {
        Object[] c2 = new Control[]{this.gainControl, this.bufferControl};
        return c2;
    }

    public boolean isPrefetched() {
        return this.prefetched;
    }

    public void setTimeBase(TimeBase master) throws IncompatibleTimeBaseException {
        if (!(master instanceof AudioTimeBase)) {
            Log.warning("AudioRenderer cannot be controlled by time bases other than its own: " + master);
        }
        this.master = master;
    }

    public synchronized void syncStart(Time at) {
        this.started = true;
        this.prefetched = true;
        this.resetted = false;
        this.resumeDevice();
        this.startTime = at.getNanoseconds();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void stop() {
        this.started = false;
        this.prefetched = false;
        Object object = this.writeLock;
        synchronized (object) {
            this.pauseDevice();
        }
    }

    public void setStopTime(Time t) {
        this.stopTime = t.getNanoseconds();
    }

    public Time getStopTime() {
        return new Time(this.stopTime);
    }

    public void setMediaTime(Time now) {
        this.mediaTimeAnchor = now.getNanoseconds();
    }

    public Time getMediaTime() {
        return new Time(this.getMediaNanoseconds());
    }

    public long getMediaNanoseconds() {
        return this.mediaTimeAnchor + (this.device != null ? this.device.getMediaNanoseconds() : 0L) - this.ticksSinceLastReset;
    }

    public long getLatency() {
        long ts = this.bytesWritten * 1000L / (long)this.bytesPerSec * 1000000L;
        return ts - this.getMediaNanoseconds();
    }

    public Time getSyncTime() {
        return new Time(0L);
    }

    public TimeBase getTimeBase() {
        if (this.master != null) {
            return this.master;
        }
        return this.timeBase;
    }

    public Time mapToTimeBase(Time t) throws ClockStoppedException {
        return new Time((long)((float)(t.getNanoseconds() - this.mediaTimeAnchor) / this.rate) + this.startTime);
    }

    public float getRate() {
        return this.rate;
    }

    public float setRate(float factor) {
        this.rate = this.device != null ? this.device.setRate(factor) : 1.0f;
        return this.rate;
    }

    public int computeBufferSize(AudioFormat f2) {
        long bytesPerSecond = (long)(f2.getSampleRate() * (double)f2.getChannels() * (double)f2.getSampleSizeInBits() / 8.0);
        long bufLen = this.bufLenReq < (long)DefaultMinBufferSize ? (long)DefaultMinBufferSize : (this.bufLenReq > (long)DefaultMaxBufferSize ? (long)DefaultMaxBufferSize : this.bufLenReq);
        float r = (float)bufLen / 1000.0f;
        long bufSize = (long)((float)bytesPerSecond * r);
        return (int)bufSize;
    }

    class BC
    implements BufferControl,
    Owned {
        AudioRenderer renderer;

        BC(AudioRenderer ar) {
            this.renderer = ar;
        }

        public long getBufferLength() {
            return AudioRenderer.this.bufLenReq;
        }

        public long setBufferLength(long time) {
            AudioRenderer.this.bufLenReq = time < (long)DefaultMinBufferSize ? (long)DefaultMinBufferSize : (time > (long)DefaultMaxBufferSize ? (long)DefaultMaxBufferSize : time);
            return AudioRenderer.this.bufLenReq;
        }

        public long getMinimumThreshold() {
            return 0L;
        }

        public long setMinimumThreshold(long time) {
            return 0L;
        }

        public void setEnabledThreshold(boolean b2) {
        }

        public boolean getEnabledThreshold() {
            return false;
        }

        public Component getControlComponent() {
            return null;
        }

        public Object getOwner() {
            return this.renderer;
        }
    }

    class AudioTimeBase
    extends MediaTimeBase {
        AudioRenderer renderer;

        AudioTimeBase(AudioRenderer r) {
            this.renderer = r;
        }

        public long getMediaTime() {
            if (AudioRenderer.this.rate == 1.0f || AudioRenderer.this.rate == 0.0f) {
                return AudioRenderer.this.device != null ? AudioRenderer.this.device.getMediaNanoseconds() : 0L;
            }
            return (long)((float)(AudioRenderer.this.device != null ? AudioRenderer.this.device.getMediaNanoseconds() : 0L) / AudioRenderer.this.rate);
        }
    }
}

