/*
 * Decompiled with CFR 0.152.
 */
package jmapps.jmstudio;

import com.sun.media.util.JMFI18N;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Panel;
import java.awt.event.ActionEvent;
import java.awt.event.WindowEvent;
import javax.media.Control;
import javax.media.protocol.DataSource;
import jmapps.ui.JMDialog;
import jmapps.ui.JMPanel;

public class CaptureControlsDialog
extends JMDialog {
    private DataSource dataSource;
    private int nControlCount = 0;

    public CaptureControlsDialog(Frame parentFrame, DataSource dataSource) {
        super(parentFrame, JMFI18N.getResource("jmstudio.capturecontrols.title"), false);
        this.dataSource = dataSource;
        try {
            this.init();
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
    }

    public boolean isEmpty() {
        return this.nControlCount < 1;
    }

    private void init() throws Exception {
        int nCount = 0;
        Object[] arrControls = null;
        this.setLayout(new BorderLayout());
        JMPanel panelContent = new JMPanel(new BorderLayout());
        panelContent.setEmptyBorder(6, 6, 6, 6);
        this.add((Component)panelContent, "Center");
        if (this.dataSource != null) {
            arrControls = this.dataSource.getControls();
        }
        if (arrControls != null) {
            nCount = arrControls.length;
        }
        Panel panel = panelContent;
        this.nControlCount = 0;
        for (int i2 = 0; i2 < nCount; ++i2) {
            Component componentControl;
            if (arrControls[i2] == null || !(arrControls[i2] instanceof Control) || (componentControl = ((Control)arrControls[i2]).getControlComponent()) == null) continue;
            ++this.nControlCount;
            Panel panelNext = new Panel(new BorderLayout(6, 6));
            panelNext.add(componentControl, "North");
            panel.add((Component)panelNext, "Center");
            panel = panelNext;
        }
        panel = new JMPanel(new FlowLayout(1));
        panelContent.add((Component)panel, "South");
        JMPanel panelButtons = this.createButtonPanel(new String[]{ACTION_CLOSE});
        panel.add(panelButtons);
        this.pack();
        this.setResizable(false);
    }

    public void actionPerformed(ActionEvent event) {
        String strCmd = event.getActionCommand();
        if (strCmd.equals(ACTION_CLOSE)) {
            this.setAction(ACTION_CLOSE);
            this.setVisible(false);
        }
    }

    public void windowClosing(WindowEvent event) {
        this.setAction(ACTION_CLOSE);
        this.setVisible(false);
    }
}

